/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.token;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.xml.namespace.QName;

public class X509BSToken
extends WSSToken {
    private static final TraceComponent tc = Tr.register(X509BSToken.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509BSToken.class.getName();
    private static final String setCertPermission = "wssecurity.X509BSToken.setCert";
    private static final String setBytesPermission = "wssecurity.X509BSToken.setBytes";
    private static final WebSphereRuntimePermission SETCERT_PERM = new WebSphereRuntimePermission("wssecurity.X509BSToken.setCert");
    private static final WebSphereRuntimePermission SETBYTES_PERM = new WebSphereRuntimePermission("wssecurity.X509BSToken.setBytes");
    public static final String KEY_LOCATOR = "com.ibm.wsspi.wssecurity.token.x509.keyLocator";
    public static final String CERT_INFO = "com.ibm.wsspi.wssecurity.token.x509.certificate";
    public static final String TRUST_ANY = "com.ibm.wsspi.wssecurity.token.x509.trustAny";
    public static final String PROVIDER = "com.ibm.wsspi.wssecurity.token.x509.provider";
    public static final String PKIX_BUILDERPARAM = "com.ibm.wsspi.wssecurity.token.x509.pkixBuilderParam";
    public static final String CERT_STORES = "com.ibm.wsspi.wssecurity.token.x509.certStores";
    private X509Certificate _cert;
    private String _uid;
    private byte[] _binary;
    private volatile int hashCode = 0;
    private boolean _isValid = false;

    public X509BSToken(String string, X509Certificate x509Certificate, QName qName) {
        this._tokenId = string == null ? "" : string;
        this._cert = x509Certificate;
        this._uid = null;
        this._vtype = qName;
    }

    public X509Certificate getCert() throws SoapSecurityException {
        if (this._cert != null) {
            if (this.isReadOnly()) {
                try {
                    return CertificateUtil.generateX509Certificate(this._cert.getEncoded(), null);
                }
                catch (Exception exception) {
                    throw SoapSecurityException.format("security.wssecurity.X509BSToken.getCert01", exception);
                }
            }
            return this._cert;
        }
        if (this._binary != null) {
            try {
                this._cert = CertificateUtil.generateX509Certificate(this._binary, null);
                this._uid = null;
                if (this.isReadOnly()) {
                    return CertificateUtil.generateX509Certificate(this._binary, null);
                }
                return this._cert;
            }
            catch (Exception exception) {
                throw SoapSecurityException.format("security.wssecurity.X509BSToken.getCert01", exception);
            }
        }
        if (this._tokenelem != null) {
            return null;
        }
        return null;
    }

    public void setCert(X509Certificate x509Certificate) {
        Tr.entry(tc, "setCert");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETCERT_PERM.toString());
            }
            securityManager.checkPermission(SETCERT_PERM);
        }
        Tr.exit(tc, "setCert");
        if (this.isReadOnly()) {
            return;
        }
        this._cert = x509Certificate;
        this._uid = null;
    }

    public byte[] getBytes() {
        try {
            if (this.isReadOnly()) {
                byte[] byArray = new byte[this._binary.length];
                System.arraycopy(this._binary, 0, byArray, 0, this._binary.length);
                return byArray != null ? byArray : (byte[])(this._cert != null ? this._cert.getEncoded() : null);
            }
            return this._binary != null ? this._binary : (byte[])(this._cert != null ? this._cert.getEncoded() : null);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Tr.error(tc, "security.wssecurity.X509BSToken.getBytes01", new Object[]{this._cert, certificateEncodingException});
            return null;
        }
    }

    public void setBytes(byte[] byArray) {
        Tr.entry(tc, "setBytes");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETBYTES_PERM.toString());
            }
            securityManager.checkPermission(SETBYTES_PERM);
        }
        Tr.exit(tc, "setBytes");
        if (this.isReadOnly()) {
            return;
        }
        this._binary = byArray;
    }

    public long getExpiration() {
        long l = 0L;
        if (this._cert != null) {
            Date date = this._cert.getNotAfter();
            l = date.getTime();
        }
        return l;
    }

    public void setExpiration(long l) {
    }

    public String getPrincipal() {
        String string = null;
        if (this._cert != null) {
            string = this._cert.getSubjectDN().getName();
        }
        return string;
    }

    public String getUniqueID() {
        if (this._uid == null) {
            this._uid = String.valueOf(this.hashCode());
        }
        if (this.isReadOnly()) {
            String string = new String(this._uid);
            return string;
        }
        return this._uid;
    }

    public int hashCode() {
        if (this.hashCode == 0 && this._cert != null) {
            this.hashCode = this._cert.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509BSToken)) {
            return false;
        }
        X509BSToken x509BSToken = (X509BSToken)object;
        return x509BSToken.hashCode() == this.hashCode();
    }

    public boolean isValid() {
        if (this._cert != null) {
            try {
                this._cert.checkValidity();
                this._isValid = true;
            }
            catch (Exception exception) {
                this._isValid = false;
            }
        }
        return this._isValid;
    }

    public short getVersion() {
        short s = -1;
        if (this._cert != null) {
            s = new Integer(this._cert.getVersion()).shortValue();
        }
        return s;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509BSToken[tokenId=[").append(this._tokenId);
        stringBuffer.append("], element=[").append(DOMUtil.getDisplayName(this._tokenelem));
        if (this._cert == null) {
            stringBuffer.append("], cert=[null");
        } else {
            stringBuffer.append("], cert=[SubjectDN=").append(this._cert.getSubjectDN());
            stringBuffer.append(", IssuerDN=").append(this._cert.getIssuerDN());
            stringBuffer.append(", IssuerSerial=").append(this._cert.getSerialNumber());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

