/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.config;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CertInRequestKeyLocator
implements KeyLocator {
    private static final TraceComponent tc = Tr.register(CertInRequestKeyLocator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CertInRequestKeyLocator.class.getName();
    private static final String F_CERTIFICATE = clsName + ".fCert";
    private static final String F_KEY = clsName + ".fKey";
    private static final String F_NAME = clsName + ".fName";
    private static final String F_NAMES = clsName + ".fNames";

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(map)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    private void getCertInRequest(Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertInRequest(" + object + ")");
        }
        if (!(object instanceof Map)) {
            throw new KeyLocatorException("Internal error: invalid context object.");
        }
        Object v = ((Map)object).get("com.ibm.xml.soapsec.RequestCert");
        if (!(v instanceof X509Certificate)) {
            String string = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error(tc, string);
            throw new KeyLocatorException(ConfigUtil.getMessage(string));
        }
        MessageContext messageContext = this.getMessageContext();
        X509Certificate x509Certificate = (X509Certificate)v;
        messageContext.setProperty(F_CERTIFICATE, x509Certificate);
        messageContext.setProperty(F_KEY, x509Certificate.getPublicKey());
        String string = x509Certificate.getSubjectDN().getName();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        messageContext.setProperty(F_NAME, string);
        messageContext.setProperty(F_NAMES, hashSet);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertInRequest(Object context)");
        }
    }

    public Set getNames(Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNames(" + object + ")");
        }
        if (this.getFName() == null) {
            this.getCertInRequest(object);
        }
        Set set = this.getFNames();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNames(Object context) returns " + set);
        }
        return set;
    }

    public Key getEncryptionKey(String string, Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncryptionKey(" + string + "," + object + ")");
        }
        if (this.getFCert() == null) {
            this.getCertInRequest(object);
        }
        Key key = this.getFKey();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEncryptionKey(String name, Object context) returns " + key);
        }
        return key;
    }

    public Key getDecryptionKey(String string, Object object) throws KeyLocatorException {
        throw new KeyLocatorException("Not implemented.");
    }

    public Key getSigningKey(String string) throws KeyLocatorException {
        throw new KeyLocatorException("Not implemented.");
    }

    public Key getVerificationKey(String string) throws KeyLocatorException {
        throw new KeyLocatorException("Not implemented.");
    }

    public String getName(Key key) throws KeyLocatorException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName(" + key + ")");
        }
        if ((string = this.getFName()) == null) {
            String string2 = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error(tc, string2);
            throw new KeyLocatorException(ConfigUtil.getMessage(string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName(Key key) returns " + string);
        }
        return string;
    }

    public String getName(String string) throws KeyLocatorException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName(" + string + ")");
        }
        if ((string2 = this.getFName()) == null) {
            String string3 = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error(tc, string3);
            throw new KeyLocatorException(ConfigUtil.getMessage(string3));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName(String name) returns " + string2);
        }
        return string2;
    }

    public Certificate getCertificate(Key key) throws KeyLocatorException {
        X509Certificate x509Certificate;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificate(" + key + ")");
        }
        if ((x509Certificate = this.getFCert()) == null) {
            String string = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error(tc, string);
            throw new KeyLocatorException(ConfigUtil.getMessage(string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificate(Key key) returns " + x509Certificate);
        }
        return x509Certificate;
    }

    public Certificate getCertificate(String string) throws KeyLocatorException {
        X509Certificate x509Certificate;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificate(" + string + ")");
        }
        if ((x509Certificate = this.getFCert()) == null) {
            String string2 = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error(tc, string2);
            throw new KeyLocatorException(ConfigUtil.getMessage(string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificate(String name) returns " + x509Certificate);
        }
        return x509Certificate;
    }

    private MessageContext getMessageContext() throws KeyLocatorException {
        MessageContext messageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageContext()");
        }
        if ((messageContext = MessageContext.getCurrentThreadsContext()) == null) {
            throw new KeyLocatorException("Internal error: message context is null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageContext()");
        }
        return messageContext;
    }

    private X509Certificate getFCert() throws KeyLocatorException {
        return (X509Certificate)this.getMessageContext().getProperty(F_CERTIFICATE);
    }

    private Key getFKey() throws KeyLocatorException {
        return (Key)this.getMessageContext().getProperty(F_KEY);
    }

    private String getFName() throws KeyLocatorException {
        return (String)this.getMessageContext().getProperty(F_NAME);
    }

    private Set getFNames() throws KeyLocatorException {
        return (Set)this.getMessageContext().getProperty(F_NAMES);
    }
}

