/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.config;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class KeyStoreKeyLocator
implements KeyLocator {
    private static final int STATUS_OK = 0;
    private static final int STATUS_CERT_ERROR = 1;
    private static final int STATUS_KEYID_ERROR = 2;
    private static final int STATUS_KEY_ERROR = 4;
    private static final TraceComponent tc = Tr.register(KeyStoreKeyLocator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyStoreKeyLocator.class.getName();
    private static final long DAYS_IN_MS = 86400000L;
    private static final long DEFAULT_DAYS_IN_MS_BEFORE_EXPIRE_WARNING = 5184000000L;
    private static final String DAYS_BEFORE_EXPIRE_WARNING_KEYS = "com.ibm.ws.wssecurity.daysBeforeExpireWarning";
    private Map fInitMap = null;
    private Map fName2Container = new HashMap();
    private Map fName2PrivContainer = new HashMap();
    private Map fKey2Container = new HashMap();
    private String fDefaultName;
    private long daysInMSBeforeExpireWarning = 5184000000L;
    private volatile boolean fInitialized = false;

    protected String getDefaultBasePath() {
        return null;
    }

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(map)");
        }
        this.fInitMap = map;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    protected synchronized void doInit() throws KeyLocatorException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doInit(map)");
        }
        if (this.fInitialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doInit()");
            }
            return;
        }
        String string = null;
        String string2 = null;
        Iterator iterator = null;
        char[] cArray = null;
        HashMap hashMap = new HashMap();
        HashMap<String, char[]> hashMap2 = new HashMap<String, char[]>();
        HashMap hashMap3 = new HashMap();
        Iterator iterator2 = null;
        Object object3 = this.getDefaultBasePath();
        Object object4 = this.fInitMap.keySet().iterator();
        while (object4.hasNext()) {
            object2 = (String)object4.next();
            object = (String)this.fInitMap.get(object2);
            if (((String)object2).equals("type")) {
                string = object;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doInit() - keystore type: " + (String)object);
                continue;
            }
            if (((String)object2).equals("path")) {
                string2 = object;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doInit() - keystore path: " + object);
                continue;
            }
            if (((String)object2).equals("base")) {
                object3 = object;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doInit() - keystore base: " + object);
                continue;
            }
            if (((String)object2).equals("storepass")) {
                cArray = ((String)object).toCharArray();
                continue;
            }
            if (((String)object2).equals("keyStoreRef")) {
                iterator = object;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doInit() - keystore reference: " + object);
                continue;
            }
            if (((String)object2).startsWith("alias_")) {
                hashMap.put(((String)object2).substring("alias_".length()), object);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doInit() - keystore " + (String)object2 + ": " + object);
                continue;
            }
            if (((String)object2).startsWith("keypass_")) {
                hashMap2.put(((String)object2).substring("keypass_".length()), ((String)object).toCharArray());
                continue;
            }
            if (((String)object2).startsWith("name_")) {
                hashMap3.put(((String)object2).substring("name_".length()), object);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doInit() - keystore " + (String)object2 + ": " + (String)object);
                continue;
            }
            if (((String)object2).equals("default")) {
                iterator2 = object;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doInit() - keystore default: " + object);
                continue;
            }
            if (!((String)object2).equals(DAYS_BEFORE_EXPIRE_WARNING_KEYS)) continue;
            if (object != null && ((String)object).length() != 0) {
                if (((String)(object = ((String)object).trim())).length() != 0) {
                    long l = 0L;
                    try {
                        l = Long.parseLong((String)object);
                        this.daysInMSBeforeExpireWarning = l * 86400000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Tr.processException((Throwable)numberFormatException, clsName + ".doInit", "182", this);
                        Tr.warning(tc, "security.wssecurity.WSEC5190W", new Object[]{DAYS_BEFORE_EXPIRE_WARNING_KEYS, object, new Long(60L)});
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doInit() - no value define for: com.ibm.ws.wssecurity.daysBeforeExpireWarning");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "doInit() - no value define for: com.ibm.ws.wssecurity.daysBeforeExpireWarning");
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "doInit() - days before expire warning: " + this.daysInMSBeforeExpireWarning / 86400000L);
        }
        if (string == null) {
            string = KeyStore.getDefaultType();
        }
        if (string2 == null) {
            throw new NullPointerException("Keystore path not specified");
        }
        object4 = string2;
        if (object3 != null) {
            object4 = ConfigUtil.fixKeystorePath(string2, (String)object3);
        }
        object2 = null;
        try {
            object2 = iterator != null ? ConfigUtil.getKeyStore(iterator) : ConfigUtil.getKeyStore(string, (String)object4, cArray);
        }
        catch (SoapSecurityException soapSecurityException) {
            throw new KeyLocatorException(soapSecurityException.toString());
        }
        try {
            Object object5;
            Object object6;
            Certificate certificate;
            Object object7;
            object = ((KeyStore)object2).aliases();
            while (object.hasMoreElements()) {
                String string3 = (String)object.nextElement();
                object7 = ((KeyStore)object2).getCertificate(string3);
                certificate = null;
                object6 = null;
                object5 = null;
                int n = 0;
                long l = -1L;
                String string4 = null;
                if (object7 != null && object7 instanceof X509Certificate) {
                    certificate = (X509Certificate)object7;
                    object6 = certificate.getPublicKey();
                    object5 = ((X509Certificate)certificate).getSubjectDN().getName();
                    l = ((X509Certificate)certificate).getNotAfter().getTime();
                    if (l - System.currentTimeMillis() < this.daysInMSBeforeExpireWarning) {
                        long l2 = l - System.currentTimeMillis();
                        long l3 = l2 / 86400000L;
                        Tr.warning(tc, "security.wssecurity.WSEC5189W", new Object[]{object5, string3, string2, new Long(l3)});
                    }
                    try {
                        ((X509Certificate)certificate).checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        ++n;
                        Tr.processException((Throwable)certificateExpiredException, clsName + ".doInit", "261", this);
                        Tr.error(tc, "security.wssecurity.WSEC5181E", new Object[]{object5, string3, string2, certificateExpiredException});
                        string4 = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{object5, string3, string2, certificateExpiredException.getMessage()});
                    }
                    catch (CertificateException certificateException) {
                        ++n;
                        Tr.processException((Throwable)certificateException, clsName + ".doInit", "268", this);
                        Tr.error(tc, "security.wssecurity.WSEC5182E", new Object[]{object5, string3, string2, certificateException});
                        string4 = ConfigUtil.getMessage("security.wssecurity.WSEC5182E", new String[]{object5, string3, string2, certificateException.getMessage()});
                    }
                }
                if (certificate == null) continue;
                KeyContainer keyContainer = new KeyContainer(string2, string3, (String)object5, (Key)object6, certificate, n, l, this.daysInMSBeforeExpireWarning, string4);
                this.fName2Container.put(keyContainer.getName(), keyContainer);
                this.fKey2Container.put(object6, keyContainer);
            }
            object = hashMap3.keySet().iterator();
            while (object.hasNext()) {
                Object object8;
                long l;
                String string5 = (String)object.next();
                object7 = (String)hashMap.get(string5);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doInit() - id=" + string5 + " alias=" + (String)object7);
                }
                if (object7 == null) continue;
                certificate = ((KeyStore)object2).getCertificate((String)object7);
                if (certificate != null) {
                    String string6;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "doInit() - private key found");
                    }
                    object6 = (String)hashMap3.get(string5);
                    object5 = null;
                    Key key = null;
                    int n = 0;
                    l = -1L;
                    String string7 = null;
                    if (certificate instanceof X509Certificate) {
                        object5 = (X509Certificate)certificate;
                        key = ((Certificate)object5).getPublicKey();
                        l = ((X509Certificate)object5).getNotAfter().getTime();
                        if (l - System.currentTimeMillis() < this.daysInMSBeforeExpireWarning) {
                            long l4 = l - System.currentTimeMillis();
                            long l5 = l4 / 86400000L;
                            Tr.warning(tc, "security.wssecurity.WSEC5189W", new Object[]{object6, object7, string2, new Long(l5)});
                        }
                        try {
                            ((X509Certificate)object5).checkValidity();
                        }
                        catch (CertificateExpiredException certificateExpiredException) {
                            ++n;
                            Tr.processException((Throwable)certificateExpiredException, clsName + ".doInit", "318", this);
                            Tr.error(tc, "security.wssecurity.WSEC5181E", new Object[]{object6, object7, string2, certificateExpiredException});
                            string7 = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{object6, object7, string2, certificateExpiredException.getMessage()});
                        }
                        catch (CertificateException certificateException) {
                            ++n;
                            Tr.processException((Throwable)certificateException, clsName + ".doInit", "325", this);
                            Tr.error(tc, "security.wssecurity.WSEC5182E", new Object[]{object6, object7, string2, certificateException});
                            string7 = ConfigUtil.getMessage("security.wssecurity.WSEC5182E", new String[]{object6, object7, string2, certificateException.getMessage()});
                        }
                        object8 = new KeyContainer(string2, (String)object7, (String)object6, key, (Certificate)object5, n, l, this.daysInMSBeforeExpireWarning, string7);
                        this.fName2Container.put(((KeyContainer)object8).getName(), object8);
                        this.fKey2Container.put(key, object8);
                    }
                    object8 = (char[])hashMap2.get(string5);
                    if (tc.isDebugEnabled()) {
                        if (object8 != null) {
                            Tr.debug(tc, "doInit() - keypass is not null");
                        } else {
                            Tr.debug(tc, "doInit() - keypass is null");
                        }
                    }
                    if (object8 == null) continue;
                    key = null;
                    n = 0;
                    string7 = null;
                    try {
                        key = ((KeyStore)object2).getKey((String)object7, (char[])hashMap2.get(string5));
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        n = 4;
                        Tr.processException((Throwable)noSuchAlgorithmException, clsName + ".doInit", "354", this);
                        Tr.error(tc, "security.wssecurity.WSEC5183E", new Object[]{object7, string2, noSuchAlgorithmException});
                        string7 = ConfigUtil.getMessage("security.wssecurity.WSEC5183E", new String[]{object7, string2, noSuchAlgorithmException.getMessage()});
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        n = 4;
                        Tr.processException((Throwable)unrecoverableKeyException, clsName + ".doInit", "360", this);
                        Tr.error(tc, "security.wssecurity.WSEC5184E", new Object[]{object7, string2, unrecoverableKeyException});
                        string7 = ConfigUtil.getMessage("security.wssecurity.WSEC5184E", new String[]{object7, string2, unrecoverableKeyException.getMessage()});
                    }
                    if (tc.isDebugEnabled()) {
                        if (key != null) {
                            Tr.debug(tc, "doInit() - key is not null");
                        } else {
                            Tr.debug(tc, "doInit() - key is null");
                        }
                    }
                    if (key == null) continue;
                    KeyContainer keyContainer = new KeyContainer(string2, (String)object7, (String)object6, key, (Certificate)object5, n, l, this.daysInMSBeforeExpireWarning, string7);
                    this.fName2PrivContainer.put(keyContainer.getName(), keyContainer);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "KeyStoreKeyLocator.doInit() - added priv key for name " + keyContainer.getName());
                    }
                    if (object5 == null || ((X509Certificate)object5).getSubjectDN() == null || (string6 = ((X509Certificate)object5).getSubjectDN().getName()) == null || string6.length() <= 0) continue;
                    String string8 = KeyStoreKeyLocator.encodedName(string6);
                    this.fName2PrivContainer.put(string8, keyContainer);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "KeyStoreKeyLocator.doInit() - added priv key for name " + string8);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doInit() - private key not found.");
                }
                if ((object6 = (Object)((char[])hashMap2.get(string5))) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "doInit() - keypass is not null");
                    }
                    object5 = null;
                    String string9 = null;
                    int n = 0;
                    l = -1L;
                    String string10 = null;
                    try {
                        object5 = ((KeyStore)object2).getKey((String)object7, (char[])object6);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        n = 4;
                        Tr.processException((Throwable)noSuchAlgorithmException, clsName + ".doInit", "412", this);
                        Tr.error(tc, "security.wssecurity.WSEC5183E", new Object[]{object7, string2, noSuchAlgorithmException});
                        string10 = ConfigUtil.getMessage("security.wssecurity.WSEC5183E", new String[]{object7, string2, noSuchAlgorithmException.getMessage()});
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        n = 4;
                        Tr.processException((Throwable)unrecoverableKeyException, clsName + ".doInit", "418", this);
                        Tr.error(tc, "security.wssecurity.WSEC5184E", new Object[]{object7, string2, unrecoverableKeyException});
                        string10 = ConfigUtil.getMessage("security.wssecurity.WSEC5184E", new String[]{object7, string2, unrecoverableKeyException.getMessage()});
                    }
                    if (object5 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "doInit() - key is not null");
                        }
                        string9 = (String)hashMap3.get(string5);
                        object8 = new KeyContainer(string2, (String)object7, string9, (Key)object5, null, n, l, this.daysInMSBeforeExpireWarning, string10);
                        this.fName2Container.put(((KeyContainer)object8).getName(), object8);
                        this.fKey2Container.put(object5, object8);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "KeyStoreKeyLocator.doInit() - added key for name " + ((KeyContainer)object8).getName());
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "doInit() - key is null");
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doInit() - keypass is null");
            }
        }
        catch (KeyStoreException keyStoreException) {
            Tr.processException((Throwable)keyStoreException, clsName + ".doInit", "451", this);
            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.exception", new Object[]{string2, keyStoreException});
            throw new KeyLocatorException(keyStoreException.toString());
        }
        if (iterator2 != null) {
            this.fDefaultName = KeyStoreKeyLocator.encodedName(iterator2);
        }
        this.fInitialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doInit() - fInitialized [" + this.fInitialized + "]");
        }
    }

    public Set getNames(Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNames(" + object + ")");
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        Set set = this.fName2Container.keySet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNames(Object context) returns " + set);
        }
        return set;
    }

    protected Key getConfidentialKey(String string, Object object) throws KeyLocatorException {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfidentialKey(" + string + "," + object + ")");
        }
        string = string != null ? KeyStoreKeyLocator.encodedName(string) : this.fDefaultName;
        Key key = null;
        if (string != null) {
            object2 = (KeyContainer)this.fName2PrivContainer.get(string);
            if (object2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getConfidentialKey - priv key NOT found for " + string);
                    Tr.debug(tc, "getConfidentialKey - priv container map: " + this.fName2PrivContainer);
                }
                object2 = (KeyContainer)this.fName2Container.get(string);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getConfKey - priv key found for " + string);
            }
            if (object2 != null) {
                key = ((KeyContainer)object2).getKey();
            }
        }
        if (key == null) {
            object2 = "security.wssecurity.KeyStoreKeyLocator.s41";
            Tr.error(tc, (String)object2);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)object2) + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfidentialKey(String name, Object context) returns " + key);
        }
        return key;
    }

    public Key getEncryptionKey(String string, Object object) throws KeyLocatorException {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncryptionKey(" + string + "," + object + ")");
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        string = string != null ? KeyStoreKeyLocator.encodedName(string) : this.fDefaultName;
        Key key = null;
        if (string != null && (object2 = (KeyContainer)this.fName2Container.get(string)) != null) {
            key = ((KeyContainer)object2).getKey();
        }
        if (key == null) {
            object2 = "security.wssecurity.KeyStoreKeyLocator.s41";
            Tr.error(tc, (String)object2);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)object2) + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEncryptionKey(String name, Object context) returns " + key);
        }
        return key;
    }

    public Key getDecryptionKey(String string, Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDecryptionKey(" + string + "," + object + ")");
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        Key key = this.getConfidentialKey(string, object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDecryptionKey(String name, Object context) returns " + key);
        }
        return key;
    }

    public Key getSigningKey(String string) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSigningKey(" + string + ")");
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        Key key = this.getConfidentialKey(string, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSigningKey(String name) returns " + key);
        }
        return key;
    }

    public Key getVerificationKey(String string) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVefificationKey(" + string + ")");
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        Key key = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVerificationKey(String name) returns " + key);
        }
        return key;
    }

    public String getName(Key key) throws KeyLocatorException {
        KeyContainer keyContainer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName(" + key + ")");
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        String string = null;
        if (key != null && (keyContainer = (KeyContainer)this.fKey2Container.get(key)) != null) {
            string = keyContainer.getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName(Key key) returns " + string);
        }
        return string;
    }

    public Certificate getCertificate(Key key) throws KeyLocatorException {
        KeyContainer keyContainer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificate(" + key + ")");
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        Certificate certificate = null;
        if (key != null && (keyContainer = (KeyContainer)this.fKey2Container.get(key)) != null) {
            certificate = keyContainer.getCertificate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificate(Key key) returns " + certificate);
        }
        return certificate;
    }

    public Certificate getCertificate(String string) throws KeyLocatorException {
        KeyContainer keyContainer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificate(" + string + ")");
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        string = string != null ? KeyStoreKeyLocator.encodedName(string) : this.fDefaultName;
        Certificate certificate = null;
        if (string != null && (keyContainer = (KeyContainer)this.fName2Container.get(string)) != null) {
            certificate = keyContainer.getCertificate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificate(String name) returns " + certificate);
        }
        return certificate;
    }

    public static String encodedName(String string) throws KeyLocatorException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encodedName(" + string + ")");
        }
        if ((string2 = KeyInfo.X509Data.encodeDName(string)) == null) {
            String string3 = "security.wssecurity.KeyStoreKeyLocator.malformedname";
            Tr.error(tc, string3, new Object[]{string});
            throw new KeyLocatorException(MessageFormat.format(ConfigUtil.getMessage(string3), string));
        }
        if (string2.length() == 0) {
            string2 = string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encodedName(String dn) returns " + string2);
        }
        return string2;
    }

    public String getName(String string) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName(" + string + ")");
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        string = string != null ? KeyStoreKeyLocator.encodedName(string) : this.fDefaultName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName(String name) returns " + string);
        }
        return string;
    }

    class KeyContainer {
        private String fKspath;
        private String fAlias;
        private String fName;
        private Key fKey;
        private Certificate fCertificate;
        private int fStatus;
        private long fExpiration;
        private long fDaysInMSBeforeExpireWarning;
        private String fErrorMes;

        private KeyContainer(String string, String string2, String string3, Key key, Certificate certificate, int n, long l, long l2, String string4) throws KeyLocatorException {
            this.fKspath = string;
            this.fAlias = string2;
            this.fName = KeyStoreKeyLocator.encodedName(string3);
            this.fKey = key;
            this.fCertificate = certificate;
            this.fStatus = n;
            this.fExpiration = l;
            this.fDaysInMSBeforeExpireWarning = l2;
            this.fErrorMes = string4;
        }

        private String getName() {
            return this.fName;
        }

        private Key getKey() throws KeyLocatorException {
            if ((this.fStatus & 1) == 1 || (this.fStatus & 4) == 4) {
                throw new KeyLocatorException(this.fErrorMes);
            }
            return this.fKey;
        }

        private Certificate getCertificate() throws KeyLocatorException {
            if ((this.fStatus & 1) == 1) {
                throw new KeyLocatorException(this.fErrorMes);
            }
            this.checkExpiration();
            return this.fCertificate;
        }

        private void checkExpiration() throws KeyLocatorException {
            if (this.fExpiration >= 0L) {
                long l = this.fExpiration - System.currentTimeMillis();
                if (l < 0L) {
                    ++this.fStatus;
                    this.fErrorMes = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{this.fName, this.fAlias, this.fKspath, "expiration time - current system time = " + l + " ms."});
                    throw new KeyLocatorException(this.fErrorMes);
                }
                if (l < this.fDaysInMSBeforeExpireWarning) {
                    long l2 = l / 86400000L;
                    Tr.warning(tc, "security.wssecurity.WSEC5189W", new Object[]{this.fName, this.fAlias, this.fKspath, new Long(l2)});
                }
            }
        }
    }
}

