/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyStoreKeyLocator;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;

public class X509TokenKeyLocator
extends KeyStoreKeyLocator {
    private static final TraceComponent tc = Tr.register(X509TokenKeyLocator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509TokenKeyLocator.class.getName();

    public Key getKey(Map map, Map map2) throws SoapSecurityException {
        Key key;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Map type,Map context)");
        }
        if (!this._initialized) {
            this.doInit();
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map2.get("com.ibm.wsspi.wssecurity.core.messageContext");
        String string = (String)map.get(Constants.WSSECURITY_KEYINFO_TYPE);
        if (string == null) {
            bl7 = false;
            bl6 = false;
            bl5 = false;
            bl4 = false;
            bl3 = false;
        } else {
            bl3 = ConfigUtil.isKeyInfoKeyname(string);
            bl4 = ConfigUtil.isKeyInfoKeyid(string);
            bl5 = ConfigUtil.isKeyInfoStrref(string);
            bl6 = ConfigUtil.isKeyInfoEmb(string);
            bl7 = ConfigUtil.isKeyInfoX509issuer(string);
        }
        String string2 = (String)map.get(Constants.WSSECURITY_KEY_TYPE);
        if (string2 == null) {
            bl2 = false;
            bl = false;
        } else {
            bl = "VerifyingKey".equals(string2);
            bl2 = "DecryptingKey".equals(string2);
        }
        if (!bl && !bl2) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getKey02", string2);
        }
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)map.get(Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoType [" + string + "].");
            Tr.debug(tc, "KeyType [" + string2 + "].");
            Tr.debug(tc, "Configuration of a TokenConsumer [" + tokenConsumerConfig + "].");
        }
        if ((key = (Key)map2.remove(this.getClass())) == null) {
            X509Certificate x509Certificate = this.getCert(bl3, bl4, bl5, bl6, bl7, tokenConsumerConfig, map, map2);
            if (x509Certificate == null) {
                throw SoapSecurityException.format("security.wssecurity.X509IssuerContentGenerator.getKey01");
            }
            map2.put(x509Certificate.getPublicKey(), x509Certificate);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "(key, certificate) put in context");
            }
            if (bl2) {
                key = this.getPrivateKey(x509Certificate);
            } else if (bl) {
                key = this.getPublicKey(x509Certificate);
            }
        }
        map2.put(this.getClass(), key);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(Map type, Map context) returns Key[" + key + "]");
        }
        return key;
    }

    private X509Certificate getCert(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, TokenConsumerConfig tokenConsumerConfig, Map map, Map map2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCert(boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "TokenConsumerConfig tconfig," + "Map type," + "Map context)");
        }
        X509Certificate x509Certificate = null;
        String string = null;
        if (bl) {
            string = (String)map.get(Constants.WSSECURITY_KEY_NAME);
        } else if (bl2) {
            string = (String)map.get(Constants.WSSECURITY_KEY_ID);
        } else if (bl3) {
            string = (String)map.get(Constants.WSSECURITY_KEY_REFERENCE);
        } else if (bl4) {
            string = (String)map.get(Constants.WSSECURITY_KEY_EMBID);
        } else if (bl5) {
            object = (String)map.get(Constants.WSSECURITY_KEY_ISSUERNAME);
            String string2 = (String)map.get(Constants.WSSECURITY_KEY_ISSUERSERIAL);
            if (object != null && string2 != null) {
                string = (String)object + ":" + string2;
            }
        }
        object = (X509BSToken)TokenManager.getToken(map2, tokenConsumerConfig, string);
        if (object != null) {
            if (((WSSToken)object).getError() != null) {
                throw ((WSSToken)object).getError();
            }
            x509Certificate = ((X509BSToken)object).getCert();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getToken(boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "Map context)" + " returns X509Certificate[" + x509Certificate + "]");
        }
        return x509Certificate;
    }

    private Key getPrivateKey(X509Certificate x509Certificate) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateKey(X509Certificate cert)");
        }
        Key key = null;
        if (x509Certificate != null && this._keylist != null) {
            String string = KeyInfo.X509Data.encodeDName(x509Certificate.getSubjectDN().getName());
            Iterator iterator = this._keylist.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string.equals(string2 = KeyInfo.X509Data.encodeDName(string2))) continue;
                key = ((KeyStoreKeyLocator.KeyInformation)this._keylist.get(string2)).getPrivateOrSecretKey();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateKey(X509Certificate cert) returns Key[" + key + "]");
        }
        return key;
    }

    private Key getPublicKey(X509Certificate x509Certificate) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPublicKey(X509Certificate cert[" + x509Certificate + "])");
        }
        PublicKey publicKey = null;
        if (x509Certificate != null) {
            publicKey = x509Certificate.getPublicKey();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPublicKey(X509Certificate cert) returns Key[" + publicKey + "]");
        }
        return publicKey;
    }
}

