/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.LoginProcessor;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.TokenPropagationCallbackHandler;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import com.ibm.wsspi.wssecurity.auth.token.LTPATokenWrapper;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LTPATokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register(LTPATokenConsumer.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPATokenConsumer.class.getName();
    private boolean _initialized = false;
    static /* synthetic */ Class array$B;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        QName qName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Node target[" + DOMUtil.getDisplayName(node) + "], " + "Map context)");
        }
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)map.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TokenConsumerConfig [" + tokenConsumerConfig + "].");
        }
        if ((qName = tokenConsumerConfig.getType()) == null) {
            qName = Constants.LTPA_TOKEN;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No token value type defined in the Token Consumer configuration, defualt [" + Constants.LTPA_TOKEN.toString() + "] is used.");
            }
        } else if (!qName.equals(Constants.LTPA_TOKEN) && !qName.equals(Constants.LTPA_TOKEN_PROPAGATION)) {
            String string = Constants.LTPA_TOKEN.toString() + ", " + Constants.LTPA_TOKEN_PROPAGATION.toString();
            throw SoapSecurityException.format("security.wssecurity.WSEC0162E", new String[]{qName.toString(), clsName, string});
        }
        if (node.getNodeType() == 1) {
            Object object;
            Object object2;
            Element element = (Element)node;
            String string = null;
            String string2 = IdUtil.getInstance().getIdAttributeName(element);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The identifier attribute of the target element is [" + string2 + "].");
            }
            if (string2 != null) {
                string = element.getAttribute(string2);
            }
            byte[] byArray = Base64.decode(DOMUtil.getStringValue(node));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Base64-decoded binary credential [" + byArray + "]");
            }
            if (byArray == null || byArray.length == 0) {
                throw SoapSecurityException.format("security.wssecurity.WSEC0163E");
            }
            QName qName2 = DOMUtil.getQName(element, element.getAttribute("ValueType"));
            boolean bl = false;
            if (qName2 == null) {
                throw SoapSecurityException.format("security.wssecurity.WSEC0164E", new String[]{qName.toString()});
            }
            if (!Constants.LTPA_TOKEN.equals(qName2)) {
                if (Constants.LTPA_TOKEN_PROPAGATION.equals(qName2)) {
                    bl = true;
                } else {
                    String string3 = Constants.LTPA_TOKEN.toString() + ", " + Constants.LTPA_TOKEN_PROPAGATION.toString();
                    throw SoapSecurityException.format("security.wssecurity.WSEC0165E", new String[]{qName.toString(), clsName, string3});
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token propagation is " + bl);
            }
            LTPAToken lTPAToken = null;
            if (bl) {
                int n;
                WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface;
                ArrayList arrayList;
                SecurityCache securityCache;
                Object[] objectArray;
                block73: {
                    object2 = null;
                    objectArray = null;
                    object = null;
                    securityCache = null;
                    arrayList = null;
                    wSCredentialTokenMapperInterface = null;
                    wSCredentialTokenMapperInterface = _wsCredToken._wsCredTokenMapper;
                    securityCache = _authCacheClass._authCache;
                    try {
                        arrayList = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(byArray);
                        objectArray = this.getSubjectFromTokenHolderCacheKey(null, arrayList);
                    }
                    catch (WSSecurityException wSSecurityException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Caught WSSecurityException trying to get cached Subject: " + wSSecurityException);
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block73;
                        Tr.debug(tc, "Caught Exception trying to get cached Subject: " + exception);
                    }
                }
                if (objectArray != null) {
                    object2 = (Subject)objectArray[0];
                    object = (String)objectArray[1];
                }
                WSCredential wSCredential = null;
                WSPrincipal wSPrincipal = null;
                if (object2 != null) {
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object2);
                    wSPrincipal = SubjectHelper.getPrincipalFromSubject((Subject)object2);
                    if (wSCredential != null) {
                        boolean bl2;
                        boolean bl3;
                        block74: {
                            bl3 = wSCredential.isDestroyed();
                            n = 0;
                            try {
                                n = wSCredential.isForwardable();
                            }
                            catch (Exception exception) {
                                bl3 = true;
                            }
                            bl2 = false;
                            if (securityCache != null && wSCredentialTokenMapperInterface != null) {
                                try {
                                    bl2 = wSCredentialTokenMapperInterface.checkCushionValidityOfAllTokens((Subject)object2, securityCache.getCushion());
                                }
                                catch (WSLoginFailedException wSLoginFailedException) {
                                    if (!tc.isDebugEnabled()) break block74;
                                    Tr.debug(tc, "Exception when running checkCushionValidityOfAllTokens");
                                }
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            if (n != 0) {
                                Tr.debug(tc, "credential is forwardable, subject valid = " + bl2);
                            } else {
                                Tr.debug(tc, "non-forwardable Subject");
                            }
                        }
                        if (bl3 || n != 0 && !bl2) {
                            object2 = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cached subject is valid.");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No WSCredential in Subject, logging in again.");
                        }
                        object2 = null;
                    }
                }
                if (object2 == null) {
                    Object object3;
                    wSCredential = null;
                    wSPrincipal = null;
                    String string4 = tokenConsumerConfig.getJAASConfig();
                    if (string4 == null || string4.length() == 0) {
                        string4 = "system.WSS_INBOUND";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using JAAS config: " + string4);
                    }
                    n = 0;
                    if (arrayList != null) {
                        n = arrayList.size();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tokenList size = " + n);
                    }
                    byte[] byArray2 = null;
                    for (int i = 0; i < n; ++i) {
                        object3 = arrayList.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "tokenList object [" + i + "] = " + object3.getClass().getName());
                        }
                        if (!(object3 instanceof TokenHolder)) continue;
                        TokenHolder tokenHolder = (TokenHolder)object3;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "th[" + i + "].name = " + tokenHolder.getName());
                            Tr.debug(tc, "th[" + i + "].version = " + tokenHolder.getVersion());
                        }
                        if (!"com.ibm.ws.security.token.AuthorizationTokenImpl".equals(tokenHolder.getName())) continue;
                        byArray2 = tokenHolder.getBytes();
                        if (!tc.isDebugEnabled()) continue;
                        if (byArray2 != null && byArray2.length > 0) {
                            Tr.debug(tc, "Got cred bytes from authz TokenHolder");
                            continue;
                        }
                        Tr.debug(tc, "Cred bytes from authz TokenHolder was null or zero-length");
                    }
                    LoginContext loginContext = null;
                    try {
                        object3 = new TokenPropagationCallbackHandler(map, arrayList, byArray2);
                        loginContext = new LoginContext(string4, (CallbackHandler)object3);
                        loginContext.login();
                    }
                    catch (LoginException loginException) {
                        Tr.processException((Throwable)loginException, LTPATokenConsumer.class.getName() + ".invoke()", "361", this);
                        throw new SoapSecurityException("Error logging in: " + loginException.getClass().getName() + ": " + loginException.getMessage());
                    }
                    object2 = object3 = loginContext.getSubject();
                    if (object == null || ((String)object).length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No cache key string found in token list; will not cache new subject.");
                        }
                    } else if (securityCache != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Caching new subject with cache key string: " + (String)object);
                        }
                        securityCache.insert((Subject)object3, new Object[]{object});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not caching new subject because Securitycache instance is null.");
                    }
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object3);
                    wSPrincipal = SubjectHelper.getPrincipalFromSubject((Subject)object3);
                }
                final LTPAToken lTPAToken2 = lTPAToken = new LTPATokenWrapper(string, null, wSCredential, wSPrincipal);
                final TokenConsumerConfig tokenConsumerConfig2 = tokenConsumerConfig;
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        lTPAToken2.setUsedTokenConsumer(tokenConsumerConfig2);
                        return null;
                    }
                });
                LTPATokenConsumer.setTokenToSubject(map, lTPAToken);
                if (object2 != null) {
                    LoginProcessor.addToSubject(map, (Subject)object2);
                }
            } else {
                Object object4;
                Object object5;
                Object object6;
                lTPAToken = new LTPAToken(string, null);
                object2 = (Boolean)tokenConsumerConfig.getProperties().get("com.ibm.wsspi.wssecurity.token.decouple");
                boolean bl4 = true;
                if (object2 != null) {
                    bl4 = (Boolean)object2;
                }
                object = null;
                object = !bl4 ? element : DOMUtil.clone(element);
                lTPAToken.setElement((Element)object);
                final LTPAToken lTPAToken3 = lTPAToken;
                final TokenConsumerConfig tokenConsumerConfig3 = tokenConsumerConfig;
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        lTPAToken3.setUsedTokenConsumer(tokenConsumerConfig3);
                        return null;
                    }
                });
                LTPATokenConsumer.setTokenToSubject(map, lTPAToken);
                final LTPAToken lTPAToken4 = lTPAToken;
                final byte[] byArray3 = byArray;
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        lTPAToken4.setBytes(byArray3);
                        return null;
                    }
                });
                WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                Set set = wSSConsumerConfig.getCallers();
                boolean bl5 = false;
                if (set != null) {
                    object6 = set.iterator();
                    while (object6.hasNext()) {
                        object5 = (WSSConsumerConfig.CallerConfig)object6.next();
                        object4 = object5.getTokenType();
                        if (!((QName)object4).equals(qName2)) continue;
                        bl5 = true;
                        break;
                    }
                }
                if (!bl5) {
                    object6 = null;
                    try {
                        object5 = getLTPAMethod._validateLTPATokenMethod;
                        object4 = getLTPAMethod._ltpaServerObject;
                        if (object5 != null && object4 != null) {
                            object6 = ((Method)object5).invoke(object4, new Object[]{byArray});
                        }
                    }
                    catch (Exception exception) {
                        throw new SoapSecurityException("security.wssecurityLTPA Token validation failed");
                    }
                    if (object6 == null) {
                        throw new SoapSecurityException("security.wssecurityLTPA Token validation failed");
                    }
                }
            }
            object2 = tokenConsumerConfig.getJAASConfig();
            if (object2 != null && !bl && tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.LTPATokenConsumer.s01", object2);
            }
            if (tokenConsumerConfig.getTrustedIDEvaluator() != null) {
                boolean bl6 = tokenConsumerConfig.getTrustedIDEvaluator().evaluate("***");
                object = lTPAToken;
                if (!bl6) {
                    Tr.warning(tc, "security.wssecurity.UsernameTokenConsumer.s02", new Object[]{string});
                }
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((LTPAToken)object, bl6){
                    private final /* synthetic */ LTPAToken val$tokenPriv;
                    private final /* synthetic */ boolean val$trusted;
                    {
                        this.val$tokenPriv = lTPAToken;
                        this.val$trusted = bl;
                    }

                    public Object run() {
                        this.val$tokenPriv.setTrusted(this.val$trusted);
                        return null;
                    }
                });
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Acquired token is [" + lTPAToken + "].");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WARNING: Unsupported node type: " + node.getNodeName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Node target,Map context)");
        }
    }

    private static void setTokenToSubject(Map map, LTPAToken lTPAToken) {
        TokenManager.setToken(map, lTPAToken);
    }

    private Object[] getSubjectFromTokenHolderCacheKey(byte[] byArray, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectFromTokenHolderCacheKey", new Object[]{byArray, list});
        }
        Subject subject = null;
        String string = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                Object object;
                TokenHolder tokenHolder = (TokenHolder)list.get(i);
                if (!tokenHolder.getName().equals("com.ibm.wsspi.security.cred.cacheKey")) continue;
                byte[] byArray2 = tokenHolder.getBytes();
                if (byArray2 != null) {
                    string = StringBytesConversion.getConvertedString(byArray2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cache key from token holder list: " + string);
                    }
                    object = _authCacheClass._authCache;
                    subject = object.getSubject(string);
                }
                if (subject == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Subject using cacheKey from prop token.");
                }
                if (byArray == null) continue;
                object = SubjectHelper.getWSCredentialFromSubject(subject);
                SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                boolean bl2 = bl = object != null && Arrays.equals(byArray, object.getCredentialToken()) || singleSignonToken != null && Arrays.equals(byArray, singleSignonToken.getBytes());
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject found from cacheKey does not have matching LTPA token.");
                }
                subject = null;
            }
        }
        Object[] objectArray = null;
        if (subject != null || string != null) {
            objectArray = new Object[]{subject, string};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectFromTokenHolderCacheKey", objectArray);
        }
        return objectArray;
    }

    private static class _authCacheClass {
        static SecurityCache _authCache = null;
        private static final String FACTORY_CLASS = "com.ibm.ws.security.auth.AuthCache";

        private _authCacheClass() {
        }

        private static Method getAuthCacheGetInstanceMethod() {
            Method method2 = null;
            Class clazz = _authCacheClass.getAuthCacheClass();
            if (clazz != null) {
                try {
                    method2 = clazz.getMethod("getInstance", null);
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".getAuthCacheGetInstanceMethod", "730");
                    throw new UndeclaredThrowableException(exception);
                }
            }
            return method2;
        }

        private static Class getAuthCacheClass() {
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz2 = classLoader != null ? classLoader.loadClass(FACTORY_CLASS) : Class.forName(FACTORY_CLASS);
                clazz = clazz2;
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".getAuthCacheClass", "757");
                throw new UndeclaredThrowableException(exception);
            }
            return clazz;
        }

        static {
            try {
                Method method2 = _authCacheClass.getAuthCacheGetInstanceMethod();
                if (method2 != null) {
                    _authCache = (SecurityCache)method2.invoke(null, null);
                    if (tc.isDebugEnabled()) {
                        if (_authCache == null) {
                            Tr.debug(tc, "AuthCache.getInstance method returned null.");
                        } else {
                            Tr.debug(tc, "AuthCache.getInstance method returned an AuthCache instance.");
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get AuthCache.getInstance method.");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, clsName + "init", "714");
            }
        }
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, clsName + "init", "690");
            }
        }
    }

    private static class getLTPAMethod {
        private static final String LTPA_SERVER_OBJECT_CLASS = "com.ibm.ws.security.ltpa.LTPAServerObject";
        private static Class _ltpaServerObjectClass = null;
        private static Method _validateLTPATokenMethod = null;
        private static Method _getLTPAServerMethod = null;
        private static Object _ltpaServerObject = null;

        private getLTPAMethod() {
        }

        static {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    if (_ltpaServerObjectClass == null) {
                        Class<?> clazz = null;
                        try {
                            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                            clazz = classLoader != null ? classLoader.loadClass(getLTPAMethod.LTPA_SERVER_OBJECT_CLASS) : Class.forName(getLTPAMethod.LTPA_SERVER_OBJECT_CLASS);
                            _ltpaServerObjectClass = clazz;
                        }
                        catch (Exception exception) {
                            throw new UndeclaredThrowableException(exception);
                        }
                    }
                    if (_getLTPAServerMethod == null && _ltpaServerObjectClass != null) {
                        try {
                            _getLTPAServerMethod = _ltpaServerObjectClass.getMethod("getLTPAServer", new Class[0]);
                            if (_getLTPAServerMethod != null) {
                                _ltpaServerObject = _getLTPAServerMethod.invoke(null, new Object[0]);
                            }
                        }
                        catch (Exception exception) {
                            throw new UndeclaredThrowableException(exception);
                        }
                    }
                    if (_validateLTPATokenMethod == null && _ltpaServerObjectClass != null) {
                        try {
                            _validateLTPATokenMethod = _ltpaServerObjectClass.getMethod("validateToken", array$B == null ? (array$B = LTPATokenConsumer.class$("[B")) : array$B);
                        }
                        catch (Exception exception) {
                            throw new UndeclaredThrowableException(exception);
                        }
                    }
                    return null;
                }
            });
        }
    }
}

