/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.callback.X509BSCallback;
import com.ibm.wsspi.wssecurity.auth.token.TokenId;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509TokenGenerator
implements TokenGeneratorComponent {
    private static final TraceComponent tc = Tr.register(X509TokenGenerator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509TokenGenerator.class.getName();
    private static final String VALUE_TYPE = "ValueType".intern();
    private static final String ENCODING_TYPE = "EncodingType".intern();
    private static final int ITSHA1_OCTETS = 20;
    private static final int IT60SHA1_OCTETS = 8;
    private static final String OID_KEYIDENTIFIER = "2.5.29.14";
    private static final byte BER_SEQUENCE = 48;
    private static final byte BER_BITSTRING = 3;
    private static final int STATUS_OK = 0;
    private static final int STATUS_CERT_ERROR = 1;
    private static final int STATUS_KEYID_ERROR = 2;
    private static final int STATUS_KEY_ERROR = 4;
    private final Map _cert2info = new Hashtable();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        boolean bl;
        Object object;
        Object object2;
        HashMap<String, Object> hashMap;
        Object v;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        QName qName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map context)");
        }
        if (element == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", "null");
        }
        TokenGeneratorConfig tokenGeneratorConfig = (TokenGeneratorConfig)map.remove("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TokenGeneratorConfig [" + tokenGeneratorConfig + "].");
        }
        if (!(com.ibm.ws.webservices.wssecurity.Constants.X509V3.equals(qName = tokenGeneratorConfig.getType()) || com.ibm.ws.webservices.wssecurity.Constants.X509V3_OLD.equals(qName) || com.ibm.ws.webservices.wssecurity.Constants.PKI_PATH.equals(qName) || com.ibm.ws.webservices.wssecurity.Constants.PKCS7.equals(qName))) {
            throw new SoapSecurityException("Unsupported value type: " + qName);
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int n = 0;
        Object v2 = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v2 != null && v2 instanceof Integer) {
            n = (Integer)v2;
        }
        boolean bl7 = tokenGeneratorConfig.isStandAlone();
        String string = (String)map.remove(Constants.WSSECURITY_KEYINFO_TYPE);
        if (string == null) {
            bl6 = false;
            bl5 = false;
            bl4 = false;
            bl3 = false;
            bl2 = false;
        } else {
            bl2 = ConfigUtil.isKeyInfoKeyname(string);
            bl3 = ConfigUtil.isKeyInfoKeyid(string);
            bl4 = ConfigUtil.isKeyInfoStrref(string);
            bl5 = ConfigUtil.isKeyInfoEmb(string);
            bl6 = ConfigUtil.isKeyInfoX509issuer(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoType: isKeyName, isKeyId, isStrref, isEmb, isX509: " + bl2 + ", " + bl3 + ", " + bl4 + ", " + bl5 + ", " + bl6 + ".");
        }
        CallbackHandlerConfig callbackHandlerConfig = tokenGeneratorConfig.getCallbackHandler();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + tokenGeneratorConfig + "].");
        }
        boolean bl8 = false;
        if (callbackHandlerConfig != null && (v = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION)) != null) {
            bl8 = ConfigUtil.isTrue(v.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "identityAssertion is [" + bl8 + "].");
        }
        X509Certificate x509Certificate = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (bl8) {
            Object object3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the cert of initial sender...");
            }
            if (sOAPMessageContext != null && (object3 = sOAPMessageContext.getProperty("com.ibm.wsspi.wssecurity.username.initialSenderCert")) != null && object3 instanceof X509Certificate) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The cert of initial sender is used.");
                }
                x509Certificate = (X509Certificate)object3;
                string4 = "Initial sender certificate";
            }
        }
        if (x509Certificate == null && callbackHandlerConfig != null) {
            void var25_40;
            Object object4;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking callback handler...");
            }
            hashMap = new HashMap();
            object2 = callbackHandlerConfig.getClassName();
            CallbackHandler callbackHandler = callbackHandlerConfig.getInstance();
            if (callbackHandler == null) {
                try {
                    void var26_52;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Instantiating the callback handler [" + (String)object2 + "]...");
                    }
                    ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                        public Object run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    Object var26_49 = null;
                    if (classLoader != null) {
                        Class<?> clazz = classLoader.loadClass((String)object2);
                    } else {
                        Class<?> clazz = Class.forName((String)object2);
                    }
                    if (!CallbackHandler.class.isAssignableFrom((Class<?>)var26_52)) throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", (String)object2, CallbackHandler.class.getName());
                    hashMap.put("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey", callbackHandlerConfig);
                    object4 = var26_52.getConstructor(Map.class);
                    callbackHandler = (CallbackHandler)((Constructor)object4).newInstance(hashMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + (String)object2 + "].");
                    }
                }
                catch (SoapSecurityException soapSecurityException) {
                    throw soapSecurityException;
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".invoke", "312");
                    Tr.error(tc, "security.wssecurity.X509TokenGenerator.s01", new Object[]{object2, exception});
                    throw SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s01", (String)object2, (Throwable)exception);
                }
                callbackHandlerConfig.setInstance(callbackHandler);
            }
            Object var25_36 = null;
            if (bl7) {
                String string5 = "com.ibm.wsspi.wssecurity.token.standAlone";
            } else {
                String string6;
                String string7 = (String)map.remove(Constants.WSSECURITY_KEY_NAMEREF);
                if (string7 != null && (string6 = KeyInfo.X509Data.encodeDName(string7)) != null && string6.length() > 0) {
                    String string8 = string6;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reference name of a key[" + (String)var25_40 + "].");
            }
            hashMap = new HashMap<String, Object>();
            if (sOAPMessageContext != null) {
                hashMap.put("com.ibm.wsspi.wssecurity.core.messageContext", sOAPMessageContext);
            }
            hashMap.put(Constants.WSSECURITY_KEY_NAMEREF, var25_40);
            if (tokenGeneratorConfig.getProvider() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Provider is " + tokenGeneratorConfig.getProvider() + ".");
                }
                hashMap.put("com.ibm.wsspi.wssecurity.token.x509.provider", tokenGeneratorConfig.getProvider());
            }
            if (tokenGeneratorConfig.getCertStores() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "A list of cert stores are " + tokenGeneratorConfig.getCertStores() + ".");
                }
                hashMap.put("com.ibm.wsspi.wssecurity.token.x509.certStores", tokenGeneratorConfig.getCertStores());
            }
            Callback[] callbackArray = new Callback[]{new X509BSCallback(), new PropertyCallback(hashMap)};
            try {
                callbackHandler.handle(callbackArray);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                Tr.processException(unsupportedCallbackException, clsName + ".invoke", "380");
                Tr.error(tc, "security.wssecurity.X509TokenGenerator.s02", new Object[]{object2, unsupportedCallbackException});
                SoapSecurityException soapSecurityException = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", (String)object2, (Throwable)unsupportedCallbackException);
                soapSecurityException.initCause(unsupportedCallbackException);
                throw soapSecurityException;
            }
            catch (IOException iOException) {
                void var28_65;
                IOException iOException2 = iOException;
                if (iOException.getCause() != null) {
                    Throwable throwable = iOException.getCause();
                }
                Tr.processException(iOException, clsName + ".invoke", "389");
                Tr.error(tc, "security.wssecurity.X509TokenGenerator.s02", new Object[]{object2, var28_65});
                SoapSecurityException soapSecurityException = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", (String)object2, (Throwable)var28_65);
                soapSecurityException.initCause(iOException);
                throw soapSecurityException;
            }
            object4 = (X509BSCallback)callbackArray[0];
            x509Certificate = ((X509BSCallback)object4).getCert();
            if (((X509BSCallback)object4).getBinary() != null) {
                string2 = Base64.encode(((X509BSCallback)object4).getBinary());
            }
            string3 = ((X509BSCallback)object4).getKeyStorePath();
            string4 = ((X509BSCallback)object4).getAlias();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeeded to invoke the callback handler [" + (String)object2 + "].");
            }
        }
        if ((hashMap = X509TokenGenerator.getInfo(this._cert2info, string3, string4, x509Certificate, string2)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: Can't get necessary information about the certificate");
            }
        } else if (string2 == null) {
            string2 = ((CertInformation)((Object)hashMap)).getBinary();
        }
        if (x509Certificate == null || string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.setCertToSubject01");
        }
        object2 = X509TokenGenerator.checkToken(map, tokenGeneratorConfig, string, x509Certificate);
        boolean bl9 = false;
        boolean bl10 = true;
        boolean bl11 = false;
        boolean bl12 = true;
        Object var28_66 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        if (bl7 || bl4 || bl5) {
            boolean bl13 = true;
            if (object2 != null) {
                if (bl7 || bl4) {
                    bl13 = false;
                    boolean bl14 = false;
                    bl12 = false;
                } else if (bl5) {
                    boolean bl15 = false;
                    bl12 = true;
                }
            }
            if (!bl13) {
                string9 = ((WSSToken)object2).getId();
            } else {
                Object object5;
                if (sOAPMessageContext != null && (object5 = sOAPMessageContext.getProperty(Constants.WSSECURITY_TOKEN_PROPERGATION)) != null && object5 instanceof Set) {
                    object = ((Set)object5).iterator();
                    while (object.hasNext()) {
                        Object e2 = object.next();
                        if (!(e2 instanceof TokenId)) continue;
                        TokenId tokenId = (TokenId)e2;
                        if (!tokenGeneratorConfig.getType().equals(tokenId.getType())) continue;
                        if (string9 == null) {
                            string9 = tokenId.getId();
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "More than one TokenId objects are found. Since the runtime tentatively uses the first identifier + \"" + string9 + "\"," + " it neglects the identifier \"" + tokenId.getId() + "\".");
                    }
                }
                if (string9 == null) {
                    string9 = IdUtil.getInstance().makeUniqueId(document, "x509bst_");
                }
                bl9 = true;
                bl = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenIdentifier [" + string9 + "].");
            }
            if (bl4) {
                String string15 = string9;
                string10 = "#" + string9;
            } else if (bl7) {
                String string16 = string9;
            }
        } else if (bl3) {
            if (hashMap == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: Can't get necessary information about the certificate");
                }
            } else {
                QName qName2 = (QName)map.remove(Constants.WSSECURITY_KEY_ENCODING);
                object = (QName)map.remove(Constants.WSSECURITY_KEY_IDTYPE);
                if (qName2 == null || NamespaceUtil.equals(qName2, com.ibm.ws.webservices.wssecurity.Constants.BASE64_BINARY)) {
                    if (object == null || NamespaceUtil.equals((QName)object, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                        string9 = ((CertInformation)hashMap).getB64KeyId();
                    } else {
                        if (!NamespaceUtil.equals((QName)object, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + object);
                        string9 = ((CertInformation)hashMap).getB64KeyId60();
                    }
                } else {
                    if (!NamespaceUtil.equals(qName2, com.ibm.ws.webservices.wssecurity.Constants.HEX_BINARY)) throw SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token15", qName2.toString());
                    if (object == null || NamespaceUtil.equals((QName)object, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                        string9 = ((CertInformation)hashMap).getHexKeyId();
                    } else {
                        if (!NamespaceUtil.equals((QName)object, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + object);
                        string9 = ((CertInformation)hashMap).getHexKeyId60();
                    }
                }
                string11 = string9;
                if (object2 != null && string9.equals(((WSSToken)object2).getId())) {
                    boolean bl16 = false;
                    bl12 = false;
                }
            }
        } else if (bl2) {
            if (hashMap == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: Can't get necessary information about the certificate");
                }
            } else {
                string12 = string9 = ((CertInformation)hashMap).getSubjectName();
            }
            if (object2 != null && string9.equals(((WSSToken)object2).getId())) {
                boolean bl17 = false;
                bl12 = false;
            }
        } else if (bl6) {
            if (hashMap == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: Can't get necessary information about the certificate");
                }
            } else {
                string9 = ((CertInformation)hashMap).getIssuerName() + ":" + ((CertInformation)hashMap).getIssuerSerial();
                string13 = ((CertInformation)hashMap).getIssuerName();
                string14 = ((CertInformation)hashMap).getIssuerSerial();
            }
            if (object2 != null && string9.equals(((WSSToken)object2).getId())) {
                boolean bl18 = false;
                bl12 = false;
            }
        }
        if (bl5) {
            map.put(Constants.WSSECURITY_KEY_EMBID, string9);
        } else {
            map.remove(Constants.WSSECURITY_KEY_EMBID);
        }
        if (string10 != null) {
            map.put(Constants.WSSECURITY_KEY_REFERENCE, string10);
        } else {
            map.remove(Constants.WSSECURITY_KEY_REFERENCE);
        }
        if (string11 != null) {
            map.put(Constants.WSSECURITY_KEY_ID, string11);
        } else {
            map.remove(Constants.WSSECURITY_KEY_ID);
        }
        if (string12 != null) {
            map.put(Constants.WSSECURITY_KEY_NAME, string12);
        } else {
            map.remove(Constants.WSSECURITY_KEY_NAME);
        }
        if (string13 != null) {
            map.put(Constants.WSSECURITY_KEY_ISSUERNAME, string13);
        } else {
            map.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
        }
        if (string14 != null) {
            map.put(Constants.WSSECURITY_KEY_ISSUERSERIAL, string14);
        } else {
            map.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
        }
        Element element2 = null;
        if (bl || bl12) {
            void var25_48;
            if (var25_48 != false) {
                void var28_69;
                object = bl9 ? element : null;
                element2 = X509TokenGenerator.createTokenElement(document, (Element)object, tokenGeneratorConfig.getType(), string2, (String)var28_69, n);
            } else if (object2 != null) {
                element2 = (Element)((WSSToken)object2).getElement().cloneNode(true);
            }
        }
        if (bl) {
            element2 = (Element)element.insertBefore(element2, element.getFirstChild());
        }
        if (bl12) {
            X509TokenGenerator.setTokenToSubject(map, tokenGeneratorConfig, x509Certificate, string9, string, element2);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "invoke(Document doc,Element parent,Map context)");
    }

    private static X509BSToken checkToken(Map map, TokenGeneratorConfig tokenGeneratorConfig, String string, X509Certificate x509Certificate) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkToken(Map context,TokenGeneratorConfig config,String keyInfoType[" + string + "]," + "X509Certificate cert)");
        }
        X509BSToken x509BSToken = null;
        Set set = TokenManager.getTokens(map);
        if (set != null && set.size() > 0) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                X509BSToken x509BSToken2;
                Object e2 = iterator.next();
                if (!(e2 instanceof X509BSToken) || !(x509BSToken2 = (X509BSToken)e2).getUsedTokenGenerator().equals(tokenGeneratorConfig) || !x509BSToken2.getKeyInfoType().equals(string) || !x509BSToken2.getCert().equals(x509Certificate)) continue;
                x509BSToken = x509BSToken2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkToken(Map context,TokenGeneratorConfig config,String keyInfoType,X509Certificate cert) returns X509BSToken[" + x509BSToken + "]");
        }
        return x509BSToken;
    }

    protected static Element createTokenElement(Document document, Element element, QName qName, String string, String string2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTokenElement(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "QName tokenType[" + qName + "]," + "String binary," + "String insertId[" + string2 + "]," + "int wssVersion[" + n + "])");
        }
        String string3 = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[0][n];
        String string4 = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[1][n];
        boolean bl = false;
        String string5 = null;
        if (element != null) {
            string5 = DOMUtil.getNamespacePrefix(element, string3);
        }
        if (string5 == null) {
            bl = true;
            string5 = "wsse:";
        } else if (string5.length() > 0) {
            string5 = string5 + ":";
        }
        Element element2 = document.createElementNS(string3, string5 + "BinarySecurityToken");
        if (bl) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", string3);
        }
        if (string2 != null) {
            bl = false;
            String string6 = DOMUtil.getNamespacePrefix(element, string4);
            if (string6 == null) {
                bl = true;
                string6 = "wsu:";
            } else if (string6.length() > 0) {
                string6 = string6 + ":";
            }
            if (bl) {
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", string4);
            }
            element2.setAttributeNS(string4, string6 + "Id", string2);
        }
        DOMUtil.setQNameAttr(element2, null, ENCODING_TYPE, com.ibm.ws.webservices.wssecurity.Constants.BASE64_BINARY, n);
        DOMUtil.setQNameAttr(element2, null, VALUE_TYPE, qName, n);
        if (string != null) {
            element2.appendChild(document.createTextNode(string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTokenElement(Document doc,Element parent,QName valueType,byte[] binary,String insertId,int wssVersion) returns Element[" + DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    private static void setTokenToSubject(Map map, TokenGeneratorConfig tokenGeneratorConfig, X509Certificate x509Certificate, String string, String string2, Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenToSubject(Map context,TokenGeneratorConfig config,X509Certificate cert,String tokenId[" + string + "]," + "String keyInfoType[" + string2 + "]," + "Element elem[" + DOMUtil.getDisplayName(element) + "])");
        }
        X509BSToken x509BSToken = new X509BSToken(string, x509Certificate, tokenGeneratorConfig.getType());
        x509BSToken.setElement(element);
        x509BSToken.setReferenced(!tokenGeneratorConfig.isStandAlone());
        x509BSToken.setUsedTokenGenerator(tokenGeneratorConfig);
        x509BSToken.setKeyInfoType(string2);
        TokenManager.setToken(map, x509BSToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenToSubject(Map context,TokenGeneratorConfig config,X509Certificate cert,String tokenId,Element elem)");
        }
    }

    private static CertInformation getInfo(Map map, String string, String string2, X509Certificate x509Certificate, String string3) throws SoapSecurityException {
        CertInformation certInformation;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInfo(Map cert2info,String kspath[" + string + "]," + "String alias[" + string2 + "]," + "X509Certificate x509," + "String binary)");
        }
        if ((certInformation = (CertInformation)map.get(x509Certificate)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The cached information corresponding the specified certficate is found.");
            }
        } else if (x509Certificate != null) {
            int n = 0;
            String string4 = null;
            String string5 = x509Certificate.getSubjectDN().getName();
            String string6 = KeyInfo.X509Data.encodeDName(string5);
            String string7 = x509Certificate.getIssuerDN().getName();
            String string8 = KeyInfo.X509Data.encodeDName(string7);
            String string9 = x509Certificate.getSerialNumber().toString();
            long l = x509Certificate.getNotAfter().getTime();
            try {
                if (string3 == null) {
                    string3 = Base64.encode(x509Certificate.getEncoded());
                }
                x509Certificate.checkValidity();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                ++n;
                string4 = ConfigUtil.getMessage("security.wssecurity.X509BSToken.getBytes01", new String[]{string2});
            }
            catch (CertificateExpiredException certificateExpiredException) {
                ++n;
                string4 = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{string5, string2, string, certificateExpiredException.getClass().getName() + ": " + certificateExpiredException.getMessage()});
            }
            catch (CertificateException certificateException) {
                ++n;
                string4 = ConfigUtil.getMessage("security.wssecurity.WSEC5182E", new String[]{string5, string2, string, certificateException.getClass().getName() + ": " + certificateException.getMessage()});
            }
            String string10 = null;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            if (n == 0) {
                try {
                    byte[] byArray = X509TokenGenerator.makeIdentifier(x509Certificate, null);
                    string10 = Base64.encode(byArray);
                    string12 = Hex.encode(byArray);
                    byArray = X509TokenGenerator.makeIdentifier(x509Certificate, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1);
                    string11 = Base64.encode(byArray);
                    string13 = Hex.encode(byArray);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    n += 2;
                    string4 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + noSuchAlgorithmException.getClass().getName() + ": " + noSuchAlgorithmException.getMessage();
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    n += 2;
                    string4 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + invalidAlgorithmParameterException.getClass() + ": " + invalidAlgorithmParameterException.getMessage();
                }
            }
            certInformation = new CertInformation(string, string2, string3, string5, string6, string7, string8, string9, string10, string11, string12, string13, l, n, string4);
            map.put(x509Certificate, certInformation);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added Certificate information: " + certInformation + ".");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInfo(Map cert2info,String kspath,String alias,X509Certificate x509,byte[] binary) returns CertInformation[" + certInformation + "]");
        }
        return certInformation;
    }

    private static byte[] certToIdentifier(Certificate certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "certToIdentifier(Certificate cert)");
        }
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        byte[] byArray = ((X509Certificate)certificate).getExtensionValue(OID_KEYIDENTIFIER);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray.length - 4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "certToIdentifier(Certificate cert)");
        }
        return byArray2;
    }

    private static byte[] pubkeyToIdentifier(Certificate certificate, QName qName) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pubkeyToIdentifier(Certificate cert,QName idty[" + qName + "])");
        }
        byte[] byArray = null;
        if (certificate != null) {
            byte[] byArray2 = certificate.getPublicKey().getEncoded();
            if (byArray2[0] != 48) {
                throw new RuntimeException("Unknown encoded key: " + Hex.encode(byArray2));
            }
            int n = byArray2[1] & 0xFF;
            int n2 = (n & 0x80) == 0 ? 2 : 2 + (n & 0x7F);
            n = byArray2[n2 + 1] & 0xFF;
            if ((n & 0x80) == 0) {
                n2 += 2;
            } else {
                int n3 = n2 + 2;
                n2 += 2 + (n & 0x7F);
                switch (n & 0x7F) {
                    case 1: {
                        n = byArray2[n3] & 0xFF;
                        break;
                    }
                    case 2: {
                        n = ((byArray2[n3] & 0xFF) << 8) + (byArray2[n3 + 1] & 0xFF);
                        break;
                    }
                    case 3: {
                        n = ((byArray2[n3] & 0xFF) << 16) + ((byArray2[n3 + 1] & 0xFF) << 8) + (byArray2[n3 + 2] & 0xFF);
                        break;
                    }
                    case 4: {
                        n = ((byArray2[n3] & 0xFF) << 24) + ((byArray2[n3 + 1] & 0xFF) << 16) + ((byArray2[n3 + 2] & 0xFF) << 8) + (byArray2[n3 + 3] & 0xFF);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Integer overflow: " + Hex.encode(byArray2));
                    }
                }
            }
            if (byArray2[n2 += n] != 3) {
                throw new RuntimeException("Non BIT STRING: 0x" + Integer.toString(byArray2[n2] & 0xFF, 16));
            }
            n2 += ((n = byArray2[n2 + 1] & 0xFF) & 0x80) == 0 ? 3 : 3 + (n & 0x7F);
            AlgorithmFactory algorithmFactory = AlgorithmFactory.getInstance();
            MessageDigest messageDigest = algorithmFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            if (NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1) || qName == null) {
                messageDigest.update(byArray2, n2, byArray2.length - n2);
                byArray = messageDigest.digest();
                algorithmFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
            } else if (NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
                messageDigest.update(byArray2, n2, byArray2.length - n2);
                byte[] byArray3 = messageDigest.digest();
                algorithmFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
                byArray = new byte[8];
                byArray[0] = (byte)(64 + (byArray3[byArray3.length - 8] & 0xF));
                System.arraycopy(byArray3, byArray3.length - 8 + 1, byArray, 1, byArray.length - 1);
            } else {
                algorithmFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
                throw new IllegalArgumentException("Internal Error: " + qName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pubkeyToIdentifier(Certificate cert,QName idty)");
        }
        return byArray;
    }

    private static byte[] makeIdentifier(Certificate certificate, QName qName) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeIdentifier(Certificate cert,QName idty[" + qName + "])");
        }
        byte[] byArray = null;
        if (certificate != null && ((byArray = X509TokenGenerator.certToIdentifier(certificate)) == null || qName != null)) {
            if (qName == null || NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                if (byArray == null || byArray.length != 20) {
                    byArray = X509TokenGenerator.pubkeyToIdentifier(certificate, qName);
                }
            } else if (NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
                if (byArray == null || byArray.length != 8) {
                    byArray = X509TokenGenerator.pubkeyToIdentifier(certificate, qName);
                }
            } else {
                throw new IllegalArgumentException("Internal Error: " + qName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeIdentifier(Certificate cert,QName idty)");
        }
        return byArray;
    }

    private static class CertInformation {
        private String _kspath;
        private String _alias;
        private String _binary;
        private String _subjectDN;
        private String _encSubjectDN;
        private String _issuerDN;
        private String _encIssuerDN;
        private String _issuerSerial;
        private String _b64KeyId;
        private String _b64KeyId60;
        private String _hexKeyId;
        private String _hexKeyId60;
        private int _status;
        private long _expiration;
        private String _errorMes;

        private CertInformation(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, long l, int n, String string13) {
            this._kspath = string;
            this._alias = string2;
            this._binary = string3;
            this._subjectDN = string4;
            this._encSubjectDN = string5;
            this._issuerDN = string6;
            this._encIssuerDN = string7;
            this._issuerSerial = string8;
            this._b64KeyId = string9;
            this._b64KeyId60 = string10;
            this._hexKeyId = string11;
            this._hexKeyId60 = string12;
            this._expiration = l;
            this._status = n;
            this._errorMes = string13;
        }

        private String getBinary() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._binary;
        }

        private String getSubjectName() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._encSubjectDN;
        }

        private String getIssuerName() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._encIssuerDN;
        }

        private String getIssuerSerial() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._issuerSerial;
        }

        private String getB64KeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._b64KeyId;
        }

        private String getB64KeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._b64KeyId60;
        }

        private String getHexKeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._hexKeyId;
        }

        private String getHexKeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._hexKeyId60;
        }

        private void checkExpiration() throws SoapSecurityException {
            long l;
            if (this._expiration >= 0L && (l = this._expiration - System.currentTimeMillis()) < 0L) {
                ++this._status;
                this._errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{this._subjectDN, this._alias, this._kspath, "expiration time - current system time = " + l + " ms."});
                throw new SoapSecurityException(this._errorMes);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("keystorePath=[").append(this._kspath).append("], ");
            stringBuffer.append("alias=[").append(this._alias).append("], ");
            stringBuffer.append("status=[").append(this._status).append("], ");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

