/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.soapimpl.SOAPDocumentImpl;
import com.ibm.trl.util.xml.XPathProcessor;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.xml.soap.security.dsig.SOAPSignatureHandler;
import com.ibm.xml.soap.transport.AbstractSOAPHandler;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class AuthenticatedPartsChecker {
    private static final String XPATH_SIGNEDINFO = "./" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
    private static final String XPATH_REFERENCE = XPATH_SIGNEDINFO + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "Reference");
    private static final String XPATH_TRANSFORMS = "./" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "Transforms");
    private static final String XPATH_TRANSFORM = XPATH_TRANSFORMS + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "Transform");
    private static final String XPATH_ALGORITHM = XPATH_TRANSFORM + "/@Algorithm";
    private static final int FLAG_BODY = 0;
    private static final int FLAG_ROOT = 1;
    private static final Hashtable table = new Hashtable();
    private boolean[] flags = new boolean[]{false, false};

    AuthenticatedPartsChecker() {
    }

    void setFlag(String string) throws SOAPException {
        Integer n = (Integer)table.get(string.trim());
        if (n == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unsupported part: '" + string + "', please check <Reference part=\"...\"> in the configuration file");
        }
        int n2 = n;
        switch (n2) {
            case 0: 
            case 1: {
                this.flags[n2] = true;
                break;
            }
            default: {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unsupported part: '" + string + "', please check <Reference part=\"...\"> in the configuration file");
            }
        }
    }

    void check(IDResolver iDResolver, Element element) throws SOAPException {
        SOAPDocumentImpl sOAPDocumentImpl = new SOAPDocumentImpl(element.getOwnerDocument());
        Element element2 = sOAPDocumentImpl.getEnvelope().getDOMEntity();
        Element element3 = sOAPDocumentImpl.getEnvelope().getBody().getDOMEntity();
        NodeList nodeList = AbstractSOAPHandler.processXPath(element, XPATH_REFERENCE);
        this.checkReference(nodeList);
        if (this.flags[1]) {
            this.checkReference(iDResolver, nodeList, element2, "http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        }
        if (this.flags[0]) {
            this.checkReference(iDResolver, nodeList, element3, null);
        }
    }

    void checkReference(NodeList nodeList) throws SOAPException {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            if (!element.hasAttribute("URI")) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Reference without URI attribute is not supported.");
            }
            String string = element.getAttribute("URI");
            if ("".equals(string) || string.startsWith("#")) continue;
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "External Reference is not supported: '" + string + "'");
        }
    }

    void checkReference(IDResolver iDResolver, NodeList nodeList, Element element, String string) throws SOAPException {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Element element3 = (Element)nodeList.item(i);
            String string2 = element3.getAttribute("URI");
            if ("".equals(string2)) {
                element2 = element.getOwnerDocument().getDocumentElement();
            } else {
                if (!string2.startsWith("#")) continue;
                string2 = string2.substring(1);
                element2 = iDResolver.resolveID(element3.getOwnerDocument(), string2);
            }
            if (element2 == null || element2 != element) continue;
            if (string == null) {
                return;
            }
            NodeList nodeList2 = SOAPSignatureHandler.processXPath(element3, XPATH_ALGORITHM);
            if (nodeList2.getLength() != 1 || !string.equals(nodeList2.item(0).getNodeValue())) continue;
            return;
        }
        throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Authenticated Part '" + element.getNodeName() + "' required");
    }

    public String toString() {
        return "AuthenticatedpartsChecker(flag[FLAG_BODY]=" + this.flags[0] + " flag[FLAG_ROOT]=" + this.flags[1] + ")";
    }

    static {
        table.put("body", new Integer(0));
        table.put("root", new Integer(1));
    }
}

