/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.soap.SOAPDocument;
import com.ibm.trl.soap.SOAPHeaderEntry;
import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.QName;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.xml.soap.security.SOAPSecurity;
import com.ibm.xml.soap.security.dsig.SOAPIDResolver;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SOAPSignature
extends SOAPSecurity {
    public static final String ELEM_SIGNATURE = "Signature";
    public static final String ATTR_ID = "id";
    private static final QName[] ID_TYPE_ATTRS = new QName[]{new QName("http://schemas.xmlsoap.org/soap/security/2000-12", "id")};
    private IDResolver idResolver = new SOAPIDResolver(ID_TYPE_ATTRS);
    private static final int MAX_DEPTH = 1;

    public void setIDResolver(IDResolver iDResolver) {
        this.idResolver = iDResolver;
    }

    public IDResolver getIDResolver() {
        return this.idResolver;
    }

    public void sign(SOAPDocument sOAPDocument, Element element, Key key, KeyInfo keyInfo, String string) throws XSignatureException, SignatureStructureException {
        element = element.getOwnerDocument() == sOAPDocument.getDocument() ? element : (Element)sOAPDocument.getDocument().importNode(element, true);
        Logger.normal("Template:\n" + new String(XPathCanonicalizer.serializeSubset(element, true)), 3);
        SOAPHeaderEntry sOAPHeaderEntry = this.createHeaderEntry(sOAPDocument, string);
        sOAPHeaderEntry.getDOMEntity().appendChild(element);
        this.normalizeForApacheSOAP(sOAPDocument.getDocument().getDocumentElement(), 0);
        SignatureContext signatureContext = new SignatureContext();
        signatureContext.setIDResolver(this.idResolver);
        if (keyInfo != null) {
            keyInfo.insertTo(element);
        }
        Logger.normal("Signing start", 0);
        signatureContext.sign(element, key);
        Logger.normal("Signing done", 0);
    }

    private void normalizeForApacheSOAP(Element element, int n) {
        int n2;
        if (n > 1) {
            return;
        }
        NodeList nodeList = element.getChildNodes();
        Node[] nodeArray = new Node[nodeList.getLength()];
        for (n2 = 0; n2 < nodeArray.length; ++n2) {
            nodeArray[n2] = nodeList.item(n2);
        }
        for (n2 = 0; n2 < nodeArray.length; ++n2) {
            element.removeChild(nodeArray[n2]);
        }
        Document document = element.getOwnerDocument();
        element.appendChild(document.createTextNode("\n"));
        block6: for (int i = 0; i < nodeArray.length; ++i) {
            switch (nodeArray[i].getNodeType()) {
                case 1: {
                    this.normalizeForApacheSOAP((Element)nodeArray[i], n + 1);
                    element.appendChild(nodeArray[i]);
                    element.appendChild(document.createTextNode("\n"));
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
                default: {
                    element.appendChild(nodeArray[i]);
                }
            }
        }
    }

    public SOAPHeaderEntry[] getSignatureEntries(SOAPDocument sOAPDocument) {
        NodeList nodeList = sOAPDocument.getEnvelope().getHeader().getDOMEntity().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/security/2000-12", ELEM_SIGNATURE);
        SOAPHeaderEntry[] sOAPHeaderEntryArray = new SOAPHeaderEntry[nodeList.getLength()];
        for (int i = 0; i < sOAPHeaderEntryArray.length; ++i) {
            sOAPHeaderEntryArray[i] = sOAPDocument.createHeaderEntry((Element)nodeList.item(i));
        }
        return sOAPHeaderEntryArray;
    }

    public Element getSignatureElement(SOAPHeaderEntry sOAPHeaderEntry) {
        return (Element)sOAPHeaderEntry.getDOMEntity().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", ELEM_SIGNATURE).item(0);
    }

    public boolean verify(SOAPHeaderEntry sOAPHeaderEntry) throws CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureStructureException {
        return this.verify(sOAPHeaderEntry, null);
    }

    public boolean verify(SOAPHeaderEntry sOAPHeaderEntry, Key key) throws CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureStructureException {
        SignatureContext signatureContext = new SignatureContext();
        if (this.idResolver != null) {
            signatureContext.setIDResolver(this.idResolver);
        }
        Logger.normal("Verifying start", 0);
        Validity validity = signatureContext.verify(this.getSignatureElement(sOAPHeaderEntry), key);
        Logger.normal("Verifying done", 0);
        Logger.normal("Core validity=" + validity.getCoreValidity(), 4);
        Logger.normal("Signed info validity=" + validity.getSignedInfoValidity(), 4);
        Logger.normal("Signed info message=" + validity.getSignedInfoMessage(), 4);
        int n = validity.getNumberOfReferences();
        for (int i = 0; i < n; ++i) {
            Logger.normal("Ref[" + i + "](validity=" + validity.getReferenceValidity(i) + ", message=" + validity.getReferenceMessage(i) + ", uri=" + validity.getReferenceURI(i) + ", type=" + validity.getReferenceType(i) + ")", 4);
        }
        return validity.getCoreValidity();
    }

    private SOAPHeaderEntry createHeaderEntry(SOAPDocument sOAPDocument, String string) {
        Element element = sOAPDocument.getDocument().createElementNS("http://schemas.xmlsoap.org/soap/security/2000-12", "SOAP-SEC:Signature");
        SOAPHeaderEntry sOAPHeaderEntry = sOAPDocument.createHeaderEntry(element);
        sOAPHeaderEntry.declareNamespace("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV");
        sOAPHeaderEntry.declareNamespace("http://schemas.xmlsoap.org/soap/security/2000-12", "SOAP-SEC");
        sOAPHeaderEntry.setMustUnderstand(true);
        sOAPHeaderEntry.setActor(string);
        sOAPDocument.getEnvelope().getHeader().addHeaderEntry(sOAPHeaderEntry);
        return sOAPHeaderEntry;
    }
}

