/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ReceiverConfig;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.SoapSecuritySender;
import com.ibm.xml.soapsec.WriteBackResult;
import com.ibm.xml.soapsec.dsig.SignatureReceiver;
import com.ibm.xml.soapsec.dsig.SignatureReceiverConfig;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.dsig.SignedPartChecker;
import com.ibm.xml.soapsec.enc.EncryptedPartChecker;
import com.ibm.xml.soapsec.enc.EncryptionReceiver;
import com.ibm.xml.soapsec.enc.EncryptionReceiverConfig;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.proxy.MessageFactory;
import com.ibm.xml.soapsec.proxy.MessageProxy;
import com.ibm.xml.soapsec.proxy.SOAPEnvelopeProxy;
import com.ibm.xml.soapsec.proxy.SOAPHeaderElementProxy;
import com.ibm.xml.soapsec.time.TimestampChecker;
import com.ibm.xml.soapsec.time.TimestampReceiver;
import com.ibm.xml.soapsec.time.TimestampReceiverConfig;
import com.ibm.xml.soapsec.token.BinaryTokenReceiver;
import com.ibm.xml.soapsec.token.LoginResult;
import com.ibm.xml.soapsec.token.ReceiverLogin;
import com.ibm.xml.soapsec.token.ReceiverLoginComponent;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.token.UsernameTokenReceiver;
import com.ibm.xml.soapsec.token.XMLTokenReceiver;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.SetupJCEProviders;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SoapSecurityReceiver {
    public static final String CONFIG_KEY;
    private ThreadLocal _messageConfig = new ThreadLocal();
    private Map handlerOption = new HashMap();
    private static final TraceComponent tc;
    private static final String comp = "security.wssecurity";
    private static final String clsName;

    public void setHandlerOption(String string, Object object) {
        this.handlerOption.put(string, object);
    }

    public Object getHandlerOption(String string) {
        return this.handlerOption.get(string);
    }

    private Map getHandlerOptions() {
        return this.handlerOption;
    }

    private final void clear() {
        this._messageConfig.set(null);
    }

    private Map getMessageConfig() {
        HashMap hashMap = (HashMap)this._messageConfig.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this._messageConfig.set(hashMap);
        }
        return hashMap;
    }

    public void setMessageOption(String string, Object object) {
        this.getMessageConfig().put(string, object);
    }

    public Object getMessageOption(String string) {
        return this.getMessageConfig().get(string);
    }

    public Map getMessageOptions() {
        return this.getMessageConfig();
    }

    public void init() {
    }

    protected void initConfig(MessageContextProxy messageContextProxy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initConfig(" + messageContextProxy + ")");
        }
        SignatureReceiver signatureReceiver = new SignatureReceiver();
        SignedPartChecker signedPartChecker = new SignedPartChecker();
        UsernameTokenReceiver usernameTokenReceiver = new UsernameTokenReceiver();
        BinaryTokenReceiver binaryTokenReceiver = new BinaryTokenReceiver();
        XMLTokenReceiver xMLTokenReceiver = new XMLTokenReceiver();
        ReceiverLoginComponent receiverLoginComponent = this.createLoginComponent();
        TimestampReceiver timestampReceiver = new TimestampReceiver();
        TimestampChecker timestampChecker = new TimestampChecker();
        EncryptionReceiver encryptionReceiver = new EncryptionReceiver();
        EncryptedPartChecker encryptedPartChecker = new EncryptedPartChecker();
        ReceiverConfig receiverConfig = (ReceiverConfig)this.getMessageOption(CONFIG_KEY);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Configuration object is as follows:", new Object[]{receiverConfig});
        }
        try {
            HashMap<Class, Object> hashMap = new HashMap<Class, Object>();
            hashMap.put(ReceiverConfig.class, receiverConfig);
            hashMap.put(SignatureReceiverConfig.class, receiverConfig.getSignatureConfig());
            hashMap.put(TokenReceiverConfig.class, receiverConfig.getTokenConfig());
            hashMap.put(EncryptionReceiverConfig.class, receiverConfig.getDecryptionConfig());
            hashMap.put(TimestampReceiverConfig.class, receiverConfig.getTimestampConfig());
            signatureReceiver.init(hashMap);
            signedPartChecker.init(hashMap);
            usernameTokenReceiver.init(hashMap);
            binaryTokenReceiver.init(hashMap);
            xMLTokenReceiver.init(hashMap);
            receiverLoginComponent.init(hashMap);
            timestampReceiver.init(hashMap);
            timestampChecker.init(hashMap);
            encryptionReceiver.init(hashMap);
            encryptedPartChecker.init(hashMap);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".initConfig", "137", this);
            Tr.error(tc, "security.wssecurity.SoapSecurityReceiver.initConfig", exception);
            throw new RuntimeException(exception.getMessage());
        }
        this.setMessageOption(SignatureReceiver.class.getName(), signatureReceiver);
        this.setMessageOption(SignedPartChecker.class.getName(), signedPartChecker);
        this.setMessageOption(UsernameTokenReceiver.class.getName(), usernameTokenReceiver);
        this.setMessageOption(BinaryTokenReceiver.class.getName(), binaryTokenReceiver);
        this.setMessageOption(XMLTokenReceiver.class.getName(), xMLTokenReceiver);
        this.setMessageOption(ReceiverLoginComponent.class.getName(), receiverLoginComponent);
        this.setMessageOption(TimestampReceiver.class.getName(), timestampReceiver);
        this.setMessageOption(TimestampChecker.class.getName(), timestampChecker);
        this.setMessageOption(EncryptionReceiver.class.getName(), encryptionReceiver);
        this.setMessageOption(EncryptedPartChecker.class.getName(), encryptedPartChecker);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initConfig(MessageContext context)");
        }
    }

    protected boolean adjustContext(MessageContextProxy messageContextProxy, Map map) throws FaultProxy {
        return false;
    }

    protected boolean backContext(MessageContextProxy messageContextProxy, Map map) throws FaultProxy {
        return false;
    }

    protected ReceiverLoginComponent createLoginComponent() {
        return new ReceiverLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MessageContextProxy messageContextProxy) throws FaultProxy {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + messageContextProxy + ")");
        }
        this.clear();
        try {
            Document document;
            boolean bl = false;
            MessageProxy messageProxy = messageContextProxy.getCurrentMessage();
            this.initConfig(messageContextProxy);
            ReceiverConfig receiverConfig = (ReceiverConfig)this.getMessageOption(CONFIG_KEY);
            try {
                receiverConfig.validate();
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "198", this);
                Tr.error(tc, "security.wssecurity.config.invalid", soapSecurityException);
                throw FaultProxy.makeFault(soapSecurityException);
            }
            try {
                document = messageProxy.getDocument();
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + "invoke", "%C", this);
                Tr.error(tc, "security.wssecuritymessage.getDocument", exception);
                throw FaultProxy.makeFault(exception);
            }
            Element element = SoapSecurityReceiver.getSecurityHeader(document, receiverConfig.getMyActor());
            if (element != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invoke wsse:Security found: " + element);
                }
                bl = ConfigUtil.isTrue(element.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand"));
                ConfigUtil.setMustUnderstand(messageContextProxy, bl);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invoke wsse:Security.mustUnderstand: " + bl);
                }
            }
            if (!(receiverConfig.isSignatureRequired() || receiverConfig.isLoginRequired() || receiverConfig.isDecryptionRequired() || receiverConfig.getTimestampConfig() != null && receiverConfig.getTimestampConfig().addReceivedTimestamp() || bl)) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "invoke(MessageContextProxy context)");
                return;
            }
            if (element == null && (receiverConfig.isSignatureRequired() || receiverConfig.isLoginRequired() || receiverConfig.isDecryptionRequired()) && SoapSecurityReceiver.countSecurityHeaders(document) > 0) {
                SoapSecurityException soapSecurityException = receiverConfig.getMyActor() == null || receiverConfig.getMyActor().trim().length() == 0 ? new SoapSecurityException("The Application Server expected a Security header with the " + Constants.NS_WSSE + " or " + Constants.NS_WSSE200207 + " or " + Constants.NS_WSSE200204 + " namespace, but it was not found.") : new SoapSecurityException("The Application Server expected a Security header with the " + Constants.NS_WSSE + " or " + Constants.NS_WSSE200207 + " or " + Constants.NS_WSSE200204 + " namespace and the " + receiverConfig.getMyActor() + " actor, but it was not found.");
                throw FaultProxy.makeFault(soapSecurityException);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ResultPool.initialize(hashMap);
            this.adjustContext(messageContextProxy, hashMap);
            String string = (String)messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace");
            boolean bl2 = string != null && string.length() != 0;
            try {
                Result[] resultArray;
                Result[] resultArray2;
                Result[] resultArray3;
                if (!bl2) {
                    if (element != null) {
                        String string2 = element.getNamespaceURI();
                        if (string2 == null || string2.length() == 0 || !NamespaceUtil.isWsse(string2)) throw SoapSecurityException.format("security.wssecurity.WSEC6720E", string2);
                        messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", string2);
                        resultArray3 = NamespaceUtil.getCorrespondingWSUNS(string2);
                        if (resultArray3 != null && resultArray3.length() != 0) {
                            messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", resultArray3);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No wsu namespace found for " + string2);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Incoming namespaces, wsse = " + string2 + ", wsu = " + (String)resultArray3);
                        }
                    } else {
                        Element element2;
                        Tr.warning(tc, "security.wssecurity.SoapSecurityReceiver.getSecurityHeader", receiverConfig.getMyActor());
                        messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", Constants.NS_WSSE);
                        Object var11_14 = null;
                        resultArray3 = null;
                        resultArray2 = null;
                        Element element3 = TimestampReceiver.getTimestampHeader(document, true);
                        if (element3 != null) {
                            resultArray3 = element3.getNamespaceURI();
                        }
                        if ((element2 = TimestampReceiver.getTimestampHeader(document, false)) != null) {
                            resultArray2 = element2.getNamespaceURI();
                        }
                        if (!(resultArray3 != null && resultArray3.length() != 0 || resultArray2 != null && resultArray2.length() != 0)) {
                            messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", Constants.NS_WSU);
                        } else if (resultArray3 == null || resultArray3.length() == 0) {
                            if (!NamespaceUtil.isWsu((String)resultArray2)) throw SoapSecurityException.format("security.wssecurity.WSEC6720E", (String)resultArray2);
                            messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", resultArray2);
                        } else if (resultArray2 == null || resultArray2.length() == 0) {
                            if (!NamespaceUtil.isWsu((String)resultArray3)) throw SoapSecurityException.format("security.wssecurity.WSEC6720E", (String)resultArray3);
                            messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", resultArray3);
                        } else {
                            if (resultArray3.compareTo((String)resultArray2) != 0) throw SoapSecurityException.format("security.wssecurity.WSEC6721E", (String)resultArray3, (String)resultArray2);
                            if (!NamespaceUtil.isWsu((String)resultArray3)) throw SoapSecurityException.format("security.wssecurity.WSEC6720E", (String)resultArray3);
                            messageContextProxy.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", resultArray3);
                        }
                    }
                    if (!NamespaceUtil.validate(messageContextProxy)) {
                        String string3 = (String)messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace");
                        resultArray3 = (String)messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace");
                        throw SoapSecurityException.format("security.wssecurity.WSEC6721E", "wsse=" + string3, "wsu=" + (String)resultArray3);
                    }
                }
                hashMap.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace"));
                hashMap.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", messageContextProxy.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace"));
                this.invokeComponent(document, SoapSecuritySender.getHeader(document), hashMap, TimestampReceiver.class);
                if (element != null) {
                    void var11_20;
                    Element element4 = DOMUtil.getFirstElement(element);
                    while (var11_20 != null) {
                        resultArray3 = var11_20.getNamespaceURI();
                        resultArray2 = var11_20.getLocalName();
                        if (Constants.NS_DSIG.equals(resultArray3) && resultArray2.equals("Signature")) {
                            if (receiverConfig.isSignatureReady()) {
                                this.invokeComponent(document, (Element)var11_20, hashMap, class$com$ibm$xml$soapsec$dsig$SignatureReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureReceiver") : class$com$ibm$xml$soapsec$dsig$SignatureReceiver);
                            } else {
                                try {
                                    this.invokeComponent(document, (Element)var11_20, hashMap, class$com$ibm$xml$soapsec$dsig$SignatureReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.dsig.SignatureReceiver") : class$com$ibm$xml$soapsec$dsig$SignatureReceiver);
                                }
                                catch (Exception exception) {
                                    Tr.processException((Throwable)exception, clsName + ".invoke", "276", this);
                                    Tr.error(tc, "security.wssecurity.invaliddsig.ignore", exception);
                                }
                            }
                        } else if (NamespaceUtil.isWsse((String)resultArray3) && resultArray2.equals("UsernameToken")) {
                            this.invokeComponent(document, (Element)var11_20, hashMap, class$com$ibm$xml$soapsec$token$UsernameTokenReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.UsernameTokenReceiver") : class$com$ibm$xml$soapsec$token$UsernameTokenReceiver);
                        } else if (NamespaceUtil.isWsse((String)resultArray3) && resultArray2.equals("BinarySecurityToken")) {
                            this.invokeComponent(document, (Element)var11_20, hashMap, class$com$ibm$xml$soapsec$token$BinaryTokenReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.BinaryTokenReceiver") : class$com$ibm$xml$soapsec$token$BinaryTokenReceiver);
                        } else if (Constants.NS_ENC.equals(resultArray3) && (resultArray2.equals("EncryptedKey") || resultArray2.equals("ReferenceList"))) {
                            this.invokeComponent(document, (Element)var11_20, hashMap, class$com$ibm$xml$soapsec$enc$EncryptionReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.enc.EncryptionReceiver") : class$com$ibm$xml$soapsec$enc$EncryptionReceiver);
                        } else {
                            this.invokeComponent(document, (Element)var11_20, hashMap, class$com$ibm$xml$soapsec$token$XMLTokenReceiver == null ? SoapSecurityReceiver.class$("com.ibm.xml.soapsec.token.XMLTokenReceiver") : class$com$ibm$xml$soapsec$token$XMLTokenReceiver);
                        }
                        Element element5 = DOMUtil.getNextElement((Node)var11_20);
                    }
                }
                if (receiverConfig.isSignatureRequired()) {
                    this.invokeComponent(document, null, hashMap, SignedPartChecker.class);
                }
                if (receiverConfig.isDecryptionRequired()) {
                    this.invokeComponent(document, null, hashMap, EncryptedPartChecker.class);
                }
                if (receiverConfig.isLoginRequired()) {
                    this.invokeComponent(document, null, hashMap, ReceiverLoginComponent.class);
                }
                this.invokeComponent(document, null, hashMap, TimestampChecker.class);
                Result[] resultArray4 = ResultPool.get(hashMap, LoginResult.class);
                resultArray3 = ResultPool.get(hashMap, SignatureResult.class);
                resultArray2 = ResultPool.get(hashMap, TokenResult.X509.class);
                this.processCertificateResults(resultArray3, resultArray2, messageContextProxy);
                if (resultArray4.length != 0) {
                    this.processLoginResults(resultArray4, messageContextProxy);
                }
                if ((resultArray = ResultPool.get(hashMap, SignatureResult.class)).length != 0) {
                    messageContextProxy.setConfig("com.ibm.xml.soapsec.RequestCert", ((SignatureResult)resultArray[0]).getCertificate());
                }
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".invoke", "321", this);
                Tr.error(tc, "security.wssecurity.invoke.exception", new Object[]{messageContextProxy.getTargetEndpointAddress(), exception});
                throw FaultProxy.makeFault(exception);
            }
            if (ResultPool.get(hashMap, WriteBackResult.class).length > 0) {
                try {
                    MessageProxy messageProxy2 = MessageFactory.getInstance().create(document, messageProxy);
                    messageContextProxy.setCurrentMessage(messageProxy2);
                }
                catch (Exception exception) {
                    throw FaultProxy.makeFault(exception);
                }
            }
            this.backContext(messageContextProxy, hashMap);
            SOAPEnvelopeProxy sOAPEnvelopeProxy = messageContextProxy.getCurrentMessage().getSOAPEnvelope();
            SOAPHeaderElementProxy sOAPHeaderElementProxy = NamespaceUtil.getWsseHeaderByName(sOAPEnvelopeProxy, "Security", false);
            if (sOAPHeaderElementProxy != null) {
                sOAPHeaderElementProxy.setProcessed(true);
            }
            if ((sOAPHeaderElementProxy = NamespaceUtil.getWsuHeaderByName(sOAPEnvelopeProxy, "Timestamp", true)) != null) {
                sOAPHeaderElementProxy.setProcessed(true);
            }
            ResultPool.finalize(hashMap);
        }
        finally {
            this.clear();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "invoke(MessageContextProxy context)");
    }

    public void onFault(MessageContextProxy messageContextProxy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(" + messageContextProxy + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(MessageContextProxy context)");
        }
    }

    protected void processLoginResults(Result[] resultArray, MessageContextProxy messageContextProxy) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processLoginResults(" + resultArray + "," + messageContextProxy + ")");
            Tr.exit(tc, "processLoginResults(Result[] results, MessageContext context)");
        }
    }

    protected void processCertificateResults(Result[] resultArray, Result[] resultArray2, MessageContextProxy messageContextProxy) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCertificateResults(" + resultArray + "," + resultArray2 + "," + messageContextProxy + ")");
            Tr.exit(tc, "processCertificateResults(Result[] resultSign, Result [] resultToken, MessageContext context)");
        }
    }

    private void invokeComponent(Document document, Element element, Map map, Class clazz) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeComponent(" + document + "," + element + "," + map + "," + clazz + ")");
        }
        SoapSecurityComponent soapSecurityComponent = this.getComponent(clazz);
        soapSecurityComponent.invoke(document, element, map);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeComponent(Document doc, Element target, Map context, Class cl)");
        }
    }

    private SoapSecurityComponent getComponent(Class clazz) {
        return (SoapSecurityComponent)this.getMessageOption(clazz.getName());
    }

    private static Element getSecurityHeader(Document document, String string) {
        Element element;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityHeader(" + document + "," + string + ")");
        }
        if ((element = DOMUtil.getFirstElement(document.getDocumentElement(), "http://schemas.xmlsoap.org/soap/envelope/", "Header")) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityHeader(Document doc, String actor) returns null");
            }
            return null;
        }
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            if (NamespaceUtil.isWsse(element2.getNamespaceURI()) && "Security".equals(element2.getLocalName())) {
                String string2 = null;
                if (element2.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor") != null) {
                    string2 = element2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor");
                }
                if (string == null && string2 == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityHeader(Document doc, String  actor) returns " + element2);
                    }
                    return element2;
                }
                if (string != null && string2 != null && string.equals(string2)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityHeader(Document doc, String actor) returns " + element2);
                    }
                    return element2;
                }
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityHeader(Document doc, String actor) returns null");
        }
        return null;
    }

    private static int countSecurityHeaders(Document document) {
        Element element;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "countSecurityHeaders(" + document + ")");
        }
        if ((element = DOMUtil.getFirstElement(document.getDocumentElement(), "http://schemas.xmlsoap.org/soap/envelope/", "Header")) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "countSecurityHeaders(Document doc) returns zero");
            }
            return 0;
        }
        int n = 0;
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            if ("Security".equals(element2.getLocalName())) {
                ++n;
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "countSecurityHeaders(Document doc) returns " + n);
        }
        return n;
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("setup-jce");
            }
        });
        if (string != null) {
            SetupJCEProviders.setup();
        }
        CONFIG_KEY = ReceiverConfig.class.getName();
        tc = Tr.register(SoapSecurityReceiver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        clsName = SoapSecurityReceiver.class.getName();
    }
}

