/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.dsig.SignatureSender;
import com.ibm.xml.soapsec.dsig.SignatureSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionRequest;
import com.ibm.xml.soapsec.enc.EncryptionSender;
import com.ibm.xml.soapsec.enc.EncryptionSenderConfig;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.proxy.MessageFactory;
import com.ibm.xml.soapsec.proxy.MessageProxy;
import com.ibm.xml.soapsec.time.TimestampSender;
import com.ibm.xml.soapsec.time.TimestampSenderConfig;
import com.ibm.xml.soapsec.token.BinaryTokenSender;
import com.ibm.xml.soapsec.token.SenderLogin;
import com.ibm.xml.soapsec.token.SenderLoginComponent;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.token.TokenSenderConfig;
import com.ibm.xml.soapsec.token.UsernameTokenSender;
import com.ibm.xml.soapsec.token.XMLTokenSender;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.SetupJCEProviders;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SoapSecuritySender {
    public static final String CONFIG_KEY;
    private ThreadLocal _messageConfig = new ThreadLocal();
    private Map handlerOption = new HashMap();
    protected static final String MESSAGE_CONTEXT = "com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.messageContext";
    private static final TraceComponent tc;
    private static final String comp = "security.wssecurity";
    private static final String clsName;

    public void setHandlerOption(String string, Object object) {
        this.handlerOption.put(string, object);
    }

    public Object getHandlerOption(String string) {
        return this.handlerOption.get(string);
    }

    private final void clear() {
        this._messageConfig.set(null);
    }

    private Map getMessageConfig() {
        HashMap hashMap = (HashMap)this._messageConfig.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this._messageConfig.set(hashMap);
        }
        return hashMap;
    }

    public void setMessageOption(String string, Object object) {
        this.getMessageConfig().put(string, object);
    }

    public Object getMessageOption(String string) {
        return this.getMessageConfig().get(string);
    }

    public Map getMessageOptions() {
        return this.getMessageConfig();
    }

    public void init() {
    }

    protected void initConfig(MessageContextProxy messageContextProxy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initConfig(" + messageContextProxy + ")");
        }
        SignatureSender signatureSender = new SignatureSender();
        SenderLoginComponent senderLoginComponent = this.createLoginComponent(messageContextProxy);
        UsernameTokenSender usernameTokenSender = new UsernameTokenSender();
        BinaryTokenSender binaryTokenSender = new BinaryTokenSender();
        XMLTokenSender xMLTokenSender = new XMLTokenSender();
        TimestampSender timestampSender = new TimestampSender();
        EncryptionSender encryptionSender = new EncryptionSender();
        SenderConfig senderConfig = (SenderConfig)this.getMessageOption(CONFIG_KEY);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Configuration object is as follows:", new Object[]{senderConfig});
        }
        try {
            HashMap<Class, Object> hashMap = new HashMap<Class, Object>();
            hashMap.put(SenderConfig.class, senderConfig);
            hashMap.put(SignatureSenderConfig.class, senderConfig.getSignatureConfig());
            hashMap.put(TokenSenderConfig.class, senderConfig.getTokenConfig());
            hashMap.put(EncryptionSenderConfig.class, senderConfig.getEncryptionConfig());
            hashMap.put(TimestampSenderConfig.class, senderConfig.getTimestampConfig());
            signatureSender.init(hashMap);
            senderLoginComponent.init(hashMap);
            usernameTokenSender.init(hashMap);
            binaryTokenSender.init(hashMap);
            xMLTokenSender.init(hashMap);
            timestampSender.init(hashMap);
            encryptionSender.init(hashMap);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".initConfig", "118", this);
            Tr.error(tc, "security.wssecurity.SoapSecuritySender.initConfig", exception);
            throw new RuntimeException(exception.getMessage());
        }
        this.setMessageOption(SignatureSender.class.getName(), signatureSender);
        this.setMessageOption(SenderLoginComponent.class.getName(), senderLoginComponent);
        this.setMessageOption(UsernameTokenSender.class.getName(), usernameTokenSender);
        this.setMessageOption(BinaryTokenSender.class.getName(), binaryTokenSender);
        this.setMessageOption(XMLTokenSender.class.getName(), xMLTokenSender);
        this.setMessageOption(TimestampSender.class.getName(), timestampSender);
        this.setMessageOption(EncryptionSender.class.getName(), encryptionSender);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initConfig(MessageContextProxy context)");
        }
    }

    protected SenderLoginComponent createLoginComponent(MessageContextProxy messageContextProxy) {
        return new SenderLogin();
    }

    protected boolean adjustContext(MessageContextProxy messageContextProxy, Map map) throws FaultProxy {
        return false;
    }

    protected boolean backContext(MessageContextProxy messageContextProxy, Map map) throws FaultProxy {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContextProxy messageContextProxy) throws FaultProxy {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + messageContextProxy + ")");
        }
        this.clear();
        try {
            Document document;
            MessageProxy messageProxy;
            boolean bl;
            this.initConfig(messageContextProxy);
            SenderConfig senderConfig = (SenderConfig)this.getMessageOption(CONFIG_KEY);
            try {
                senderConfig.validate();
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "173", this);
                Tr.error(tc, "security.wssecurity.config.invalid", soapSecurityException);
                throw FaultProxy.makeFault(soapSecurityException);
            }
            boolean bl2 = senderConfig.isTimestampEnabled();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            RequestPool.initialize(hashMap);
            boolean bl3 = this.adjustContext(messageContextProxy, hashMap);
            boolean bl4 = bl = senderConfig.isTokenEnabled() || senderConfig.isSignatureEnabled() || senderConfig.isEncryptionEnabled() || bl3;
            if (!bl2 && !bl) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_invoke(MessageContext context)");
                }
                return;
            }
            try {
                messageProxy = messageContextProxy.getCurrentMessage();
                document = messageProxy.getDocument();
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".invoke", "197", this);
                Tr.error(tc, "security.wssecurity.message.getDocument", exception);
                throw FaultProxy.makeFault(exception);
            }
            try {
                this.setMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress", messageContextProxy.getTargetEndpointAddress());
                this.setMessageOption(MESSAGE_CONTEXT, messageContextProxy);
                hashMap.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", Constants.getWSSENS(messageContextProxy));
                hashMap.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", Constants.getWSUNS(messageContextProxy));
                if (bl2) {
                    Element element = SoapSecuritySender.getHeader(document);
                    this.invokeComponent(document, element, hashMap, TimestampSender.class);
                }
                if (bl) {
                    boolean bl5 = this.checkMustUnderstand(senderConfig, messageContextProxy);
                    Element element = SoapSecuritySender.addSecurityHeader(document, Constants.getWSSENS(hashMap), senderConfig.getTargetActor(), bl5 ? "1" : null);
                    if (senderConfig.isTokenEnabled()) {
                        this.invokeComponent(document, element, hashMap, SenderLoginComponent.class);
                    }
                    int n = RequestPool.get(hashMap, TokenRequest.Username.class).length;
                    if (senderConfig.isTokenEnabled() && n > 0) {
                        this.invokeComponent(document, element, hashMap, UsernameTokenSender.class);
                    }
                    if (RequestPool.get(hashMap, TokenRequest.Binary.class).length > 0) {
                        this.invokeComponent(document, element, hashMap, BinaryTokenSender.class);
                    }
                    if (RequestPool.get(hashMap, TokenRequest.XML.class).length > 0) {
                        this.invokeComponent(document, element, hashMap, XMLTokenSender.class);
                    }
                    n = RequestPool.get(hashMap, SignatureRequest.class).length;
                    if (senderConfig.isSignatureEnabled() || n > 0) {
                        this.invokeComponent(document, element, hashMap, SignatureSender.class);
                    }
                    if (RequestPool.get(hashMap, TokenRequest.Binary.class).length > 0) {
                        this.invokeComponent(document, element, hashMap, BinaryTokenSender.class);
                    }
                    n = RequestPool.get(hashMap, EncryptionRequest.class).length;
                    if (senderConfig.isEncryptionEnabled() || n > 0) {
                        hashMap.put("com.ibm.xml.soapsec.RequestCert", messageContextProxy.getConfig("com.ibm.xml.soapsec.RequestCert"));
                        this.invokeComponent(document, element, hashMap, EncryptionSender.class);
                    }
                    if (!senderConfig.doIndentation()) {
                        DOMUtil.removeIndentation(element);
                    }
                }
                MessageProxy messageProxy2 = MessageFactory.getInstance().create(document, messageProxy);
                messageContextProxy.setCurrentMessage(messageProxy2);
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".invoke", "264", this);
                Tr.error(tc, "security.wssecurity.invoke.exception", new Object[]{messageContextProxy.getTargetEndpointAddress(), exception});
                FaultProxy faultProxy = FaultProxy.makeFault(exception);
                if (messageContextProxy.getPastPivot()) {
                    messageContextProxy.setCurrentMessage(MessageProxy.getInstance(faultProxy));
                }
                throw faultProxy;
            }
            this.backContext(messageContextProxy, hashMap);
            RequestPool.finalize(hashMap);
        }
        finally {
            this.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(MessageContextProxy context)");
        }
    }

    private void invokeComponent(Document document, Element element, Map map, Class clazz) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeComponent(" + document + "," + map + "," + clazz + ")");
        }
        SoapSecurityComponent soapSecurityComponent = this.getComponent(clazz);
        soapSecurityComponent.invoke(document, element, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeComponent(Document doc, Element security, Map context, Class cl)");
        }
    }

    public void onFault(MessageContextProxy messageContextProxy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(" + messageContextProxy + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(MessageContextProxy context)");
        }
    }

    private SoapSecurityComponent getComponent(Class clazz) {
        return (SoapSecurityComponent)this.getMessageOption(clazz.getName());
    }

    private static Element searchForSecurityHeader(Element element, String string, String string2) {
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            String string3 = element2.getNamespaceURI();
            String string4 = element2.getLocalName();
            if (NamespaceUtil.isWsse(string3) && "Security".equals(string4) && !(string != null && string.length() != 0 ? !string.equals(element2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor")) : element2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor").length() != 0)) {
                String string5;
                if (string2 != null && !string2.equals(string5 = element2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand"))) {
                    Tr.error(tc, "security.wssecurity.SoapSecurityReceiver.sss03", new Object[]{string5, string2});
                }
                return element2;
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        return null;
    }

    public static Element getHeader(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = DOMUtil.getFirstElement(element, "http://schemas.xmlsoap.org/soap/envelope/", "Header");
        if (element2 == null) {
            String string = element.getPrefix();
            if (string == null) {
                string = "";
            } else if (string.length() > 0) {
                string = string + ":";
            }
            element2 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", string + "Header");
            element.insertBefore(element2, element.getFirstChild());
        }
        return element2;
    }

    private static Element addSecurityHeader(Document document, String string, String string2, String string3) {
        String string4;
        Element element;
        Element element2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSecurityHeader(" + document + "," + string2 + "," + string3 + ")");
        }
        if ((element2 = SoapSecuritySender.searchForSecurityHeader(element = SoapSecuritySender.getHeader(document), string2, string3)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addSecurityHeader Uses existing wsse:Security element");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addSecurityHeader(Document factory, String actor, String must)");
            }
            return element2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addSecurityHeader Creates new wsse:Security element");
        }
        element2 = document.createElementNS(string, "wsse:Security");
        element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsse", string);
        if (string2 != null) {
            string4 = element.getPrefix();
            if (string4 == null || string4.length() <= 0) {
                element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "env:actor", string2);
                element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:env", "http://schemas.xmlsoap.org/soap/envelope/");
            } else {
                element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", string4 + ":actor", string2);
            }
        }
        if (string3 != null) {
            string4 = element.getPrefix();
            if (string4 == null || string4.length() <= 0) {
                element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "env:mustUnderstand", string3);
                element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:env", "http://schemas.xmlsoap.org/soap/envelope/");
            } else {
                element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", string4 + ":mustUnderstand", string3);
            }
        }
        element.insertBefore(element2, element.getFirstChild());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSecurityHeader(Document factory, String actor, String must)");
        }
        return element2;
    }

    public static void prependSecurityElement(Element element, Element element2) {
        element.insertBefore(element2, element.getFirstChild());
    }

    private boolean checkMustUnderstand(SenderConfig senderConfig, MessageContextProxy messageContextProxy) {
        boolean bl = true;
        boolean bl2 = false;
        bl2 = ((MessageContext)messageContextProxy.get()).isServer();
        if (bl2) {
            boolean bl3 = senderConfig.getServiceGetMustUnderstand();
            if (bl3) {
                bl = ConfigUtil.getMustUnderstand(messageContextProxy);
            }
        } else {
            bl = senderConfig.getClientSetMustUnderstand();
        }
        ConfigUtil.setMustUnderstand(messageContextProxy, bl);
        return bl;
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("setup-jce");
            }
        });
        if (string != null) {
            SetupJCEProviders.setup();
        }
        CONFIG_KEY = SenderConfig.class.getName();
        tc = Tr.register(SoapSecuritySender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        clsName = SoapSecuritySender.class.getName();
    }
}

