/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.confimpl;

import com.ibm.wsspi.wssecurity.Initializable;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ReceiverConfig;
import com.ibm.xml.soapsec.dsig.KeyInfoResolver;
import com.ibm.xml.soapsec.dsig.SignatureReceiverConfig;
import com.ibm.xml.soapsec.dsig.VerificationResultHandler;
import com.ibm.xml.soapsec.dsig.VerificationSettings;
import com.ibm.xml.soapsec.enc.EncryptionReceiverConfig;
import com.ibm.xml.soapsec.time.TimestampReceiverConfig;
import com.ibm.xml.soapsec.token.LoginMapping;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PrivateReceiverConfig
implements ReceiverConfig {
    private static final TraceComponent tc = Tr.register(PrivateReceiverConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PrivateReceiverConfig.class.getName();
    protected String myactor = null;
    protected boolean _bypassSecurityHeader = false;
    protected final Set requiredIntegralParts = new HashSet();
    protected final Set allowedTransforms = new HashSet();
    protected final List defaultVerificationKeys = new LinkedList();
    protected final List keyInfoResolvers = new LinkedList();
    protected final List verificationResultHandlers = new LinkedList();
    protected final List verificationSettingsList = new LinkedList();
    protected final SignatureReceiverConfig signatureReceiverConfig = new SignatureReceiverConfig(){

        public Set getRequiredIntegralParts() {
            return PrivateReceiverConfig.this.requiredIntegralParts;
        }

        public Set getAllowedTransforms() {
            return PrivateReceiverConfig.this.allowedTransforms;
        }

        public List getDefaultVerificationKeys() {
            return PrivateReceiverConfig.this.defaultVerificationKeys;
        }

        public List getKeyInfoResolvers() {
            return PrivateReceiverConfig.this.keyInfoResolvers;
        }

        public List getVerificationResultHandlers() {
            return PrivateReceiverConfig.this.verificationResultHandlers;
        }

        public List getVerificationSettingsList() {
            return PrivateReceiverConfig.this.verificationSettingsList;
        }

        public String toString() {
            return "SignatureReceiverConfig(requiredIntegralParts=" + PrivateReceiverConfig.this.requiredIntegralParts + " defaultVerificationKeys=" + PrivateReceiverConfig.this.defaultVerificationKeys + " keyInfoResolvers=" + PrivateReceiverConfig.this.keyInfoResolvers + " verificationResultHandlers=" + PrivateReceiverConfig.this.verificationResultHandlers + " verificationSettingsList=" + PrivateReceiverConfig.this.verificationSettingsList + ")";
        }
    };
    protected final List authMethods = new LinkedList();
    protected String idType = null;
    protected String trustMode = null;
    protected final Map am2lm = new HashMap();
    protected final Map tvt2lm = new HashMap();
    protected TrustedIDEvaluator trustedIDEvaluator = null;
    protected boolean checkNonce = false;
    protected NonceManager nonceManager = null;
    protected boolean checkNonceTimestamp = false;
    protected long nonceMaxAge = -1L;
    protected long nonceClockSkew = -1L;
    protected Map _properties = null;
    protected final TokenReceiverConfig tokenReceiverConfig = new TokenReceiverConfig(){

        public List getAuthMethods() {
            return PrivateReceiverConfig.this.authMethods;
        }

        public String getIdType() {
            return PrivateReceiverConfig.this.idType;
        }

        public String getTrustMode() {
            return PrivateReceiverConfig.this.trustMode;
        }

        public LoginMapping getLoginMapping(String string) {
            if (PrivateReceiverConfig.this.am2lm.containsKey(string)) {
                return (LoginMapping)PrivateReceiverConfig.this.am2lm.get(string);
            }
            return null;
        }

        public LoginMapping getLoginMapping(QName qName) {
            if (PrivateReceiverConfig.this.tvt2lm.containsKey(qName)) {
                return (LoginMapping)PrivateReceiverConfig.this.tvt2lm.get(qName);
            }
            return null;
        }

        public TrustedIDEvaluator getTrustedIDEvaluator() {
            return PrivateReceiverConfig.this.trustedIDEvaluator;
        }

        public List getVerificationSettingsList() {
            return PrivateReceiverConfig.this.verificationSettingsList;
        }

        public boolean isX509Ready() {
            return PrivateReceiverConfig.this.verificationSettingsList.size() > 0;
        }

        public boolean isNonceChecked() {
            return PrivateReceiverConfig.this.checkNonce;
        }

        public NonceManager getNonceManager() {
            return PrivateReceiverConfig.this.nonceManager;
        }

        public boolean isNonceTimestampChecked() {
            return PrivateReceiverConfig.this.checkNonceTimestamp;
        }

        public long getNonceMaxAge() {
            return PrivateReceiverConfig.this.nonceMaxAge;
        }

        public long getNonceClockSkew() {
            return PrivateReceiverConfig.this.nonceClockSkew;
        }

        public String toString() {
            return "TokenReceiverConfig(authMethods=" + PrivateReceiverConfig.this.authMethods + " idType=" + PrivateReceiverConfig.this.idType + " trustMode=" + PrivateReceiverConfig.this.trustMode + " loginMappings=" + PrivateReceiverConfig.this.am2lm + " trustedIDEvaluator=" + PrivateReceiverConfig.this.trustedIDEvaluator + " verificationSettingsList=" + PrivateReceiverConfig.this.verificationSettingsList + " isNonceChecked=" + PrivateReceiverConfig.this.checkNonce + " nonceManager=" + PrivateReceiverConfig.this.nonceManager + " isNonceTimestampChecked=" + PrivateReceiverConfig.this.checkNonceTimestamp + " nonceMaxAge=" + PrivateReceiverConfig.this.nonceMaxAge + " nonceClockSkew=" + PrivateReceiverConfig.this.nonceClockSkew + ")";
        }
    };
    protected final Set requiredConfidentialParts = new HashSet();
    protected final List encryptionSettingsList = new LinkedList();
    protected EncryptionReceiverConfig encryptionReceiverConfig = new EncryptionReceiverConfig(){

        public Set getRequiredConfidentialParts() {
            return PrivateReceiverConfig.this.requiredConfidentialParts;
        }

        public List getEncryptionSettingsList() {
            return PrivateReceiverConfig.this.encryptionSettingsList;
        }

        public String toString() {
            return "EncryptionReceiverConfig(requiredConfidentialParts=" + PrivateReceiverConfig.this.requiredConfidentialParts + " encryptionSettingsList=" + PrivateReceiverConfig.this.encryptionSettingsList + ")";
        }
    };
    protected boolean enableReceivedTimestamp;
    protected TimestampReceiverConfig timestampReceiverConfig = new TimestampReceiverConfig(){

        public boolean addReceivedTimestamp() {
            return PrivateReceiverConfig.this.enableReceivedTimestamp;
        }

        public String getActor() {
            return PrivateReceiverConfig.this.myactor;
        }

        public String toString() {
            return "TimestampReceiverConfig(addReceivedTimestamp=" + this.addReceivedTimestamp() + ")";
        }
    };
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$KeyInfoResolver;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$dsig$VerificationResultHandler;

    protected void processPrivateConfig(Document document) throws SoapSecurityException {
        Initializable initializable;
        Map map;
        String string;
        Element element;
        int n;
        String string2;
        int n2;
        ClassLoader classLoader = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processPrivateConfig(" + document + ")");
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "CertificatePolicy");
        int n3 = nodeList.getLength();
        HashSet<String> hashSet = new HashSet<String>();
        for (n2 = 0; n2 < n3; ++n2) {
            string2 = nodeList.item(n2).getFirstChild().getNodeValue();
            hashSet.add(string2.trim());
        }
        Element element2 = DOMUtil.getZeroOrOneElement(document, "http://www.ibm.com/xml/soapsec/config", "PolicyMappingInhibited");
        n2 = element2 != null && ConfigUtil.isTrue(element2.getAttribute("flag")) ? 1 : 0;
        element2 = DOMUtil.getZeroOrOneElement(document, "http://www.ibm.com/xml/soapsec/config", "ExplicitPolicyRequired");
        boolean bl = element2 != null && ConfigUtil.isTrue(element2.getAttribute("flag"));
        element2 = DOMUtil.getZeroOrOneElement(document, "http://www.ibm.com/xml/soapsec/config", "RevocationEnabled");
        boolean bl2 = element2 != null && ConfigUtil.isTrue(element2.getAttribute("flag"));
        boolean[] blArray = new boolean[]{false, false, false, false, false, false, false, false, false};
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyUsage");
        n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            string2 = DOMUtil.getStringValue(nodeList.item(i));
            if ("DIGITAL_SIGNATURE".equals(string2)) {
                blArray[0] = true;
                continue;
            }
            if ("NON_REPUDIATION".equals(string2)) {
                blArray[1] = true;
                continue;
            }
            if ("KEY_ENCIPHERMENT".equals(string2)) {
                blArray[2] = true;
                continue;
            }
            if ("DATA_ENCHIPERMENT".equals(string2)) {
                blArray[3] = true;
                continue;
            }
            if ("KEY_AGREEMENT".equals(string2)) {
                blArray[4] = true;
                continue;
            }
            if ("KEY_CERT_SIGN".equals(string2)) {
                blArray[5] = true;
                continue;
            }
            if ("CRL_SIGN".equals(string2)) {
                blArray[6] = true;
                continue;
            }
            if ("ENCIPHER_ONLY".equals(string2)) {
                blArray[7] = true;
                continue;
            }
            if ("DECIPHER_ONLY".equals(string2)) {
                blArray[8] = true;
                continue;
            }
            throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s18", string2);
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "ExtendedKeyUsage");
        n3 = nodeList.getLength();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 0; i < n3; ++i) {
            hashSet2.add(DOMUtil.getStringValue(nodeList.item(i)));
        }
        Iterator iterator = this.verificationSettingsList.iterator();
        PKIXBuilderParameters pKIXBuilderParameters = null;
        X509CertSelector x509CertSelector = null;
        while (iterator.hasNext()) {
            pKIXBuilderParameters = ((VerificationSettings)iterator.next()).getPKIXBuilderParameters();
            if (pKIXBuilderParameters == null) continue;
            pKIXBuilderParameters.setInitialPolicies(hashSet);
            pKIXBuilderParameters.setPolicyMappingInhibited(n2 != 0);
            pKIXBuilderParameters.setExplicitPolicyRequired(bl);
            pKIXBuilderParameters.setRevocationEnabled(bl2);
            x509CertSelector = (X509CertSelector)pKIXBuilderParameters.getTargetCertConstraints();
            x509CertSelector.setKeyUsage(blArray);
            try {
                x509CertSelector.setExtendedKeyUsage(hashSet2);
            }
            catch (IOException iOException) {
                String string3 = "security.wssecurity.PrivateReceiverConfig.s25";
                Tr.processException((Throwable)iOException, clsName + ".processPrivateConfig", "309", this);
                Tr.error(tc, string3, ((Object)hashSet2).toString());
                throw SoapSecurityException.format(string3, ((Object)hashSet2).toString(), (Throwable)iOException);
            }
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "Transform");
        n3 = nodeList.getLength();
        if (n3 == 0) {
            Tr.warning(tc, "security.wssecurity.no.allowed.algorithms.defined");
        } else {
            for (n = 0; n < n3; ++n) {
                element = (Element)nodeList.item(n);
                this.allowedTransforms.add(DOMUtil.getAttribute(element, "algorithm"));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed Transforms:", new Object[]{this.allowedTransforms});
        }
        if (this.allowedTransforms.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.no.allowed.transforms.defined");
        }
        nodeList = document.getElementsByTagNameNS(Constants.NS_DSIG, "KeyInfo");
        n3 = nodeList.getLength();
        for (n = 0; n < n3; ++n) {
            this.defaultVerificationKeys.add(nodeList.item(n));
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyInfoResolver");
        n3 = nodeList.getLength();
        for (n = 0; n < n3; ++n) {
            element = (Element)nodeList.item(n);
            string = DOMUtil.getAttribute(element, "class");
            map = ConfigUtil.getProperties(element);
            initializable = (KeyInfoResolver)ConfigUtil.instantiate(string, class$com$ibm$xml$soapsec$dsig$KeyInfoResolver == null ? PrivateReceiverConfig.class$("com.ibm.xml.soapsec.dsig.KeyInfoResolver") : class$com$ibm$xml$soapsec$dsig$KeyInfoResolver, map, classLoader);
            this.keyInfoResolvers.add(initializable);
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "VerificationResultHandler");
        n3 = nodeList.getLength();
        for (n = 0; n < n3; ++n) {
            element = (Element)nodeList.item(n);
            string = DOMUtil.getAttribute(element, "class");
            map = ConfigUtil.getProperties(element);
            initializable = (VerificationResultHandler)ConfigUtil.instantiate(string, class$com$ibm$xml$soapsec$dsig$VerificationResultHandler == null ? PrivateReceiverConfig.class$("com.ibm.xml.soapsec.dsig.VerificationResultHandler") : class$com$ibm$xml$soapsec$dsig$VerificationResultHandler, map, classLoader);
            this.verificationResultHandlers.add(initializable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPrivateConfig(Document privateConfig)");
        }
    }

    public String getMyActor() {
        return this.myactor;
    }

    protected boolean containsId() {
        return this.authMethods.contains("IDAssertion");
    }

    public boolean isSignatureReady() {
        return this.isSignatureRequired() || this.authMethods.contains("Signature") || this.containsId() && "Signature".equals(this.trustMode);
    }

    public boolean isSignatureRequired() {
        return this.requiredIntegralParts.size() > 0;
    }

    public boolean isLoginRequired() {
        return this.authMethods.size() > 0;
    }

    public boolean isDecryptionRequired() {
        return this.requiredConfidentialParts.size() > 0;
    }

    public void validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        Iterator<Object> iterator = this.requiredIntegralParts.iterator();
        Object object = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof String)) {
                throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.rconf02", object.toString());
            }
            if ("body".equals(object) || "timestamp".equals(object) || "securitytoken".equals(object)) continue;
            throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.rconf02", object.toString());
        }
        iterator = this.requiredConfidentialParts.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof String)) {
                throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.confPart", object.toString());
            }
            if ("bodycontent".equals(object) || "usernametoken".equals(object)) continue;
            throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.confPart", object.toString());
        }
        if (!(this.idType == null || "Username".equals(this.idType) || "DN".equals(this.idType) || "X509Certificate".equals(this.idType))) {
            throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s31", this.idType);
        }
        if ("X509Certificate".equals(this.idType) && this.verificationSettingsList.size() == 0) {
            throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s44");
        }
        if (this.trustMode != null && !"Signature".equals(this.trustMode) && !"BasicAuth".equals(this.trustMode)) {
            throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s08", this.trustMode);
        }
        if (this.authMethods.contains("Signature")) {
            if (this.requiredIntegralParts.size() == 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s34");
            }
            if (this.requiredIntegralParts.contains("securitytoken")) {
                throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.sigWithSec");
            }
        }
        if (this.authMethods.contains("IDAssertion")) {
            if (this.idType == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s32");
            }
            if (this.trustMode != null && this.trustedIDEvaluator == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s35");
            }
        }
        iterator = this.am2lm.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = this.am2lm.get(string);
            if (!(object instanceof LoginMapping)) {
                throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s37");
            }
            LoginMapping loginMapping = (LoginMapping)object;
            if (this.isNullOrZero(loginMapping.getConfigName())) {
                throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s38");
            }
            if (loginMapping.getCallbackHandlerFactory() == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s39");
            }
            if ("IDAssertion".equals(string) || "BasicAuth".equals(string) || "Signature".equals(string) || loginMapping.getTokenValueType() != null) continue;
            throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s40");
        }
        iterator = this.authMethods.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof String && this.am2lm.containsKey(object)) continue;
            throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s29", object.toString());
        }
        if ("BasicAuth".equals(this.trustMode) && !this.am2lm.containsKey("BasicAuth")) {
            throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.s43");
        }
        if (this.enableReceivedTimestamp && (this.myactor == null || this.myactor.length() == 0)) {
            throw SoapSecurityException.format("security.wssecurity.PrivateReceiverConfig.rconf03");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
    }

    private boolean isNullOrZero(String string) {
        return string == null || string.length() == 0;
    }

    public SignatureReceiverConfig getSignatureConfig() {
        return this.signatureReceiverConfig;
    }

    public TokenReceiverConfig getTokenConfig() {
        return this.tokenReceiverConfig;
    }

    public EncryptionReceiverConfig getDecryptionConfig() {
        return this.encryptionReceiverConfig;
    }

    public TimestampReceiverConfig getTimestampConfig() {
        return this.timestampReceiverConfig;
    }

    public boolean getBypassSecurityHeaderSetting() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled=" + this._bypassSecurityHeader);
        }
        return this._bypassSecurityHeader;
    }

    public Map getProperties() {
        return this._properties;
    }

    public Object getProperty(Object object) {
        if (this._properties != null) {
            return this._properties.get(object);
        }
        return null;
    }

    protected String getLogProperties(Map map, Map map2, Map map3, Map map4, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        String string4 = "";
        if (string2 != null) {
            string3 = string2;
        }
        if (string != null) {
            string4 = string;
        }
        stringBuffer.append("\nDefault properties: " + (map == null ? "null" : map.toString()));
        stringBuffer.append("\nApplication " + string4 + " " + string3 + " extension properties: " + (map3 == null ? "null" : map3.toString()));
        stringBuffer.append("\nApplication binding parameters: " + (map2 == null ? "null" : map2.toString()));
        stringBuffer.append("\nApplication " + string4 + " " + string3 + " binding properties: " + (map4 == null ? "null" : map4.toString()));
        stringBuffer.append("\nCombined properties: " + this._properties);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClass().getName() + "(" + "signatureReceiverConfig=" + this.signatureReceiverConfig + " tokenReceiverConfig=" + this.tokenReceiverConfig + " encryptionReceiverConfig=" + this.encryptionReceiverConfig + " bypassSecurityHeader=" + this._bypassSecurityHeader + " properties=" + this._properties + ")";
    }
}

