/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.dsig;

import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.Reference;
import com.ibm.ws.wssecurity.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TemplateGenerator;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.dsig.SignatureSenderConfig;
import com.ibm.xml.soapsec.dsig.SignerRequest;
import com.ibm.xml.soapsec.dsig.TemplateModifier;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SignatureSender
implements SoapSecurityComponent {
    static boolean USE_XPATH = false;
    static boolean USE_EMBEDDED = false;
    private static final String SIGNATURE_PREFIX = "ds";
    private static final TraceComponent tc = Tr.register(SignatureSender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    SenderConfig gconfig;
    SignatureSenderConfig config;
    private IdUtil idResolver;
    private static final String BODY = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']";
    static final String BODY_XPATH = "count(/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::node() | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/@* | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/namespace::*) = count(/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::node() | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/@* | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/namespace::* | .)";

    public void init(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + map + ")");
        }
        this.gconfig = (SenderConfig)map.get(SenderConfig.class);
        this.config = (SignatureSenderConfig)map.get(SignatureSenderConfig.class);
        this.idResolver = IdUtil.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    private static boolean matchClass(Class clazz, String string) {
        if (clazz.getName().equals(string)) {
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && SignatureSender.matchClass(clazz2, string)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!SignatureSender.matchClass(classArray[i], string)) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceOf(Object object, String string) {
        return SignatureSender.matchClass(object.getClass(), string);
    }

    private static void addReferenceForBody(TemplateGenerator templateGenerator, Document document, SignatureSenderConfig signatureSenderConfig, String string) {
        Reference reference;
        if (USE_XPATH) {
            reference = templateGenerator.createReference("");
            reference.addXPathTransform(BODY_XPATH);
            reference.addTransform(signatureSenderConfig.getCanonicalizationMethod());
        } else {
            String string2 = null;
            Element element = document.getDocumentElement();
            element = DOMUtil.getFirstElement(element, "http://schemas.xmlsoap.org/soap/envelope/", "Body");
            String string3 = IdUtil.getInstance().getIdAttributeName(element);
            if (string3 != null) {
                string2 = element.getAttribute(string3);
            }
            if (string2 == null || string2.length() == 0) {
                string2 = IdUtil.getInstance().makeUniqueId(document, "wssecurity_body_id_");
                element.setAttributeNS(string, "wsu:Id", string2);
                element.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsu", string);
            }
            reference = templateGenerator.createReference("#" + string2);
            String string4 = signatureSenderConfig.getCanonicalizationMethod();
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(string4) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(string4)) {
                Object object;
                HashSet<String> hashSet = new HashSet<String>();
                for (Node node = element; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
                    object = node.getAttributes();
                    int n = object == null ? 0 : object.getLength();
                    for (int i = 0; i < n; ++i) {
                        String string5 = object.item(i).getNodeName();
                        if (string5.equals("xmlns")) {
                            hashSet.add("#default");
                            continue;
                        }
                        if (!string5.startsWith("xmlns:")) continue;
                        hashSet.add(string5.substring(6));
                    }
                }
                SignatureSender.scanNamespaceDecls(element, hashSet);
                Element element2 = document.createElementNS(Constants.NS_DSIG, "Transform");
                element2.setAttributeNS(null, "Algorithm", string4);
                if (hashSet.size() > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    object = hashSet.iterator();
                    while (object.hasNext()) {
                        stringBuffer.append(object.next());
                        stringBuffer.append(" ");
                    }
                    Element element3 = document.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "ec:InclusiveNamespaces");
                    element3.setAttributeNS(Constants.NS_XMLNS, "xmlns:ec", "http://www.w3.org/2001/10/xml-exc-c14n#");
                    element3.setAttributeNS(null, "PrefixList", new String(stringBuffer));
                    element2.appendChild(element3);
                }
                reference.addTransform(element2);
            } else {
                reference.addTransform(string4);
            }
        }
        templateGenerator.addReference(reference);
    }

    private static void scanNamespaceDecls(Node node, Set set) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            String string = namedNodeMap.item(i).getNodeName();
            if (string.equals("xmlns")) {
                set.add("#default");
                continue;
            }
            if (!string.startsWith("xmlns:")) continue;
            set.add(string.substring(6));
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            SignatureSender.scanNamespaceDecls(node2, set);
        }
    }

    public void invoke(Document document, Element element, Map map) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        X509Certificate x509Certificate;
        Key key;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        String string = this.config.getSignatureMethod();
        String string2 = this.config.getKeyName();
        KeyLocator keyLocator = this.config.getKeyLocator();
        Request[] requestArray = RequestPool.get(map, SignerRequest.class);
        if (requestArray.length == 0) {
            key = keyLocator.getSigningKey(string2);
            x509Certificate = (X509Certificate)keyLocator.getCertificate(string2);
        } else {
            if (requestArray.length > 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, requestArray.length + " SignerRequests. Using the first one");
            }
            object5 = (SignerRequest)requestArray[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Switch signer to: " + ((SignerRequest)object5).getAlias());
            }
            key = keyLocator.getSigningKey(((SignerRequest)object5).getAlias());
            x509Certificate = (X509Certificate)keyLocator.getCertificate(((SignerRequest)object5).getAlias());
        }
        if (string == null) {
            if (SignatureSender.instanceOf(key, "java.security.interfaces.DSAPrivateKey")) {
                string = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else if (SignatureSender.instanceOf(key, "java.security.interfaces.RSAPrivateKey")) {
                string = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else {
                Tr.warning(tc, "security.wssecurity.SignatureSender.unknownKey", key.getClass().getName());
            }
        }
        TemplateGenerator templateGenerator = new TemplateGenerator(document, this.config.getDigestMethod(), this.config.getCanonicalizationMethod(), string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining signing parts.");
        }
        Iterator iterator = this.config.getIntegralParts().iterator();
        object5 = Constants.getWSUNS(map);
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.equals("body")) continue;
            SignatureSender.addReferenceForBody(templateGenerator, document, this.config, (String)object5);
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining RequestPool.");
        }
        requestArray = RequestPool.get(map, SignatureRequest.class);
        for (int i = 0; i < requestArray.length; ++i) {
            object4 = (SignatureRequest)requestArray[i];
            if (((SignatureRequest)object4).isBodyRequest()) {
                throw SoapSecurityException.format("security.wssecurity.SignatureSender.dsig02");
            }
            object3 = templateGenerator.createReference("#" + ((SignatureRequest)object4).getIdName());
            ((Reference)object3).addTransform(this.config.getCanonicalizationMethod());
            templateGenerator.addReference((Reference)object3);
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Generating a template.");
        }
        if (!bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element security, Map context)");
            }
            return;
        }
        Element element2 = templateGenerator.getSignatureElement();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Apply TemplateModifiers.");
        }
        iterator = this.config.getTemplateModifiers().iterator();
        while (iterator.hasNext()) {
            ((TemplateModifier)iterator.next()).modifyTemplate(element2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Starting to Sign.");
        }
        object4 = null;
        element.insertBefore(element2, element.getFirstChild());
        if (this.config.getPreC14n()) {
            SignatureSender.preC14n(document, element2);
        }
        if (this.gconfig.doIndentation()) {
            element.insertBefore(document.createTextNode("\n      "), element2);
        } else {
            DOMUtil.removeIndentation(element);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Template: " + new String(XPathCanonicalizer.serializeSubset(element2, true)));
        }
        object3 = this.config.getCanonicalizationMethod();
        if (this.config.addInclusiveNamespaces() && ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(object3) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(object3))) {
            object2 = DOMUtil.getOneElement(element2, Constants.NS_DSIG, "CanonicalizationMethod");
            HashSet<String> hashSet = new HashSet<String>();
            for (Node node = object2; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    String string4 = namedNodeMap.item(i).getNodeName();
                    if (string4.equals("xmlns")) {
                        hashSet.add("#default");
                        continue;
                    }
                    if (!string4.startsWith("xmlns:")) continue;
                    hashSet.add(string4.substring(6));
                }
            }
            SignatureSender.scanNamespaceDecls((Node)object2, hashSet);
            if (hashSet.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next());
                    stringBuffer.append(" ");
                }
                object = document.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "ec:InclusiveNamespaces");
                object.setAttributeNS(Constants.NS_XMLNS, "xmlns:ec", "http://www.w3.org/2001/10/xml-exc-c14n#");
                object.setAttributeNS(null, "PrefixList", new String(stringBuffer));
                object2.appendChild((Node)object);
            }
        }
        SignatureContext signatureContext = new SignatureContext();
        if (tc.isDebugEnabled()) {
            signatureContext.setResourceShower(ShowerImpl.getInstance());
        }
        signatureContext.setIDResolver(this.idResolver);
        object2 = Constants.getWSSENS(map);
        if (USE_EMBEDDED) {
            SignatureSender.insertEmbedded(element2, x509Certificate.getEncoded(), (String)object2);
        } else {
            object4 = IdUtil.getInstance().makeUniqueId(document, "wssecurity_binary_security_token_id_");
            SignatureSender.insertTokenReference(element2, (String)object4, (String)object2);
        }
        if (this.gconfig.doIndentation()) {
            DOMUtil.indent(element2, 6, 2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing started.");
        }
        signatureContext.sign(element2, key);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing done.");
        }
        if (!USE_EMBEDDED) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Requesting a BinarySecurityToken for the signer certificate");
            }
            object = new TokenRequest.Binary(Constants.getQName((String)object2, "X509v3"), x509Certificate.getEncoded(), (String)object4, null);
            RequestPool.add(map, (Request)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element security, Map context)");
        }
    }

    private static void insertTokenReference(Element element, String string, String string2) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(string2, "wsse:Reference");
        element2.setAttribute("URI", "#" + string);
        Element element3 = SignatureSender.insertSTR(element, string2);
        element3.appendChild(element2);
    }

    private static void insertEmbedded(Element element, byte[] byArray, String string) throws SoapSecurityException {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(string, "wsse:BinarySecurityToken");
        element2.appendChild(document.createTextNode(Base64.encode(byArray)));
        Element element3 = document.createElementNS(string, "wsse:Embedded");
        element3.appendChild(element2);
        Element element4 = SignatureSender.insertSTR(element, string);
        element4.appendChild(element3);
        DOMUtil.setQNameAttr(element2, null, "ValueType", Constants.getQName(string, "X509v3"));
        DOMUtil.setQNameAttr(element2, null, "EncodingType", Constants.getQName(string, "Base64Binary"));
    }

    private static Element insertSTR(Element element, String string) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(string, "wsse:SecurityTokenReference");
        element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsse", string);
        String string2 = "KeyInfo";
        if (element.getPrefix() != null) {
            string2 = element.getPrefix() + ":KeyInfo";
        }
        Element element3 = document.createElementNS(Constants.NS_DSIG, string2);
        string2 = "xmlns";
        if (element.getPrefix() != null) {
            string2 = "xmlns:" + element.getPrefix();
        }
        element3.setAttributeNS(Constants.NS_XMLNS, string2, Constants.NS_DSIG);
        element3.appendChild(element2);
        element.appendChild(element3);
        return element2;
    }

    private static void preC14n(Document document, Element element) {
        Element element2 = DOMUtil.getFirstElement(document.getDocumentElement(), "http://schemas.xmlsoap.org/soap/envelope/", "Body");
        SignatureSender.setPrefix(element2, element2.getPrefix(), "S");
        element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:S", "http://schemas.xmlsoap.org/soap/envelope/");
        String string = "xmlns";
        if (element.getPrefix() != null) {
            string = "xmlns:" + element.getPrefix();
        }
        element.removeAttribute(string);
        SignatureSender.setPrefix(element, element.getPrefix(), SIGNATURE_PREFIX);
        string = "xmlns";
        if (SIGNATURE_PREFIX != null) {
            string = "xmlns:ds";
        }
        element.setAttributeNS(Constants.NS_XMLNS, string, Constants.NS_DSIG);
        Element element3 = DOMUtil.getFirstElement(element, Constants.NS_DSIG, "SignedInfo");
        SignatureSender.setPrefix(element3, element3.getPrefix(), "Sig");
        element3.setAttributeNS(Constants.NS_XMLNS, "xmlns:Sig", Constants.NS_DSIG);
    }

    static void setPrefix(Element element, String string, String string2) {
        Object object;
        if (element.getPrefix() == null) {
            if (string == null) {
                element.setPrefix(string2);
            }
        } else if (element.getPrefix().equals(string)) {
            element.setPrefix(string2);
        }
        if (string != null) {
            object = element.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                Attr attr = (Attr)object.item(i);
                if (attr.getPrefix() == null || !attr.getPrefix().equals(string)) continue;
                attr.setPrefix(string2);
            }
        }
        object = DOMUtil.getFirstChild2(element);
        while (object != null) {
            switch (object.getNodeType()) {
                case 1: {
                    SignatureSender.setPrefix((Element)object, string, string2);
                }
            }
            object = DOMUtil.getNextSibling2((Node)object);
        }
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showSignedResource(Element element, int n, String string, String string2, byte[] byArray, String string3) {
            String string4 = null;
            try {
                string4 = string3 == null ? new String(byArray, "UTF-8") : new String(byArray, string3);
            }
            catch (Exception exception) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [" + string3 + "].");
            }
            if (n < 0) {
                Tr.debug(tc, "ResourceShower logs sign-SignedInfo: " + string4);
            } else if (string == null || string.length() == 0) {
                Tr.debug(tc, "ResourceShower logs sign-resource_" + n + ": " + string4);
            } else {
                Tr.debug(tc, "ResourceShower logs sign-" + string + ": " + string4);
            }
        }
    }
}

