/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.proxy;

import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageProxy;
import com.ibm.xml.soapsec.proxy.ProxyBase;
import com.ibm.xml.soapsec.proxy.SOAPEnvelopeProxy;
import com.ibm.xml.soapsec.proxy.SOAPPartProxy;
import com.ibm.xml.soapsec.util.DOMUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AxisMessageProxyImpl
extends MessageProxy {
    private Object message;
    private static Constructor constructor;
    private static Method getSOAPEnvelope;
    private static Method getSOAPPart;
    private static Method getCharacterEncoding;
    static Class cls;

    public AxisMessageProxyImpl(Object object) {
        try {
            this.message = object instanceof String || object instanceof InputStream ? constructor.newInstance(object) : (object instanceof FaultProxy ? constructor.newInstance(((FaultProxy)object).get()) : object);
        }
        catch (Throwable throwable) {
            ProxyBase.processException(throwable);
        }
    }

    public Object get() {
        return this.message;
    }

    public SOAPEnvelopeProxy getSOAPEnvelope() throws FaultProxy {
        try {
            Object object = getSOAPEnvelope.invoke(this.message, null);
            return SOAPEnvelopeProxy.getInstance(object);
        }
        catch (Throwable throwable) {
            ProxyBase.throwException(throwable);
            return null;
        }
    }

    public SOAPPartProxy getSOAPPart() {
        try {
            Object object = getSOAPPart.invoke(this.message, null);
            return SOAPPartProxy.getInstance(object);
        }
        catch (Throwable throwable) {
            ProxyBase.processException(throwable);
            return null;
        }
    }

    public Document getDocument() throws FaultProxy {
        try {
            SOAPPartProxy sOAPPartProxy = this.getSOAPPart();
            String string = sOAPPartProxy.getOriginalMessage();
            if (string != null && string.length() > 0) {
                return DOMUtil.parse(new InputSource(new ByteArrayInputStream(string.getBytes("UTF-8"))), false);
            }
            byte[] byArray = sOAPPartProxy.getAsBytes();
            return DOMUtil.parse(new InputSource(new ByteArrayInputStream(byArray)), false);
        }
        catch (Throwable throwable) {
            ProxyBase.throwException(throwable);
            return null;
        }
    }

    public String getCharEncoding() {
        String string = null;
        if (!ProxyBase.axis) {
            try {
                string = (String)getCharacterEncoding.invoke(this.message, null);
            }
            catch (Throwable throwable) {
                ProxyBase.processException(throwable);
            }
            if (string == null) {
                string = "UTF-8";
            }
        } else {
            string = "UTF-8";
        }
        return string;
    }

    static {
        try {
            cls = Class.forName("org.apache.axis.Message");
            constructor = cls.getConstructor(Object.class);
            getSOAPEnvelope = cls.getMethod("getSOAPEnvelope", null);
            getSOAPPart = cls.getMethod("getSOAPPart", null);
            getCharacterEncoding = cls.getMethod("getCharacterEncoding", null);
        }
        catch (Throwable throwable) {
            ProxyBase.processException(throwable);
        }
    }
}

