/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.time;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.SoapSecuritySender;
import com.ibm.xml.soapsec.WriteBackResult;
import com.ibm.xml.soapsec.time.TimestampReceiverConfig;
import com.ibm.xml.soapsec.time.TimestampResult;
import com.ibm.xml.soapsec.token.UTC;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TimestampReceiver
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(TimestampReceiver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TimestampReceiver.class.getName();
    static final boolean DO_INDENT = true;
    TimestampReceiverConfig config;

    public void init(Map map) throws Exception {
        this.config = (TimestampReceiverConfig)map.get(TimestampReceiverConfig.class);
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        Element element2;
        Object object;
        Date date = null;
        Date date2 = null;
        String string = null;
        Element element3 = null;
        Element element4 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        if (this.config.addReceivedTimestamp()) {
            Node node;
            String string2 = Constants.getWSUNS(map);
            Element element5 = TimestampReceiver.getTimestampHeader(document, true);
            if (element5 == null) {
                element5 = document.createElementNS(string2, "wsu:TimestampTrace");
                element5.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsu", string2);
                Element element6 = SoapSecuritySender.getHeader(document);
                element6.insertBefore(element5, element6.getFirstChild());
            }
            Element element7 = document.createElementNS(string2, "wsu:Received");
            element7.setAttributeNS(null, "Role", this.config.getActor());
            element7.appendChild(document.createTextNode(UTC.format(new Date())));
            object = element5.getLastChild();
            if (object != null && object.getNodeType() != 3) {
                object = null;
            }
            if ((node = element5.getFirstChild()) == null) {
                element5.insertBefore(document.createTextNode("\n      "), (Node)object);
            } else if (node.getNodeType() == 3) {
                element5.insertBefore(document.createTextNode(node.getNodeValue()), (Node)object);
            }
            element5.insertBefore(element7, (Node)object);
            ResultPool.add(map, new WriteBackResult(){});
        }
        if ((element2 = TimestampReceiver.getTimestampHeader(document, false)) != null) {
            string = NamespaceUtil.getWsuAttribute(element2, "Id");
            if (string.length() == 0) {
                string = null;
            }
            element3 = NamespaceUtil.getFirstChildWsuElement(element2, "Created");
            element4 = NamespaceUtil.getFirstChildWsuElement(element2, "Expires");
        }
        try {
            if (element3 != null) {
                date = UTC.parse(DOMUtil.getStringValue(element3));
            }
            if (element4 != null) {
                date2 = UTC.parse(DOMUtil.getStringValue(element4));
            }
        }
        catch (ParseException parseException) {
            object = "security.wssecurity.TimestampReceiver.parse";
            Tr.processException((Throwable)parseException, clsName + ".invoke", "134", this);
            Tr.error(tc, (String)object, parseException);
            throw SoapSecurityException.format((String)object, parseException.toString(), (Throwable)parseException);
        }
        if (date != null || date2 != null) {
            ResultPool.add(map, new TimestampResult(date, date2, string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }

    public static Element getTimestampHeader(Document document, boolean bl) {
        Element element;
        String string;
        String string2 = string = bl ? "TimestampTrace" : "Timestamp";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestampHeader(" + document + ")");
        }
        if ((element = DOMUtil.getFirstElement(document.getDocumentElement(), "http://schemas.xmlsoap.org/soap/envelope/", "Header")) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTimestampHeader(Document doc) returns null");
            }
            return null;
        }
        Element element2 = DOMUtil.getFirstElement(element);
        while (element2 != null) {
            if (NamespaceUtil.isWsu(element2.getNamespaceURI()) && string.equals(element2.getLocalName())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTimestampHeader(Document doc) returns " + element2);
                }
                return element2;
            }
            element2 = DOMUtil.getNextElement(element2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestampHeader(Document doc) returns null");
        }
        return null;
    }
}

