/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.time;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.time.TimestampSenderConfig;
import com.ibm.xml.soapsec.token.UTC;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TimestampSender
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(TimestampSender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TimestampSender.class.getName();
    SenderConfig gconfig;
    TimestampSenderConfig config;

    public void init(Map map) throws Exception {
        this.gconfig = (SenderConfig)map.get(SenderConfig.class);
        this.config = (TimestampSenderConfig)map.get(TimestampSenderConfig.class);
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        if ((element2 = NamespaceUtil.getFirstChildWsuElement(element, "Timestamp")) == null) {
            if (this.config.addCreatedTimestamp()) {
                this.addCreated(document, element, map);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
            }
            return;
        }
        if (this.config.addCreatedTimestamp()) {
            throw SoapSecurityException.format("security.wssecurity.TimestampSender.time03");
        }
        Element element3 = NamespaceUtil.getFirstChildWsuElement(element, "TimestampTrace");
        Element element4 = null;
        Object object = DOMUtil.getLastChild2(element3);
        while (object != null) {
            if (object.getNodeType() == 1 && NamespaceUtil.isWsu(object.getNamespaceURI()) && "Received".equals(object.getLocalName())) {
                element4 = (Element)object;
                if (element4.getAttribute("Role").equals(this.config.getMyActor())) break;
                element4 = null;
            }
            object = DOMUtil.getPreviousSibling2((Node)object);
        }
        if (element4 == null) {
            if (this.config.signTimestamp()) {
                throw SoapSecurityException.format("security.wssecurity.TimestampSender.time04");
            }
        } else {
            if (this.config.signTimestamp()) {
                object = NamespaceUtil.getWsuAttribute(element4, "Id");
                if (object == null) {
                    object = IdUtil.getInstance().makeUniqueId(document, "tsr_");
                    String string = "Id";
                    if (element4.getPrefix() != null) {
                        string = element4.getPrefix() + ":Id";
                    }
                    element4.setAttributeNS(element4.getNamespaceURI(), string, (String)object);
                }
                RequestPool.add(map, new SignatureRequest((String)object));
            }
            try {
                object = UTC.parse(DOMUtil.getStringValue(element4));
            }
            catch (ParseException parseException) {
                String string = "security.wssecurity.TimestampReceiver.parse";
                Tr.processException((Throwable)parseException, clsName + ".invoke", "139", this);
                Tr.error(tc, string, parseException);
                throw SoapSecurityException.format(string, parseException.toString(), (Throwable)parseException);
            }
            long l = System.currentTimeMillis() - ((Date)object).getTime();
            element4.setAttributeNS(null, "Delay", Long.toString(l));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    private void addCreated(Document document, Element element, Map map) {
        Object object;
        Date date = new Date();
        String string = Constants.getWSUNS(map);
        Element element2 = document.createElementNS(string, "wsu:Timestamp");
        element2.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsu", string);
        if (this.config.signTimestamp()) {
            object = IdUtil.getInstance().makeUniqueId(document, "ts_");
            element2.setAttributeNS(string, "wsu:Id", (String)object);
            RequestPool.add(map, new SignatureRequest((String)object));
        }
        if (this.config.addCreatedTimestamp()) {
            object = UTC.format(date);
            Element element3 = document.createElementNS(string, "wsu:Created");
            element3.appendChild(document.createTextNode((String)object));
            element2.appendChild(element3);
        }
        if (this.config.getDuration() != null) {
            object = this.config.getDuration();
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            ((Duration)object).addTo(calendar);
            String string2 = UTC.format(calendar.getTime());
            Element element4 = document.createElementNS(string, "wsu:Expires");
            element4.appendChild(document.createTextNode(string2));
            element2.appendChild(element4);
        }
        element.insertBefore(element2, element.getFirstChild());
        if (this.gconfig.doIndentation()) {
            element.insertBefore(document.createTextNode("\n    "), element2);
            DOMUtil.indent(element2, 4, 2);
        }
    }
}

