/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.VerificationSettings;
import com.ibm.xml.soapsec.token.LoginMapping;
import com.ibm.xml.soapsec.token.ReceiverLogin;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinaryTokenReceiver
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(BinaryTokenReceiver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = BinaryTokenReceiver.class.getName();
    TokenReceiverConfig conf = null;

    public BinaryTokenReceiver() {
    }

    public BinaryTokenReceiver(TokenReceiverConfig tokenReceiverConfig) {
        this.conf = tokenReceiverConfig;
    }

    public void init(Map map) throws Exception {
        this.conf = (TokenReceiverConfig)map.get(TokenReceiverConfig.class);
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        String string = Constants.getWSSENS(map);
        QName qName = Constants.getQName(string, "InvalidSecurityToken");
        QName qName2 = Constants.getQName(string, "UnsupportedSecurityToken");
        if (this.conf == null) {
            throw SoapSecurityException.format(qName, "token12");
        }
        String string2 = IdUtil.getInstance().getIdAttributeName(element);
        String string3 = string2 == null ? null : element.getAttribute(string2);
        String string4 = DOMUtil.getStringValue(element);
        byte[] byArray = null;
        String string5 = element.getAttribute("EncodingType");
        if (string5.equals("")) {
            throw SoapSecurityException.format(qName, "security.wssecurity.BinaryTokenReceiver.token13");
        }
        QName qName3 = DOMUtil.getQName(element, string5);
        if (!NamespaceUtil.equals(qName3, Constants.BASE64_BINARY_RCVR)) {
            if (NamespaceUtil.equals(qName3, Constants.HEX_BINARY_RCVR)) {
                throw SoapSecurityException.format(qName2, "security.wssecurity.BinaryTokenReceiver.token14");
            }
            throw SoapSecurityException.format(qName2, "security.wssecurity.BinaryTokenReceiver.token15", string5);
        }
        byArray = Base64.decode(string4);
        String string6 = element.getAttribute("ValueType");
        if (string6.equals("")) {
            throw SoapSecurityException.format(qName, "security.wssecurity.BinaryTokenReceiver.token16");
        }
        QName qName4 = DOMUtil.getQName(element, string6);
        if (NamespaceUtil.equals(qName4, Constants.X509V3_RCVR)) {
            if (this.conf.isX509Ready()) {
                try {
                    X509Certificate x509Certificate = null;
                    String string7 = null;
                    String string8 = null;
                    boolean bl = false;
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate2 = null;
                    try {
                        x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                    }
                    catch (CertificateException certificateException) {
                        throw SoapSecurityException.format(qName, "security.wssecurity.BinaryTokenReceiver.token17", certificateException.toString());
                    }
                    Iterator iterator = this.conf.getVerificationSettingsList().iterator();
                    SoapSecurityException soapSecurityException = null;
                    while (iterator.hasNext()) {
                        VerificationSettings verificationSettings = (VerificationSettings)iterator.next();
                        Provider provider = verificationSettings.getCertPathProvider();
                        if (!verificationSettings.getTrustAnyCertificate()) {
                            CertPathBuilder certPathBuilder = provider == null ? CertPathBuilder.getInstance("PKIX") : CertPathBuilder.getInstance("PKIX", provider);
                            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)verificationSettings.getPKIXBuilderParameters().clone();
                            X509CertSelector x509CertSelector = (X509CertSelector)pKIXBuilderParameters.getTargetCertConstraints();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "CertPathProvider = " + (provider == null ? "default" : provider.getName()));
                                Tr.debug(tc, "CertPath Builder = " + certPathBuilder.getClass().getName());
                                Tr.debug(tc, "CertPath Selector = " + x509CertSelector.getClass().getName());
                                Tr.debug(tc, "SubjectDN = " + x509Certificate2.getSubjectX500Principal().getName());
                            }
                            x509CertSelector.setSubject(x509Certificate2.getSubjectX500Principal().getEncoded());
                            pKIXBuilderParameters.setTargetCertConstraints(x509CertSelector);
                            HashSet<X509Certificate> hashSet = verificationSettings.getEeCerts();
                            if (hashSet == null) {
                                hashSet = new HashSet<X509Certificate>();
                            }
                            hashSet.add(x509Certificate2);
                            CertStore certStore = provider == null ? CertStore.getInstance("Collection", new CollectionCertStoreParameters(hashSet)) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(hashSet), provider);
                            pKIXBuilderParameters.addCertStore(certStore);
                            pKIXBuilderParameters.setRevocationEnabled(false);
                            try {
                                List<CertStore> list = pKIXBuilderParameters.getCertStores();
                                X509CRLSelector x509CRLSelector = new X509CRLSelector();
                                boolean bl2 = false;
                                if (list != null) {
                                    Iterator<CertStore> iterator2 = list.iterator();
                                    while (iterator2.hasNext()) {
                                        Iterator<? extends CRL> iterator3;
                                        CertStore certStore2 = iterator2.next();
                                        Collection<? extends CRL> collection = certStore2.getCRLs(x509CRLSelector);
                                        if (collection == null || !(iterator3 = collection.iterator()).hasNext()) continue;
                                        bl2 = true;
                                        break;
                                    }
                                }
                                if (bl2) {
                                    pKIXBuilderParameters.setRevocationEnabled(true);
                                    Tr.debug(tc, " RevocationEnabled.");
                                } else {
                                    Tr.debug(tc, " Revocation Not Enabled.");
                                }
                            }
                            catch (Exception exception) {
                                Tr.debug(tc, "Exception occurred while attempting to process CRLs: " + exception);
                            }
                            try {
                                certPathBuilder.build(pKIXBuilderParameters);
                                string7 = verificationSettings.getTrustAnchorRef();
                                string8 = verificationSettings.getCertStoreRef();
                                x509Certificate = x509Certificate2;
                                break;
                            }
                            catch (CertPathBuilderException certPathBuilderException) {
                                soapSecurityException = SoapSecurityException.format(qName, "security.wssecurity.BinaryTokenReceiver.token19", certPathBuilderException.toString());
                                continue;
                            }
                        }
                        x509Certificate = x509Certificate2;
                        bl = true;
                        break;
                    }
                    if (x509Certificate == null) {
                        throw soapSecurityException;
                    }
                    ResultPool.add(map, new TokenResult.X509(x509Certificate, string3, string7, string8, bl));
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "184", this);
                    Tr.error(tc, "security.wssecurity.BinaryTokenReceiver.token20", soapSecurityException);
                    throw soapSecurityException;
                }
                catch (Exception exception) {
                    String string9 = "security.wssecurity.BinaryTokenReceiver.token20";
                    Tr.processException((Throwable)exception, clsName + ".invoke", "189", this);
                    Tr.error(tc, string9, exception);
                    throw SoapSecurityException.format(string9, exception.toString());
                }
            }
            Tr.warning(tc, "security.wssecurity.BinaryTokenReceiver.token40");
        } else if (byArray != null && byArray.length != 0) {
            LoginMapping loginMapping;
            if (NamespaceUtil.isWsse(qName4.getNamespaceURI())) {
                qName4 = new QName(Constants.NS_WSSE, qName4.getLocalPart());
            }
            if ((loginMapping = this.conf.getLoginMapping(qName4)) != null) {
                Subject subject = ReceiverLogin.login(loginMapping, byArray, null, null, map);
                ResultPool.add(map, new TokenResult.Generic(qName4, subject, string3));
            } else {
                Tr.warning(tc, "security.wssecurity.BinaryTokenReceiver.token22", qName4.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }
}

