/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluatorException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.dsig.SignatureReceiverConfig;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.token.LoginMapping;
import com.ibm.xml.soapsec.token.LoginResult;
import com.ibm.xml.soapsec.token.ReceiverLoginComponent;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.token.UserRegistry;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReceiverLogin
implements ReceiverLoginComponent {
    private static final TraceComponent tc = Tr.register(ReceiverLogin.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = ReceiverLogin.class.getName();
    private static final String comp = "security.wssecurity";
    protected TokenReceiverConfig conf = null;
    protected SignatureReceiverConfig sconf = null;
    protected String currentRealm = null;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenResult$X509;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenResult$Username;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$token$TokenResult$Generic;

    public void init(Map map) throws Exception {
        this.conf = (TokenReceiverConfig)map.get(TokenReceiverConfig.class);
        this.sconf = (SignatureReceiverConfig)map.get(SignatureReceiverConfig.class);
        this.currentRealm = UserRegistry.getInstance().getRealm();
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        Object object;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        if (this.conf == null) {
            String string2 = Constants.getWSSENS(map);
            throw SoapSecurityException.format(Constants.getQName(string2, "InvalidSecurity"), "security.wssecurity.ReceiverLogin.token01");
        }
        String string3 = this.conf.getIdType();
        String string4 = this.conf.getTrustMode();
        LinkedList linkedList = this.conf.getAuthMethods();
        if (linkedList == null) {
            linkedList = new LinkedList();
        }
        Subject subject = null;
        String string5 = null;
        boolean bl = false;
        Iterator iterator = linkedList.iterator();
        String string6 = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string6 = string6 == null ? new String(string) : string6 + ", " + string;
            if (string.equals("IDAssertion")) {
                Object object2;
                Set set;
                Object object3;
                int n;
                Object object4;
                object = null;
                if (string3.equals("X509Certificate")) {
                    object4 = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$X509 == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenResult$X509") : class$com$ibm$xml$soapsec$token$TokenResult$X509);
                    for (n = 0; n < ((Result[])object4).length; ++n) {
                        TokenResult.X509 x509 = (TokenResult.X509)object4[n];
                        if (x509.getUsed()) continue;
                        subject = ReceiverLogin.login(this.conf.getLoginMapping("IDAssertion"), this.getSecurityName(x509.getCertificate()), null, null, map);
                        string5 = x509.getIdName();
                        object = x509;
                        x509.setAuthenticatedId();
                        break;
                    }
                } else {
                    object4 = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$Username == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenResult$Username") : class$com$ibm$xml$soapsec$token$TokenResult$Username);
                    for (n = 0; n < ((Result[])object4).length; ++n) {
                        TokenResult.Username username = (TokenResult.Username)object4[n];
                        if (!username.isIdAssertion()) continue;
                        subject = username.getSubject();
                        string5 = username.getIdName();
                        object = username;
                        break;
                    }
                }
                if ("BasicAuth".equals(string4)) {
                    object4 = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$Username == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenResult$Username") : class$com$ibm$xml$soapsec$token$TokenResult$Username);
                    n = 0;
                    for (int i = 0; i < ((Result[])object4).length; ++i) {
                        object3 = (TokenResult.Username)object4[i];
                        if (((TokenResult.Username)object3).isIdAssertion() || !this.validateId(((TokenResult.Username)object3).getUsername())) continue;
                        n = 1;
                        break;
                    }
                    if (n == 0) {
                        throw SoapSecurityException.format("security.wssecurity.ReceiverLogin.token35");
                    }
                } else if ("Signature".equals(string4)) {
                    object4 = ResultPool.get(map, class$com$ibm$xml$soapsec$dsig$SignatureResult == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.dsig.SignatureResult") : class$com$ibm$xml$soapsec$dsig$SignatureResult);
                    if (((Result[])object4).length <= 0) {
                        throw SoapSecurityException.format("security.wssecurity.ReceiverLogin.token03");
                    }
                    String string7 = object.getIdName();
                    if (string7 == null) {
                        throw SoapSecurityException.format("security.wssecurity.ReceiverLogin.token05");
                    }
                    boolean bl2 = false;
                    for (int i = 0; i < ((Result[])object4).length; ++i) {
                        set = (SignatureResult)object4[i];
                        object2 = this.getSecurityName(((SignatureResult)((Object)set)).getCertificate());
                        if (!((SignatureResult)((Object)set)).isSigned(string7) || !this.validateId((String)object2)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        throw SoapSecurityException.format("security.wssecurity.ReceiverLogin.token06");
                    }
                }
                if (subject != null) {
                    object4 = null;
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    String string8 = null;
                    object3 = this.conf.getLoginMapping("IDAssertion").getProperties();
                    if (object3 == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "properties is null.");
                        }
                    } else {
                        set = object3.keySet();
                        if (set == null || set.isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "CallerConfig's properties has no entry.");
                            }
                        } else {
                            object2 = set.iterator();
                            while (object2.hasNext()) {
                                String string9 = (String)object2.next();
                                if (!"LoginUsername".equals(string9)) continue;
                                string8 = (String)object3.get(string9);
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Extracted Username", string8);
                        }
                    }
                    if (contextManager == null) {
                        Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
                    } else {
                        try {
                            object4 = contextManager.login(this.currentRealm, string8);
                        }
                        catch (WSLoginFailedException wSLoginFailedException) {
                            Tr.processException((Throwable)wSLoginFailedException, clsName + ".login", "235", this);
                            throw SoapSecurityException.format("security.wssecurity.ReceiverLogin.token11", wSLoginFailedException);
                        }
                        this.addToSubject((Subject)object4, subject);
                    }
                }
            } else if (string.equals("BasicAuth")) {
                object = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$Username == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenResult$Username") : class$com$ibm$xml$soapsec$token$TokenResult$Username);
                for (int i = 0; i < ((Result[])object).length; ++i) {
                    TokenResult.Username username = (TokenResult.Username)object[i];
                    if (username.isIdAssertion()) continue;
                    subject = username.getSubject();
                    string5 = username.getIdName();
                    break;
                }
            } else if (string.equals("Signature")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authMethod is Signature.");
                }
                object = ResultPool.get(map, class$com$ibm$xml$soapsec$dsig$SignatureResult == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.dsig.SignatureResult") : class$com$ibm$xml$soapsec$dsig$SignatureResult);
                String string10 = null;
                for (int i = 0; i < ((Result[])object).length; ++i) {
                    SignatureResult signatureResult = (SignatureResult)object[i];
                    if (!signatureResult.getCompliance()) continue;
                    string10 = this.getSecurityName(signatureResult.getCertificate());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling Signature login module, uname is " + string10);
                    }
                    subject = ReceiverLogin.login(this.conf.getLoginMapping("Signature"), string10, null, null, map);
                    if (tc.isDebugEnabled()) {
                        if (subject == null) {
                            Tr.debug(tc, "Subject returned from Signature login module is null.");
                        } else {
                            Tr.debug(tc, "Subject returned from Signature login module is not null.");
                        }
                    }
                    bl = true;
                    signatureResult.setAuthenticatedId();
                    break;
                }
                if (subject != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "authMethod is Signature, subject is not null, uname is " + string10);
                    }
                    Subject subject2 = null;
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    if (contextManager == null) {
                        Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "about to do context manager login. realm is " + this.currentRealm + ", uname is " + string10);
                        }
                        try {
                            subject2 = contextManager.login(this.currentRealm, string10);
                        }
                        catch (WSLoginFailedException wSLoginFailedException) {
                            Tr.processException((Throwable)wSLoginFailedException, clsName + ".login", "306", this);
                            throw SoapSecurityException.format("security.wssecurity.ReceiverLogin.token11", wSLoginFailedException);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Context manager login successful. About to add credentials and principal to subject.");
                        }
                        this.addToSubject(subject2, subject);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authMethod is Signature, subject is null");
                }
            } else {
                int n = 0;
                object = ResultPool.get(map, class$com$ibm$xml$soapsec$token$TokenResult$Generic == null ? ReceiverLogin.class$("com.ibm.xml.soapsec.token.TokenResult$Generic") : class$com$ibm$xml$soapsec$token$TokenResult$Generic);
                if (n < ((Result[])object).length) {
                    TokenResult.Generic generic = (TokenResult.Generic)object[n];
                    subject = generic.getSubject();
                    string5 = generic.getIdName();
                }
            }
            if (subject == null) continue;
            break;
        }
        if (linkedList.size() != 0) {
            if (subject == null) {
                Tr.error(tc, "security.wssecurity.WSEC5207E", new Object[]{string6});
                string = Constants.getWSSENS(map);
                throw SoapSecurityException.format(Constants.getQName(string, "FailedAuthentication"), "security.wssecurity.ReceiverLogin.token07");
            }
            if (!bl && this.sconf.getRequiredIntegralParts().contains("securitytoken")) {
                boolean bl3 = false;
                object = ResultPool.get(map, SignatureResult.class);
                for (int i = 0; i < ((Result[])object).length; ++i) {
                    SignatureResult signatureResult = (SignatureResult)object[i];
                    if (!signatureResult.isSigned(string5)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    String string11 = Constants.getWSSENS(map);
                    throw SoapSecurityException.format(Constants.getQName(string11, "FailedCheck"), "security.wssecurity.ReceiverLogin.unsigned");
                }
            }
            ResultPool.add(map, new LoginResult(subject));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }

    private void addToSubject(final Subject subject, final Subject subject2) {
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Iterator<Principal> iterator;
                Iterator<Object> iterator2;
                Iterator<Object> iterator3 = subject.getPublicCredentials().iterator();
                while (iterator3.hasNext()) {
                    iterator2 = iterator3.next();
                    if (iterator2 == null) continue;
                    if (!subject2.getPublicCredentials().contains(iterator2)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding public object to Subject: " + iterator2);
                        }
                        subject2.getPublicCredentials().add(iterator2);
                        continue;
                    }
                    Tr.error(tc, "Public credential already exists within subject");
                }
                iterator2 = subject.getPrivateCredentials().iterator();
                while (iterator2.hasNext()) {
                    iterator = iterator2.next();
                    if (iterator == null) continue;
                    if (!subject2.getPrivateCredentials().contains(iterator)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding private object to Subject: " + iterator);
                        }
                        subject2.getPrivateCredentials().add(iterator);
                        continue;
                    }
                    Tr.error(tc, "Private credential already exists within subject");
                }
                iterator = subject.getPrincipals().iterator();
                while (iterator.hasNext()) {
                    Principal principal = iterator.next();
                    if (principal == null) continue;
                    if (!subject2.getPrincipals().contains(principal)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding principal object to Subject: " + principal);
                        }
                        subject2.getPrincipals().add(principal);
                        continue;
                    }
                    Tr.error(tc, "Principal already exists within subject");
                }
                return null;
            }
        });
    }

    protected boolean validateId(String string) {
        try {
            return this.conf.getTrustedIDEvaluator().evaluate(string);
        }
        catch (TrustedIDEvaluatorException trustedIDEvaluatorException) {
            Tr.processException(trustedIDEvaluatorException, clsName + ".validateId", "265");
            Tr.error(tc, "security.wssecurity.ReceiverLogin.trust", trustedIDEvaluatorException);
            return false;
        }
    }

    static Subject login(LoginMapping loginMapping, Object object, Document document, char[] cArray, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(" + loginMapping + "," + object + "," + "XXXXXX" + "," + map + ")");
        }
        CallbackHandlerFactory callbackHandlerFactory = loginMapping.getCallbackHandlerFactory();
        if (object instanceof byte[]) {
            callbackHandlerFactory.setTokenBytes((byte[])object);
        } else if (object instanceof Element) {
            callbackHandlerFactory.setXMLToken((Element)object);
            callbackHandlerFactory.setSOAPMessage(document);
        } else {
            callbackHandlerFactory.setUsername((String)object);
            callbackHandlerFactory.setPassword(cArray);
        }
        callbackHandlerFactory.setProperties(loginMapping.getProperties());
        CallbackHandler callbackHandler = callbackHandlerFactory.newCallbackHandler();
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(loginMapping.getConfigName(), callbackHandler);
        }
        catch (LoginException loginException) {
            String string = "security.wssecurity.ReceiverLogin.token10";
            Tr.processException(loginException, clsName + ".login", "300");
            Tr.error(tc, string, loginException);
            String string2 = Constants.getWSSENS(map);
            throw SoapSecurityException.format(Constants.getQName(string2, "InvalidSecurity"), string, loginException.toString());
        }
        try {
            loginContext.login();
        }
        catch (LoginException loginException) {
            String string = "security.wssecurity.ReceiverLogin.token11";
            String string3 = "security.wssecurity.WSEC5201E";
            Tr.processException(loginException, clsName + ".login", "315");
            Tr.error(tc, string3, loginException);
            String string4 = Constants.getWSSENS(map);
            throw SoapSecurityException.format(Constants.getQName(string4, "FailedAuthentication"), string, loginException.toString());
        }
        Subject subject = loginContext.getSubject();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(LoginMapping mapping, Object token, char[] password) returns " + subject);
        }
        return subject;
    }

    private String getSecurityName(final X509Certificate x509Certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityName", x509Certificate);
        }
        String string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                String string = UserRegistry.getInstance().mapCertificate(x509Certificate);
                return string;
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mappedName: " + string);
        }
        if (string == null || string.length() == 0) {
            string = x509Certificate.getSubjectDN().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mappedName is null, so used the DN in the certificate: " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName returns " + string);
        }
        return string;
    }
}

