/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.BinaryTokenCallback;
import com.ibm.wsspi.wssecurity.auth.callback.XMLTokenSenderCallback;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.token.SenderLoginComponent;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.token.TokenSenderConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SenderLogin
implements SenderLoginComponent {
    private static final String comp = "security.wssecurity";
    private static final TraceComponent tc = Tr.register(SenderLogin.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    TokenSenderConfig conf = null;

    public void init(Map map) throws Exception {
        this.conf = (TokenSenderConfig)map.get(TokenSenderConfig.class);
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
            }
            String string = Constants.getWSSENS(map);
            if (this.conf == null) {
                throw SoapSecurityException.format(Constants.getQName(string, "InvalidSecurity"), "security.wssecurity.ReceiverLogin.token01");
            }
            String string2 = this.conf.getAuthMethod();
            String string3 = this.conf.getIdType();
            String string4 = this.conf.getTrustMode();
            QName qName = this.conf.getTokenValueType();
            final CallbackHandler callbackHandler = this.conf.getCallbackHandler();
            boolean bl = this.conf.isIntegral();
            try {
                if ("BasicAuth".equals(string2)) {
                    TokenRequest.Username username = this.retrieveUsernameTokenByTargetPort();
                    if (username == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Existing token not found, prompting for new token.");
                        }
                        username = this.getUsernameRequest(callbackHandler, true);
                        RequestPool.add(map, username);
                        this.cacheUsernameTokenByTargetPort(username);
                    } else {
                        RequestPool.add(map, username);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Existing token found.");
                        }
                    }
                    break block26;
                }
                if ("IDAssertion".equals(string2)) {
                    if (!string3.equals("X509Certificate")) {
                        String string5 = this.getInitialSenderId();
                        if (string5 == null || string5.length() == 0) {
                            Tr.error(tc, "security.wssecurity.no.initial.sender");
                            throw SoapSecurityException.format("security.wssecurity.no.initial.sender");
                        }
                        TokenRequest.Username username = new TokenRequest.Username(this.getInitialSenderId(), null, null, false, this.conf.isNonceAdded(), this.conf.getEncodingType(), this.conf.isNonceTimestampAdded());
                        if (string4 != null) {
                            if (string4.equals("BasicAuth")) {
                                RequestPool.add(map, this.getUsernameRequest(callbackHandler, true));
                            } else {
                                username.setSignature(true);
                            }
                        }
                        RequestPool.add(map, username);
                    } else {
                        X509Certificate x509Certificate = this.getInitialSenderCert();
                        if (x509Certificate == null) {
                            Tr.error(tc, "security.wssecurity.no.initial.cert");
                            throw SoapSecurityException.format("security.wssecurity.no.initial.cert");
                        }
                        byte[] byArray = x509Certificate.getEncoded();
                        TokenRequest.Binary binary = new TokenRequest.Binary(Constants.getQName(string, "X509v3"), byArray, null, null, bl);
                        if (string4 != null) {
                            if (string4.equals("BasicAuth")) {
                                RequestPool.add(map, this.getUsernameRequest(callbackHandler, true));
                            } else {
                                binary.setSignature(true);
                            }
                        }
                        RequestPool.add(map, binary);
                    }
                    break block26;
                }
                if ("Signature".equals(string2)) break block26;
                final BinaryTokenCallback binaryTokenCallback = new BinaryTokenCallback(null, null);
                final XMLTokenSenderCallback xMLTokenSenderCallback = new XMLTokenSenderCallback();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException, UnsupportedCallbackException {
                            callbackHandler.handle(new Callback[]{binaryTokenCallback, xMLTokenSenderCallback});
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                byte[] byArray = binaryTokenCallback.getCredToken();
                if (byArray != null && byArray.length != 0) {
                    RequestPool.add(map, new TokenRequest.Binary(qName, byArray, null, null, bl));
                } else {
                    Element[] elementArray = xMLTokenSenderCallback.getXMLTokens();
                    if (elementArray != null && elementArray.length != 0) {
                        RequestPool.add(map, new TokenRequest.XML(elementArray, bl));
                    }
                }
            }
            catch (Exception exception) {
                throw SoapSecurityException.format(Constants.getQName(string, "InvalidSecurity"), "security.wssecurity.SenderLogin.token32", exception.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    protected TokenRequest.Username getUsernameRequest(CallbackHandler callbackHandler, boolean bl) throws Exception {
        NameCallback nameCallback = new NameCallback(ConfigUtil.getMessage("security.wssecurity.SenderLogin.token29"));
        PasswordCallback passwordCallback = new PasswordCallback(ConfigUtil.getMessage("security.wssecurity.SenderLogin.token30"), false);
        if (bl) {
            callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        } else {
            callbackHandler.handle(new Callback[]{nameCallback});
        }
        String string = nameCallback.getName();
        String string2 = bl ? new String(passwordCallback.getPassword()) : null;
        return new TokenRequest.Username(string, string2, null, this.conf.isIntegral(), this.conf.isNonceAdded(), this.conf.getEncodingType(), this.conf.isNonceTimestampAdded());
    }

    protected String getInitialSenderId() throws SoapSecurityException {
        return "initialSender";
    }

    protected X509Certificate getInitialSenderCert() throws SoapSecurityException {
        return null;
    }

    protected void cacheUsernameTokenByTargetPort(TokenRequest.Username username) throws SoapSecurityException {
    }

    protected TokenRequest.Username retrieveUsernameTokenByTargetPort() throws SoapSecurityException {
        return null;
    }
}

