/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.enc.EncryptionRequest;
import com.ibm.xml.soapsec.token.BinaryTokenSender;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.token.TokenSenderConfig;
import com.ibm.xml.soapsec.token.UTC;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UsernameTokenSender
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(UsernameTokenSender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    SenderConfig gconfig = null;
    TokenSenderConfig conf = null;

    public void init(Map map) throws Exception {
        this.gconfig = (SenderConfig)map.get(SenderConfig.class);
        this.conf = (TokenSenderConfig)map.get(TokenSenderConfig.class);
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + document + "," + element + "," + map + ")");
        }
        Request[] requestArray = RequestPool.get(map, TokenRequest.Username.class);
        for (int i = 0; i < requestArray.length; ++i) {
            this.insertToken(document, element, map, (TokenRequest.Username)requestArray[i]);
            RequestPool.remove(map, requestArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }

    private void insertToken(Document document, Element element, Map map, TokenRequest.Username username) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        String string = element.getPrefix();
        string = string == null || string.length() == 0 ? "" : string + ":";
        String string2 = Constants.getWSSENS(map);
        String string3 = Constants.getWSUNS(map);
        Element element2 = document.createElementNS(string2, string + "UsernameToken");
        if (username.getSignature() || this.conf.isConfidential()) {
            object3 = IdUtil.getInstance().makeUniqueId(document, "usernametoken_");
            BinaryTokenSender.addIdAttribute(element2, (String)object3, string2, string3);
            if (username.getSignature()) {
                RequestPool.add(map, new SignatureRequest((String)object3));
            }
            if (this.conf.isConfidential()) {
                RequestPool.add(map, new EncryptionRequest((String)object3, false, this.conf.getEncryptionSettings()));
            }
        }
        Element element3 = document.createElementNS(string2, string + "Username");
        if (username.getName() == null) {
            Tr.error(tc, "security.wssecurity.WSEC5199E");
            throw SoapSecurityException.format("security.wssecurity.WSEC5199E");
        }
        element3.appendChild(document.createTextNode(username.getName()));
        element2.appendChild(element3);
        if (username.getPassword() != null) {
            Element element4 = document.createElementNS(string2, string + "Password");
            element4.appendChild(document.createTextNode(username.getPassword()));
            element2.appendChild(element4);
        }
        if (username.isNonceAdded()) {
            object3 = this.conf.getNonceManager();
            if (object3 == null) {
                Tr.error(tc, "security.wssecurity.UsernameToken.token56");
                throw SoapSecurityException.format("security.wssecurity.UsernameToken.token56");
            }
            object2 = object3.generate();
            object = document.createElementNS(string2, string + "Nonce");
            QName qName = username.getEncodingType();
            String string4 = null;
            if (qName == null || NamespaceUtil.equals(qName, Constants.getQName(string2, "Base64Binary"))) {
                string4 = Base64.encode((byte[])object2);
            } else if (NamespaceUtil.equals(qName, Constants.getQName(string2, "HexBinary"))) {
                DOMUtil.setQNameAttr((Element)object, null, "EncodingType", qName);
                string4 = Hex.encode((byte[])object2);
            } else {
                Tr.error(tc, "security.wssecurity.UsernameToken.token55", qName.toString());
                throw SoapSecurityException.format("security.wssecurity.UsernameToken.token55", qName.toString());
            }
            object.appendChild(document.createTextNode(string4));
            element2.appendChild((Node)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce is enabled and added");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce is disabled and not added");
        }
        if (username.isTimestampAdded()) {
            object3 = new Date();
            object2 = null;
            if (DOMUtil.hasNamespaceDeclaration(element2, string3)) {
                object = DOMUtil.getNamespacePrefix(element2, string3);
                object2 = document.createElementNS(string3, (String)object + ":Created");
            } else {
                object2 = document.createElementNS(string3, "Created");
                object2.setAttributeNS(Constants.NS_XMLNS, "xmlns", string3);
            }
            object = UTC.format((Date)object3);
            object2.appendChild(document.createTextNode((String)object));
            element2.appendChild((Node)object2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce timestamp is enabled, timestamp = " + (String)object + " is added");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce timestamp is disabled and not added");
        }
        element.insertBefore(element2, element.getFirstChild());
        if (this.gconfig.doIndentation()) {
            DOMUtil.indent(element2, 6, 2);
            element.insertBefore(document.createTextNode("\n      "), element2);
        }
    }
}

