/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;

public class CertificateUtil {
    private static final TraceComponent tc = Tr.register(CertificateUtil.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CertificateUtil.class.getName();
    public static final int ENCIPHERMENT = 0;
    public static final int SIGNATURE = 1;
    private static final String[] KEY_USAGE = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};

    public static boolean isUsedFor(Certificate certificate, int n) {
        boolean[] blArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsedFor(" + certificate + ", " + n + ")");
        }
        boolean bl = true;
        if (certificate != null && "X.509".equals(certificate.getType()) && (blArray = ((X509Certificate)certificate).getKeyUsage()) != null) {
            switch (n) {
                case 0: {
                    bl = blArray.length > 3 && blArray[2] && blArray[3];
                    break;
                }
                case 1: {
                    bl = blArray.length > 0 && blArray[0];
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown usage type: " + n);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsedFor(Certificate cert, int type) returns " + bl);
        }
        return bl;
    }

    public static String keyUsageToString(Certificate certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyUsageToString(" + certificate + ")");
        }
        String string = null;
        if (certificate != null && "X.509".equals(certificate.getType())) {
            string = CertificateUtil.keyUsageToString(((X509Certificate)certificate).getKeyUsage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyUsageToString(Certificate cert) returns " + string);
        }
        return string;
    }

    public static String keyUsageToString(boolean[] blArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyUsageToString(" + blArray + ")");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < KEY_USAGE.length && i < blArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(KEY_USAGE[i]);
            stringBuffer.append('=');
            stringBuffer.append(blArray[i]);
        }
        stringBuffer.append('}');
        String string = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyUsageToString(boolean[] usage) returns " + string);
        }
        return string;
    }

    public static X509DataUtil[] getX509Data(Element element) throws XSignatureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509Data(" + element + ")");
        }
        X509DataUtil[] x509DataUtilArray = null;
        try {
            KeyInfo keyInfo = CertificateUtil.getKeyInfo(element);
            KeyInfo.X509Data[] x509DataArray = keyInfo.getX509Data();
            if (x509DataArray == null || x509DataArray.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            Key key = keyInfo.getKeyValue();
            x509DataUtilArray = new X509DataUtil[x509DataArray.length];
            for (int i = 0; i < x509DataArray.length; ++i) {
                x509DataUtilArray[i] = new X509DataUtil(x509DataArray[i], key);
            }
        }
        catch (SignatureStructureException signatureStructureException) {
            throw new XSignatureException(signatureStructureException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509Data(Element signature) returns " + x509DataUtilArray);
        }
        return x509DataUtilArray;
    }

    private static KeyInfo getKeyInfo(Element element) throws SignatureStructureException, XSignatureException {
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfo(" + element + ")");
        }
        if ((element2 = KeyInfo.searchForKeyInfo(element)) == null) {
            throw new SignatureStructureException("No KeyInfo element.");
        }
        KeyInfo keyInfo = new KeyInfo(element2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfo(Element signature) returns " + keyInfo);
        }
        return keyInfo;
    }

    public static X509Certificate generateX509Certificate(byte[] byArray, Provider provider) throws CertificateException, NoSuchProviderException {
        return (X509Certificate)CertificateUtil.generateCertificate(byArray, "X.509", provider);
    }

    public static Certificate generateCertificate(byte[] byArray, String string, Provider provider) throws CertificateException, NoSuchProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateX509Certificate(byte[] binary[" + byArray + "]," + "String type[" + string + "]," + "Provider provider[" + provider + "])");
        }
        Certificate certificate = null;
        if (byArray != null && string != null) {
            CertificateFactory certificateFactory = provider == null ? CertificateFactory.getInstance(string) : CertificateFactory.getInstance(string, provider);
            certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateX509Certificate(byte[] binary,String type,Provider provider) returns Certificate[" + certificate + "]");
        }
        return certificate;
    }

    public static byte[] encodePkiPath(Provider provider, List list, KeyStore keyStore, String string) throws CertificateException, KeyStoreException {
        CertPath certPath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encodePkiPath(Provider provider[" + provider + "]," + "List certStores[" + list + "]," + "KeyStore kstore[" + keyStore + "]," + "String alias[" + string + "])");
        }
        byte[] byArray = null;
        if (keyStore != null && string != null && (certPath = CertificateUtil.getCertPath(keyStore, string, provider)) != null) {
            byArray = certPath.getEncoded("PkiPath");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encodePkiPath(Provider provider,CertStores certStores,KeyStore kstore,String alias) returns byte[][" + byArray + "]");
        }
        return byArray;
    }

    public static byte[] encodePKCS7(Provider provider, List list, KeyStore keyStore, String string) throws CertStoreException, KeyStoreException, IOException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encodePKCS7(Provider provider[" + provider + "]," + "List certStores[" + list + "]," + "KeyStore kstore[" + keyStore + "]," + "String alias[" + string + "])");
        }
        byte[] byArray = null;
        if (keyStore != null && string != null) {
            CRL[] cRLArray = CertificateUtil.extractCRLs(list);
            if (tc.isDebugEnabled()) {
                CertificateUtil.listCrlContents((X509CRL[])cRLArray);
            }
            Content content = CertificateUtil.getSignedData(keyStore, string, cRLArray);
            byArray = CertificateUtil.getBinaryEncodedContent(content);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encodePKCS7(Provider provider,List certStores,KeyStore kstore,String alias) returns byte[][" + byArray + "]");
        }
        return byArray;
    }

    private static X509CRL[] extractCRLs(List list) throws CertStoreException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractCRLs(List certStores[" + list + "])");
        }
        ArrayList<? extends CRL> arrayList = new ArrayList<CRL>();
        if (list != null && !list.isEmpty()) {
            object = list.iterator();
            while (object.hasNext()) {
                CertStore certStore = (CertStore)object.next();
                X509CRLSelector x509CRLSelector = new X509CRLSelector();
                Collection<? extends CRL> collection = null;
                collection = certStore.getCRLs(x509CRLSelector);
                if (collection == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, collection.size() + " CRLs found in the cert store[" + certStore + "].");
                }
                arrayList.addAll(collection);
            }
        }
        object = new X509CRL[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (X509CRL)arrayList.get(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractCRLs(List certStores) returns CRL[] " + object);
        }
        return object;
    }

    public static void listCrlContents(Collection collection) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = null;
            object = collection == null ? "null" : (collection.isEmpty() ? "empty" : "populated");
            Tr.entry(tc, "listCrlContents(Collection crlList [" + (String)object + "])");
        }
        if (tc.isDebugEnabled() && collection != null && !collection.isEmpty()) {
            object = collection.iterator();
            while (object.hasNext()) {
                X509CRL x509CRL = (X509CRL)object.next();
                CertificateUtil.listCrlContents(x509CRL);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCrlContents(Collection)");
        }
    }

    public static void listCrlContents(X509CRL x509CRL) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCrlContents(X509CRL crl [" + (x509CRL == null ? "null" : "not null") + "])");
        }
        if (tc.isDebugEnabled() && x509CRL != null) {
            try {
                Tr.debug(tc, "Issuer: " + x509CRL.getIssuerDN().getName());
                Tr.debug(tc, "Revoked certificates:");
                Set<? extends X509CRLEntry> set = x509CRL.getRevokedCertificates();
                if (set == null) {
                    Tr.debug(tc, "  None");
                } else {
                    Iterator<? extends X509CRLEntry> iterator = set.iterator();
                    while (iterator.hasNext()) {
                        X509CRLEntry x509CRLEntry = iterator.next();
                        if (x509CRLEntry == null) continue;
                        Tr.debug(tc, " " + x509CRLEntry.getSerialNumber().toString(10) + "=0x" + x509CRLEntry.getSerialNumber().toString(16));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCrlContents(X509CRL)");
        }
    }

    public static void listCrlContents(X509CRL[] x509CRLArray) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = null;
            object = x509CRLArray == null ? "null" : (x509CRLArray.length == 0 ? "empty" : "populated");
            Tr.entry(tc, "listCrlContents(X509CRL[] crls [" + (String)object + "])");
        }
        if (tc.isDebugEnabled() && x509CRLArray != null) {
            object = null;
            for (int i = 0; i < x509CRLArray.length; ++i) {
                object = x509CRLArray[i];
                CertificateUtil.listCrlContents((X509CRL)object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCrlContents(X509CRL[])");
        }
    }

    public static void listCertContents(Collection collection) {
        if (tc.isDebugEnabled() && collection != null && !collection.isEmpty()) {
            Object object;
            if (tc.isEntryEnabled()) {
                object = null;
                object = collection == null ? "null" : (collection.isEmpty() ? "empty" : "populated");
                Tr.entry(tc, "listCertContents(Collection certList [" + (String)object + "])");
            }
            object = collection.iterator();
            while (object.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)object.next();
                Tr.debug(tc, "Subject: " + x509Certificate.getSubjectX500Principal().getName() + " SN: " + x509Certificate.getSerialNumber().toString(10) + "=0x" + x509Certificate.getSerialNumber().toString(16));
                Tr.debug(tc, x509Certificate.toString());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listCertContents(Collection)");
            }
        }
    }

    public static void listCertData(PKIXParameters pKIXParameters) {
        if (tc.isDebugEnabled() && pKIXParameters != null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listCertData(PKIXParameters pkixParams [" + (pKIXParameters == null ? "null" : "not null") + "])");
            }
            try {
                int n = 1;
                List<CertStore> list = pKIXParameters.getCertStores();
                if (list == null) {
                    Tr.debug(tc, "  None");
                } else {
                    X509CRLSelector x509CRLSelector = new X509CRLSelector();
                    X509CertSelector x509CertSelector = new X509CertSelector();
                    Iterator<CertStore> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Tr.debug(tc, "  CertStore #" + n++);
                        CertStore certStore = iterator.next();
                        Collection<? extends CRL> collection = certStore.getCRLs(x509CRLSelector);
                        CertificateUtil.listCrlContents(collection);
                        Collection<? extends Certificate> collection2 = certStore.getCertificates(x509CertSelector);
                        CertificateUtil.listCertContents(collection2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listCertData");
            }
        }
    }

    private static Content getSignedData(KeyStore keyStore, String string, CRL[] cRLArray) throws KeyStoreException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignedData(KeyStore ks[" + keyStore + "], " + "String alias[" + string + "], " + "CRL[] crls[" + cRLArray + "])");
        }
        SignedData signedData = null;
        Certificate[] certificateArray = keyStore.getCertificateChain(string);
        if (certificateArray != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, certificateArray.length + " certificates found");
            }
            signedData = new SignedData(certificateArray, cRLArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignedData(KeyStore ks, String alias, CRL[] crls,  returns SignedData[" + signedData + "]");
        }
        return signedData;
    }

    private static byte[] getBinaryEncodedContent(Content content) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBinaryEncodedContent(Content data[" + content + "])");
        }
        byte[] byArray = null;
        ContentInfo contentInfo = new ContentInfo(content);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        contentInfo.encode((OutputStream)byteArrayOutputStream);
        byArray = byteArrayOutputStream.toByteArray();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBinaryEncodedContent(Content data) returns byte[] " + byArray);
        }
        return byArray;
    }

    private static CertPath getCertPath(KeyStore keyStore, String string, Provider provider) throws KeyStoreException, CertificateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertPath(KeyStore ks[" + keyStore + "], " + "String alias[" + string + "], " + "Provider provider[" + provider + "])");
        }
        CertPath certPath = null;
        Certificate[] certificateArray = keyStore.getCertificateChain(string);
        final Vector<Certificate> vector = new Vector<Certificate>();
        if (certificateArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Acquired certificate chain is null.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, certificateArray.length + " certificates found");
            }
            for (int i = 0; i < certificateArray.length; ++i) {
                vector.add(certificateArray[i]);
            }
            final CertificateFactory certificateFactory = provider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
            try {
                certPath = (CertPath)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws CertificateException {
                        CertPath certPath = certificateFactory.generateCertPath(vector);
                        return certPath;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof CertificateException) {
                    throw (CertificateException)throwable;
                }
                throw new CertificateException(throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertPath(KeyStore ks, String alias,Provider provider) returns CertPath[" + certPath + "]");
        }
        return certPath;
    }

    public static CertPath generateCertPath(byte[] byArray, String string, String string2, Provider provider) throws CertificateException, NoSuchProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateCertPath(byte[] binary[" + byArray + "]," + "String factoryType[" + string + "]," + "String encodingType[" + string2 + "]," + "Provider provider[" + provider + "])");
        }
        CertPath certPath = null;
        if (byArray != null && string != null && string2 != null) {
            CertificateFactory certificateFactory = provider == null ? CertificateFactory.getInstance(string) : CertificateFactory.getInstance(string, provider);
            certPath = certificateFactory.generateCertPath(new ByteArrayInputStream(byArray), string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateCertPath(byte[] binary,String factoryType,String encoingType,Provider provider) returns CertPath[" + certPath + "]");
        }
        return certPath;
    }

    public static Collection generateCRLs(byte[] byArray, String string, Provider provider) throws CertificateException, CRLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateCRLs(byte[] binary[" + byArray + "]," + "String factoryType[" + string + "]," + "Provider provider[" + provider + "])");
        }
        Collection<? extends CRL> collection = null;
        if (byArray != null && string != null) {
            CertificateFactory certificateFactory = provider == null ? CertificateFactory.getInstance(string) : CertificateFactory.getInstance(string, provider);
            collection = certificateFactory.generateCRLs(new ByteArrayInputStream(byArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateCRLs(byte[] binary,String factoryType,Provider provider) returns Collection[" + collection + "]");
        }
        return collection;
    }

    public static PKIXCertPathValidatorResult validateX509Certificate(X509Certificate x509Certificate, Provider provider, PKIXParameters pKIXParameters) throws CertPathBuilderException, CertPathValidatorException, CertStoreException, KeyStoreException, InvalidAlgorithmParameterException, IOException, NoSuchAlgorithmException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateX509Certificate(X509Certificate cert[" + x509Certificate + "], " + "Provider provider[" + provider + "]," + "PKIXParameters params[" + pKIXParameters + "])");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
        if (x509Certificate != null && pKIXParameters != null) {
            boolean bl = false;
            Set<TrustAnchor> set = pKIXParameters.getTrustAnchors();
            if (set != null && set.size() > 0) {
                Iterator<TrustAnchor> iterator = set.iterator();
                while (iterator.hasNext()) {
                    TrustAnchor trustAnchor = iterator.next();
                    X509Certificate x509Certificate2 = trustAnchor.getTrustedCert();
                    if (!x509Certificate.equals(x509Certificate2)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl && (certPathBuilderResult = CertificateUtil.buildCertPath(x509Certificate, null, pKIXParameters, provider, false)) != null) {
                pKIXCertPathValidatorResult = CertificateUtil.validateCertPath(certPathBuilderResult.getCertPath(), pKIXParameters);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateX509Certificate(X509Certificate cert, Provider provider,PKIXParameters params) returns PKIXCertPathValidatorResult[" + pKIXCertPathValidatorResult + "]");
        }
        return pKIXCertPathValidatorResult;
    }

    public static PKIXCertPathValidatorResult validateCertPath(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateCertPath(CertPath path[" + certPath + "]," + "PKIXParameters params[" + pKIXParameters + "])");
        }
        PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
        if (certPath != null && pKIXParameters == null) {
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, pKIXParameters);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateCertPath(CertPath path,PKIXParameters params) returns PKIXCertPathValidatorResult[" + pKIXCertPathValidatorResult + "]");
        }
        return pKIXCertPathValidatorResult;
    }

    public static BigInteger convertSerialNumber(String string) throws ParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertSerialNumber(String data[" + string + "])");
        }
        BigInteger bigInteger = null;
        if (string != null) {
            long l = 0L;
            for (int i = 0; i < string.length(); ++i) {
                l <<= 4;
                char c = string.charAt(i);
                if ('0' <= c && c <= '9') {
                    l += (long)(c - 48);
                    continue;
                }
                if ('a' <= c && c <= 'f') {
                    l += (long)(c + 10 - 97);
                    continue;
                }
                if ('A' <= c && c <= 'F') {
                    l += (long)(c + 10 - 65);
                    continue;
                }
                throw new ParseException("Illegal character: " + c, i);
            }
            bigInteger = BigInteger.valueOf(l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertSerialNumber(String data) returns BigInteger[" + bigInteger + "]");
        }
        return bigInteger;
    }

    public static CertPathBuilderResult buildCertPath(X509Certificate x509Certificate, CertPath certPath, PKIXParameters pKIXParameters, Provider provider, boolean bl) throws CertPathBuilderException, CertPathValidatorException, CertStoreException, KeyStoreException, InvalidAlgorithmParameterException, IOException, NoSuchAlgorithmException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildCertPath(cert, path, pkixParams, provider)");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cert [" + (x509Certificate == null ? "null" : "not null") + "]," + " path [" + (certPath == null ? "null" : "not null") + "]," + " pkixParams [" + (pKIXParameters == null ? "null" : "not null") + "]," + " isPkcs7 [" + bl + "]");
        }
        CertPathBuilder certPathBuilder = null;
        certPathBuilder = provider == null ? CertPathBuilder.getInstance("PKIX") : CertPathBuilder.getInstance("PKIX", provider);
        X509CertSelector x509CertSelector = (X509CertSelector)pKIXParameters.getTargetCertConstraints();
        x509CertSelector.setSubject(x509Certificate.getSubjectX500Principal().getEncoded());
        pKIXParameters.setTargetCertConstraints(x509CertSelector);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CertPathProvider = " + (provider == null ? "default" : provider.getName()));
            Tr.debug(tc, "CertPath Builder = " + certPathBuilder.getClass().getName());
            Tr.debug(tc, "CertPath Selector = " + x509CertSelector.getClass().getName());
            Tr.debug(tc, "SubjectDN = " + x509Certificate.getSubjectX500Principal().getName());
        }
        HashSet<Object> hashSet = null;
        if (certPath != null) {
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding all certs in the path to pkixParams");
                }
                hashSet = new HashSet<Certificate>(certPath.getCertificates());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Certificates in path:");
                    CertificateUtil.listCertContents(hashSet);
                }
                if (!hashSet.contains(x509Certificate)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding primary cert to pkixParams");
                    }
                    hashSet.add(x509Certificate);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certs already populated in pkixParams");
            }
        } else {
            hashSet = new HashSet<X509Certificate>();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding single cert to pkixParams");
            }
            hashSet.add(x509Certificate);
        }
        if (hashSet != null) {
            object = provider == null ? CertStore.getInstance("Collection", new CollectionCertStoreParameters(hashSet)) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(hashSet), provider);
            pKIXParameters.addCertStore((CertStore)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Final pkixParams before build: [" + pKIXParameters + "]");
            Tr.debug(tc, "Certificate data in final pkixParams:");
            CertificateUtil.listCertData(pKIXParameters);
        }
        object = null;
        if (certPathBuilder != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Building the cert path...");
            }
            object = certPathBuilder.build(pKIXParameters);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CertPathBuilderResult=" + object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildCertPath");
        }
        return object;
    }

    public static String buildCertIndex(String string, TokenConsumerConfig tokenConsumerConfig) {
        Integer n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildCertIndex(encoded[" + (string == null ? "null" : "non-null") + "]" + ", config[" + (tokenConsumerConfig == null ? "null" : "non-null"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Building certificate cache index.");
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (tokenConsumerConfig != null) {
            n = new Integer(tokenConsumerConfig.hashCode());
            string2 = n.toString();
        }
        if (string != null) {
            n = new Integer(string.hashCode());
            string4 = n.toString();
        }
        string3 = string4 + string2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Hash code of the config object = " + string2);
            if (string4 != null) {
                Tr.debug(tc, "Hash code of encoded cert string = " + string4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildCertIndex() returns x509CertIndex = " + string3);
        }
        return string3;
    }

    public static class X509DataUtil {
        KeyInfo.X509Data x5data;
        CertStore docStore = null;
        Key publicKey;

        public X509DataUtil(KeyInfo.X509Data x509Data, Key key) {
            this.x5data = x509Data;
            this.publicKey = key;
        }

        private CertStore createCertStore() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCertStore()");
            }
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            X509Certificate[] x509CertificateArray = this.x5data.getCertificates();
            if (x509CertificateArray != null) {
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    vector.addElement(x509CertificateArray[i]);
                }
            }
            CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(vector));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createCertStore() returns " + certStore);
            }
            return certStore;
        }

        public Key validate(PKIXBuilderParameters pKIXBuilderParameters) throws XSignatureException {
            return this.validateAndGetCert(pKIXBuilderParameters).getPublicKey();
        }

        public X509Certificate validateAndGetCert(PKIXBuilderParameters pKIXBuilderParameters) throws XSignatureException {
            CertPath certPath;
            CertPathValidator certPathValidator;
            Object object;
            List<CertStore> list;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateAndGetCert(" + pKIXBuilderParameters + ")");
            }
            ArrayList<CertStore> arrayList = new ArrayList<CertStore>(((list = pKIXBuilderParameters.getCertStores()) == null ? 0 : list.size()) + 1);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
            try {
                arrayList.add(this.createCertStore());
                pKIXBuilderParameters.setCertStores(arrayList);
                object = CertPathBuilder.getInstance("PKIX");
                certPathValidator = CertPathValidator.getInstance("PKIX");
                certPath = ((CertPathBuilder)object).build(pKIXBuilderParameters).getCertPath();
                certPathValidator.validate(certPath, pKIXBuilderParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(invalidAlgorithmParameterException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(noSuchAlgorithmException);
            }
            catch (CertPathBuilderException certPathBuilderException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(certPathBuilderException);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(certPathValidatorException);
            }
            object = certPath.getCertificates();
            CertPathValidator certPathValidator2 = certPathValidator = object.isEmpty() ? null : (X509Certificate)object.get(0);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateAndGetCert(PKIXBuilderParameters params) returns " + certPathValidator);
            }
            return certPathValidator;
        }

        public X509CertSelector createSelector() throws IOException {
            X509Certificate[] x509CertificateArray;
            Object[] objectArray;
            Object[] objectArray2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSelector()");
            }
            X509CertSelector x509CertSelector = new X509CertSelector();
            String[] stringArray = this.x5data.getIssuerNames();
            if (stringArray != null && stringArray.length > 0) {
                objectArray2 = this.x5data.getSerialNumbers();
                x509CertSelector.setIssuer(stringArray[0]);
                x509CertSelector.setSerialNumber((BigInteger)objectArray2[0]);
            }
            if ((objectArray2 = this.x5data.getSubjectNames()) != null && objectArray2.length > 0) {
                x509CertSelector.setSubject((String)objectArray2[0]);
            } else {
                objectArray = this.x5data.getCertificates();
                if (objectArray != null && objectArray.length > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CertPath Selector = " + x509CertSelector.getClass().getName());
                        Tr.debug(tc, "SubjectDN = " + ((X509Certificate)objectArray[0]).getSubjectX500Principal().getName());
                    }
                    x509CertSelector.setSubject(((X509Certificate)objectArray[0]).getSubjectX500Principal().getEncoded());
                }
            }
            objectArray = this.x5data.getSKIs();
            if (objectArray != null && objectArray.length > 0) {
                x509CertSelector.setSubjectKeyIdentifier((byte[])objectArray[0]);
            }
            if ((x509CertificateArray = this.x5data.getCertificates()) != null && x509CertificateArray.length == 1) {
                x509CertSelector.setCertificate(x509CertificateArray[0]);
            }
            if (this.publicKey != null) {
                x509CertSelector.setSubjectPublicKey(this.publicKey.getEncoded());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSelector() returns " + x509CertSelector);
            }
            return x509CertSelector;
        }
    }
}

