/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Initializable;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigUtil {
    private static final String clsName = ConfigUtil.class.getName();
    private static final String comp = "security.wssecurity";
    private static final TraceComponent tc = Tr.register(ConfigUtil.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true", "1"};
    private static final String[] FALSE_VALUES = new String[]{"no", "off", "false", "0"};
    private static final PrivilegedAction contextLoaderGetter = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final PrivilegedAction thisClassLoaderGetter = new PrivilegedAction(){

        public Object run() {
            return this.getClass().getClassLoader();
        }
    };
    private static final String[] USAGE_VALUES = new String[]{"required", "optional", "rejected", "observed", "ignored"};
    private static final String[] KEYINFO_TYPES = new String[]{"STRREF", "EMB", "KEYID", "KEYNAME", "X509ISSUER"};
    private static final Set C14N_TRANSFORMS = new HashSet();
    private static final Set DOMREQUIRED_TRANSFORMS;
    private static final Set SECRETKEY_ALGORITHMS;
    static /* synthetic */ Class class$com$ibm$xml$soapsec$util$ConfigUtil$_MessageCatalog;

    public static boolean isTrue(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTrue(String flag[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < TRUE_VALUES.length; ++i) {
                if (!TRUE_VALUES[i].equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrue(String flag) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isFalse(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFalse(String flag[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < FALSE_VALUES.length; ++i) {
                if (!FALSE_VALUES[i].equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFalse returns [" + bl + "]");
        }
        return bl;
    }

    public static boolean hasValue(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean getIsTrueProperty(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsTrueProperty(_map, " + string + ")");
        }
        String string2 = (String)map.get(string);
        boolean bl = false;
        if (ConfigUtil.hasValue(string2) && ConfigUtil.isTrue(string2)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsTrueProperty returns [" + bl + "]");
        }
        return bl;
    }

    public static boolean getIsTruePropertyEnv(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsTruePropertyEnv(_map, " + string + ")");
        }
        boolean bl = false;
        String string2 = ConfigUtil.getPropertyEnv(map, string);
        if (ConfigUtil.hasValue(string2) && ConfigUtil.isTrue(string2)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsTruePropertyEnv returns [" + bl + "]");
        }
        return bl;
    }

    public static boolean getIsFalseProperty(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsFalseProperty(_map, " + string + ")");
        }
        String string2 = (String)map.get(string);
        boolean bl = true;
        if (ConfigUtil.hasValue(string2) && ConfigUtil.isFalse(string2)) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsFalseProperty returns [" + bl + "]");
        }
        return bl;
    }

    public static String getPropertyEnv(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyEnv(_map, " + string + ")");
        }
        String string2 = null;
        if (map != null && string != null && string.length() != 0 && !ConfigUtil.hasValue(string2 = (String)map.get(string)) && ConfigUtil.hasValue(string2 = System.getProperty(string)) && tc.isDebugEnabled()) {
            Tr.exit(tc, string + "=" + string2 + " in the JVM.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyEnv returns [" + string2 + "]");
        }
        return string2;
    }

    public static boolean isValidWSKeyStore(String string) {
        return KeyStoreManager.getInstance().getKeyStore(string) != null;
    }

    public static boolean isHWKeyStore(String string) {
        return KeyStoreManager.getInstance().isHWKeyStore(string);
    }

    public static Provider getHWCryptoProviderInstance(String string) {
        return KeyStoreManager.getInstance().getHWCryptoProviderInstance(string);
    }

    public static void returnHWCryptoProviderInstance(String string, Provider provider) {
        KeyStoreManager.getInstance().returnHWCryptoProviderInstance(string, provider);
    }

    public static String getHWKeyStorePassword(String string) {
        String string2 = null;
        WSKeyStore wSKeyStore = KeyStoreManager.getInstance().getKeyStore(string);
        if (wSKeyStore != null) {
            string2 = wSKeyStore.getProperty("com.ibm.ssl.keyStorePassword");
        }
        return string2;
    }

    public static KeyStore getHWKeyStore(String string) {
        KeyStore keyStore = null;
        WSKeyStore wSKeyStore = KeyStoreManager.getInstance().getKeyStore(string);
        if (wSKeyStore != null) {
            try {
                keyStore = wSKeyStore.getKeyStore(false, false);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot get the HW KeyStore referenced by :" + string);
                }
                Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{string});
            }
            if (keyStore == null) {
                Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{string});
            }
        } else {
            Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{string});
        }
        return keyStore;
    }

    public static File fixPath(String string, String string2) {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixPath(String path[" + string + "]," + "String base[" + string2 + "])");
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = string2 != null ? new File(string2, string) : new File(file.getAbsolutePath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixPath(String path,String base) returns File[" + file + "]");
        }
        return file;
    }

    public static String fixKeystorePath(String string, String string2) {
        CharSequence charSequence;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixKeystorePath", "String path[" + string + "]," + "String base[" + string2 + "]");
        }
        String string3 = null;
        String string4 = string;
        String string5 = string2;
        if (string2 != null) {
            try {
                serializable = new URL(string2);
                charSequence = new StringBuffer(string2);
                if (string2.charAt(string2.length() - 1) != '/') {
                    ((StringBuffer)charSequence).append("/");
                }
                ((StringBuffer)charSequence).append(string);
                string4 = ((StringBuffer)charSequence).toString();
                string5 = null;
                Tr.debug(tc, "base is a URL, concat path=" + string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string5 == null) {
            try {
                String string6;
                serializable = new URL(string4);
                charSequence = "";
                if (string2 == null) {
                    charSequence = "path is a ";
                }
                if ((string6 = ((URL)serializable).getProtocol()).equalsIgnoreCase("file")) {
                    string4 = ((URL)serializable).getPath();
                    Tr.debug(tc, (String)charSequence + "file URL, extracting file portion: " + string4);
                } else {
                    Tr.debug(tc, (String)charSequence + "normal URL, returning unchanged");
                    string3 = string4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string3 == null) {
            try {
                serializable = null;
                serializable = string2 != null ? new File(string2, string) : new File(string4);
                string3 = ((File)serializable).getAbsolutePath();
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception caught while creating a File object from " + string4 + ": " + exception);
                Tr.debug(tc, "Returning unchanged.");
                string3 = string4;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixKeystorePath returns [" + string3 + "]");
        }
        return string3;
    }

    public static KeyStore getKeyStore(String string) throws SoapSecurityException {
        Tr.entry(tc, "getKeyStore(String keyStoreRef[" + string + "])");
        if (string == null || string.length() == 0) {
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s08", string);
        }
        KeyStore keyStore = ConfigUtil.createKeyStore(null, null, null, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore(String keyStoreRef)");
        }
        return keyStore;
    }

    public static KeyStore getKeyStore(String string, String string2, char[] cArray) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = cArray == null ? "null" : "not null";
            Tr.entry(tc, "getKeyStore(String type[" + string + "]," + "String path[" + string2 + "]," + "char[] storepass[" + (String)object + "])");
        }
        if (cArray == null || cArray.length == 0) {
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s03", string2);
        }
        object = ConfigUtil.createKeyStore(string, string2, cArray, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore(String type,String path,char[] storepass)");
        }
        return object;
    }

    private static KeyStore createKeyStore(final String string, final String string2, final char[] cArray, String string3) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = cArray == null ? "null" : "not null";
            Tr.entry(tc, "createKeyStore(String type[" + string + "]," + "String path[" + string2 + "]," + "char[] storepass[" + (String)object + "]," + "KeyStore Reference[" + string3 + "])");
        }
        object = null;
        try {
            if (string3 != null && string3.length() != 0) {
                WSKeyStore wSKeyStore = KeyStoreManager.getInstance().getKeyStore(string3);
                if (wSKeyStore != null) {
                    object = wSKeyStore.getKeyStore(false, false);
                    if (object == null) {
                        Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{string3});
                    }
                } else {
                    Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{string3});
                }
            } else {
                object = (KeyStore)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws SoapSecurityException {
                        String string3 = ConfigUtil.fixKeystorePath(string2, null);
                        KeyStore keyStore = null;
                        InputStream inputStream = null;
                        try {
                            keyStore = KeyStore.getInstance(string);
                            inputStream = ConfigUtil.openKeyStore(string3);
                            keyStore.load(inputStream, cArray);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Tr.processException(fileNotFoundException, clsName + ".createKeyStore", "199");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s04", new Object[]{string3});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s04", string3);
                        }
                        catch (IOException iOException) {
                            Tr.processException(iOException, clsName + ".createKeyStore", "205");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s05", new Object[]{string3});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s05", string3);
                        }
                        catch (CertificateException certificateException) {
                            Tr.processException(certificateException, clsName + ".createKeyStore", "211");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{string3, certificateException.getClass().getName(), certificateException.getMessage()});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s06", string3, certificateException.getClass().getName(), certificateException.getMessage(), certificateException);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            Tr.processException(noSuchAlgorithmException, clsName + ".createKeyStore", "219");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{string3, noSuchAlgorithmException.getClass().getName(), noSuchAlgorithmException.getMessage()});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s06", string3, noSuchAlgorithmException.getClass().getName(), noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
                        }
                        catch (KeyStoreException keyStoreException) {
                            Tr.processException(keyStoreException, clsName + ".createKeyStore", "227");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{string3, keyStoreException.getClass().getName(), keyStoreException.getMessage()});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s06", string3, keyStoreException.getClass().getName(), keyStoreException.getMessage(), keyStoreException);
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            Tr.processException(unsatisfiedLinkError, clsName + ".createKeyStore", "235");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{string3, unsatisfiedLinkError.getClass().getName(), unsatisfiedLinkError.getMessage()});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s06", string3, unsatisfiedLinkError.getClass().getName(), unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        return keyStore;
                    }
                });
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            Tr.processException(throwable, clsName + ".createKeyStore", "244");
            if (throwable instanceof SoapSecurityException) {
                throw (SoapSecurityException)throwable;
            }
            throw new SoapSecurityException(throwable);
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".createKeyStore", "252");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{string3, exception});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s28", string3, (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyStore(String type,String path,char[] storepass) returns KeyStore[" + object + "]");
        }
        return object;
    }

    public static InputStream openUrlOrFile(String string) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openUrlOrFile", string);
        }
        InputStream inputStream = null;
        URL uRL = null;
        File file = new File(string);
        if (file.exists() && file.length() == 0L) {
            throw new IOException("File exists, but is empty: " + string);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Opening as a URL");
            }
            uRL = new URL(string);
            inputStream = uRL.openStream();
        }
        catch (MalformedURLException malformedURLException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Opening as a File");
            }
            inputStream = new FileInputStream(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openUrlOrFile");
        }
        return inputStream;
    }

    public static InputStream openKeyStore(String string) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openKeyStore", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling openUrlOrFile(" + string + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openKeyStore");
        }
        return ConfigUtil.openUrlOrFile(string);
    }

    public static Key getKey(KeyStore keyStore, String string, char[] cArray) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = cArray == null ? "null" : "not null";
            Tr.entry(tc, "getKey(KeyStore keyStore,String alias[" + string + "]," + "char[] keypass[" + (String)object + "])");
        }
        object = null;
        try {
            object = keyStore.getKey(string, cArray);
        }
        catch (KeyStoreException keyStoreException) {
            Tr.processException(keyStoreException, clsName + ".getKey", "276");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s07", new Object[]{string, keyStore.toString(), keyStoreException.getClass().getName(), keyStoreException.getMessage(), keyStoreException});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s07", string, keyStore.toString(), keyStoreException.getClass().getName(), keyStoreException.getMessage(), keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Tr.processException(noSuchAlgorithmException, clsName + ".getKey", "284");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s07", new Object[]{string, keyStore.toString(), noSuchAlgorithmException.getClass().getName(), noSuchAlgorithmException.getMessage(), noSuchAlgorithmException});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s07", string, keyStore.toString(), noSuchAlgorithmException.getClass().getName(), noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            Tr.processException(unrecoverableKeyException, clsName + ".getKey", "292");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s27", new Object[]{string, keyStore.toString(), unrecoverableKeyException.getClass().getName(), unrecoverableKeyException});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s27", string, keyStore.toString(), unrecoverableKeyException.getClass().getName(), unrecoverableKeyException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(KeyStore keyStore,String alias,char[] keypass) returns Key[" + object + "]");
        }
        return object;
    }

    public static Certificate getCertificate(KeyStore keyStore, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificate(KeyStore keyStore,String alias[" + string + "])");
        }
        Certificate certificate = null;
        try {
            certificate = keyStore.getCertificate(string);
        }
        catch (KeyStoreException keyStoreException) {
            Tr.processException(keyStoreException, clsName + ".getCertificate", "322");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s13", new Object[]{string, keyStore.toString(), keyStoreException.getClass().getName(), keyStoreException.getMessage(), keyStoreException});
            throw SoapSecurityException.format("security.wssecurity.FileConfigSSR.s13", string, keyStore.toString(), keyStoreException.getClass().getName(), keyStoreException.getMessage(), keyStoreException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificate(KeyStore keyStore,String alias) returns Certificate[" + certificate + "]");
        }
        return certificate;
    }

    public static X509Certificate getX509Certificate(File file, CertificateFactory certificateFactory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509Certificate(File path[" + file + "]," + "CertificateFactory certificateFactory[" + certificateFactory + "])");
        }
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(file));
        }
        catch (IOException iOException) {
            Tr.processException(iOException, clsName + ".getX509Certificate", "351");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s23", new Object[]{file.getAbsolutePath(), iOException});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s23", file.getAbsolutePath(), (Throwable)iOException);
        }
        catch (CertificateException certificateException) {
            Tr.processException(certificateException, clsName + ".getX509Certificate", "357");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s24", new Object[]{file.getAbsolutePath(), certificateException});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s24", file.getAbsolutePath(), (Throwable)certificateException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509Certificate(File path,CertificateFactory certificateFactory) returns X509Certificate[" + x509Certificate + "]");
        }
        return x509Certificate;
    }

    public static X509CRL getX509CRL(String string, CertificateFactory certificateFactory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509CRL(String path[" + string + "]," + "CertificateFactory certificateFactory[" + certificateFactory + "])");
        }
        X509CRL x509CRL = null;
        File file = new File(string);
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling fixKeystorePath to determine if the input is a file or a URL");
            }
            String string2 = ConfigUtil.fixKeystorePath(string, null);
            InputStream inputStream = ConfigUtil.openUrlOrFile(string2);
            x509CRL = (X509CRL)certificateFactory.generateCRL(inputStream);
        }
        catch (IOException iOException) {
            Tr.processException(iOException, clsName + ".getX509CRL", "384");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s25", new Object[]{file.getAbsolutePath(), iOException});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s25", file.getAbsolutePath(), (Throwable)iOException);
        }
        catch (CRLException cRLException) {
            Tr.processException(cRLException, clsName + ".getX509CRL", "390");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s26", new Object[]{file.getAbsolutePath(), cRLException});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s26", file.getAbsolutePath(), (Throwable)cRLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509CRL(String path,CertificateFactory certificateFactory) returns X509CRL[" + x509CRL + "]");
        }
        return x509CRL;
    }

    public static CertificateFactory createCertificateFactory(String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCertificateFactory(String provider[" + string + "])");
        }
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = string == null || "".equals(string) ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", string);
        }
        catch (CertificateException certificateException) {
            Tr.processException(certificateException, clsName + ".createCertificateFactory", "419");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s24", new Object[]{string, certificateException});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s24", string, (Throwable)certificateException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Tr.processException(noSuchProviderException, clsName + ".createCertificateFactory", "425");
            Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s22", new Object[]{string, noSuchProviderException});
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s22", string, (Throwable)noSuchProviderException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertificateFactory(String provider) returns CertificateFactory[" + certificateFactory + "]");
        }
        return certificateFactory;
    }

    public static Document mergeDocuments(Document[] documentArray) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeDocuments(Document[] docs[" + documentArray + "])");
        }
        Document document = DOMUtil.createDocument();
        Element element = document.createElement("root");
        document.appendChild(element);
        if (documentArray != null) {
            for (int i = 0; i < documentArray.length; ++i) {
                Element element2;
                if (documentArray[i] == null || (element2 = documentArray[i].getDocumentElement()) == null) continue;
                element.appendChild(document.importNode(element2, true));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeDocuments(Document[] docs) returns Document[" + document + "]");
        }
        return document;
    }

    public static Object instantiate(String string, Class clazz, ClassLoader classLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instantiate(String cls[" + string + "]," + "Class type[" + clazz + "]," + "ClassLoader acl)");
        }
        Object var3_3 = null;
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)thisClassLoaderGetter);
        }
        if (tc.isDebugEnabled()) {
            if (classLoader2 != null) {
                Tr.debug(tc, "Classloader: " + classLoader2.getClass().getName());
                Tr.debug(tc, "Classloader dump: " + classLoader2.toString());
            } else {
                Tr.debug(tc, "Classloader: <null>");
            }
        }
        try {
            Class<?> clazz2 = classLoader2 != null ? classLoader2.loadClass(string) : Class.forName(string);
            if (clazz != null && !clazz.isAssignableFrom(clazz2)) {
                throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", string, clazz.getName());
            }
            var3_3 = clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.processException(classNotFoundException, clsName + ".instantiate", "514");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s09", new Object[]{string});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s09", string);
        }
        catch (InstantiationException instantiationException) {
            Tr.processException(instantiationException, clsName + ".instantiate", "519");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{string});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s10", string);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.processException(illegalAccessException, clsName + ".instantiate", "524");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s11", new Object[]{string});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s11", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instantiate(String cls,Class type,ClassLoader acl) returns Object[" + var3_3 + "]");
        }
        return var3_3;
    }

    public static Initializable instantiate(String string, Class clazz, Map map, ClassLoader classLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instantiate(String cls[" + string + "]," + "Class type[" + clazz + "]," + "Map map," + "ClassLoader acl)");
        }
        Initializable initializable = (Initializable)ConfigUtil.instantiate(string, clazz, classLoader);
        initializable.init(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instantiate(String cls,Class type,Map map,ClassLoader acl) returns Initializable[" + initializable + "]");
        }
        return initializable;
    }

    public static void getProperties(Map map, Element element) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties(Map properties,Element parent[" + DOMUtil.getDisplayName(element) + "])");
        }
        NodeList nodeList = DOMUtil.getChildElements(element, Constants.NS_CONFIG, "Property");
        Element element2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
            String string = DOMUtil.getAttribute(element2, "name");
            String string2 = DOMUtil.getAttribute(element2, "value");
            map.put(string, string2);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added a property (Name [" + string + "], Value [" + string2 + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties(Map properties,Element parent)");
        }
    }

    public static Map getProperties(Element element) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties(Element parent[" + DOMUtil.getDisplayName(element) + "])");
        }
        NodeList nodeList = DOMUtil.getChildElements(element, Constants.NS_CONFIG, "Property");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Element element2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
            String string = DOMUtil.getAttribute(element2, "name");
            String string2 = DOMUtil.getAttribute(element2, "value");
            hashMap.put(string, string2);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added a property (Name [" + string + "], Value [" + string2 + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties(Element parent)");
        }
        return hashMap;
    }

    public static KeyLocator findKeyLocator(Element element, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findKeyLocator(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String name[" + string + "]," + "String parentPath[" + string2 + "])");
        }
        NodeList nodeList = element.getElementsByTagNameNS(Constants.NS_CONFIG, "KeyLocator");
        Element element2 = null;
        String string3 = null;
        KeyLocator keyLocator = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
            if (!string.equals(DOMUtil.getAttribute(element2, "name"))) continue;
            string3 = DOMUtil.getAttribute(element2, "classname");
            Map map = ConfigUtil.getProperties(element2);
            if (string3.equals("com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator")) {
                map.put("base", string2);
            }
            keyLocator = (KeyLocator)ConfigUtil.instantiate(string3, KeyLocator.class, map, null);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findKeyLocator(Element element,String name,String parentPath) returns KeuLocator[" + keyLocator + "]");
        }
        return keyLocator;
    }

    public static String getMessage(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessage(String key[" + string + "]");
        }
        String string2 = string;
        if (_MessageCatalog.instance != null) {
            try {
                string2 = _MessageCatalog.instance.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception", new Object[]{missingResourceException});
                }
                Tr.processException(missingResourceException, ConfigUtil.class.getName() + ".getMessage", "673");
                string2 = string;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessage(String key) returns String[" + string2 + "]");
        }
        return string2;
    }

    public static String getMessage(String string, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessage(String key[" + string + "]," + "String[] args[" + stringArray + "])");
        }
        String string2 = ConfigUtil.getMessage(string);
        if (stringArray != null && stringArray.length > 0) {
            string2 = MessageFormat.format(string2, stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessage(String key,String[] args) returns String[" + string2 + "]");
        }
        return string2;
    }

    public static int isIntegralWASDialect(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isIntegralWASDialect(String keyword[" + string + "])");
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < IntegralDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!string.equals(IntegralDialectElementSelector.WASDIALECTS[i])) continue;
                n = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isIntegralWASDialect(String keyword) returns int[" + n + "]");
        }
        return n;
    }

    public static int isConfidentialWASDialect(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isConfidentialWASDialect(String keyword[" + string + "])");
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < ConfidentialDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!string.equals(ConfidentialDialectElementSelector.WASDIALECTS[i])) continue;
                n = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isConfidentialWASDialect(String keyword) returns int[" + n + "]");
        }
        return n;
    }

    public static int isTimestampWASDialect(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTimestampWASDialect(String keyword[" + string + "])");
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < TimestampDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!string.equals(TimestampDialectElementSelector.WASDIALECTS[i])) continue;
                n = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTimestampWASDialect(String keyword) returns int[" + n + "]");
        }
        return n;
    }

    public static int isUsage(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsage(String usage[" + string + "])");
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < USAGE_VALUES.length; ++i) {
                if (!USAGE_VALUES[i].equalsIgnoreCase(string)) continue;
                n = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsage(String usage) returns int[" + n + "]");
        }
        return n;
    }

    public static boolean isUsageRequired(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsageRequired(String usage[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = USAGE_VALUES[0].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsageRequired(String usage) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isUsageOptional(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsageOptional(String usage[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = USAGE_VALUES[1].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsageOptional(String usage) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isUsageRejected(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsageRejected(String usage[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = USAGE_VALUES[2].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsageRejected(String usage) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isUsageObserved(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsageObserved(String usage[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = USAGE_VALUES[3].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsageObserved(String usage) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isUsageIgnored(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsageIgnored(String usage[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = USAGE_VALUES[4].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsageIgnored(String usage) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static int isKeyInfoSignature(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoSignature(String keyword[" + string + "])");
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < IntegralDialectElementSelector.KEYSIGNMETHOD.length; ++i) {
                if (!string.equals(IntegralDialectElementSelector.KEYSIGNMETHOD[i])) continue;
                n = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoSignature(String keyword) returns int[" + n + "]");
        }
        return n;
    }

    public static int isKeyInfoType(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoType(String type[" + string + "])");
        }
        int n = -1;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < KEYINFO_TYPES.length; ++i) {
                if (!KEYINFO_TYPES[i].equalsIgnoreCase(string)) continue;
                n = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoType(String type) returns int[" + n + "]");
        }
        return n;
    }

    public static boolean isKeyInfoStrref(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoStrref(String type[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[0].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoStrref(String type) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isKeyInfoEmb(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoEmb(String type[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[1].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoEmb(String type) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isKeyInfoKeyid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoKeyid(String type[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[2].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoKeyid(String type) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isKeyInfoKeyname(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoKeyname(String type[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[3].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoKeyname(String type) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isKeyInfoX509issuer(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoX509issuer(String type[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            bl = KEYINFO_TYPES[4].equalsIgnoreCase(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoX509issuer(String type) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isC14nTransform(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isC14nTransform(String algorithm[" + string + "])");
        }
        boolean bl = C14N_TRANSFORMS.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isC14nTransform(String algorithm) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isDOMRequiredTransform(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDOMRequiredTransform(String algorithm[" + string + "])");
        }
        boolean bl = DOMREQUIRED_TRANSFORMS.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDOMRequiredTransform(String algorithm) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean isSecretKeyAlgorithm(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecretKeyAlgorithm(String algorithm[" + string + "])");
        }
        boolean bl = false;
        if (string != null) {
            bl = SECRETKEY_ALGORITHMS.contains(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecretKeyAlgorithm(String algorithm) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static int getMinimumPosition(List list, List list2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinimumPosition(List order[" + list + "]," + "List references[" + list2 + "])");
        }
        int n = 10000;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            SigningReferenceConfig signingReferenceConfig = (SigningReferenceConfig)iterator.next();
            int n2 = ConfigUtil.getPosition(list, signingReferenceConfig.getReference());
            if (n2 >= n) continue;
            n = n2;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinimumPosition(List order,List references) returns int[" + n + "]");
        }
        return n;
    }

    public static int getPosition(List list, ReferencePartConfig referencePartConfig) {
        ReferencePartConfig referencePartConfig2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinimumPosition(List order[" + list + "]," + "ReferencePartConfig reference[" + referencePartConfig + "])");
        }
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !(referencePartConfig2 = (ReferencePartConfig)iterator.next()).equals(referencePartConfig)) {
            if (!iterator.hasNext()) continue;
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinimumPosition(List order,ReferencePartConfig reference) returns int[" + n + "]");
        }
        return n;
    }

    public static void insertGenerator(List list, List list2, int n, Configuration configuration) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertGenerator(List operationGenerators[" + list + "]," + "List order[" + list2 + "]," + "int orderNumber[" + n + "]," + "Configuration config)");
        }
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n3 = 0;
            if (e2 instanceof EncryptionGeneratorConfig) {
                n3 = ConfigUtil.getPosition(list2, ((EncryptionGeneratorConfig)e2).getReference());
            } else if (e2 instanceof SignatureGeneratorConfig) {
                n3 = ConfigUtil.getMinimumPosition(list2, ((SignatureGeneratorConfig)e2).getReferences());
            }
            if (n3 > n) {
                list.add(n2, configuration);
                return;
            }
            ++n2;
        }
        list.add(configuration);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertGenerator(List operationGenerators,List order,int orderNumber,Configuration config)");
        }
    }

    public static String trim(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.trim();
        }
        return string2;
    }

    public static void logProperties(Map map, Map map2, String string, String string2, String string3) {
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (string3 != null) {
                stringBuffer.append("Consumer name: " + string3);
            }
            if (ConfigUtil.hasValue(string)) {
                if (string2 != null) {
                    stringBuffer.append("\nSystem property: {" + string + "=" + string2 + "}");
                } else {
                    stringBuffer.append("\nSystem property: {}");
                }
            }
            if (map != null) {
                stringBuffer.append("\nApplication properties: " + map);
            }
            if (map2 != null) {
                stringBuffer.append("\nThis consumer's properties: " + map2);
            }
            Tr.debug(tc, stringBuffer.toString());
        }
    }

    public static Provider setupCertStoreProvider(Map map, Map map2, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupCertStoreProvider");
        }
        String string2 = "com.ibm.wsspi.wssecurity.config.CertStore.Provider";
        ConfigUtil.logProperties(map, map2, string2, System.getProperty(string2), string);
        HashMap hashMap = new HashMap();
        if (map != null) {
            hashMap.putAll(map);
        }
        if (map2 != null) {
            hashMap.putAll(map2);
        }
        String string3 = ConfigUtil.getPropertyEnv(hashMap, string2);
        Provider provider = null;
        if (ConfigUtil.hasValue(string3)) {
            if (map2 != null) {
                map2.put(string2, string3);
            }
            if (tc.isDebugEnabled()) {
                if (ConfigUtil.hasValue(string)) {
                    Tr.debug(tc, "Cert store security provider for " + string + " is: '" + string3 + "'.");
                } else {
                    Tr.debug(tc, "Cert store security provider is: '" + string3 + "'.");
                }
            }
            if ((provider = Security.getProvider(string3)) == null) {
                Tr.debug(tc, "Provider '" + string3 + "' not found.");
            }
        } else if (tc.isDebugEnabled()) {
            if (ConfigUtil.hasValue(string)) {
                Tr.debug(tc, "No user-specified cert store security provider is active for " + string);
            } else {
                Tr.debug(tc, "No user-specified cert store security provider is active.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupCertStoreProvider");
        }
        return provider;
    }

    public static void setMustUnderstand(SOAPMessageContext sOAPMessageContext, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMustUnderstand(messageContext)=" + bl);
        }
        if (sOAPMessageContext != null) {
            sOAPMessageContext.setProperty(com.ibm.ws.webservices.wssecurity.Constants.MUST_UNDERSTAND, new Boolean(bl));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMustUnderstand");
        }
    }

    public static void setMustUnderstand(MessageContextProxy messageContextProxy, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMustUnderstand(MessageContextProxy)=" + bl);
        }
        if (messageContextProxy != null) {
            messageContextProxy.setConfig(com.ibm.ws.webservices.wssecurity.Constants.MUST_UNDERSTAND, new Boolean(bl));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMustUnderstand");
        }
    }

    public static boolean getMustUnderstand(SOAPMessageContext sOAPMessageContext) {
        Boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMustUnderstand(messageContext)");
        }
        boolean bl2 = true;
        if (sOAPMessageContext != null && (bl = (Boolean)sOAPMessageContext.getProperty(com.ibm.ws.webservices.wssecurity.Constants.MUST_UNDERSTAND)) != null) {
            bl2 = bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMustUnderstand=" + bl2);
        }
        return bl2;
    }

    public static boolean getMustUnderstand(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMustUnderstand(context)");
        }
        boolean bl = true;
        if (map != null) {
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
            bl = ConfigUtil.getMustUnderstand(sOAPMessageContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMustUnderstand=" + bl);
        }
        return bl;
    }

    public static boolean getMustUnderstand(MessageContextProxy messageContextProxy) {
        Boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMustUnderstand(MessageContextProxy)");
        }
        boolean bl2 = true;
        if (messageContextProxy != null && (bl = (Boolean)messageContextProxy.getConfig(com.ibm.ws.webservices.wssecurity.Constants.MUST_UNDERSTAND)) != null) {
            bl2 = bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMustUnderstand=" + bl2);
        }
        return bl2;
    }

    static {
        C14N_TRANSFORMS.add("http://www.w3.org/2001/10/xml-exc-c14n#");
        C14N_TRANSFORMS.add("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        C14N_TRANSFORMS.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        C14N_TRANSFORMS.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        DOMREQUIRED_TRANSFORMS = new HashSet();
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2002/06/xmldsig-filter2");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/TR/1999/REC-xslt-19991116");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2002/07/decrypt#XML");
        SECRETKEY_ALGORITHMS = new HashSet();
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-tripledes");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes128");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes192");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes256");
    }

    private static class _MessageCatalog {
        private static final TraceComponent tc1 = Tr.register(class$com$ibm$xml$soapsec$util$ConfigUtil$_MessageCatalog == null ? (class$com$ibm$xml$soapsec$util$ConfigUtil$_MessageCatalog = ConfigUtil.class$("com.ibm.xml.soapsec.util.ConfigUtil$_MessageCatalog")) : class$com$ibm$xml$soapsec$util$ConfigUtil$_MessageCatalog, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        private static ResourceBundle instance;

        private _MessageCatalog() {
        }

        private static void init() {
            block5: {
                if (tc1.isEntryEnabled()) {
                    Tr.entry(tc1, "init()");
                }
                try {
                    instance = ResourceBundle.getBundle("com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
                    if (tc1.isDebugEnabled()) {
                        Tr.debug(tc1, "Initialize resource bundle: com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
                    }
                }
                catch (Throwable throwable) {
                    instance = null;
                    Tr.processException(throwable, (class$com$ibm$xml$soapsec$util$ConfigUtil$_MessageCatalog == null ? (class$com$ibm$xml$soapsec$util$ConfigUtil$_MessageCatalog = ConfigUtil.class$("com.ibm.xml.soapsec.util.ConfigUtil$_MessageCatalog")) : class$com$ibm$xml$soapsec$util$ConfigUtil$_MessageCatalog).getName(), "1230");
                    Tr.warning(tc1, "security.wssecurity.cannot.laod.resource", new Object[]{throwable});
                    if (!tc1.isDebugEnabled()) break block5;
                    Tr.debug(tc1, "Failed to initialize resource bundle: com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
                }
            }
            if (tc1.isEntryEnabled()) {
                Tr.exit(tc1, "init()");
            }
        }

        static {
            _MessageCatalog.init();
        }
    }
}

