/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.domutil.Serializer;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.ErrorHandlerImpl;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtil {
    private static final TraceComponent tc = Tr.register(DOMUtil.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = DOMUtil.class.getName();
    private static final PrivilegedAction contextLoaderGetter = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final HashSet INDENT_NS = new HashSet();

    public static Document parse(InputSource inputSource, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse(InputStream in,boolean validating[" + bl + "])");
        }
        Document document = null;
        try {
            AlgorithmFactory algorithmFactory = AlgorithmFactory.getInstance();
            DocumentBuilder documentBuilder = algorithmFactory.getDocumentBuilder();
            ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl();
            documentBuilder.setErrorHandler(errorHandlerImpl);
            documentBuilder.setEntityResolver(new JarEntityResolver());
            document = documentBuilder.parse(inputSource);
            int n = errorHandlerImpl.getErrorCount();
            documentBuilder.setErrorHandler(null);
            documentBuilder.setEntityResolver(null);
            algorithmFactory.releaseDocumentBuilder(documentBuilder);
            if (n > 0) {
                throw new SAXException(ConfigUtil.getMessage("security.wssecurity.DOMUtil.s01", new String[]{Integer.toString(n)}));
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Tr.processException(parserConfigurationException, clsName + ".parse", "111");
            Tr.error(tc, "security.wssecurity.DOMUtil.s04", new Object[]{parserConfigurationException});
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.s04", parserConfigurationException);
        }
        catch (IOException iOException) {
            Tr.processException(iOException, clsName + ".parse", "115");
            Tr.error(tc, "security.wssecurity.DOMUtil.s04", new Object[]{iOException});
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.s04", iOException);
        }
        catch (SAXException sAXException) {
            Tr.processException(sAXException, clsName + ".parse", "119");
            Tr.error(tc, "security.wssecurity.DOMUtil.s04", new Object[]{sAXException});
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.s04", sAXException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse(InputStream in,boolean validating) returns Document[" + DOMUtil.getDisplayName(document) + "]");
        }
        return document;
    }

    public static Document getPrivateConfig(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateConfig(boolean sender[" + bl + "])");
        }
        String string = bl ? "config/ibm-wssecurity-sender-private.xml" : "config/ibm-wssecurity-receiver-private.xml";
        Document document = DOMUtil.getPrivateConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateConfig(boolean sender) returns Document[" + DOMUtil.getDisplayName(document) + "]");
        }
        return document;
    }

    protected static Document getPrivateConfig(final String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateConfig(String file[" + string + "])");
        }
        Document document = null;
        try {
            document = (Document)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws SoapSecurityException {
                    InputSource inputSource = DOMUtil.getResourceAsInputSource(string);
                    return DOMUtil.parse(inputSource, true);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            SoapSecurityException soapSecurityException = (SoapSecurityException)privilegedActionException.getException();
            Tr.processException(soapSecurityException, clsName + ".getPrivateCofig", "164");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{soapSecurityException});
            Throwable throwable = soapSecurityException.getCauseException();
            if (throwable != null) {
                throw new IllegalArgumentException(soapSecurityException.getMessage() + ": " + throwable.getMessage());
            }
            throw new IllegalArgumentException(soapSecurityException.getMessage());
        }
        catch (Throwable throwable) {
            Tr.processException(throwable, clsName + ".getPrivateConfig", "174");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{throwable});
            throw new IllegalArgumentException(throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateConfig(String file) returns Document[" + DOMUtil.getDisplayName(document) + "]");
        }
        return document;
    }

    public static Document getConfigValidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigValidation()");
        }
        Document document = null;
        try {
            document = (Document)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws SoapSecurityException {
                    InputSource inputSource = DOMUtil.getResourceAsInputSource("config/ibm-wssecurity-config-validation.xml");
                    return DOMUtil.parse(inputSource, true);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            SoapSecurityException soapSecurityException = (SoapSecurityException)privilegedActionException.getException();
            Tr.processException(soapSecurityException, clsName + ".getPrivateCofig", "203");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{soapSecurityException});
            Throwable throwable = soapSecurityException.getCauseException();
            if (throwable != null) {
                throw new IllegalArgumentException(soapSecurityException.getMessage() + ": " + throwable.getMessage());
            }
            throw new IllegalArgumentException(soapSecurityException.getMessage());
        }
        catch (Throwable throwable) {
            Tr.processException(throwable, clsName + ".getPrivateConfig", "213");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{throwable});
            throw new IllegalArgumentException(throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigValidation() returns Document[" + DOMUtil.getDisplayName(document) + "]");
        }
        return document;
    }

    public static InputSource getResourceAsInputSource(String string) {
        ClassLoader classLoader;
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceAsInputSource(String path[" + string + "])");
        }
        if ((inputStream = (classLoader = DOMUtil.class.getClassLoader()).getResourceAsStream(string)) == null) {
            inputStream = classLoader.getResourceAsStream("/" + string);
        }
        if (inputStream == null) {
            classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)contextLoaderGetter);
            if (classLoader == null) {
                inputStream = ClassLoader.getSystemResourceAsStream(string);
                if (inputStream == null) {
                    inputStream = ClassLoader.getSystemResourceAsStream("/" + string);
                }
            } else {
                inputStream = classLoader.getResourceAsStream(string);
                if (inputStream == null) {
                    inputStream = classLoader.getResourceAsStream("/" + string);
                }
            }
        }
        if (inputStream == null) {
            throw new RuntimeException(ConfigUtil.getMessage("security.wssecurity.DOMUtil.s03", new String[]{string}));
        }
        InputSource inputSource = new InputSource(inputStream);
        if (tc.isEntryEnabled()) {
            String string2 = inputSource == null ? "null" : "not null";
            Tr.exit(tc, "getResourceAsInputSource(String path) returns InputSource[" + string2 + "]");
        }
        return inputSource;
    }

    public static String toString(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        String string = DOMUtil.toString(node, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString(Node node) returns String[" + string + "]");
        }
        return string;
    }

    public static String toString(Node node, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString(Node node[" + DOMUtil.getDisplayName(node) + "]," + "String enc[" + string + "])");
        }
        String string2 = null;
        if (node != null) {
            byte[] byArray = null;
            try {
                byArray = Serializer.serialize(node);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Internal Error: " + iOException);
            }
            try {
                string2 = string == null ? new String(byArray) : new String(byArray, string);
            }
            catch (Exception exception) {
                string2 = new String(byArray);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString(Node node,String enc) returns String[" + string2 + "]");
        }
        return string2;
    }

    public static Document createDocument() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDocument()");
        }
        Document document = null;
        try {
            AlgorithmFactory algorithmFactory = AlgorithmFactory.getInstance();
            DocumentBuilder documentBuilder = algorithmFactory.getDocumentBuilder();
            document = documentBuilder.newDocument();
            algorithmFactory.releaseDocumentBuilder(documentBuilder);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Tr.processException(parserConfigurationException, clsName + ".getPrivateCofig", "378");
            Tr.error(tc, "security.wssecurity.DOMUtil.s05", new Object[]{parserConfigurationException});
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.s05", parserConfigurationException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDocument() returns Document[" + DOMUtil.getDisplayName(document) + "]");
        }
        return document;
    }

    public static Element getZeroOrOneElement(Element element, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZeroOrOneElement(Element config[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() != 0) {
            if (nodeList.getLength() == 1) {
                element2 = (Element)nodeList.item(0);
            } else {
                String string3 = (string != null ? "{" + string + "}" : "") + string2;
                throw SoapSecurityException.format("security.wssecurity.RequestReceiverConfig.sconf02", string3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZeroOrOneElement(Element config,String ns,String name) returns Element[" + DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    public static Element getZeroOrOneElement(Document document, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZeroOrOneElement(Document config[" + DOMUtil.getDisplayName(document) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        Element element = DOMUtil.getZeroOrOneElement(document.getDocumentElement(), string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZeroOrOneElement(Document config,String ns,String name) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    public static Element getOneElement(Element element, String string, String string2) throws SoapSecurityException {
        NodeList nodeList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneElement(Element config[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        if ((nodeList = element.getElementsByTagNameNS(string, string2)).getLength() != 1) {
            String string3 = (string != null ? "{" + string + "}" : "") + string2;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf03", string3);
        }
        Element element2 = (Element)nodeList.item(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneElement(Element config,String ns,String name) returns Element[" + DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    public static Element getOneElement(Document document, String string, String string2) throws SoapSecurityException {
        NodeList nodeList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneElement(Document config[" + DOMUtil.getDisplayName(document) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        if ((nodeList = document.getElementsByTagNameNS(string, string2)).getLength() != 1) {
            String string3 = (string != null ? "{" + string + "}" : "") + string2;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf03", string3);
        }
        Element element = (Element)nodeList.item(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneElement(Document config,String ns,String name) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    public static NodeList getChildElements(Element element, String string, String string2) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildElements(Element parent[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1 || !DOMUtil.equals((Node)object, string, string2)) continue;
            arrayList.add(object);
        }
        object = new NodeList(){

            public int getLength() {
                return arrayList.size();
            }

            public Node item(int n) {
                return (Node)arrayList.get(n);
            }
        };
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildElements(Element parent,String ns,String name) returns NodeList[" + object + "]");
        }
        return object;
    }

    public static Element getChildElement(Element element, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildElement(Element parent[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        Element element2 = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !DOMUtil.equals(node, string, string2)) continue;
            element2 = (Element)node;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildElement(Element parent,String ns,String name) returns Element[" + DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    public static Element getAncestorElement(Element element, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAncestorElement(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        Element element2 = null;
        if (DOMUtil.equals(element, string, string2)) {
            element2 = element;
        } else {
            for (Node node = element.getParentNode(); node != null && element != node; node = node.getParentNode()) {
                if (node.getNodeType() != 1) continue;
                element2 = DOMUtil.getAncestorElement((Element)node, string, string2);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAncestorElement(Element element,String ns,String name) returns Element[" + DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    public static boolean equals(Node node, String string, String string2) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(Node node[" + DOMUtil.getDisplayName(node) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        boolean bl2 = bl = DOMUtil.equals(node.getNamespaceURI(), string) && DOMUtil.equals(node.getLocalName(), string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(Node node,String ns,String name) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private static boolean equals(String string, String string2) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(String str1[" + string + "]," + "String str2[" + string2 + "])");
        }
        boolean bl2 = bl = string == null && string2 == null || string != null && string.equals(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(String str1,String str2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean equals(Node node, Node node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(Node node1[" + DOMUtil.getDisplayName(node) + "]," + "Node node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean bl = false;
        if (node == null && node2 == null) {
            bl = true;
        } else if (node == null || node2 == null) {
            bl = false;
        } else if (node.equals(node2)) {
            bl = true;
        } else if (node.getNodeType() != node2.getNodeType()) {
            bl = false;
        } else {
            switch (node.getNodeType()) {
                case 1: {
                    bl = DOMUtil.equalsElement(node, node2);
                    break;
                }
                case 2: {
                    bl = DOMUtil.equalsAttribute((Attr)node, (Attr)node2);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    bl = DOMUtil.equalsTextValue(node, node2);
                    break;
                }
                case 5: 
                case 12: {
                    bl = DOMUtil.equalsNodeName(node, node2);
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(Node node1,Node node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private static boolean equalsElement(Node node, Node node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsElement(Node node1[" + DOMUtil.getDisplayName(node) + "]," + "Node node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean bl = false;
        if (node == null && node2 == null) {
            bl = true;
        } else if (DOMUtil.equals(node.getNamespaceURI(), node2.getNamespaceURI()) && DOMUtil.equals(node.getLocalName(), node2.getLocalName())) {
            Node node3 = node.getParentNode();
            Node node4 = node2.getParentNode();
            Element element = DOMUtil.getFirstElement(node3);
            Element element2 = DOMUtil.getFirstElement(node4);
            while (element != null && element2 != null) {
                if (element.equals(node) && element2.equals(node2)) {
                    if (node3 != null && node4 != null && node3.getNodeType() == 9 && node4.getNodeType() == 9) {
                        bl = true;
                    } else {
                        bl = DOMUtil.equals(node3, node4);
                        break;
                    }
                }
                element = DOMUtil.getNextElement(element);
                element2 = DOMUtil.getNextElement(element2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsElement(Node node1,Node node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private static boolean equalsAttribute(Attr attr, Attr attr2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsAttribute(Attr node1[" + DOMUtil.getDisplayName(attr) + "]," + "Attr node2[" + DOMUtil.getDisplayName(attr2) + "])");
        }
        boolean bl = false;
        if (attr == null && attr2 == null) {
            bl = true;
        } else if (DOMUtil.equals(attr.getName(), attr2.getName()) && DOMUtil.equals(attr.getValue(), attr2.getValue())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsAttribute(Attr node1,Attr node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private static boolean equalsTextValue(Node node, Node node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsTextValue(Node node1[" + DOMUtil.getDisplayName(node) + "]," + "Node node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean bl = false;
        if (node == null && node2 == null) {
            bl = true;
        } else if (DOMUtil.equals(node.getNodeValue(), node2.getNodeValue())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsTextValue(Node node1,Node node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private static boolean equalsNodeName(Node node, Node node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsNodeName(Node node1[" + DOMUtil.getDisplayName(node) + "]," + "Node node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean bl = false;
        if (node == null && node2 == null) {
            bl = true;
        } else if (DOMUtil.equals(node.getNodeName(), node2.getNodeName())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsNodeName(Node node1,Node node2) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static NodeList getOneOrMoreChildElements(Element element, String string, String string2) throws SoapSecurityException {
        NodeList nodeList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneOrMoreChildElements(Element parent[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        if ((nodeList = DOMUtil.getChildElements(element, string, string2)).getLength() <= 0) {
            String string3 = (string != null ? "{" + string + "}" : "") + string2;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf09", string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneOrMoreChildElements(Element parent,String ns,String name) returns NodeList[" + nodeList + "]");
        }
        return nodeList;
    }

    public static NodeList getOneOrMoreElements(Element element, String string, String string2) throws SoapSecurityException {
        NodeList nodeList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneOrMoreElements(Element parent[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        if ((nodeList = element.getElementsByTagNameNS(string, string2)).getLength() <= 0) {
            String string3 = (string != null ? "{" + string + "}" : "") + string2;
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf09", string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneOrMoreElements(Element parent,String ns,String name) retuns NodeList[" + nodeList + "]");
        }
        return nodeList;
    }

    public static String getAttribute(Element element, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String name[" + string + "])");
        }
        if (!element.hasAttribute(string)) {
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf10", element.getLocalName(), string);
        }
        String string2 = element.getAttribute(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute(Element element,String name) returns String [" + string2 + "]");
        }
        return string2;
    }

    public static Element getOneChildElement(Element element, String string, String string2) throws SoapSecurityException {
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneChildElement(Element parent[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        if ((element2 = DOMUtil.getChildElement(element, string, string2)) == null) {
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf03", string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneChildElement(Element parent,String ns,String name) retuns Element[" + DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    public static Element getOneChildElement(Element element, String string, String[] stringArray) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneChildElement(Element parent[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + string + "]," + "String[] names[" + stringArray + "])");
        }
        Element element2 = null;
        for (int i = 0; i < stringArray.length && (element2 = DOMUtil.getChildElement(element, string, stringArray[i])) == null; ++i) {
        }
        if (element2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf11", stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneChildElement(Element parent,String ns,String[] names) retuns Element[" + DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    public static Node getNextSibling2(Node node) {
        Node node2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextSibling2(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        if ((node2 = node.getNextSibling()) == null) {
            Node node3 = node.getParentNode();
            if (node3 == null) {
                return null;
            }
            if (node3.getNodeType() == 5) {
                node2 = DOMUtil.getNextSibling2(node3);
            }
        } else {
            while (node2.getNodeType() == 5) {
                Node node4 = node2.getFirstChild();
                if (node4 == null) {
                    node2 = DOMUtil.getNextSibling2(node2);
                    break;
                }
                node2 = node4;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextSibling2(Node node) returns Node[" + DOMUtil.getDisplayName(node2) + "]");
        }
        return node2;
    }

    public static Node getPreviousSibling2(Node node) {
        Node node2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreviousSibling2(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        if ((node2 = node.getPreviousSibling()) == null) {
            Node node3 = node.getParentNode();
            if (node3 == null) {
                return null;
            }
            if (node3.getNodeType() == 5) {
                node2 = DOMUtil.getPreviousSibling2(node3);
            }
        } else {
            while (node2.getNodeType() == 5) {
                Node node4 = node2.getLastChild();
                if (node4 == null) {
                    node2 = DOMUtil.getPreviousSibling2(node2);
                    break;
                }
                node2 = node4;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreviousSibling2(Node node) returns Node[" + DOMUtil.getDisplayName(node2) + "]");
        }
        return node2;
    }

    public static Node getFirstChild2(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstChild2(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        Node node2 = node.getFirstChild();
        while (node2 != null && node2.getNodeType() == 5) {
            Node node3 = node2.getFirstChild();
            if (node3 == null) {
                node2 = DOMUtil.getNextSibling2(node2);
                break;
            }
            node2 = node3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstChild2(Node node) returns Node[" + DOMUtil.getDisplayName(node2) + "]");
        }
        return node2;
    }

    public static Node getLastChild2(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastChild2(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        Node node2 = node.getLastChild();
        while (node2 != null && node2.getNodeType() == 5) {
            Node node3 = node2.getLastChild();
            if (node3 == null) {
                node2 = DOMUtil.getPreviousSibling2(node2);
                break;
            }
            node2 = node3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastChild2(Node node) returns Node[" + DOMUtil.getDisplayName(node2) + "]");
        }
        return node2;
    }

    public static Element getFirstElement(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstElement(Node parent[" + DOMUtil.getDisplayName(node) + "])");
        }
        Node node2 = DOMUtil.getFirstChild2(node);
        while (node2 != null && node2.getNodeType() != 1) {
            node2 = DOMUtil.getNextSibling2(node2);
        }
        Element element = (Element)node2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstElement(Node parent) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    public static Element getFirstElement(Node node, String string, String string2) {
        Element element;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstElement(Node parent[" + DOMUtil.getDisplayName(node) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        Node node2 = DOMUtil.getFirstChild2(node);
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                element = (Element)node2;
                String string3 = element.getNamespaceURI();
                if ((string2.equals("*") || element.getLocalName().equals(string2)) && (string == null && string3 == null || string != null && string.equals("*") || string != null && string.equals(string3))) break;
            }
            node2 = DOMUtil.getNextSibling2(node2);
        }
        element = (Element)node2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstElement(Node parent,String ns,String name) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    public static Element getLastElement(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastElement(Node parent[" + DOMUtil.getDisplayName(node) + "])");
        }
        Node node2 = DOMUtil.getLastChild2(node);
        while (node2 != null && node2.getNodeType() != 1) {
            node2 = DOMUtil.getPreviousSibling2(node2);
        }
        Element element = (Element)node2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastElement(Node parent) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    public static Element getLastElement(Node node, String string, String string2) {
        Element element;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastElement(Node parent[" + DOMUtil.getDisplayName(node) + "]," + "String ns[" + string + "]," + "String name[" + string2 + "])");
        }
        Node node2 = DOMUtil.getLastChild2(node);
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                element = (Element)node2;
                String string3 = element.getNamespaceURI();
                if ((string2.equals("*") || element.getLocalName().equals(string2)) && (string == null && string3 == null || string != null && string.equals("*") || string != null && string.equals(string3))) break;
            }
            node2 = DOMUtil.getPreviousSibling2(node2);
        }
        element = (Element)node2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastElement(Node parent,String ns,String name) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    public static Element getNextElement(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextElement(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        Node node2 = node;
        while ((node2 = DOMUtil.getNextSibling2(node2)) != null && node2.getNodeType() != 1) {
        }
        Element element = (Element)node2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextElement(Node node) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    public static String getStringValue(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStringValue(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        String string = null;
        switch (node.getNodeType()) {
            case 1: 
            case 5: 
            case 9: {
                Node node2 = node.getFirstChild();
                if (node2 == null) {
                    string = "";
                    break;
                }
                if (node2 == node.getLastChild() && (node2.getNodeType() == 3 || node2.getNodeType() == 4)) {
                    string = node2.getNodeValue();
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer();
                DOMUtil.getStringValue0(node, stringBuffer);
                string = new String(stringBuffer);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = node.getNodeValue();
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unexpected node type: " + node.getNodeType());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStringValue(Node node) returns String[" + string + "]");
        }
        return string;
    }

    private static void getStringValue0(Node node, StringBuffer stringBuffer) {
        switch (node.getNodeType()) {
            case 1: 
            case 5: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    DOMUtil.getStringValue0(node2, stringBuffer);
                }
                break;
            }
            case 3: 
            case 4: {
                stringBuffer.append(node.getNodeValue());
                break;
            }
        }
    }

    public static boolean declareNamespace(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "declareNamespace(Element element[" + DOMUtil.getDisplayName(element) + "])");
        }
        boolean bl = true;
        String string = "xmlns";
        if (element.getPrefix() != null) {
            string = "xmlns:" + element.getPrefix();
        }
        String string2 = element.getNamespaceURI();
        for (Node node = element; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            Attr attr = node.getAttributeNode(string);
            if (attr == null) continue;
            if (string2 == null) {
                if (attr.getNodeValue().length() == 0) {
                    bl = false;
                    break;
                }
                element.setAttributeNS(Constants.NS_XMLNS, string, "");
                bl = true;
                break;
            }
            if (string2.equals(attr.getNodeValue())) {
                bl = false;
                break;
            }
            element.setAttributeNS(Constants.NS_XMLNS, string, string2);
            bl = true;
            break;
        }
        if (string2 == null) {
            bl = false;
        }
        element.setAttributeNS(Constants.NS_XMLNS, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "declareNamespace(Element element) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static void removeIndentation(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeIndentation(Element element[" + DOMUtil.getDisplayName(element) + "])");
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                DOMUtil.removeIndentation((Element)node);
                node = node.getNextSibling();
                continue;
            }
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                Node node2 = node;
                if (DOMUtil.isAllSpace(node)) {
                    node = node.getNextSibling();
                    element.removeChild(node2);
                    continue;
                }
                if (DOMUtil.hasSpace(node)) {
                    DOMUtil.trimSpaces(node);
                    node = node.getNextSibling();
                    continue;
                }
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeIndentation(Element element)");
        }
    }

    public static void indent(Element element, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "indent(Element element[" + DOMUtil.getDisplayName(element) + "]," + "int init[" + n + "]," + "int diff[" + n2 + "])");
        }
        int n3 = n + n2;
        if (INDENT_NS.contains(element.getNamespaceURI()) && element.hasChildNodes()) {
            element.normalize();
            Document document = element.getOwnerDocument();
            Node node = null;
            for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() == 1) {
                    if (node == null || node.getNodeType() != 3) {
                        element.insertBefore(DOMUtil.createTextNode(document, n3), node2);
                    } else if (DOMUtil.isAllSpace(node)) {
                        element.replaceChild(DOMUtil.createTextNode(document, n3), node);
                    }
                    DOMUtil.indent((Element)node2, n3, n2);
                }
                node = node2;
            }
            if (node == null || node.getNodeType() != 3) {
                element.appendChild(DOMUtil.createTextNode(document, n));
            } else if (DOMUtil.isAllSpace(node)) {
                element.replaceChild(DOMUtil.createTextNode(document, n), node);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "indent(Element element,int init,int diff)");
        }
    }

    protected static Node createTextNode(Document document, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTextNode(Document factory[" + DOMUtil.getDisplayName(document) + "]," + "int spaces[" + n + "])");
        }
        StringBuffer stringBuffer = new StringBuffer(1 + n);
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        Text text = document.createTextNode(new String(stringBuffer));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTextNode(Document factory,int spaces) returns Node[" + text + "]");
        }
        return text;
    }

    protected static boolean isAllSpace(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAllSpace(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        boolean bl = true;
        String string = node.getNodeValue();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            bl = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAllSpace(Node node) returns boolean[" + bl + "]");
        }
        return bl;
    }

    protected static boolean hasSpace(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasSpace(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        boolean bl = false;
        String string = node.getNodeValue();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasSpace(Node node) returns boolean[" + bl + "]");
        }
        return bl;
    }

    protected static void trimSpaces(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trimSpaces(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        boolean bl = false;
        String string = node.getNodeValue();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                bl = false;
                continue;
            }
            if (!bl && (c == ' ' || c == '\t')) continue;
            bl = true;
            stringBuffer.append(c);
        }
        node.setNodeValue(new String(stringBuffer));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trimSpaces(Node node)");
        }
    }

    public static QName getQName(Element element, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQName(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String qNameStr[" + string + "])");
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(":");
        if (n == -1) {
            string2 = "xmlns";
            string3 = string;
        } else {
            string2 = "xmlns:" + string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        Node node = element;
        String string4 = "";
        while (node instanceof Element && (string4 = node.getAttribute(string2)).equals("")) {
            node = node.getParentNode();
        }
        QName qName = new QName(string4, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQName(Element element,String qNameStr) returns QName[" + qName + "]");
        }
        return qName;
    }

    public static void setQNameAttr(Element element, String string, String string2, QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameAttr(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String attrNameNS[" + string + "]," + "String attrName[" + string2 + "]," + "QName attrValue[" + qName + "])");
        }
        String string3 = DOMUtil.setQName0(element, qName);
        element.setAttributeNS(string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameAttr(Element element,String attrNameNS,String attrName,QName attrValue)");
        }
    }

    public static void setQNameText(Element element, QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameText(Element element[" + DOMUtil.getDisplayName(element) + "]," + "QName text[" + qName + "])");
        }
        String string = DOMUtil.setQName0(element, qName);
        Document document = element.getOwnerDocument();
        element.appendChild(document.createTextNode(string));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameText(Element element,QName text)");
        }
    }

    private static String setQName0(Element element, QName qName) {
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        Node node = element;
        String string3 = null;
        HashSet<String> hashSet = new HashSet<String>();
        while (node instanceof Element) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                String string4 = node2.getNodeName();
                String string5 = node2.getNodeValue();
                if (!string4.startsWith("xmlns")) continue;
                String string6 = null;
                int n = string4.indexOf(":");
                string6 = n == -1 ? "" : string4.substring(n + 1);
                if (string5.equals(string) && string3 == null && !hashSet.contains(string6)) {
                    string3 = string6;
                }
                hashSet.add(string6);
            }
            node = node.getParentNode();
        }
        if (string3 == null) {
            string3 = string != null && string.length() != 0 ? "ns" + string.hashCode() : "ns" + qName.hashCode();
            while (hashSet.contains(string3)) {
                string3 = "ns" + DOMUtil.makeRandomStr();
            }
            element.setAttributeNS(Constants.NS_XMLNS, "xmlns:" + string3, string);
        }
        return string3.equals("") ? string2 : string3 + ":" + string2;
    }

    protected static String makeRandomStr() {
        return String.valueOf(Math.abs(new Random().nextLong()));
    }

    public static Element StringToElement(String string, String string2, String string3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StringToElement(String namespace[" + string + "]," + "String name[" + string2 + "]," + "String str[" + string3 + "])");
        }
        Element element = null;
        Document document = DOMUtil.createDocument();
        Element element2 = null;
        element2 = string == null || string.length() == 0 ? document.createElement(string2) : document.createElementNS(string, string2);
        Text text = document.createTextNode(string3);
        element2.appendChild(text);
        element = element2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "StringToElement(String namespace,String name,String str) returns Element[" + element + "]");
        }
        return element;
    }

    public static boolean hasNamespaceDeclaration(Element element, String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasNamespaceDeclaration(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + string + "])");
        }
        boolean bl2 = bl = DOMUtil.getNamespaceDeclaration(element, string) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasNamespaceDeclaration(Element element,String namespace) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static String getNamespacePrefix(Element element, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespacePrefix(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + string + "])");
        }
        Object object = null;
        String string2 = element.getNamespaceURI();
        if (string2 != null && string2.equals(string)) {
            object = element.getPrefix();
        } else {
            Object object2;
            Attr attr = DOMUtil.getNamespaceDeclaration(element, string);
            if (attr != null && !"xmlns".equals(object2 = attr.getLocalName())) {
                object = object2;
            }
            if (object == null && (object2 = element.getParentNode()) != null && object2 instanceof Element) {
                object = DOMUtil.getNamespacePrefix((Element)object2, string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespacePrefix(Element element,String namespace) returns String[" + (String)object + "]");
        }
        return object;
    }

    public static Attr getNamespaceDeclaration(Element element, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespaceDeclaration(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + string + "])");
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = null;
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr2 = (Attr)namedNodeMap.item(i);
            String string2 = attr2.getName();
            if (!"xmlns".equals(string2) && !string2.startsWith("xmlns:") || !string.equals(string2 = attr2.getValue())) continue;
            attr = attr2;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespaceDeclaration(Element element,String namespace) returns Attr[" + attr + "]");
        }
        return attr;
    }

    public static Attr removeNamespaceDeclaration(Element element, String string) {
        Attr attr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNamespaceDeclaration(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + string + "])");
        }
        if ((attr = DOMUtil.getNamespaceDeclaration(element, string)) != null) {
            element.removeAttributeNode(attr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNamespaceDeclaration(Element element,String namespace) returns Attr[" + attr + "]");
        }
        return attr;
    }

    public static Collection getEffectiveNamespaceDeclarations(Node node, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveNamespaceDeclarations(Node node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + bl + "])");
        }
        Collection collection = null;
        if (node != null) {
            HashMap<String, Attr> hashMap = new HashMap<String, Attr>();
            DOMUtil.getEffectiveAttributes(node, node, bl, new String[]{"xmlns", "xmlns:"}, hashMap);
            Document document = node.getOwnerDocument();
            if (node.getNodeType() == 9) {
                document = (Document)node;
            }
            Attr attr = document.createAttributeNS(Constants.NS_XMLNS, "xmlns:xml");
            attr.setValue("http://www.w3.org/XML/1998/namespace");
            hashMap.put(attr.getName(), attr);
            collection = hashMap.values();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveNamespaceDeclarations(Node node,boolean inclusive) returns Collection[" + collection + "]");
        }
        return collection;
    }

    private static void getEffectiveAttributes(Node node, Node node2, boolean bl, String[] stringArray, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveAttributes(Node current[" + DOMUtil.getDisplayName(node) + "]," + "Node start[" + DOMUtil.getDisplayName(node2) + "]," + "boolean inclusive[" + bl + "]," + "String[] names[" + stringArray + "]," + "Map name2Attr)");
        }
        if (com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil.hasParentNode(node)) {
            DOMUtil.getEffectiveAttributes(node.getParentNode(), node2, bl, stringArray, map);
        }
        if ((node != node2 || bl) && node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string = attr.getName();
                for (int j = 0; j < stringArray.length; ++j) {
                    String string2 = stringArray[j];
                    if (string2.endsWith(":")) {
                        if (!string.startsWith(string2)) continue;
                        map.put(string, attr);
                        continue;
                    }
                    if (!string.equals(string2)) continue;
                    map.put(string, attr);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveAttributes(Node current,Node start,boolean inclusive,String[] names,Map name2Attr)");
        }
    }

    public static Collection getEffectiveXMLPrefixedAttributes(Node node, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveXMLPrefixedAttributes(Node node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + bl + "])");
        }
        Collection collection = null;
        if (node != null) {
            HashMap hashMap = new HashMap();
            DOMUtil.getEffectiveAttributes(node, node, bl, new String[]{"xml:"}, hashMap);
            collection = hashMap.values();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveXMLPrefixedAttributes(Node node,boolean inclusive) returns Collection[" + collection + "]");
        }
        return collection;
    }

    public static Element createDummyElement(Element element, Document document, Node node, boolean bl) {
        Collection collection;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(Element element[" + DOMUtil.getDisplayName(element) + "]," + "Document factory[" + DOMUtil.getDisplayName(document) + "]," + "Node node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + bl + "])");
        }
        String string = null;
        String string2 = "dummy";
        if (element != null) {
            string = element.getNamespaceURI();
            string2 = element.getTagName();
        }
        if (document == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element element2 = document.createElementNS(string, string2);
        if (node != null && (collection = DOMUtil.getEffectiveNamespaceDeclarations(node, bl)) != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Attr attr = (Attr)iterator.next();
                element2.setAttributeNS(Constants.NS_XMLNS, attr.getName(), attr.getValue());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(Element element,Document factory,Node node,boolean inclusive) returns Element[" + DOMUtil.getDisplayName(element2) + "]");
        }
        return element2;
    }

    public static Element createDummyElement(Document document, Node node, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(Document factory[" + DOMUtil.getDisplayName(document) + "]," + "Node node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + bl + "])");
        }
        Element element = DOMUtil.createDummyElement(null, document, node, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(Document factory,Node node,boolean inclusive) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    public static Element createDummyElement(Document document) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(Document factory[" + DOMUtil.getDisplayName(document) + "])");
        }
        Element element = DOMUtil.createDummyElement(null, document, null, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(Document factory) returns Element[" + element + "]");
        }
        return element;
    }

    public static String getQualifiedName(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQualifiedName(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        String string = node.getPrefix();
        String string2 = node.getLocalName();
        if (string == null) {
            string = "";
        } else if (!"".equals(string)) {
            string = string + ":";
        }
        String string3 = string + string2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQualifiedName(Node node) returns String[" + string3 + "]");
        }
        return string3;
    }

    public static String getDisplayName(Node node) {
        return DOMUtil.getDisplayName(node, true);
    }

    public static String getDisplayName(Node node, boolean bl) {
        String string = null;
        if (node != null) {
            String string2 = bl ? node.getClass().getName() + " --- " : "";
            String string3 = node.getLocalName();
            switch (node.getNodeType()) {
                case 1: {
                    String string4 = node.getNamespaceURI();
                    string = string2 + "{" + string4 + "}" + string3;
                    break;
                }
                default: {
                    String string5 = node.getNodeName();
                    string = string3 != null ? string2 + string5 + "::" + string3 : string2 + string5;
                }
            }
        }
        return string;
    }

    static {
        INDENT_NS.add(Constants.NS_WSSE);
        INDENT_NS.add(Constants.NS_DSIG);
        INDENT_NS.add(Constants.NS_ENC);
        INDENT_NS.add(Constants.NS_WSSE200207);
        INDENT_NS.add(Constants.NS_WSSE200204);
        INDENT_NS.add(Constants.NS_WSU);
        INDENT_NS.add(Constants.NS_WSU200207);
    }

    public static class JarEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) {
            String string3;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resolveEntity(String publicId[" + string + "]," + "String systemId[" + string2 + "])");
            }
            InputSource inputSource = null;
            if (string2 != null) {
                try {
                    string3 = null;
                    int n = string2.lastIndexOf(47);
                    string3 = n < 0 ? "config/" + string2 : "config/" + string2.substring(n + 1);
                    InputStream inputStream = (class$com$ibm$xml$soapsec$util$DOMUtil == null ? (class$com$ibm$xml$soapsec$util$DOMUtil = DOMUtil.class$("com.ibm.xml.soapsec.util.DOMUtil")) : class$com$ibm$xml$soapsec$util$DOMUtil).getClassLoader().getResourceAsStream(string3);
                    if (inputStream == null) {
                        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)contextLoaderGetter);
                        inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
                    }
                    if (inputStream != null) {
                        inputSource = new InputSource(inputStream);
                    }
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".resolveEntity", "266");
                    Tr.error(tc, "security.wssecurity.DOMUtil.s02", new Object[]{string, string2, exception});
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                string3 = inputSource == null ? "null" : "not null";
                Tr.entry(tc, "resolveEntity(String publicId,String systemId) returns InputStream[" + string3 + "]");
            }
            return inputSource;
        }
    }
}

