/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import java.text.ParseException;
import java.util.Calendar;

public class Duration {
    private static final int ST_START = 0;
    private static final int ST_NEG = 1;
    private static final int ST_P = 2;
    private static final int ST_DIGIT_YMD = 3;
    private static final int ST_T = 1004;
    private static final int ST_YEAR = 1005;
    private static final int ST_MONTH = 1006;
    private static final int ST_DAY = 1007;
    private static final int ST_DIGIT_MD = 8;
    private static final int ST_DIGIT_D = 9;
    private static final int ST_DIGIT_HMS = 10;
    private static final int ST_HOUR = 1011;
    private static final int ST_MINUTE = 1012;
    private static final int ST_PERIOD = 13;
    private static final int ST_SECOND = 1014;
    private static final int ST_DIGIT_MS = 15;
    private static final int ST_DIGIT_S = 16;
    private static final int ST_DIGIT_MILLI = 17;
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
    int millisecond;

    public static Duration parse(String string) throws ParseException {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 1;
        int n5 = Integer.MAX_VALUE;
        Duration duration = new Duration();
        while (n < 1000 || n3 < n2) {
            int n6 = n3 < n2 ? string.charAt(n3) & 0xFF : -1;
            switch (n) {
                case 0: {
                    if (n6 == 45) {
                        n4 = -1;
                        ++n3;
                        n = 1;
                        break;
                    }
                    if (n6 == 80) {
                        ++n3;
                        n = 2;
                        break;
                    }
                    throw new ParseException("'-' or 'P' is expected.", n3);
                }
                case 1: {
                    if (n6 == 80) {
                        ++n3;
                        n = 2;
                        break;
                    }
                    throw new ParseException("'P' is expected.", n3);
                }
                case 2: {
                    int n7;
                    if (48 <= n6 && n6 <= 57) {
                        n7 = Duration.lookupDigit(string, n3);
                        n5 = Integer.parseInt(string.substring(n3, n3 + n7));
                        n3 += n7;
                        n = 3;
                        break;
                    }
                    if (n6 == 84) {
                        ++n3;
                        n = 1004;
                        break;
                    }
                    throw new ParseException("Digit or 'T' is expected.", n3);
                }
                case 3: {
                    if (n6 == 89) {
                        duration.year = n4 * n5;
                        ++n3;
                        n = 1005;
                        break;
                    }
                    if (n6 == 77) {
                        duration.month = n4 * n5;
                        ++n3;
                        n = 1006;
                        break;
                    }
                    if (n6 == 68) {
                        duration.day = n4 * n5;
                        ++n3;
                        n = 1007;
                        break;
                    }
                    throw new ParseException("'Y' or 'M' or 'D' is expected.", n3);
                }
                case 1005: {
                    int n7;
                    if (48 <= n6 && n6 <= 57) {
                        n7 = Duration.lookupDigit(string, n3);
                        n5 = Integer.parseInt(string.substring(n3, n3 + n7));
                        n3 += n7;
                        n = 8;
                        break;
                    }
                    if (n6 == 84) {
                        ++n3;
                        n = 1004;
                        break;
                    }
                    throw new ParseException("Digit or 'T' is expected.", n3);
                }
                case 8: {
                    if (n6 == 77) {
                        duration.month = n4 * n5;
                        ++n3;
                        n = 1006;
                        break;
                    }
                    if (n6 == 68) {
                        duration.day = n4 * n5;
                        ++n3;
                        n = 1007;
                        break;
                    }
                    throw new ParseException("'M' or 'D' is expected.", n3);
                }
                case 1006: {
                    int n7;
                    if (48 <= n6 && n6 <= 57) {
                        n7 = Duration.lookupDigit(string, n3);
                        n5 = Integer.parseInt(string.substring(n3, n3 + n7));
                        n3 += n7;
                        n = 9;
                        break;
                    }
                    if (n6 == 84) {
                        ++n3;
                        n = 1004;
                        break;
                    }
                    throw new ParseException("Digit or 'T' is expected.", n3);
                }
                case 9: {
                    if (n6 == 68) {
                        duration.day = n4 * n5;
                        ++n3;
                        n = 1007;
                        break;
                    }
                    throw new ParseException("'D' is expected.", n3);
                }
                case 1007: {
                    if (n6 == 84) {
                        ++n3;
                        n = 1004;
                        break;
                    }
                    throw new ParseException("'T' is expected.", n3);
                }
                case 1004: {
                    int n7;
                    if (48 <= n6 && n6 <= 57) {
                        n7 = Duration.lookupDigit(string, n3);
                        n5 = Integer.parseInt(string.substring(n3, n3 + n7));
                        n3 += n7;
                        n = 10;
                        break;
                    }
                    throw new ParseException("Digit is expected.", n3);
                }
                case 10: {
                    if (n6 == 72) {
                        duration.hour = n4 * n5;
                        ++n3;
                        n = 1011;
                        break;
                    }
                    if (n6 == 77) {
                        duration.minute = n4 * n5;
                        ++n3;
                        n = 1012;
                        break;
                    }
                    if (n6 == 46) {
                        duration.second = n4 * n5;
                        ++n3;
                        n = 13;
                        break;
                    }
                    if (n6 == 83) {
                        duration.second = n4 * n5;
                        ++n3;
                        n = 1014;
                        break;
                    }
                    throw new ParseException("'H', 'M', '.', or 'S' is expected.", n3);
                }
                case 1011: {
                    int n7;
                    if (48 <= n6 && n6 <= 57) {
                        n7 = Duration.lookupDigit(string, n3);
                        n5 = Integer.parseInt(string.substring(n3, n3 + n7));
                        n3 += n7;
                        n = 15;
                        break;
                    }
                    throw new ParseException("Digit is expected.", n3);
                }
                case 15: {
                    if (n6 == 77) {
                        duration.minute = n4 * n5;
                        ++n3;
                        n = 1012;
                        break;
                    }
                    if (n6 == 46) {
                        duration.second = n4 * n5;
                        ++n3;
                        n = 13;
                        break;
                    }
                    if (n6 == 83) {
                        duration.second = n4 * n5;
                        ++n3;
                        n = 1014;
                        break;
                    }
                    throw new ParseException("'M', '.', or 'S' is expected.", n3);
                }
                case 1012: {
                    int n7;
                    if (48 <= n6 && n6 <= 57) {
                        n7 = Duration.lookupDigit(string, n3);
                        n5 = Integer.parseInt(string.substring(n3, n3 + n7));
                        n3 += n7;
                        n = 16;
                        break;
                    }
                    throw new ParseException("Digit is expected.", n3);
                }
                case 16: {
                    if (n6 == 46) {
                        duration.second = n4 * n5;
                        ++n3;
                        n = 13;
                        break;
                    }
                    if (n6 == 83) {
                        duration.second = n4 * n5;
                        ++n3;
                        n = 1014;
                        break;
                    }
                    throw new ParseException("'.' or 'S' is expected.", n3);
                }
                case 13: {
                    int n7;
                    if (48 <= n6 && n6 <= 57) {
                        n7 = Duration.lookupDigit(string, n3);
                        if (n7 == 1) {
                            n5 = Integer.parseInt(string.substring(n3, n3 + n7));
                            n5 *= 100;
                        } else if (n7 == 2) {
                            n5 = Integer.parseInt(string.substring(n3, n3 + n7));
                            n5 *= 10;
                        } else if (n7 >= 3) {
                            n5 = Integer.parseInt(string.substring(n3, n3 + 3));
                        }
                        n3 += n7;
                        n = 17;
                        break;
                    }
                    if (n6 == 83) {
                        ++n3;
                        n = 1014;
                        break;
                    }
                    throw new ParseException("Digit is expected.", n3);
                }
                case 17: {
                    duration.millisecond = n4 * n5;
                    if (n6 == 83) {
                        ++n3;
                        n = 1014;
                        break;
                    }
                    throw new ParseException("'S' is expected.", n3);
                }
                case 1014: {
                    throw new ParseException("Unexpected character.", n3);
                }
            }
        }
        return duration;
    }

    private static final int lookupDigit(String string, int n) {
        char c;
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3 && (c = string.charAt(n2)) >= '0' && '9' >= c; ++n2) {
        }
        return n2 - n;
    }

    Duration() {
        this.millisecond = 0;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.day = 0;
        this.month = 0;
        this.year = 0;
    }

    public Duration(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.millisecond = n7;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public void addTo(Calendar calendar) {
        calendar.add(1, this.year);
        calendar.add(2, this.month);
        calendar.add(6, this.day);
        calendar.add(11, this.hour);
        calendar.add(12, this.minute);
        calendar.add(13, this.second);
        calendar.add(14, this.millisecond);
    }

    public String toString() {
        return "Duration(year=" + this.year + " month=" + this.month + " day=" + this.day + " hour=" + this.hour + " min=" + this.minute + " sec=" + this.second + " msec=" + this.millisecond + ")";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)object;
        return this.year == duration.year && this.month == duration.month && this.day == duration.day && this.hour == duration.hour && this.minute == duration.minute && this.second == duration.second && this.millisecond == duration.millisecond;
    }
}

