/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdUtil
implements IDResolver {
    private static final TraceComponent tc = Tr.register(IdUtil.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = IdUtil.class.getName();
    private static final String NS_XHTML = "http://www.w3.org/1999/xhtml";
    private static final String[][] KNOWN_IDATTRS = new String[][]{{Constants.NS_WSSE, "*", "Id"}, {Constants.NS_WSSE200207, "*", "Id"}, {Constants.NS_WSSE200204, "*", "Id"}, {Constants.NS_DSIG, "*", "Id"}, {Constants.NS_ENC, "*", "Id"}, {"http://www.w3.org/1999/xhtml", "*", "id"}};
    private static final String[][] KNOWN_GLOBAL_IDATTRS = new String[][]{{Constants.NS_WSU, "Id"}, {Constants.NS_WSU200207, "Id"}};
    private static Random randomgen = new Random();
    private static IdUtil instance = new IdUtil();
    protected String[][] known_idattrs = KNOWN_IDATTRS;
    protected String[][] known_global_idattrs = KNOWN_GLOBAL_IDATTRS;
    private static long id = 0L;

    protected IdUtil() {
    }

    public static IdUtil getInstance() {
        return instance;
    }

    public String getIdAttributeName(Element element) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdAttributeName(Element element[" + DOMUtil.getDisplayName(element) + "])");
        }
        String string = null;
        String string2 = element.getNamespaceURI();
        String string3 = element.getLocalName();
        for (n = 0; n < this.known_idattrs.length; ++n) {
            if (!this.known_idattrs[n][0].equals(string2) || !"*".equals(this.known_idattrs[n][1]) && !this.known_idattrs[n][1].equals(string3) || !element.hasAttribute(this.known_idattrs[n][2])) continue;
            string = this.known_idattrs[n][2];
            break;
        }
        for (n = 0; n < this.known_global_idattrs.length; ++n) {
            Attr attr = element.getAttributeNodeNS(this.known_global_idattrs[n][0], this.known_global_idattrs[n][1]);
            if (attr == null) continue;
            string = attr.getNodeName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdAttributeName(Element element) returns String[" + string + "]");
        }
        return string;
    }

    private boolean matchId(Element element, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchId(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String id[" + string + "]," + "boolean onlyWsu[" + bl + "])");
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = string.equals(NamespaceUtil.getWsuAttribute(element, "Id"));
        } else {
            String string2 = this.getIdAttributeName(element);
            boolean bl3 = bl2 = string2 != null && string.equals(element.getAttribute(string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchId(Element element,String id,boolean onlyWsu) returns boolean[" + bl2 + "]");
        }
        return bl2;
    }

    public String makeUniqueId(Document document, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeUniqueId(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "String base[" + string + "])");
        }
        String string2 = string + id++;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeUniqueId(Document doc,String base) returns String[" + string2 + "]");
        }
        return string2;
    }

    public void checkIdUniqueness(Document document) throws SoapSecurityException {
        Element element;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIdUniqueness(Document doc[" + DOMUtil.getDisplayName(document) + "])");
        }
        if (document != null && (element = document.getDocumentElement()) != null) {
            HashSet hashSet = new HashSet();
            IdUtil.checkIdUniqueness(element, hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIdUniqueness(Document doc)");
        }
    }

    private static void checkIdUniqueness(Node node, Set set) throws SoapSecurityException {
        Node node2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIdUniqueness(Node node[" + DOMUtil.getDisplayName(node) + "]," + "Set ids[" + set + "])");
        }
        if (node.getNodeType() == 1) {
            node2 = (Element)node;
            String string = IdUtil.getInstance().getIdAttributeName((Element)node2);
            if (string != null) {
                String string2 = node2.getAttribute(string);
                if (set.contains(string2)) {
                    throw SoapSecurityException.format("security.wssecurity.IdUtil.s01", string2);
                }
                set.add(string2);
            }
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 && node2.getNodeType() != 5) continue;
            IdUtil.checkIdUniqueness(node2, set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIdUniqueness(Node node,Set ids)");
        }
    }

    public Element resolveID(Document document, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveID(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "String id[" + string + "])");
        }
        Element element = this.resolveId0(document, string, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveID(Document doc,String id) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    public boolean findId(Document document, String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findId(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "String id[" + string + "])");
        }
        boolean bl2 = bl = this.resolveId0(document, string, false) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findId(Document doc,String id) returns boolean[" + bl + "]");
        }
        return bl;
    }

    public boolean findWsuId(Document document, String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findWsuId(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "String id[" + string + "])");
        }
        boolean bl2 = bl = this.resolveId0(document, string, true) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findWsuId(Document doc,String id) returns boolean[" + bl + "]");
        }
        return bl;
    }

    private Element resolveId0(Document document, String string, boolean bl) {
        if (document == null) {
            return null;
        }
        Element element = document.getElementById(string);
        if (element != null) {
            return element;
        }
        return this.resolve(document.getDocumentElement(), string, bl);
    }

    protected Element resolveId(Node node, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveId(Node node[" + DOMUtil.getDisplayName(node) + "]," + "String id[" + string + "])");
        }
        Element element = null;
        if (node != null) {
            element = this.resolve(node, string, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveId(Node node,String id) returns Element[" + DOMUtil.getDisplayName(element) + "]");
        }
        return element;
    }

    private Element resolve(Node node, String string, boolean bl) {
        if (node.getNodeType() == 1 && this.matchId((Element)node, string, bl)) {
            return (Element)node;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Element element;
            if (node2.getNodeType() != 1 && node2.getNodeType() != 5 || (element = this.resolve(node2, string, bl)) == null) continue;
            return element;
        }
        return null;
    }

    public String getId(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getId(Element element[" + DOMUtil.getDisplayName(element) + "])");
        }
        String string = null;
        String string2 = this.getIdAttributeName(element);
        if (string2 != null) {
            string = element.getAttribute(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getId(Element element) returns String[" + string + "]");
        }
        return string;
    }
}

