/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingDeclReader;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.api.util.encoding.IANACharset;
import com.ibm.xml.xlxp.api.util.encoding.RewindableInputStream;
import com.ibm.xml.xlxp.api.util.encoding.UCSEncodingSupport;
import com.ibm.xml.xlxp.api.util.encoding.UTF8EncodingSupport;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.scan.util.XMLString;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class SimpleParsedEntityFactory
implements ParsedEntityFactory {
    public static final boolean REQUIRE_IANA_ENCODING_NAMES = false;
    private static final int FREE_ENTITY_COUNT = 8;
    private static final int FREE_STREAM_COUNT = 8;
    private String[] fCharsetName;
    private int fFreeEntityCount;
    private ParsedEntity[] fFreeEntities;
    private int fFreeStreamCount;
    private RewindableInputStream[] fFreeStreams;
    private DataSourceFactory fSourceFactory;
    private int fIDCounter;
    private boolean fCheckAvailable = Boolean.getBoolean("com.ibm.xml.xlxp.api.util.SimpleParsedEntityFactory.checkAvailable");
    private EncodingSupport fUTF8EncodingSupport;
    private EncodingDeclReader fEncodingDeclReader;

    public SimpleParsedEntityFactory(DataBufferFactory dataBufferFactory) {
        this.fSourceFactory = new DataSourceFactory(dataBufferFactory);
        this.fUTF8EncodingSupport = UTF8EncodingSupport.getInstance();
        this.fFreeEntities = new ParsedEntity[8];
        this.fFreeStreams = new RewindableInputStream[8];
        this.fCharsetName = new String[1];
        this.fEncodingDeclReader = new EncodingDeclReader();
    }

    public void setBufferLength(int n) {
        this.fSourceFactory.setBufferLength(n);
    }

    public void reset(boolean bl) {
        if (!bl) {
            while (this.fFreeEntityCount > 0) {
                --this.fFreeEntityCount;
                this.fFreeEntities[this.fFreeEntityCount] = null;
            }
        }
    }

    public ParsedEntity createParsedEntity(InputStream inputStream, String string) {
        ParsedEntity parsedEntity = this.getFreeEntity();
        try {
            this.setByteStreamSource(parsedEntity, inputStream, string, true);
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        return parsedEntity;
    }

    protected final ParsedEntity getFreeEntity() {
        ParsedEntity parsedEntity;
        if (this.fFreeEntityCount > 0) {
            parsedEntity = this.fFreeEntities[--this.fFreeEntityCount];
            this.fFreeEntities[this.fFreeEntityCount] = null;
        } else {
            parsedEntity = new ParsedEntity(this);
        }
        parsedEntity.id = this.fIDCounter++;
        return parsedEntity;
    }

    public ParsedEntity createParsedEntityFromXMLString(XMLString xMLString, String string) {
        ParsedEntity parsedEntity = this.getFreeEntity();
        parsedEntity.baseURI = string;
        parsedEntity.setContent(xMLString);
        return parsedEntity;
    }

    public void releaseParsedEntity(ParsedEntity parsedEntity) {
        parsedEntity.clear();
        if (this.fFreeEntityCount < 8) {
            this.fFreeEntities[this.fFreeEntityCount++] = parsedEntity;
        }
    }

    protected final void setByteStreamSource(ParsedEntity parsedEntity, InputStream inputStream, String string, boolean bl) throws IOException {
        if (string == null) {
            this.detectEncodingSetSource(parsedEntity, inputStream, bl);
        } else {
            this.fCharsetName[0] = string.toUpperCase();
            EncodingSupport encodingSupport = IANACharset.getEncodingSupport(this.fCharsetName);
            if (encodingSupport != null) {
                this.loadFromByteStream(parsedEntity, inputStream, this.fCharsetName[0], true, encodingSupport);
            } else {
                this.convertByteStreamWithUnknownEncoding(parsedEntity, inputStream, string);
            }
        }
    }

    protected final void setCharacterStreamSource(ParsedEntity parsedEntity, Reader reader) {
        this.loadFromCharacterStream(parsedEntity, reader);
    }

    private void detectEncodingSetSource(ParsedEntity parsedEntity, InputStream inputStream, boolean bl) throws IOException {
        String string = null;
        boolean bl2 = false;
        RewindableInputStream rewindableInputStream = this.createRewindableInputStream(inputStream);
        this.fEncodingDeclReader.setSource(rewindableInputStream, bl);
        int n = this.fEncodingDeclReader.detectEncoding();
        switch (n) {
            default: {
                this.loadFromByteStream(parsedEntity, rewindableInputStream, "UTF-8", false, this.fUTF8EncodingSupport);
                return;
            }
            case 2: {
                this.loadFromByteStream(parsedEntity, rewindableInputStream, "UTF-16BE", false, UCSEncodingSupport.getInstance(0));
                return;
            }
            case 3: {
                this.loadFromByteStream(parsedEntity, rewindableInputStream, "UTF-16LE", false, UCSEncodingSupport.getInstance(1));
                return;
            }
            case 4: {
                this.loadFromByteStream(parsedEntity, rewindableInputStream, "UTF-32BE", false, UCSEncodingSupport.getInstance(2));
                return;
            }
            case 5: {
                this.loadFromByteStream(parsedEntity, rewindableInputStream, "UTF-32LE", false, UCSEncodingSupport.getInstance(3));
                return;
            }
            case 6: {
                string = this.fEncodingDeclReader.getLatinEncoding();
                break;
            }
            case 7: {
                string = this.fEncodingDeclReader.getEBCDICEncoding();
                break;
            }
            case 8: {
                string = this.fEncodingDeclReader.getUCSEncoding(2, true);
                bl2 = true;
                break;
            }
            case 9: {
                string = this.fEncodingDeclReader.getUCSEncoding(2, false);
                bl2 = true;
                break;
            }
            case 10: {
                string = this.fEncodingDeclReader.getUCSEncoding(4, true);
                bl2 = true;
                break;
            }
            case 11: {
                string = this.fEncodingDeclReader.getUCSEncoding(4, false);
                bl2 = true;
            }
        }
        rewindableInputStream.rewind();
        if (string == null) {
            this.loadFromByteStream(parsedEntity, rewindableInputStream, "UTF-8", false, this.fUTF8EncodingSupport);
        } else {
            this.fCharsetName[0] = string.toUpperCase();
            EncodingSupport encodingSupport = IANACharset.getEncodingSupport(this.fCharsetName);
            if (encodingSupport != null) {
                this.loadFromByteStream(parsedEntity, rewindableInputStream, this.fCharsetName[0], bl2, encodingSupport);
            } else {
                this.convertByteStreamWithUnknownEncoding(parsedEntity, rewindableInputStream, string);
            }
        }
    }

    private final void loadFromByteStream(ParsedEntity parsedEntity, InputStream inputStream, String string, boolean bl, EncodingSupport encodingSupport) {
        encodingSupport.loadFromByteStream(parsedEntity, inputStream, string, bl, this.fCheckAvailable, this.fSourceFactory);
    }

    private final void loadFromCharacterStream(ParsedEntity parsedEntity, Reader reader) {
        CharacterStreamDataSource characterStreamDataSource = this.fSourceFactory.allocateCharacterStreamDataSource();
        characterStreamDataSource.setCharacterStream(reader);
        characterStreamDataSource.load(parsedEntity);
    }

    private final void convertByteStreamWithUnknownEncoding(ParsedEntity parsedEntity, InputStream inputStream, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        this.loadFromCharacterStream(parsedEntity, inputStreamReader);
    }

    private RewindableInputStream createRewindableInputStream(InputStream inputStream) {
        RewindableInputStream rewindableInputStream;
        if (this.fFreeStreamCount > 0) {
            rewindableInputStream = this.fFreeStreams[--this.fFreeStreamCount];
            rewindableInputStream.setStream(inputStream);
        } else {
            rewindableInputStream = new RewindableInputStream(this, inputStream);
        }
        return rewindableInputStream;
    }

    public void releaseRewindableInputStream(RewindableInputStream rewindableInputStream) {
        if (this.fFreeStreamCount < 8) {
            this.fFreeStreams[this.fFreeStreamCount++] = rewindableInputStream;
        }
    }
}

