/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.atcc;

import com.tivoli.pd.as.atcc.IATCCache;
import com.tivoli.pd.as.atcc.ICmdCache;
import com.tivoli.pd.as.atcc.IObjectTreeCache;
import com.tivoli.pd.as.rbpf.AmasCmdObject;
import com.tivoli.pd.as.rbpf.AmasPDObjectDirect;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.AmasUtil;
import com.tivoli.pd.jazn.PDAuthorizationContext;
import com.tivoli.pd.jazn.PDLocalServer;
import com.tivoli.pd.jazn.PDReplicaDbUpdate;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import com.tivoli.pd.jutil.PDAttrs;
import com.tivoli.pd.jutil.PDBasicContext;
import com.tivoli.pd.jutil.PDException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ATCCacheImpl
implements PDReplicaDbUpdate,
IATCCache {
    private final String ATCCacheImpl_java_sourceCodeID = "$Id: @(#)90  1.4 src/amas/com/tivoli/pd/as/atcc/ATCCacheImpl.java, amemb.jacc.was, amemb600, 051118a 05/05/06 01:41:19 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private IObjectTreeCache _objectCache;
    private ICmdCache _cmdCache;
    private boolean _enabled = false;
    private Properties _props;
    private boolean _rollbackEnabled = false;
    private boolean _retryEnabled = false;
    private int _retryTimes = 0;
    private AmasSession _sess;
    private long _dbLatestVersion = -1L;
    private long _dbCurrentVersion = -1L;
    private boolean _replicaReturned = false;
    private boolean _allowCacheUpdate = true;
    private boolean _initialized = false;
    private int _policyRefreshWait = 20;
    private ILogger _traceLogger;
    private ILogger _msgLogger;
    private static final String CLASSNAME = "com.tivoli.pd.as.attc.ATCCacheImpl";
    private static final String CMDCACHE_PROPERTY = "com.tivoli.pd.as.atcc.CmdCache";
    private static final String OBJECTCACHE_PROPERTY = "com.tivoli.pd.as.atcc.ObjectTreeCache";
    private static final String POLICY_REFRESH_PROPERTY = "com.tivoli.pd.as.atcc.PolicyRefreshWait";
    private static final String RETRY_TIMES_PROPERTY = "com.tivoli.pd.as.atcc.RetryTimes";
    private static final String RETRY_ENABLED_PROPERTY = "com.tivoli.pd.as.atcc.RetryEnabled";
    private static final String ROLLBACK_ENABLED_PROPERTY = "com.tivoli.pd.as.atcc.RollbackEnabled";

    public void initialize(AmasSession amasSession) {
        Object object;
        Object object2;
        block25: {
            Object object3;
            this._initialized = false;
            this._sess = amasSession;
            this._props = amasSession.getProperties();
            this._traceLogger = LogManager.getManager().getTraceLogger("AmasCacheTraceLogger");
            this._msgLogger = LogManager.getManager().getMessageLogger("AmasCacheMessageLogger");
            String string = null;
            string = this._props.getProperty(OBJECTCACHE_PROPERTY);
            if (string == null) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    object3 = new AmasMessage(916942877);
                    this._msgLogger.text(2L, (Object)CLASSNAME, "<init>", ((AmasMessage)object3).getMessageString());
                }
                this._objectCache = null;
            } else {
                try {
                    object3 = Class.forName(string);
                    this._objectCache = (IObjectTreeCache)((Class)object3).newInstance();
                    this._objectCache.initialize(this._props);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        object2 = new AmasMessage(916942875, string);
                        this._msgLogger.text(4L, (Object)this, "<init>", ((AmasMessage)object2).getMessageString());
                    }
                    this._objectCache = null;
                }
                catch (InstantiationException instantiationException) {
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        object2 = new AmasMessage(916942876, string);
                        this._msgLogger.text(4L, (Object)this, "<init>", ((AmasMessage)object2).getMessageString());
                    }
                    this._objectCache = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        object2 = new AmasMessage(916942876, string);
                        this._msgLogger.text(4L, (Object)this, "<init>", ((AmasMessage)object2).getMessageString());
                    }
                    this._objectCache = null;
                }
            }
            object3 = null;
            object3 = this._props.getProperty(CMDCACHE_PROPERTY);
            if (object3 == null) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    object2 = new AmasMessage(916942877);
                    this._msgLogger.text(2L, (Object)CLASSNAME, "<init>", ((AmasMessage)object2).getMessageString());
                }
                this._cmdCache = null;
            } else {
                try {
                    object2 = Class.forName((String)object3);
                    this._cmdCache = (ICmdCache)((Class)object2).newInstance();
                    this._cmdCache.initialize(this._props);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        object = new AmasMessage(916942875, object3);
                        this._msgLogger.text(4L, (Object)this, "<init>", ((AmasMessage)object).getMessageString());
                    }
                    this._cmdCache = null;
                }
                catch (InstantiationException instantiationException) {
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        object = new AmasMessage(916942876, object3);
                        this._msgLogger.text(4L, (Object)this, "<init>", ((AmasMessage)object).getMessageString());
                    }
                    this._cmdCache = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        object = new AmasMessage(916942876, object3);
                        this._msgLogger.text(4L, (Object)this, "<init>", ((AmasMessage)object).getMessageString());
                    }
                    this._cmdCache = null;
                }
            }
            try {
                PDLocalServer.registerForDbUpdates((PDAuthorizationContext)amasSession.getSessionContext(), (Object)this);
            }
            catch (PDException pDException) {
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    object = new AmasMessage(916942911, pDException.toString());
                    this._msgLogger.text(8L, (Object)CLASSNAME, "<init>", ((AmasMessage)object).getMessageString());
                }
            }
            catch (AmasException amasException) {
                if (this._msgLogger == null || !this._msgLogger.isLogging()) break block25;
                object = new AmasMessage(916942911, amasException.toString());
                this._msgLogger.text(8L, (Object)CLASSNAME, "<init>", ((AmasMessage)object).getMessageString());
            }
        }
        object2 = this._props.getProperty(RETRY_TIMES_PROPERTY);
        this._retryTimes = AmasUtil.parseIntProp((String)object2, this._retryTimes);
        object = this._props.getProperty(RETRY_ENABLED_PROPERTY);
        this._retryEnabled = AmasUtil.checkBoolProperty((String)object, this._retryEnabled);
        String string = this._props.getProperty(ROLLBACK_ENABLED_PROPERTY);
        this._rollbackEnabled = AmasUtil.checkBoolProperty(string, this._rollbackEnabled);
        String string2 = this._props.getProperty(POLICY_REFRESH_PROPERTY, "20");
        this._policyRefreshWait = AmasUtil.parseIntProp(string2, this._policyRefreshWait);
        if (this._objectCache != null && this._cmdCache != null) {
            this._initialized = true;
        }
    }

    public void enableTransaction() {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "enableTransaction()");
        }
        if (!this._enabled && this._initialized) {
            this._enabled = true;
            this.primeCache();
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "enableTransaction()");
        }
    }

    public IObjectTreeCache getObjectCache() {
        return this._objectCache;
    }

    public ICmdCache getCmdCache() {
        return this._cmdCache;
    }

    public void primeCache() {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "primeCache()");
        }
        if (this._enabled) {
            block17: {
                Object object;
                block16: {
                    this._replicaReturned = false;
                    this._sess.policyRefresh();
                    try {
                        int n = 0;
                        while (!this._replicaReturned) {
                            Thread.sleep(1000L);
                            if (++n != this._policyRefreshWait) continue;
                            this._replicaReturned = true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        object = new AmasMessage(916942910, interruptedException.toString());
                        if (this._msgLogger == null || !this._msgLogger.isLogging()) break block16;
                        this._msgLogger.message(4L, (Object)CLASSNAME, "primeCache()", ((AmasMessage)object).getMessageString());
                    }
                }
                this._replicaReturned = false;
                this.clearCache();
                IObjectTreeCache iObjectTreeCache = this.getObjectCache();
                try {
                    Object object2;
                    Object object3;
                    Object object4;
                    object = PDLocalServer.listLocalObjects((PDAuthorizationContext)this._sess.getSessionContext(), (String)this._sess.getRoleContainerName(), (boolean)true);
                    if (object != null) {
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.message(16L, (Object)CLASSNAME, "primeCache()", "Adding " + ((ArrayList)object).size() + " roles to cache");
                        }
                        object4 = ((ArrayList)object).iterator();
                        while (object4.hasNext()) {
                            object3 = (String)object4.next();
                            object2 = new PDAttrs((PDBasicContext)this._sess.getSessionContext());
                            boolean bl = PDLocalServer.getPObjExtAttributes((PDAuthorizationContext)this._sess.getSessionContext(), (String)object3, (boolean)false, (PDAttrs)object2);
                            AmasPDObjectDirect amasPDObjectDirect = new AmasPDObjectDirect(this._sess, (String)object3);
                            amasPDObjectDirect.setAttr((PDAttrs)object2);
                            iObjectTreeCache.addEntry((String)object3, amasPDObjectDirect);
                        }
                    }
                    if ((object4 = PDLocalServer.listLocalObjects((PDAuthorizationContext)this._sess.getSessionContext(), (String)this._sess.getResourceContainerName(), (boolean)true)) != null) {
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.message(16L, (Object)CLASSNAME, "primeCache()", "Adding " + ((ArrayList)object4).size() + " resources to cache");
                        }
                        object3 = ((ArrayList)object4).iterator();
                        while (object3.hasNext()) {
                            object2 = (String)object3.next();
                            PDAttrs pDAttrs = new PDAttrs((PDBasicContext)this._sess.getSessionContext());
                            boolean bl = PDLocalServer.getPObjExtAttributes((PDAuthorizationContext)this._sess.getSessionContext(), (String)object2, (boolean)false, (PDAttrs)pDAttrs);
                            AmasPDObjectDirect amasPDObjectDirect = new AmasPDObjectDirect(this._sess, (String)object2);
                            amasPDObjectDirect.setAttr(pDAttrs);
                            iObjectTreeCache.addEntry((String)object2, amasPDObjectDirect);
                        }
                    }
                    this._dbCurrentVersion = this._dbLatestVersion;
                }
                catch (PDException pDException) {
                    AmasMessage amasMessage = new AmasMessage(916942910, pDException.toString());
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.message(4L, (Object)CLASSNAME, "primeCache()", amasMessage.getMessageString());
                    }
                }
                catch (AmasException amasException) {
                    AmasMessage amasMessage = new AmasMessage(916942910, amasException.toString());
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block17;
                    this._msgLogger.message(4L, (Object)CLASSNAME, "primeCache()", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)CLASSNAME, "primeCache()");
            }
        }
    }

    public void validateCache() {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "validateCache()");
        }
        if (this._enabled) {
            AmasMessage amasMessage;
            AmasCmdObject amasCmdObject;
            this.primeCache();
            ICmdCache iCmdCache = this.getCmdCache();
            List list = iCmdCache.getCmds();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                amasCmdObject = (AmasCmdObject)iterator.next();
                if (amasCmdObject.checkCmd()) continue;
                if (this._allowCacheUpdate) {
                    iCmdCache.deleteCmd(amasCmdObject);
                    iCmdCache.addFailedCmd(amasCmdObject);
                    continue;
                }
                amasMessage = new AmasMessage(916942927, "CMD [" + amasCmdObject.printCmd() + "]");
                if (this._msgLogger == null || !this._msgLogger.isLogging()) continue;
                this._msgLogger.message(4L, (Object)CLASSNAME, "validateCache()", amasMessage.getMessageString());
            }
            list = iCmdCache.getFailedCmds();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                amasCmdObject = (AmasCmdObject)iterator.next();
                if (!amasCmdObject.checkCmd()) continue;
                if (this._allowCacheUpdate) {
                    iCmdCache.deleteFailedCmd(amasCmdObject);
                    iCmdCache.addCmd(amasCmdObject);
                    continue;
                }
                amasMessage = new AmasMessage(916942928, "CMD [" + amasCmdObject.printCmd() + "]");
                if (this._msgLogger == null || !this._msgLogger.isLogging()) continue;
                this._msgLogger.message(4L, (Object)CLASSNAME, "validateCache()", amasMessage.getMessageString());
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "validateCache()");
        }
    }

    public void retryTransactions() {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "retryTransaction()");
        }
        if (this._retryEnabled && this._initialized) {
            for (int i = 0; this._retryTimes > i; ++i) {
                ICmdCache iCmdCache = this.getCmdCache();
                if (iCmdCache.hasFailedCmds()) {
                    List list = iCmdCache.getFailedCmds();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        AmasCmdObject amasCmdObject = (AmasCmdObject)iterator.next();
                        if (!amasCmdObject.execCmd()) continue;
                        iCmdCache.deleteFailedCmd(amasCmdObject);
                        iCmdCache.addCmd(amasCmdObject);
                    }
                    continue;
                }
                i = this._retryTimes;
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "retryTransaction()");
        }
    }

    public void rollbackTransactions() {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "rollbackTransaction()");
        }
        if (this._rollbackEnabled && this._initialized) {
            AmasCmdObject amasCmdObject;
            AmasCmdObject amasCmdObject2;
            Iterator iterator;
            List list;
            ICmdCache iCmdCache = this.getCmdCache();
            if (iCmdCache.hasFailedCmds()) {
                list = iCmdCache.getCmds();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    amasCmdObject2 = (AmasCmdObject)iterator.next();
                    amasCmdObject = amasCmdObject2.getRollbackCmd();
                    if (!amasCmdObject.execCmd()) continue;
                    iCmdCache.deleteCmd(amasCmdObject2);
                    iCmdCache.addFailedCmd(amasCmdObject2);
                }
            }
            if (iCmdCache.hasCmds()) {
                list = iCmdCache.getCmds();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    amasCmdObject2 = (AmasCmdObject)iterator.next();
                    amasCmdObject = amasCmdObject2.getRollbackCmd();
                    if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                    this._traceLogger.exit(16L, (Object)CLASSNAME, "rollbackTransactions()", (Object)("command used = " + amasCmdObject2.printCmd()));
                    this._traceLogger.exit(16L, (Object)CLASSNAME, "rollbackTransactions()", (Object)("rollback command used = " + amasCmdObject.printCmd()));
                }
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "retryTransaction()");
        }
    }

    public boolean runTransaction(AmasCmdObject amasCmdObject) throws AmasException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "runTransaction()");
        }
        boolean bl = false;
        if (this._enabled && this._initialized) {
            ICmdCache iCmdCache = this.getCmdCache();
            bl = amasCmdObject.execCmd();
            if (bl) {
                iCmdCache.addCmd(amasCmdObject);
            } else if (this._retryEnabled) {
                iCmdCache.addFailedCmd(amasCmdObject);
            } else {
                AmasMessage amasMessage = new AmasMessage(916942856, "Execution of command '" + amasCmdObject.printCmd() + "' failed. " + "Error message logged by command is '" + amasCmdObject.getErrorMessage() + "'");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.message(4L, (Object)CLASSNAME, "primeCache()", amasMessage.getMessageString());
                }
                throw new AmasException(amasMessage);
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "runTransaction()");
        }
        return bl;
    }

    public void disableTransaction() {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "disableTransaction()");
        }
        if (this._enabled) {
            this.retryTransactions();
            this._enabled = false;
            this.clearCache();
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "disableTransaction()");
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void replicaDbUpdate(String string) {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "replicaDbUpdate(String dbReplica) { dbReplica = " + string + " }");
        }
        this._replicaReturned = true;
        this._dbLatestVersion = Long.parseLong(string);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "replicaDbUpdate(String)");
        }
    }

    private void clearCache() {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "clearCache()");
        }
        if (this._initialized) {
            if (this._cmdCache != null && this._cmdCache.isInitialized()) {
                this._cmdCache.removeAll();
            }
            if (this._objectCache != null && this._objectCache.isInitialized()) {
                this._objectCache.removeAll();
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "clearCache()");
        }
    }
}

