/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.atcc;

import com.tivoli.pd.as.atcc.ICmdCache;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.RWLock;
import com.tivoli.pd.as.util.RWLockException;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CmdCacheImpl
implements ICmdCache {
    private final String CmdCacheImpl_java_sourceCodeID = "$Id: @(#)91  1.2 src/amas/com/tivoli/pd/as/atcc/CmdCacheImpl.java, amemb.jacc.was, amemb600, 051118a 05/05/06 01:41:19 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private List _failedCmds = new ArrayList();
    private List _cmds = new ArrayList();
    private boolean _initialized = false;
    private RWLock _rwLockCmd;
    private RWLock _rwLockFailed;
    private ILogger _traceLogger = LogManager.getManager().getTraceLogger("AmasCacheTraceLogger");
    private ILogger _msgLogger = LogManager.getManager().getMessageLogger("AmasCacheMessageLogger");
    static /* synthetic */ Class class$com$tivoli$pd$as$atcc$CmdCacheImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Properties properties) {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "initialize(Properties) ");
        }
        if (!this._initialized) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)this, "initialize(Properties)", "Enabling cache");
            }
            Class clazz = class$com$tivoli$pd$as$atcc$CmdCacheImpl == null ? (class$com$tivoli$pd$as$atcc$CmdCacheImpl = CmdCacheImpl.class$("com.tivoli.pd.as.atcc.CmdCacheImpl")) : class$com$tivoli$pd$as$atcc$CmdCacheImpl;
            synchronized (clazz) {
                this._rwLockCmd = new RWLock();
                this._rwLockFailed = new RWLock();
                this._initialized = true;
            }
        } else if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.text(16L, (Object)this, "initialize(Properties)", "Cache already initialized");
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "initialize(Properties)");
        }
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void addFailedCmd(Object object) {
        if (this._initialized) {
            block7: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "addFailedCmd(Object cmd) ");
                }
                try {
                    boolean bl = this._rwLockFailed.getWriterLock();
                    if (bl) {
                        this._failedCmds.add(object);
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "addFailedCmd(Object)", "Adding entry for object [" + object.toString() + "]");
                        }
                        this._rwLockFailed.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "addFailedCmd(Object)", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "addFailedCmd(Object)");
            }
        }
    }

    public void addCmd(Object object) {
        if (this._initialized) {
            block7: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "addCmd(Object cmd) ");
                }
                try {
                    boolean bl = this._rwLockCmd.getWriterLock();
                    if (bl) {
                        this._cmds.add(0, object);
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "addCmd(Object)", "Adding entry for object [" + object.toString() + "]");
                        }
                        this._rwLockCmd.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "addCmd(Object)", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "addCmd(Object)");
            }
        }
    }

    public boolean deleteFailedCmd(Object object) {
        boolean bl;
        block6: {
            bl = false;
            if (this._initialized) {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "deleteFailedCmd()");
                }
                try {
                    boolean bl2 = this._rwLockFailed.getWriterLock();
                    if (bl2) {
                        bl = this._failedCmds.contains(object) ? this._failedCmds.remove(object) : true;
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "deleteFailedCmd()", amasMessage.getMessageString());
                }
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "deleteFailedCmd()");
        }
        return bl;
    }

    public boolean deleteCmd(Object object) {
        boolean bl;
        block6: {
            bl = false;
            if (this._initialized) {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "deleteCmd()");
                }
                try {
                    boolean bl2 = this._rwLockCmd.getWriterLock();
                    if (bl2) {
                        bl = this._cmds.contains(object) ? this._cmds.remove(object) : true;
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "deleteFailedCmd()", amasMessage.getMessageString());
                }
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "deleteCmd()");
        }
        return bl;
    }

    public List getFailedCmds() {
        ArrayList arrayList = new ArrayList();
        if (this._initialized) {
            block7: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "getFailedCmds() ");
                }
                try {
                    boolean bl = this._rwLockFailed.getReaderLock();
                    if (bl) {
                        arrayList = new ArrayList(this._failedCmds);
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "getFailedCmds()", "Getting the failed command list");
                        }
                        this._rwLockFailed.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "getFailedCmds()", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "getFailedCmds()");
            }
        }
        return arrayList;
    }

    public List getCmds() {
        ArrayList arrayList = new ArrayList();
        if (this._initialized) {
            block7: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "getCmds() ");
                }
                try {
                    boolean bl = this._rwLockCmd.getReaderLock();
                    if (bl) {
                        arrayList = new ArrayList(this._cmds);
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "getCmds()", "Getting the command list ");
                        }
                        this._rwLockCmd.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "getCmds()", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "getCmds()");
            }
        }
        return arrayList;
    }

    public void removeAll() {
        if (this._initialized) {
            block7: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "removeAll() ");
                }
                try {
                    boolean bl = this._rwLockFailed.getWriterLock();
                    boolean bl2 = this._rwLockCmd.getWriterLock();
                    if (bl && bl2) {
                        this._failedCmds.clear();
                        this._cmds.clear();
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "removeAll()", "Cleaning caches ");
                        }
                        this._rwLockFailed.releaseLock();
                        this._rwLockCmd.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removeAll()", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "removeAll()");
            }
        }
    }

    public boolean hasFailedCmds() {
        boolean bl = false;
        if (this._failedCmds.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean hasCmds() {
        boolean bl = false;
        if (this._cmds.size() > 0) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

