/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.atcc;

import com.tivoli.pd.as.atcc.IObjectTreeCache;
import com.tivoli.pd.as.atcc.ObjectTreeCacheNode;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.RWLock;
import com.tivoli.pd.as.util.RWLockException;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ObjectTreeCacheImpl
implements IObjectTreeCache {
    private final String ObjectTreeCacheImpl_java_sourceCodeID = "$Id: @(#)96  1.2 src/amas/com/tivoli/pd/as/atcc/ObjectTreeCacheImpl.java, amemb.jacc.was, amemb600, 051118a 05/05/06 01:41:20 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static boolean CREATE_PATH = true;
    private static boolean NO_CREATE_PATH = false;
    private static String _delim = "/";
    private boolean _initialized = false;
    private Properties _cfg = null;
    private ILogger _msgLogger;
    private ILogger _traceLogger;
    private ObjectTreeCacheNode _rootNode = null;
    private RWLock _rwLock = null;

    public void initialize(Properties properties) {
        String string;
        this._initialized = false;
        this._cfg = properties;
        this._traceLogger = LogManager.getManager().getTraceLogger("AmasCacheTraceLogger");
        this._msgLogger = LogManager.getManager().getMessageLogger("AmasCacheMessageLogger");
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "initialize(Properties)");
        }
        if ((string = this._cfg.getProperty("com.tivoli.pd.as.cache.EnableObjectCaching")) == null || string.equalsIgnoreCase("true")) {
            this._rootNode = new ObjectTreeCacheNode("Root", null, null);
            this._rwLock = new RWLock();
            this._initialized = true;
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "initialize(Properties)");
        }
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void addEntry(String string, Object object) {
        if (this._initialized) {
            block6: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "addEntry('" + string + "', " + object + ")");
                }
                try {
                    boolean bl = this._rwLock.getWriterLock();
                    if (bl) {
                        ObjectTreeCacheNode objectTreeCacheNode = this.findNode(string, CREATE_PATH);
                        objectTreeCacheNode.setObject(object);
                        this._rwLock.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "addEntry()", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "addEntry(String, Object)");
            }
        }
    }

    public void removeEntry(String string) {
        if (this._initialized) {
            block7: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "removeEntry('" + string + "')");
                }
                try {
                    boolean bl = this._rwLock.getWriterLock();
                    if (bl) {
                        ObjectTreeCacheNode objectTreeCacheNode = this.findNode(string, NO_CREATE_PATH);
                        if (objectTreeCacheNode != null) {
                            objectTreeCacheNode.setObject(null);
                        }
                        this._rwLock.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removeEntry()", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "removeEntry(String)");
            }
        }
    }

    public Object getEntry(String string) {
        Object object = null;
        if (this._initialized) {
            block7: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "getEntry('" + string + "')");
                }
                try {
                    boolean bl = this._rwLock.getReaderLock();
                    if (bl) {
                        ObjectTreeCacheNode objectTreeCacheNode = this.findNode(string, NO_CREATE_PATH);
                        if (objectTreeCacheNode != null) {
                            object = objectTreeCacheNode.getObject();
                        }
                        this._rwLock.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "getEntry()", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "getEntry(String)");
            }
        }
        return object;
    }

    public void removeAll() {
        block3: {
            try {
                boolean bl = this._rwLock.getWriterLock();
                if (bl) {
                    this._rootNode = new ObjectTreeCacheNode("Root", null, null);
                }
                this._rwLock.releaseLock();
            }
            catch (RWLockException rWLockException) {
                if (this._msgLogger == null || !this._msgLogger.isLogging()) break block3;
                AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                this._msgLogger.text(4L, (Object)this, "removeAll()", amasMessage.getMessageString());
            }
        }
    }

    public void removeOldest(int n) {
    }

    public void removeOldestExpired(int n) {
    }

    public List listChildren(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._initialized) {
            block8: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "listChildren('" + string + "')");
                }
                try {
                    boolean bl = this._rwLock.getReaderLock();
                    if (bl) {
                        ObjectTreeCacheNode objectTreeCacheNode = this.findNode(string);
                        if (objectTreeCacheNode != null) {
                            List list = objectTreeCacheNode.getChildren();
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                arrayList.add(string + _delim + ((ObjectTreeCacheNode)iterator.next()).getName());
                            }
                        }
                        this._rwLock.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block8;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "listChildren()", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "listChildren(String)");
            }
        }
        return arrayList;
    }

    public List getChildren(String string) {
        return null;
    }

    public String toString() {
        if (this._initialized) {
            return this.toStringRecursive("", this._rootNode);
        }
        return "Cache not initialized";
    }

    private String toStringRecursive(String string, ObjectTreeCacheNode objectTreeCacheNode) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(objectTreeCacheNode.getName());
        stringBuffer.append(" [");
        stringBuffer.append(objectTreeCacheNode.getObject());
        stringBuffer.append("]");
        stringBuffer.append("\n");
        List list = objectTreeCacheNode.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = string + objectTreeCacheNode.getName() + _delim;
            stringBuffer.append(this.toStringRecursive(string2, (ObjectTreeCacheNode)iterator.next()));
        }
        return stringBuffer.toString();
    }

    private ObjectTreeCacheNode findNode(String string) {
        return this.findNode(string, NO_CREATE_PATH);
    }

    private ObjectTreeCacheNode findNode(String string, boolean bl) {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "findNode('" + string + "', " + bl + ")");
        }
        if (string.startsWith(_delim)) {
            string = string.substring(1);
        }
        String[] stringArray = string.split(_delim);
        ObjectTreeCacheNode objectTreeCacheNode = null;
        ObjectTreeCacheNode objectTreeCacheNode2 = this._rootNode;
        for (int i = 0; i < stringArray.length; ++i) {
            List list = objectTreeCacheNode2.getChildren();
            if (!(list != null && list.size() != 0 || bl)) {
                objectTreeCacheNode2 = null;
                break;
            }
            ObjectTreeCacheNode objectTreeCacheNode3 = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectTreeCacheNode objectTreeCacheNode4 = (ObjectTreeCacheNode)iterator.next();
                if (!objectTreeCacheNode4.getName().equals(stringArray[i])) continue;
                objectTreeCacheNode3 = objectTreeCacheNode4;
                break;
            }
            if (objectTreeCacheNode3 == null) {
                if (bl) {
                    objectTreeCacheNode3 = new ObjectTreeCacheNode(stringArray[i], null, objectTreeCacheNode2);
                    objectTreeCacheNode2.addChild(objectTreeCacheNode3);
                } else {
                    objectTreeCacheNode2 = null;
                    break;
                }
            }
            objectTreeCacheNode2 = objectTreeCacheNode3;
        }
        objectTreeCacheNode = objectTreeCacheNode2;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "findNode()");
        }
        return objectTreeCacheNode;
    }
}

