/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.cache;

import com.tivoli.pd.as.cache.DynamicRolePurgeTask;
import com.tivoli.pd.as.cache.GenericCache;
import com.tivoli.pd.as.cache.GenericCacheEntry;
import com.tivoli.pd.as.cache.IDynamicRoleCache;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.RWLock;
import com.tivoli.pd.as.util.RWLockException;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class DynamicRoleCacheImpl
implements IDynamicRoleCache {
    private final String DynamicRoleCacheImpl_java_sourceCodeID = "$Id: @(#)63  1.4 src/amas/com/tivoli/pd/as/cache/DynamicRoleCacheImpl.java, amemb.jacc.was, amemb600, 051118a 05/03/30 00:56:18 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private boolean _initialized;
    private ILogger _trcLogger;
    private ILogger _msgLogger;
    private int _roleLifeTime;
    private int _numCaches;
    private GenericCache[] _theCaches;
    private RWLock[] _rwLocks;
    Timer _purgeScheduler;
    private Properties cfg = null;

    public void initialize(Properties properties) {
        String string;
        this.cfg = properties;
        this._initialized = false;
        this._roleLifeTime = -1;
        this._trcLogger = LogManager.getManager().getTraceLogger("AmasCacheTraceLogger");
        this._msgLogger = LogManager.getManager().getMessageLogger("AmasCacheMessageLogger");
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)this, "initialize(Properties)");
        }
        if ((string = this.cfg.getProperty("com.tivoli.pd.as.cache.EnableDynamicRoleCaching")) == null || string.equalsIgnoreCase("true")) {
            String string2 = this.cfg.getProperty("com.tivoli.pd.as.cache.DynamicRoleCache.PrincipalLifeTime");
            int n = this.parseIntProp(string2, 10);
            String string3 = this.cfg.getProperty("com.tivoli.pd.as.cache.DynamicRoleCache.MaxUsers");
            int n2 = this.parseIntProp(string3, 10000);
            String string4 = this.cfg.getProperty("com.tivoli.pd.as.cache.DynamicRoleCache.RoleLifetime");
            this._roleLifeTime = this.parseIntProp(string4, 20);
            String string5 = this.cfg.getProperty("com.tivoli.pd.as.cache.DynamicRoleCache.NumBuckets");
            this._numCaches = this.parseIntProp(string5, 20);
            this._theCaches = new GenericCache[this._numCaches];
            this._rwLocks = new RWLock[this._numCaches];
            int n3 = n2 / this._numCaches;
            for (int i = 0; i < this._numCaches; ++i) {
                this._theCaches[i] = new GenericCache(n, n3);
                this._rwLocks[i] = new RWLock();
            }
            if (n2 >= 100) {
                this._purgeScheduler = new Timer(true);
                DynamicRolePurgeTask dynamicRolePurgeTask = new DynamicRolePurgeTask(this, n2 / 100);
                long l = n * 60000 / 2;
                this._purgeScheduler.schedule((TimerTask)dynamicRolePurgeTask, l, l);
            }
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                Object[] objectArray = new Object[]{new Integer(n2), new Integer(n), new Integer(this._roleLifeTime), new Integer(this._numCaches)};
                AmasMessage amasMessage = new AmasMessage(916942872, objectArray);
                this._msgLogger.text(1L, (Object)this, "initialize", amasMessage.getMessageString());
            }
            this._initialized = true;
        } else if (this._msgLogger != null && this._msgLogger.isLogging()) {
            AmasMessage amasMessage = new AmasMessage(916942871);
            this._msgLogger.text(1L, (Object)this, "initialize", amasMessage.getMessageString());
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)this, "initialize(Properties)");
        }
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void addPrincipal(String string, Object object) {
        if (this._initialized) {
            block7: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "addPrincipal(String prinName, Object prin) { prinName = " + string + " }");
                }
                try {
                    int n = this.getCacheNumber(string);
                    boolean bl = this._rwLocks[n].getWriterLock();
                    if (bl) {
                        DynamicRoleCacheEntry dynamicRoleCacheEntry = new DynamicRoleCacheEntry(string, object, this._roleLifeTime);
                        this._theCaches[n].addEntry(string, dynamicRoleCacheEntry);
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)this, "addPrincipal(String, Object)", "Added new entry for " + string + " to cache number " + n);
                        }
                        this._rwLocks[n].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942912, (Object)string, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "addPrincipal(String, Object)", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "addPrincipal(String, Object)");
            }
        }
    }

    public void removePrincipal(String string) {
        if (this._initialized) {
            block7: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "removePrincipal(String prinName) { prinName = " + string + " }");
                }
                try {
                    int n = this.getCacheNumber(string);
                    boolean bl = this._rwLocks[n].getWriterLock();
                    if (bl) {
                        this._theCaches[n].removeEntry(string);
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)this, "removePrincipal(String)", "Removed entry for " + string + " from cache number " + n);
                        }
                        this._rwLocks[n].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942913, (Object)string, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removePrincipal(String)", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "removePrincipal(String)");
            }
        }
    }

    public Object getPrincipal(String string) {
        Object object = null;
        if (this._initialized) {
            block8: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "getPrincipal(String prinName) { prinName = " + string + " }");
                }
                try {
                    int n = this.getCacheNumber(string);
                    boolean bl = this._rwLocks[n].getReaderLock();
                    if (bl) {
                        DynamicRoleCacheEntry dynamicRoleCacheEntry = (DynamicRoleCacheEntry)this._theCaches[n].getEntry(string);
                        if (dynamicRoleCacheEntry != null) {
                            object = dynamicRoleCacheEntry.getPrincipal();
                            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                this._trcLogger.text(16L, (Object)this, "getPrincipal(String)", "Retrieved entry for " + string + " from cache number " + n);
                            }
                        }
                        this._rwLocks[n].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block8;
                    AmasMessage amasMessage = new AmasMessage(916942914, (Object)string, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "getPrincipal(String)", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "getPrincipal(String)");
            }
        }
        return object;
    }

    public void removeAll() {
        if (this._initialized) {
            block6: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "removeAll()");
                }
                try {
                    for (int i = 0; i < this._numCaches; ++i) {
                        boolean bl = this._rwLocks[i].getWriterLock();
                        if (!bl) continue;
                        this._theCaches[i].removeAll();
                        this._rwLocks[i].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942915, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removeAll()", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "removeAll()");
            }
        }
    }

    public void removeOldest(int n) {
        if (this._initialized) {
            block6: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "removeOldest(int numEntries) { numEntries = " + n + " }");
                }
                try {
                    for (int i = 0; i < this._numCaches; ++i) {
                        boolean bl = this._rwLocks[i].getWriterLock();
                        if (!bl) continue;
                        this._theCaches[i].removeOldest(n);
                        this._rwLocks[i].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942915, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removeOldest(int numEntries) { numEntries = " + n + " }", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "removeOldest(int)");
            }
        }
    }

    public void removeOldestExpired(int n) {
        if (this._initialized) {
            block6: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "removeOldestExpired(int numEntries) { numEntries = " + n + " }");
                }
                try {
                    for (int i = 0; i < this._numCaches; ++i) {
                        boolean bl = this._rwLocks[i].getWriterLock();
                        if (!bl) continue;
                        this._theCaches[i].removeOldestExpired(n);
                        this._rwLocks[i].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942915, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removeOldestExpired(int numEntries) { numEntries = " + n + " }", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "removeOldestExpired(int)");
            }
        }
    }

    public void addRoleToPrincipal(String string, Object object, String string2) {
        if (this._initialized) {
            block8: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "addRoleToPrincipal(String prinName, Object prin, String role) { prinName = " + string + " , role = " + string2 + " }");
                }
                try {
                    int n = this.getCacheNumber(string);
                    boolean bl = this._rwLocks[n].getWriterLock();
                    if (bl) {
                        DynamicRoleCacheEntry dynamicRoleCacheEntry = (DynamicRoleCacheEntry)this._theCaches[n].getEntry(string);
                        if (dynamicRoleCacheEntry != null && dynamicRoleCacheEntry.getPrincipal().equals(object)) {
                            dynamicRoleCacheEntry.addRole(string2);
                            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                this._trcLogger.text(16L, (Object)this, "addRoleoPrincipal(String, Object, String)", "Added role " + string2 + " for principal " + string + " in cache number " + n);
                            }
                        }
                        this._rwLocks[n].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block8;
                    Object[] objectArray = new Object[]{string2, string, rWLockException.toString()};
                    AmasMessage amasMessage = new AmasMessage(916942916, objectArray);
                    this._msgLogger.text(4L, (Object)this, "addRoleToPrincipal(String, Object, String)", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "addRoleToPrincipal(String, Object, String)");
            }
        }
    }

    public void addDeniedRoleToPrincipal(String string, Object object, String string2) {
        if (this._initialized) {
            block8: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "addDeniedRoleToPrincipal(String prinName, Object prin, String role) { prinName = " + string + " , role = " + string2 + " }");
                }
                try {
                    int n = this.getCacheNumber(string);
                    boolean bl = this._rwLocks[n].getWriterLock();
                    if (bl) {
                        DynamicRoleCacheEntry dynamicRoleCacheEntry = (DynamicRoleCacheEntry)this._theCaches[n].getEntry(string);
                        if (dynamicRoleCacheEntry != null && dynamicRoleCacheEntry.getPrincipal().equals(object)) {
                            dynamicRoleCacheEntry.addDeniedRole(string2);
                            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                this._trcLogger.text(16L, (Object)this, "addDeniedRoleoPrincipal(String, Object, String)", "Added denied role " + string2 + " for principal " + string + " in cache number " + n);
                            }
                        }
                        this._rwLocks[n].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block8;
                    Object[] objectArray = new Object[]{string2, string, rWLockException.toString()};
                    AmasMessage amasMessage = new AmasMessage(916942916, objectArray);
                    this._msgLogger.text(4L, (Object)this, "addDeniedRoleToPrincipal(String, Object, String)", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "addDeniedRoleToPrincipal(String, Object, String)");
            }
        }
    }

    public String[] getRolesForPrincipal(String string) {
        String[] stringArray = null;
        if (this._initialized) {
            block9: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "getRolesForPrincipal(String prinName) { prinName = " + string + " }");
                }
                try {
                    int n = this.getCacheNumber(string);
                    boolean bl = this._rwLocks[n].getReaderLock();
                    if (bl) {
                        DynamicRoleCacheEntry dynamicRoleCacheEntry = (DynamicRoleCacheEntry)this._theCaches[n].getEntry(string);
                        if (dynamicRoleCacheEntry != null) {
                            stringArray = dynamicRoleCacheEntry.getRoles();
                            if (stringArray != null && this._trcLogger != null && this._trcLogger.isLogging()) {
                                this._trcLogger.text(16L, (Object)this, "getRoleForPrincipal(String)", "Retrieved " + stringArray.length + " roles for principal " + string + " from cache number " + n);
                            }
                        } else {
                            stringArray = new String[]{};
                        }
                        this._rwLocks[n].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block9;
                    AmasMessage amasMessage = new AmasMessage(916942917, (Object)string, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "getRolesForPrincipal(String)", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "getRolesForPrincipal(String)");
            }
        }
        return stringArray;
    }

    public String[] getDeniedRolesForPrincipal(String string) {
        String[] stringArray = null;
        if (this._initialized) {
            block9: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "getDeniedRolesForPrincipal(String prinName) { prinName = " + string + " }");
                }
                try {
                    int n = this.getCacheNumber(string);
                    boolean bl = this._rwLocks[n].getReaderLock();
                    if (bl) {
                        DynamicRoleCacheEntry dynamicRoleCacheEntry = (DynamicRoleCacheEntry)this._theCaches[n].getEntry(string);
                        if (dynamicRoleCacheEntry != null) {
                            stringArray = dynamicRoleCacheEntry.getDeniedRoles();
                            if (stringArray != null && this._trcLogger != null && this._trcLogger.isLogging()) {
                                this._trcLogger.text(16L, (Object)this, "getDeniedRoleForPrincipal(String)", "Retrieved " + stringArray.length + " denied roles for principal " + string + " from cache number " + n);
                            }
                        } else {
                            stringArray = new String[]{};
                        }
                        this._rwLocks[n].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block9;
                    AmasMessage amasMessage = new AmasMessage(916942917, (Object)string, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "getDeniedRolesForPrincipal(String)", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "getDeniedRolesForPrincipal(String)");
            }
        }
        return stringArray;
    }

    public void flushCachedRoles() {
        if (this._initialized) {
            block7: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)this, "flushDynamicCacheRoles()");
                }
                try {
                    for (int i = 0; i < this._numCaches; ++i) {
                        boolean bl = this._rwLocks[i].getReaderLock();
                        if (!bl) continue;
                        Collection collection = this._theCaches[i].getAllEntries();
                        this._rwLocks[i].releaseLock();
                        if (collection == null) continue;
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            DynamicRoleCacheEntry dynamicRoleCacheEntry = (DynamicRoleCacheEntry)iterator.next();
                            bl = this._rwLocks[i].getWriterLock();
                            if (!bl) continue;
                            dynamicRoleCacheEntry.removeRoles();
                            dynamicRoleCacheEntry.removeDeniedRoles();
                            this._rwLocks[i].releaseLock();
                        }
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942918, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "flushDynamicCacheRoles()", amasMessage.getMessageString());
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)this, "flushDynamicCacheRoles()");
            }
        }
    }

    private int getCacheNumber(String string) {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)this, "getCacheNumber(String prinName) { prinName = " + string + " }");
        }
        int n = 0;
        n = (string.hashCode() & Integer.MAX_VALUE) % this._numCaches;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)this, "getCacheNumber(String) { retVal = " + n + " }");
        }
        return n;
    }

    private int parseIntProp(String string, int n) {
        int n2 = -1;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 == -1) {
            n2 = n;
        }
        return n2;
    }

    private class RoleList
    extends ArrayList {
        private Object _lock = new Object();
        private int _roleLifeTime;

        public RoleList(int n) {
            this._roleLifeTime = n * 1000;
        }

        public Object getLock() {
            return this._lock;
        }

        public void addRole(String string) {
            long l = System.currentTimeMillis();
            this.removeExpiredRoles(l);
            RoleListEntry roleListEntry = new RoleListEntry(string, l);
            int n = this.indexOf(roleListEntry);
            if (n == -1) {
                this.add(roleListEntry);
            } else {
                this.set(n, roleListEntry);
            }
        }

        public String[] getRoles() {
            String[] stringArray = null;
            this.removeExpiredRoles();
            int n = this.size();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                RoleListEntry roleListEntry = (RoleListEntry)this.get(i);
                stringArray[i] = roleListEntry.roleName;
            }
            return stringArray;
        }

        protected void removeExpiredRoles(long l) {
            int n = this.size();
            long l2 = l - (long)this._roleLifeTime;
            for (int i = n - 1; i >= 0; --i) {
                RoleListEntry roleListEntry = (RoleListEntry)this.get(i);
                if (roleListEntry == null || roleListEntry.timeStamp >= l2) continue;
                this.remove(i);
            }
        }

        protected void removeExpiredRoles() {
            long l = System.currentTimeMillis();
            this.removeExpiredRoles(l);
        }

        protected void removeRoles() {
            int n = this.size();
            for (int i = n - 1; i >= 0; --i) {
                this.remove(i);
            }
        }
    }

    private class RoleListEntry {
        public String roleName;
        public long timeStamp;

        public RoleListEntry(String string, long l) {
            this.roleName = string;
            this.timeStamp = l;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            RoleListEntry roleListEntry = (RoleListEntry)object;
            if (roleListEntry.roleName.equals(this.roleName)) {
                bl = true;
            }
            return bl;
        }
    }

    private class DynamicRoleCacheEntry
    extends GenericCacheEntry {
        private Object _prinRef;
        private RoleList _roleList;
        private RoleList _roleDeniedList;

        public DynamicRoleCacheEntry(String string, Object object, int n) {
            super(System.currentTimeMillis());
            this._prinRef = object;
            this._roleList = new RoleList(n);
            this._roleDeniedList = new RoleList(n);
        }

        public Object getPrincipal() {
            return this._prinRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getRoles() {
            String[] stringArray = null;
            Object object = this._roleList.getLock();
            synchronized (object) {
                stringArray = this._roleList.getRoles();
            }
            return stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getDeniedRoles() {
            String[] stringArray = null;
            Object object = this._roleDeniedList.getLock();
            synchronized (object) {
                stringArray = this._roleDeniedList.getRoles();
            }
            return stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRole(String string) {
            Object object = this._roleList.getLock();
            synchronized (object) {
                this._roleList.addRole(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDeniedRole(String string) {
            Object object = this._roleDeniedList.getLock();
            synchronized (object) {
                this._roleDeniedList.addRole(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRoles() {
            Object object = this._roleList.getLock();
            synchronized (object) {
                this._roleList.removeRoles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDeniedRoles() {
            Object object = this._roleDeniedList.getLock();
            synchronized (object) {
                this._roleDeniedList.removeRoles();
            }
        }
    }
}

