/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.cache;

import com.tivoli.pd.as.cache.GSOCachePurgeTask;
import com.tivoli.pd.as.cache.GenericCache;
import com.tivoli.pd.as.cache.GenericCacheEntry;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.RWLock;
import com.tivoli.pd.as.util.RWLockException;
import com.tivoli.pd.jadmin.PDSSOCred;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import java.util.Timer;
import java.util.TimerTask;

public final class GSOCache {
    private final String GSOCache_java_sourceCodeID = "$Id: @(#)61  1.4 src/amas/com/tivoli/pd/as/cache/GSOCache.java, amemb.jacc.was, amemb600, 051118a 05/03/30 00:56:16 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private GenericCache _theCache = null;
    private RWLock _lock = null;
    private long _expiry;
    private boolean _initialized = false;
    private Timer _purgeScheduler;
    private ILogger _traceLogger = LogManager.getManager().getTraceLogger("AmasCacheTraceLogger");
    private ILogger _msgLogger = LogManager.getManager().getMessageLogger("AmasCacheMessageLogger");
    static /* synthetic */ Class class$com$tivoli$pd$as$cache$GSOCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(int n, int n2) {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "initialize(int size, int expiry) { size = " + n + " , expiry = " + n2 + " }");
        }
        if (!this._initialized) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)this, "initialize(int, int)", "Setting cache size [" + n + "] expiry time [" + n2 + "]");
            }
            Class clazz = class$com$tivoli$pd$as$cache$GSOCache == null ? (class$com$tivoli$pd$as$cache$GSOCache = GSOCache.class$("com.tivoli.pd.as.cache.GSOCache")) : class$com$tivoli$pd$as$cache$GSOCache;
            synchronized (clazz) {
                this._theCache = new GenericCache(n2, n);
                this._lock = new RWLock();
                if (n >= 100) {
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)this, "initialize(int, int)", "Setting up purge tasks");
                    }
                    this._purgeScheduler = new Timer(true);
                    GSOCachePurgeTask gSOCachePurgeTask = new GSOCachePurgeTask(this, n / 100);
                    long l = n2 * 60000 / 2;
                    this._purgeScheduler.schedule((TimerTask)gSOCachePurgeTask, l, l);
                }
                this._initialized = true;
            }
        } else if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.text(16L, (Object)this, "initialize(int, int)", "Cache already initialized");
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "initialize(int,int)");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public PDSSOCred getAuthData(String string, String string2) throws AmasException {
        PDSSOCred pDSSOCred;
        block12: {
            block13: {
                block10: {
                    block11: {
                        GSOCacheEntry gSOCacheEntry;
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.entry(80L, (Object)this, "getAuthData(String resource, String user) { resource = " + string + " , user = " + string2 + " }");
                        }
                        pDSSOCred = null;
                        if (!this._initialized) break block10;
                        boolean bl = this._lock.getReaderLock();
                        if (!bl) break block11;
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "Resource [" + string + "] User [" + string2 + "]");
                        }
                        String string3 = string + "/" + string2;
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "Getting entry with key [" + string3 + "]");
                        }
                        if ((gSOCacheEntry = (GSOCacheEntry)this._theCache.getEntry(string3)) != null) {
                            pDSSOCred = gSOCacheEntry._authData;
                            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                                this._traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "AuthData entry found");
                            }
                        } else if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "AuthData entry not found");
                        }
                        this._lock.releaseLock();
                        if (this._traceLogger == null) break block12;
                        break block13;
                    }
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "We have a problem with the read lock");
                    }
                    throw new AmasException(916942897, (Object[])null);
                }
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "Init has not been called");
                }
                throw new AmasException(916942899, (Object[])null);
            }
            if (this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "getAuthData(String, String)");
            }
        }
        return pDSSOCred;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAuthData(PDSSOCred pDSSOCred) throws AmasException {
        block14: {
            block15: {
                block11: {
                    block12: {
                        block13: {
                            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                                this._traceLogger.entry(80L, (Object)this, "addAuthData(PDSSOCred)");
                            }
                            if (!this._initialized) break block11;
                            boolean bl = this._lock.getWriterLock();
                            if (!bl) break block12;
                            if (pDSSOCred == null) break block13;
                            String string = null;
                            GSOCacheEntry gSOCacheEntry = null;
                            try {
                                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                                    this._traceLogger.text(16L, (Object)this, "addAuthData(PDSSOCred)", "Resource [" + pDSSOCred.getResourceName() + "] User [" + pDSSOCred.getUser() + "]");
                                }
                                string = pDSSOCred.getResourceName() + "/" + pDSSOCred.getUser();
                                long l = System.currentTimeMillis();
                                gSOCacheEntry = new GSOCacheEntry(pDSSOCred, l);
                            }
                            catch (Exception exception) {
                                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                                    this._traceLogger.text(16L, (Object)this, "addAuthData(PDSSOCred)", "We have caught an exception [" + exception.toString() + "]");
                                }
                                this._lock.releaseLock();
                                throw new AmasException(exception);
                            }
                            if (string != null && gSOCacheEntry != null) {
                                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                                    this._traceLogger.text(16L, (Object)this, "addAuthData(PDSSOCred)", "Adding the entry to the cache with key [" + string + "]");
                                }
                                this._theCache.addEntry(string, gSOCacheEntry);
                            }
                            this._lock.releaseLock();
                            if (this._traceLogger == null) break block14;
                            break block15;
                        }
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "addAuthData(PDSSOCred)", "The authData passed in is null");
                        }
                        Object[] objectArray = new Object[]{"authData"};
                        throw new AmasException(916942900, objectArray);
                    }
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)this, "addAuthData(PDSSOCred)", "We have a problem with the writer lock");
                    }
                    throw new AmasException(916942898, (Object[])null);
                }
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(16L, (Object)this, "addAuthData(PDSSOCred)", "Init has not been called");
                }
                throw new AmasException(916942899, (Object[])null);
            }
            if (this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "addAuthData(PDSSOCred)");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void deleteAuthData(String string, String string2) throws AmasException {
        block10: {
            block11: {
                block7: {
                    block8: {
                        block9: {
                            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                                this._traceLogger.entry(80L, (Object)this, "deleteAuthData(String resource, String user) { resource = " + string + " , user = " + string2 + " }");
                            }
                            if (!this._initialized) break block7;
                            boolean bl = this._lock.getWriterLock();
                            if (!bl) break block8;
                            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                                this._traceLogger.text(16L, (Object)this, "deleteAuthData(String, String)", "Resource [" + string + "] User [" + string2 + "]");
                            }
                            if (string == null || string2 == null) break block9;
                            String string3 = string + "/" + string2;
                            this._theCache.removeEntry(string3);
                            this._lock.releaseLock();
                            if (this._traceLogger == null) break block10;
                            break block11;
                        }
                        this._lock.releaseLock();
                        if (string == null && this._msgLogger != null && this._msgLogger.isLogging()) {
                            this._msgLogger.text(4L, (Object)this, "deleteAuthData(String, String)", AmasMsgHelper.formatSingleParamMessage(916942900, "resource"));
                        }
                        if (string2 == null && this._msgLogger != null && this._msgLogger.isLogging()) {
                            this._msgLogger.text(4L, (Object)this, "deleteAuthData(String, String)", AmasMsgHelper.formatSingleParamMessage(916942900, "user"));
                        }
                        Object[] objectArray = new Object[]{"resource/user"};
                        throw new AmasException(916942900, objectArray);
                    }
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)this, "deleteAuthData(String, String)", "We have a problem with the writer lock");
                    }
                    throw new AmasException(916942898, (Object[])null);
                }
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.text(16L, (Object)this, "deleteAuthData(String, String)", "Init has not been called");
                }
                throw new AmasException(916942899, (Object[])null);
            }
            if (this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "deleteAuthData(String, String)");
            }
        }
    }

    public void removeOldestExpired(int n) {
        if (this._initialized) {
            block6: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "removeOldestExpired(int maxRemove) { maxRemove = " + n + " }");
                }
                try {
                    boolean bl = this._lock.getWriterLock();
                    if (bl) {
                        this._theCache.removeOldestExpired(n);
                        this._lock.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removeOldestExpired(int)", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "removeOldestExpired(int)");
            }
        }
    }

    public void flush() {
        if (this._initialized) {
            block6: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "flush()");
                }
                try {
                    boolean bl = this._lock.getWriterLock();
                    if (bl) {
                        this._theCache.removeAll();
                        this._lock.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "flush()", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "flush()");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class GSOCacheEntry
    extends GenericCacheEntry {
        protected PDSSOCred _authData = null;

        GSOCacheEntry(PDSSOCred pDSSOCred, long l) {
            super(l);
            this._authData = pDSSOCred;
        }
    }
}

