/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.cache;

import com.tivoli.pd.as.cache.GenericCacheEntry;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GenericCache {
    private final String GenericCache_java_sourceCodeID = "$Id: @(#)66  1.4 src/amas/com/tivoli/pd/as/cache/GenericCache.java, amemb.jacc.was, amemb600, 051118a 05/03/30 00:56:19 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private int _entryLifeTime;
    private int _maxEntries;
    private ILogger _traceLogger = LogManager.getManager().getTraceLogger("AmasCacheTraceLogger");
    private ILogger _msgLogger = LogManager.getManager().getMessageLogger("AmasCacheMessageLogger");
    private Map _objectStore;
    private ExpiryList _keyExpiryList;
    protected static final int CLEAN_DEFAULT = 1;

    public GenericCache(int n, int n2) {
        this._entryLifeTime = n * 60000;
        this._maxEntries = n2;
        this._objectStore = new HashMap();
        this._keyExpiryList = new ExpiryList(this._objectStore);
        if (this._traceLogger.isLogging()) {
            this._traceLogger.text(16L, (Object)this, "GenericCache", "Constructed a generic cache with following settings -->\nEntryLifetime: " + new Integer(n) + ", MaxEntries: " + new Integer(n2));
        }
    }

    public void addEntry(String string, GenericCacheEntry genericCacheEntry) {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "addEntry(String key, GenericCacheEntry entry) { key = " + string + " }");
        }
        this.removeEntry(string);
        long l = System.currentTimeMillis();
        if (this._keyExpiryList.size() == this._maxEntries) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)this, "addEntry", "Hit size limit removing oldest 1");
            }
            this._keyExpiryList.removeOldest(1, false, 0);
        }
        this._objectStore.put(string, genericCacheEntry);
        ExpiryListEntry expiryListEntry = new ExpiryListEntry(string, l);
        this._keyExpiryList.add(expiryListEntry);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.text(16L, (Object)this, "addEntry", "Successfully added entry for key " + string);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "addEntry(String, GenericCacheEntry)");
        }
    }

    public void removeEntry(String string) {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "removeEntry(String key) { key = " + string + " }");
        }
        if (this._objectStore.containsKey(string)) {
            this._objectStore.remove(string);
            int n = this._keyExpiryList.indexOf(new ExpiryListEntry(string, 0L));
            if (n >= 0) {
                this._keyExpiryList.remove(n);
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)this, "removeEntry", "Successfully removed entry for key " + string);
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "removeEntry(String)");
        }
    }

    public void removeOldest(int n) {
        this._keyExpiryList.removeOldest(n, false, 0);
    }

    public void removeOldestExpired(int n) {
        this._keyExpiryList.removeOldest(n, true, this._entryLifeTime);
    }

    public GenericCacheEntry getEntry(String string) {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "getEntry(String key) { key = " + string + " }");
        }
        GenericCacheEntry genericCacheEntry = null;
        long l = System.currentTimeMillis();
        long l2 = l - (long)this._entryLifeTime;
        GenericCacheEntry genericCacheEntry2 = (GenericCacheEntry)this._objectStore.get(string);
        if (genericCacheEntry2 != null && genericCacheEntry2.getTimeStamp() >= l2 && (genericCacheEntry = genericCacheEntry2) != null && this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.text(16L, (Object)this, "getEntry", "Successfully retrieved entry for key " + string);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "getEntry(String key)");
        }
        return genericCacheEntry;
    }

    public void removeAll() {
        this._keyExpiryList.clear();
        this._objectStore.clear();
    }

    protected Collection getAllEntries() {
        return this._objectStore.values();
    }

    private class ExpiryListEntry {
        protected String _cacheKey;
        protected long _timeStamp;

        public ExpiryListEntry(String string, long l) {
            this._cacheKey = string;
            this._timeStamp = l;
        }

        public String getKey() {
            return this._cacheKey;
        }

        public long getTimeStamp() {
            return this._timeStamp;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            ExpiryListEntry expiryListEntry = (ExpiryListEntry)object;
            if (expiryListEntry.getKey().equals(this._cacheKey)) {
                bl = true;
            }
            return bl;
        }
    }

    private class ExpiryList
    extends ArrayList {
        Map _objectStore;
        private ILogger _traceLogger = LogManager.getManager().getTraceLogger("AmasCacheTraceLogger");

        public ExpiryList(Map map) {
            this._objectStore = map;
        }

        public void removeOldest(int n, boolean bl, int n2) {
            int n3;
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.entry(80L, (Object)this, "removeOldest(int numEntries, boolean onlyExpired, int lifeTime) { numEntries = " + n + " , onlyExpired = " + bl + " , lifeTime = " + n2 + " }");
            }
            long l = System.currentTimeMillis();
            long l2 = l - (long)n2;
            if (n >= this.size()) {
                n = this.size();
            }
            for (n3 = 0; n3 < n; ++n3) {
                ExpiryListEntry expiryListEntry = (ExpiryListEntry)this.get(n3);
                if (expiryListEntry == null) continue;
                if (!bl || bl && expiryListEntry.getTimeStamp() < l2) {
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)this, "removeOldest", "Removing object for key " + expiryListEntry.getKey());
                    }
                    this._objectStore.remove(expiryListEntry.getKey());
                    continue;
                }
                if (!bl) continue;
                if (this._traceLogger == null || !this._traceLogger.isLogging()) break;
                this._traceLogger.text(16L, (Object)this, "removeOldest", "Hit unexpired entry -- cleanup finished");
                break;
            }
            this.removeRange(0, n3);
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)this, "removeOldest", "Removing entries 0 to " + n3 + " from list");
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "removeOldest(int, boolean, int)");
            }
        }
    }
}

