/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.cache;

import com.tivoli.pd.as.cache.GenericCache;
import com.tivoli.pd.as.cache.GenericCacheEntry;
import com.tivoli.pd.as.cache.IObjectCache;
import com.tivoli.pd.as.cache.ObjectCachePurgeTask;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.AmasUtil;
import com.tivoli.pd.as.util.RWLock;
import com.tivoli.pd.as.util.RWLockException;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class ObjectCacheImpl
implements IObjectCache {
    private final String ObjectCacheImpl_java_sourceCodeID = "$Id: @(#)72  1.3 src/amas/com/tivoli/pd/as/cache/ObjectCacheImpl.java, amemb.jacc.was, amemb600, 051118a 05/02/20 18:08:27 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private Properties cfg = null;
    private boolean _initialized = false;
    private GenericCache[] _theCache;
    private RWLock[] _rwLocks;
    Timer _purgeScheduler;
    private int _numCaches;
    private ILogger _msgLogger;
    private ILogger _traceLogger;

    public void initialize(Properties properties) {
        String string;
        this._initialized = false;
        this.cfg = properties;
        this._traceLogger = LogManager.getManager().getTraceLogger("AmasCacheTraceLogger");
        this._msgLogger = LogManager.getManager().getMessageLogger("AmasCacheMessageLogger");
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "initialize(Properties)");
        }
        if ((string = this.cfg.getProperty("com.tivoli.pd.as.cache.EnableObjectCaching")) == null || string.equalsIgnoreCase("true")) {
            String string2 = this.cfg.getProperty("com.tivoli.pd.as.cache.ObjectCache.ResourceLifeTime");
            int n = AmasUtil.parseIntProp(string2, 10);
            String string3 = this.cfg.getProperty("com.tivoli.pd.as.cache.ObjectCache.MaxResources");
            int n2 = AmasUtil.parseIntProp(string3, 10000);
            String string4 = this.cfg.getProperty("com.tivoli.pd.as.cache.ObjectCache.NumBuckets");
            this._numCaches = AmasUtil.parseIntProp(string4, 20);
            this._theCache = new GenericCache[this._numCaches];
            this._rwLocks = new RWLock[this._numCaches];
            int n3 = n2 / this._numCaches;
            for (int i = 0; i < this._numCaches; ++i) {
                this._theCache[i] = new GenericCache(n, n3);
                this._rwLocks[i] = new RWLock();
            }
            if (n2 >= 100) {
                this._purgeScheduler = new Timer(true);
                ObjectCachePurgeTask objectCachePurgeTask = new ObjectCachePurgeTask(this, n2 / 100);
                long l = n * 60000 / 2;
                this._purgeScheduler.schedule((TimerTask)objectCachePurgeTask, l, l);
            }
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                Object[] objectArray = new Object[]{new Integer(n2), new Integer(n), new Integer(this._numCaches)};
                AmasMessage amasMessage = new AmasMessage(916942874, objectArray);
                this._msgLogger.text(1L, (Object)this, "initialize(Properties)", amasMessage.getMessageString());
            }
            this._initialized = true;
        } else if (this._msgLogger != null && this._msgLogger.isLogging()) {
            AmasMessage amasMessage = new AmasMessage(916942873, (Object)null);
            this._msgLogger.text(1L, (Object)this, "initialize(Properties)", amasMessage.getMessageString());
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "initialize(Properties)");
        }
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void addEntry(String string, Object object) {
        if (this._initialized) {
            block7: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "addEntry(String key, Object data) { key = " + string + " }");
                }
                try {
                    int n = this.getCacheNumber(string);
                    boolean bl = this._rwLocks[n].getWriterLock();
                    if (bl) {
                        ObjectCacheEntry objectCacheEntry = new ObjectCacheEntry(string, object);
                        this._theCache[n].addEntry(string, objectCacheEntry);
                        if (this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "addEntry(String, Object)", "Added new entry for [" + string + "] to cache number [" + n + "]");
                        }
                        this._rwLocks[n].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "addEntry(String, Object)", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "addEntry(String, Object)");
            }
        }
    }

    public void removeEntry(String string) {
        if (this._initialized) {
            block7: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "removeEntry(String key) { key = " + string + " }");
                }
                try {
                    int n = this.getCacheNumber(string);
                    boolean bl = this._rwLocks[n].getWriterLock();
                    if (bl) {
                        this._theCache[n].removeEntry(string);
                        if (this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "removeEntry(String)", "Remove entry for [" + string + "] from cache number [" + n + "]");
                        }
                        this._rwLocks[n].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removeEntry(String)", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "removeEntry(String)");
            }
        }
    }

    public Object getEntry(String string) {
        Object object = null;
        if (this._initialized) {
            block7: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "getEntry(String key) { key = " + string + " }");
                }
                try {
                    int n = this.getCacheNumber(string);
                    boolean bl = this._rwLocks[n].getReaderLock();
                    if (bl) {
                        ObjectCacheEntry objectCacheEntry = (ObjectCacheEntry)this._theCache[n].getEntry(string);
                        if (objectCacheEntry != null && (object = objectCacheEntry.getEntry()) != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)this, "getEntry(String)", "Retrieved entry for [" + string + "] from cache number [" + n + "]");
                        }
                        this._rwLocks[n].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block7;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "getEntry(String)", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "getEntry(String)");
            }
        }
        return object;
    }

    public void removeAll() {
        if (this._initialized) {
            block6: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "removeAll()");
                }
                try {
                    for (int i = 0; i < this._numCaches; ++i) {
                        boolean bl = this._rwLocks[i].getWriterLock();
                        if (!bl) continue;
                        this._theCache[i].removeAll();
                        this._rwLocks[i].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removeAll()", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "removeAll()");
            }
        }
    }

    public void removeOldest(int n) {
        if (this._initialized) {
            block6: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "removeOldest(int numEntries) { numEntries = " + n + " }");
                }
                try {
                    for (int i = 0; i < this._numCaches; ++i) {
                        boolean bl = this._rwLocks[i].getWriterLock();
                        if (!bl) continue;
                        this._theCache[i].removeOldest(n);
                        this._rwLocks[i].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removeOldest(int)", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "removeOldest(int)");
            }
        }
    }

    public void removeOldestExpired(int n) {
        if (this._initialized) {
            block6: {
                if (this._traceLogger != null && this._traceLogger.isLogging()) {
                    this._traceLogger.entry(80L, (Object)this, "removeOldestExpired(int numEntries) { numEntries = " + n + " }");
                }
                try {
                    for (int i = 0; i < this._numCaches; ++i) {
                        boolean bl = this._rwLocks[i].getWriterLock();
                        if (!bl) continue;
                        this._theCache[i].removeOldestExpired(n);
                        this._rwLocks[i].releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block6;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "removeOldestExpired(int)", amasMessage.getMessageString());
                }
            }
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.exit(96L, (Object)this, "removeOldestExpired(int)");
            }
        }
    }

    private int getCacheNumber(String string) {
        int n = 0;
        n = (string.hashCode() & Integer.MAX_VALUE) % this._numCaches;
        return n;
    }

    private class ObjectCacheEntry
    extends GenericCacheEntry {
        private String _key;
        private Object _entry;

        public ObjectCacheEntry(String string, Object object) {
            super(System.currentTimeMillis());
            this._key = string;
            this._entry = object;
        }

        public String getKey() {
            return this._key;
        }

        public Object getEntry() {
            return this._entry;
        }
    }
}

