/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.cache;

import com.tivoli.pd.as.cache.IStaticRoleCache;
import com.tivoli.pd.as.cache.NotStaticRoleException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.RWLock;
import com.tivoli.pd.as.util.RWLockException;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class StaticRoleCacheImpl
implements IStaticRoleCache {
    private final String StaticRoleCacheImpl_java_sourceCodeID = "$Id: @(#)74  1.3 src/amas/com/tivoli/pd/as/cache/StaticRoleCacheImpl.java, amemb.jacc.was, amemb600, 051118a 05/03/30 00:56:20 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    boolean _initialized = false;
    private Map[] _fqRoleLists;
    private RWLock[] _listLocks;
    private String[] _roleToIndexMap;
    private Properties cfg = null;
    private ILogger _traceLogger = null;
    private ILogger _msgLogger = null;

    public void initialize(Properties properties) {
        String string;
        this.cfg = properties;
        this._initialized = false;
        this._traceLogger = LogManager.getManager().getTraceLogger("AmasCacheTraceLogger");
        this._msgLogger = LogManager.getManager().getMessageLogger("AmasCacheMessageLogger");
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "initialize(Properties)");
        }
        if ((string = this.cfg.getProperty("com.tivoli.pd.as.cache.EnableStaticRoleCaching")) == null || string.equalsIgnoreCase("true")) {
            String string2 = this.cfg.getProperty("com.tivoli.pd.as.cache.StaticRoleCache.Roles");
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                int n = stringTokenizer.countTokens();
                this._roleToIndexMap = new String[n];
                this._fqRoleLists = new HashMap[n];
                this._listLocks = new RWLock[n];
                for (int i = 0; i < n; ++i) {
                    String string3;
                    this._roleToIndexMap[i] = string3 = stringTokenizer.nextToken();
                    this._fqRoleLists[i] = new HashMap();
                    this._listLocks[i] = new RWLock();
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) continue;
                    AmasMessage amasMessage = new AmasMessage(916942868, string3);
                    this._msgLogger.text(1L, (Object)this, "initialize(Properties)", amasMessage.getMessageString());
                }
                if (n > 0) {
                    this._initialized = true;
                }
            } else if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942869, null);
                this._msgLogger.text(1L, (Object)this, "initialize(Properties)", amasMessage.getMessageString());
            }
        } else if (this._msgLogger != null && this._msgLogger.isLogging()) {
            AmasMessage amasMessage = new AmasMessage(916942867, null);
            this._msgLogger.text(1L, (Object)this, "initialize(Properties)", amasMessage.getMessageString());
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "initialize(Properties)");
        }
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean isStaticRole(String string) {
        int n;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "isStaticRole(String roleName) { roleName = " + string + " }");
        }
        boolean bl = false;
        if (this._initialized && (n = this.getRoleIndex(string)) != -1) {
            bl = true;
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)this, "isStaticRole(String)", "Returning true for role " + string);
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "isStaticRole(String) { retVal = " + bl + " }");
        }
        return bl;
    }

    public boolean isRoleMember(String string, String string2, String string3) throws NotStaticRoleException {
        boolean bl;
        block8: {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.entry(80L, (Object)this, "isRoleMember(String principalName, String roleName, String fullyQualifiedRoleName) { principalName = " + string + " , roleName = " + string2 + " , fullyQualifiedRoleName = " + string3 + " }");
            }
            bl = false;
            if (this._initialized) {
                try {
                    int n = this.getRoleIndexEx(string2);
                    Map map = this._fqRoleLists[n];
                    RWLock rWLock = this._listLocks[n];
                    boolean bl2 = rWLock.getReaderLock();
                    if (bl2) {
                        RoleMembershipList roleMembershipList;
                        if (map != null && (roleMembershipList = (RoleMembershipList)map.get(string3)) != null && roleMembershipList.isMember(string)) {
                            bl = true;
                            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                                this._traceLogger.text(16L, (Object)this, "isRoleMember(String, String, String)", "Returned true for " + string + " : " + string2);
                            }
                        }
                        rWLock.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block8;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "isRoleMember(String, String, String)", amasMessage.getMessageString());
                }
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "isRoleMember(String, String, String) { retVal = " + bl + " }");
        }
        return bl;
    }

    public void addRoleMember(String string, String string2, String string3) {
        block9: {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.entry(80L, (Object)this, "addRoleMember(String principalName, String roleName, String fullyQualifiedRoleName) { principalName = " + string + " , roleName = " + string2 + " , fullyQualifiedRoleName = " + string3 + " }");
            }
            if (this._initialized) {
                try {
                    int n = this.getRoleIndexEx(string2);
                    Map map = this._fqRoleLists[n];
                    RWLock rWLock = this._listLocks[n];
                    boolean bl = rWLock.getWriterLock();
                    if (bl) {
                        if (map != null) {
                            RoleMembershipList roleMembershipList = (RoleMembershipList)map.get(string3);
                            if (roleMembershipList == null) {
                                roleMembershipList = new RoleMembershipList();
                                map.put(string3, roleMembershipList);
                            }
                            roleMembershipList.addMembershipEntry(string);
                            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                                this._traceLogger.text(16L, (Object)this, "addRoleMember(String, String, String)", "Added " + string + " for role " + string3);
                            }
                        }
                        rWLock.releaseLock();
                    }
                }
                catch (RWLockException rWLockException) {
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block9;
                    AmasMessage amasMessage = new AmasMessage(916942849, rWLockException.toString());
                    this._msgLogger.text(4L, (Object)this, "addRoleMember(String, String, String)", amasMessage.getMessageString());
                }
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "addRoleMember(String, String, String)");
        }
    }

    protected int getRoleIndexEx(String string) {
        int n;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "getRoleIndexEx(String roleName) { roleName = " + string + " }");
        }
        if ((n = this.getRoleIndex(string)) == -1) {
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)this, "getRoleIndexEx(String)", string + "is not a static role.");
            }
            throw new NotStaticRoleException();
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "getRoleIndexEx(String) { retVal = " + n + " }");
        }
        return n;
    }

    protected int getRoleIndex(String string) {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)this, "getRoleIndex(String roleName) { roleName = " + string + " }");
        }
        int n = -1;
        if (string != null) {
            for (int i = 0; i < this._roleToIndexMap.length; ++i) {
                if (!this._roleToIndexMap[i].equals(string)) continue;
                n = i;
                break;
            }
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)this, "getRoleIndex(String) { retVal = " + n + " }");
        }
        return n;
    }

    class RoleMembershipList {
        private List _membershipList = new ArrayList();
        private List _nonMembershipList = new ArrayList();

        RoleMembershipList() {
        }

        void addMembershipEntry(String string) {
            if (!this._membershipList.contains(string)) {
                this._membershipList.add(string);
            }
        }

        void addNonMembershipEntry(String string) {
            if (!this._nonMembershipList.contains(string)) {
                this._nonMembershipList.add(string);
            }
        }

        boolean isMember(String string) {
            return this._membershipList.contains(string);
        }

        boolean isNonMember(String string) {
            return this._nonMembershipList.contains(string);
        }
    }
}

