/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.gso;

import com.tivoli.pd.as.cache.GSOCache;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.RWLock;
import com.tivoli.pd.jadmin.PDSSOCred;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import com.tivoli.pd.jutil.PDContext;
import com.tivoli.pd.jutil.PDException;
import com.tivoli.pd.jutil.PDMessage;
import com.tivoli.pd.jutil.PDMessages;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;

public final class GSOHelper {
    private final String GSOHelper_java_sourceCodeID = "$Id: @(#)75  1.2 src/amas/com/tivoli/pd/as/gso/GSOHelper.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:53:43 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    GSOCache _cache;
    PDContext _ctx;
    static HashMap _insts = null;
    static RWLock _instLock = null;
    private static ILogger _traceLogger;
    private static ILogger _msgLogger;
    private static final String DEFCFG = "DEFCFG";
    private static final int CACHEEXPIRY = 10;
    private static final int CACHEMAXSIZE = 1000;

    private GSOHelper(String string) {
        block12: {
            this.GSOHelper_java_sourceCodeID = "$Id: @(#)75  1.2 src/amas/com/tivoli/pd/as/gso/GSOHelper.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:53:43 @(#) $";
            this._cache = null;
            this._ctx = null;
            if (_traceLogger != null && _traceLogger.isLogging()) {
                _traceLogger.entry(80L, (Object)this, "GSOHelper(String cfgUrl) { cfgUrl = " + string + " }");
            }
            this._cache = new GSOCache();
            this._cache.initialize(1000, 10);
            try {
                URL uRL;
                block11: {
                    SecurityManager securityManager;
                    uRL = null;
                    if (_traceLogger.isLogging()) {
                        _traceLogger.text(16L, (Object)this, "GSOHelper(String)", "Passed in URL [" + string + "]");
                    }
                    if ((securityManager = System.getSecurityManager()) == null) {
                        string = GSOHelper.getCfgUrl(string);
                        uRL = new URL(string);
                    } else {
                        final String string2 = string;
                        try {
                            uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() {
                                    URL uRL;
                                    block3: {
                                        uRL = null;
                                        try {
                                            String string = GSOHelper.getCfgUrl(string2);
                                            uRL = new URL(string);
                                        }
                                        catch (MalformedURLException malformedURLException) {
                                            if (_traceLogger.isLogging()) {
                                                _traceLogger.text(16L, (Object)this, "GSOHelper(String)", "MalformedURLException:" + malformedURLException.toString());
                                            }
                                            if (!_msgLogger.isLogging()) break block3;
                                            AmasMessage amasMessage = new AmasMessage(916942901, GSOHelper.getCfgUrl(string2));
                                            _msgLogger.text(4L, (Object)this, "GSOHelper(String)", amasMessage.getMessageString());
                                        }
                                    }
                                    return uRL;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            if (_traceLogger.isLogging()) {
                                _traceLogger.text(16L, (Object)this, "GSOHelper(String)", "PrivilegedActionException:" + privilegedActionException.toString());
                            }
                            if (!_msgLogger.isLogging()) break block11;
                            AmasMessage amasMessage = new AmasMessage(916942901, GSOHelper.getCfgUrl(string));
                            _msgLogger.text(4L, (Object)this, "GSOHelper(String)", amasMessage.getMessageString());
                        }
                    }
                }
                this._ctx = new PDContext(uRL);
            }
            catch (Exception exception) {
                if (_traceLogger.isLogging()) {
                    _traceLogger.text(16L, (Object)this, "GSOHelper(String)", "Exception e:" + exception.toString());
                }
                if (!_msgLogger.isLogging()) break block12;
                AmasMessage amasMessage = new AmasMessage(916942901, string);
                _msgLogger.text(4L, (Object)this, "GSOHelper(String)", amasMessage.getMessageString());
            }
        }
        if (_traceLogger != null && _traceLogger.isLogging()) {
            _traceLogger.exit(96L, (Object)this, "GSOHelper(String)");
        }
    }

    private static String getCfgUrl(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = "file:///" + System.getProperty("java.home") + System.getProperty("file.separator") + "PdPerm.properties";
        }
        return string2;
    }

    public static GSOHelper getInstance() {
        GSOHelper gSOHelper = null;
        gSOHelper = GSOHelper.getInstance(null);
        if (_traceLogger.isLogging()) {
            _traceLogger.exit(96L, (Object)gSOHelper, "getInstance()");
        }
        return gSOHelper;
    }

    public static GSOHelper getInstance(String string) {
        GSOHelper gSOHelper = null;
        boolean bl = _instLock.getReaderLock();
        if (bl) {
            String string2 = null;
            string2 = string == null ? DEFCFG : string;
            gSOHelper = (GSOHelper)_insts.get(string2);
            _instLock.releaseLock();
            if (gSOHelper == null) {
                boolean bl2 = _instLock.getWriterLock();
                if (bl2) {
                    gSOHelper = (GSOHelper)_insts.get(string2);
                    if (gSOHelper == null) {
                        _traceLogger = LogManager.getManager().getTraceLogger("AmasCacheTraceLogger");
                        _msgLogger = LogManager.getManager().getMessageLogger("AmasCacheMessageLogger");
                        gSOHelper = new GSOHelper(string);
                        _insts.put(string2, gSOHelper);
                        if (_traceLogger.isLogging()) {
                            _traceLogger.text(16L, (Object)gSOHelper, "getInstance", "Created handle using the key [" + string2 + "]");
                        }
                    } else if (_traceLogger.isLogging()) {
                        _traceLogger.text(16L, (Object)gSOHelper, "getInstance", "We already have a handle using the key [" + string2 + "]");
                    }
                    _instLock.releaseLock();
                }
            } else if (_traceLogger.isLogging()) {
                _traceLogger.text(16L, (Object)gSOHelper, "getInstance", "We already have a handle using the key [" + string2 + "]");
            }
        }
        return gSOHelper;
    }

    public PDSSOCred getAuthData(String string, String string2) throws AmasException {
        if (_traceLogger.isLogging()) {
            _traceLogger.entry(80L, (Object)this, "getAuthData(String resourceName, String userName) { resourceName = " + string + " , userName = " + string2 + " }");
        }
        PDSSOCred pDSSOCred = null;
        if (string != null && string2 != null) {
            pDSSOCred = this._cache.getAuthData(string, string2);
            if (_traceLogger.isLogging() && pDSSOCred == null) {
                _traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "Cache returned null");
            }
            if (pDSSOCred == null) {
                final PDMessages pDMessages = new PDMessages();
                try {
                    final String string3 = string;
                    final String string4 = string2;
                    pDSSOCred = (PDSSOCred)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (_traceLogger.isLogging()) {
                                _traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "Calling PDSSOCred");
                            }
                            return new PDSSOCred(GSOHelper.this._ctx, string3, "Web Resource", string4, pDMessages);
                        }
                    });
                    if (_traceLogger.isLogging()) {
                        _traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "PDSSOCred returned ");
                    }
                    if (pDSSOCred != null) {
                        if (_traceLogger.isLogging()) {
                            _traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "Adding Cred to cache");
                        }
                        this._cache.addAuthData(pDSSOCred);
                    }
                }
                catch (Exception exception) {
                    if (_traceLogger.isLogging()) {
                        _traceLogger.text(16L, (Object)this, "getAuthData(String, String)", "Got an exception from Privileged Action [" + exception.toString() + "]");
                    }
                    AmasMessage amasMessage = new AmasMessage(916942902, exception.toString());
                    throw new AmasException(amasMessage);
                }
            }
        }
        if (_traceLogger.isLogging()) {
            _traceLogger.exit(96L, (Object)this, "getAuthData(String, String)");
        }
        return pDSSOCred;
    }

    public static String getFirstExceptionMessage(PDException pDException) {
        String string = null;
        if (pDException != null) {
            PDMessages pDMessages = pDException.getMessages();
            if (pDMessages != null && pDMessages.size() > 0) {
                PDMessage pDMessage = (PDMessage)pDMessages.get(0);
                string = pDMessage.getMsgText();
            } else {
                PDException pDException2 = (PDException)pDException.getCause();
                string = GSOHelper.getFirstExceptionMessage(pDException2);
            }
        }
        return string;
    }

    static {
        _insts = new HashMap();
        _instLock = new RWLock();
    }
}

