/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc;

import com.tivoli.pd.as.jacc.PolicyHandlerMapping;
import com.tivoli.pd.as.jacc.util.JACCException;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.CfgManager;
import com.tivoli.pd.as.rbpf.CfgResource;
import com.tivoli.pd.as.rbpf.RtManager;
import com.tivoli.pd.as.rbpf.RtResource;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jutil.PDAttrValue;
import java.util.Iterator;
import java.util.List;

public class PolicyConfigurationHelper {
    private AmasSession _sess = null;
    private CfgManager _cfgMgr = null;
    private RtManager _rtMgr = null;
    private ILogger _trcLogger;
    private ILogger _msgLogger;
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    protected String POLICY_CONFIG_ATTR_NAME = "PolicyConfigurationSuccess";
    private static final String POLICY_CONFIG_ATTR_VALUE = "true";
    protected PolicyHandlerMapping DUMMY_HANDLER_MAPPING = new PolicyHandlerMapping();
    private static final String CLASSNAME = "com.tivoli.pd.as.jacc.PolicyConfigurationHelper";
    private final String PolicyConfigurationHelper_java_sourceCodeID = "@(#)03 1.2 src/jacc/com/tivoli/pd/as/jacc/PolicyConfigurationHelper.java, amemb.jacc.was, amemb600, 051118a 04/07/21 02:01:20 @(#)";

    public PolicyConfigurationHelper(AmasSession amasSession) {
        this._sess = amasSession;
        this._cfgMgr = this._sess.getCfgManager();
        this._rtMgr = this._sess.getRtManager();
        this._trcLogger = this._sess.getLogManager().getTraceLogger("JACCTraceLogger");
        this._msgLogger = this._sess.getLogManager().getMessageLogger("JACCMessageLogger");
    }

    public void create() throws JACCException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "create()");
        }
        CfgResource[] cfgResourceArray = null;
        int n = 0;
        try {
            cfgResourceArray = this._cfgMgr.createResources(this.DUMMY_HANDLER_MAPPING);
            n = cfgResourceArray.length;
            if (cfgResourceArray == null || n != 1) {
                AmasMessage amasMessage = new AmasMessage(864297007, new Integer(n));
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "create()", amasMessage.getMessageString());
                }
                throw new JACCException(amasMessage);
            }
            cfgResourceArray[0].addPolicyDataEntry(this.POLICY_CONFIG_ATTR_NAME, POLICY_CONFIG_ATTR_VALUE);
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = amasException.getAmasMessage();
            String string = null;
            if (amasMessage != null) {
                string = amasMessage.toString();
            }
            AmasMessage amasMessage2 = null;
            amasMessage2 = cfgResourceArray != null && cfgResourceArray[0] != null ? new AmasMessage(864297002, (Object)cfgResourceArray[0].getPosName(), string) : new AmasMessage(864297002, (Object)"", string);
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "create()", amasMessage2.getMessageString());
            }
            throw new JACCException(amasMessage2);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "create()");
        }
    }

    public boolean exists() throws JACCException {
        boolean bl;
        block7: {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.entry(80L, (Object)CLASSNAME, "exists()");
            }
            bl = false;
            RtResource rtResource = null;
            try {
                rtResource = this._rtMgr.matchResource(this.DUMMY_HANDLER_MAPPING);
                List list = rtResource.getLocalPolicyData(this.POLICY_CONFIG_ATTR_NAME);
                if (list == null) break block7;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string;
                    PDAttrValue pDAttrValue = (PDAttrValue)iterator.next();
                    int n = pDAttrValue.getType();
                    if (n != 4 || !(string = (String)pDAttrValue.getValue()).equalsIgnoreCase(POLICY_CONFIG_ATTR_VALUE)) continue;
                    bl = true;
                    break;
                }
            }
            catch (AmasException amasException) {
                AmasMessage amasMessage = amasException.getAmasMessage();
                String string = null;
                if (amasMessage != null) {
                    string = amasMessage.toString();
                }
                AmasMessage amasMessage2 = null;
                amasMessage2 = rtResource != null ? new AmasMessage(864297001, (Object)rtResource.getPosName(), string) : new AmasMessage(864297001, (Object)"", string);
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "exists()", amasMessage2.getMessageString());
                }
                throw new JACCException(amasMessage2);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "exists(): Returning " + bl);
        }
        return bl;
    }

    public void delete() throws JACCException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "delete()");
        }
        CfgResource cfgResource = null;
        try {
            cfgResource = this._cfgMgr.getCfgResource(this.DUMMY_HANDLER_MAPPING);
            if (cfgResource != null) {
                this._cfgMgr.deleteResource(cfgResource);
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = amasException.getAmasMessage();
            String string = null;
            if (amasMessage != null) {
                string = amasMessage.toString();
            }
            AmasMessage amasMessage2 = null;
            amasMessage2 = cfgResource != null ? new AmasMessage(864297000, (Object)cfgResource.getPosName(), string) : new AmasMessage(864297000, (Object)"", string);
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "delete()", amasMessage2.getMessageString());
            }
            throw new JACCException(amasMessage2);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "delete()");
        }
    }
}

