/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc;

import com.tivoli.pd.as.jacc.PolicyConfigurationHelper;
import com.tivoli.pd.as.jacc.RoleConfigurationHelper;
import com.tivoli.pd.as.jacc.util.JACCException;
import com.tivoli.pd.as.jacc.util.JACCUtil;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.RtManager;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jazn.PDPrincipal;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Properties;
import javax.security.jacc.PolicyContext;

public class TAMJACCPolicy
extends Policy {
    private final String TAMJACCPolicy_java_sourceCodeID = "$Id: @(#)97  1.1 src/jacc/com/tivoli/pd/as/jacc/TAMJACCPolicy.java, amemb.jacc.was, amemb600, 080423a 06/01/03 19:26:49 @(#) $";
    private Policy _policy = Policy.getPolicy();
    private static AmasSession _sess;
    private static PolicyConfigurationHelper _polHelper;
    private static RoleConfigurationHelper _roleHelper;
    private static RtManager _rtManager;
    private ILogger _trcLogger;
    private ILogger _msgLogger;
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.jacc.TAMJACCPolicy";

    public TAMJACCPolicy() throws JACCException {
        Object object;
        TAMJACCPolicy.init();
        _polHelper = new PolicyConfigurationHelper(_sess);
        _roleHelper = new RoleConfigurationHelper(_sess);
        _rtManager = _sess.getRtManager();
        this._trcLogger = _sess.getLogManager().getTraceLogger("JACCTraceLogger");
        this._msgLogger = _sess.getLogManager().getMessageLogger("JACCMessageLogger");
        try {
            object = null;
            try {
                object = JACCUtil.loadPropertiesFromClasspath("jaccHandlerMappings.properties");
            }
            catch (IOException iOException) {
                String string = AmasMsgHelper.formatSingleParamMessage(864296981, "jaccHandlerMappings.properties");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "TAMJACCPolicy()", string);
                }
                throw new JACCException(string);
            }
            _sess.registerResourceHandlerClasses((Properties)object);
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = amasException.getAmasMessage();
            String string = null;
            if (amasMessage != null) {
                string = amasMessage.toString();
            }
            AmasMessage amasMessage2 = new AmasMessage(864296992, string);
            System.out.println(amasMessage2.getMessageString());
            throw new JACCException(amasMessage2);
        }
        object = AmasMsgHelper.formatMessage(864296999, null);
        if (this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(1L, (Object)CLASSNAME, "TAMJACCPolicy()", (String)object);
        }
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        boolean bl = false;
        if (JACCUtil.isJACCPermission(permission)) {
            block25: {
                Object object;
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission): permission = " + permission.toString());
                }
                String string = PolicyContext.getContextID();
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "implies(): contextID = " + string, "About to check for existance of Policy and Role Configuration objects in TAM for context: " + string);
                }
                boolean bl2 = false;
                boolean bl3 = false;
                try {
                    bl2 = _polHelper.exists();
                }
                catch (JACCException jACCException) {
                    object = AmasMsgHelper.formatDoubleParamMessage(864297003, string, jACCException.toString());
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", (String)object);
                    }
                    bl = false;
                    bl2 = false;
                }
                if (bl2) {
                    try {
                        Principal[] principalArray = protectionDomain.getPrincipals();
                        if (principalArray == null || principalArray.length == 0) {
                            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                this._trcLogger.text(16L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", "Performing the unauthenticated access check for Permission: " + permission.toString());
                            }
                            bl = _rtManager.isAccessAllowed(permission, null);
                            break block25;
                        }
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", "About to extract PDPrincipal from the ProtectionDomain or Subject in access decision for Permission: " + permission.toString());
                        }
                        try {
                            object = principalArray[0];
                            if (object != null) {
                                String string2 = object.getName();
                                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                    this._trcLogger.text(16L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", "PDPrincipal successfully extracted from Subject. About to perform access decision for principal: " + string2 + " on Permission: " + permission.toString());
                                }
                                bl = _rtManager.isAccessAllowed(permission, string2);
                            } else {
                                String string3 = AmasMsgHelper.formatMessage(864296970, null);
                                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                                    this._msgLogger.text(4L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", string3);
                                }
                                bl = false;
                            }
                        }
                        catch (Exception exception) {
                            String string4 = AmasMsgHelper.formatSingleParamMessage(864296982, exception.toString());
                            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                                this._msgLogger.text(4L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", string4);
                            }
                            bl = false;
                        }
                    }
                    catch (AmasException amasException) {
                        object = AmasMsgHelper.formatDoubleParamMessage(864296972, permission.toString(), amasException.toString());
                        if (this._msgLogger != null && this._msgLogger.isLogging()) {
                            this._msgLogger.text(4L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission): permission = perm.toString()", (String)object);
                        }
                        bl = false;
                    }
                } else {
                    Object[] objectArray = new Object[]{permission.toString(), new Boolean(bl3), new Boolean(bl2)};
                    object = new AmasMessage(864297004, objectArray);
                    String string5 = ((AmasMessage)object).toString();
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission): permission = perm.toString()", string5);
                    }
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission): permission = " + permission.toString() + " : returning " + bl);
            }
        } else if (this._policy != null) {
            bl = this._policy.implies(protectionDomain, permission);
        }
        return bl;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getPermissions(CodeSource)");
        }
        PermissionCollection permissionCollection = null;
        if (this._policy != null) {
            permissionCollection = this._policy.getPermissions(codeSource);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getPermissions(CodeSource)");
        }
        return permissionCollection;
    }

    public void refresh() {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "refresh()");
        }
        if (this._policy != null) {
            this._policy.refresh();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "refresh()");
        }
    }

    private PDPrincipal getPDPrincipal(Principal[] principalArray, Permission permission) throws JACCException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getPDPrincipal(Subject, Permission)");
        }
        PDPrincipal pDPrincipal = null;
        if (principalArray != null && principalArray.length > 0) {
            for (int i = 0; i < principalArray.length; ++i) {
                if (!(principalArray[i] instanceof PDPrincipal)) continue;
                pDPrincipal = (PDPrincipal)principalArray[i];
                break;
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            String string = null;
            string = pDPrincipal != null ? " returning PDPrincipal for user: " + pDPrincipal.getName() + " on Permission: " + permission.toString() : " returning a null PDPrincipal on Permission: " + permission.toString();
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getPDPrincipal(Subject)" + string);
        }
        return pDPrincipal;
    }

    public static AmasSession getSess() {
        if (_sess == null) {
            try {
                TAMJACCPolicy.init();
            }
            catch (JACCException jACCException) {
                // empty catch block
            }
        }
        return _sess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void init() throws JACCException {
        AmasMessage amasMessage;
        Properties properties;
        block14: {
            if (_sess != null) return;
            properties = new Properties();
            File file = null;
            final File file2 = file = new File("amwas.properties");
            FileInputStream fileInputStream = null;
            SecurityManager securityManager = System.getSecurityManager();
            try {
                try {
                    if (securityManager == null) {
                        fileInputStream = new FileInputStream(file);
                    } else {
                        try {
                            fileInputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws FileNotFoundException {
                                    return new FileInputStream(file2);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            String string = AmasMsgHelper.formatSingleParamMessage(864296964, file.getAbsolutePath());
                            System.out.println(string);
                            throw new JACCException(string);
                        }
                    }
                    properties.load(fileInputStream);
                }
                catch (IOException iOException) {
                    String string = AmasMsgHelper.formatDoubleParamMessage(864296966, file.getAbsolutePath(), iOException.toString());
                    System.out.println(string);
                    throw new JACCException(string);
                }
                amasMessage = null;
                if (fileInputStream == null) break block14;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    String string = AmasMsgHelper.formatDoubleParamMessage(864296966, file.getAbsolutePath(), iOException.toString());
                    System.out.println(string);
                    throw new JACCException(string);
                }
            }
            try {}
            catch (IOException iOException) {
                String string = AmasMsgHelper.formatDoubleParamMessage(864296966, file.getAbsolutePath(), iOException.toString());
                System.out.println(string);
                throw new JACCException(string);
            }
            fileInputStream.close();
        }
        try {
            properties.put("com.tivoli.pd.as.rbpf.PropagateChildRole", "false");
            properties.put("com.tivoli.pd.as.rbpf.CopyParentRole", "false");
            properties.put("com.tivoli.pd.as.rbpf.DeleteBaseRoleRecursive", "false");
            _sess = AmasSession.create(properties);
            return;
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage2 = amasException.getAmasMessage();
            String string = null;
            if (amasMessage2 != null) {
                string = amasMessage2.toString();
            }
            amasMessage = new AmasMessage(864296991, string);
            System.out.println(amasMessage.getMessageString());
            throw new JACCException(amasMessage);
        }
    }
}

