/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.tivoli.pd.as.jacc.PolicyConfigurationHelper;
import com.tivoli.pd.as.jacc.RoleConfigurationHelper;
import com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.jacc.util.JACCException;
import com.tivoli.pd.as.jacc.util.JACCUtil;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.RtManager;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jazn.PDPrincipal;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jutil.PDException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;

public class TAMPolicy
extends Policy {
    private final String TAMPolicy_java_sourceCodeID = "$Id: @(#)20 1.23 src/jacc/com/tivoli/pd/as/jacc/TAMPolicy.java, amemb.jacc.was, amemb600, 071107a 07/11/06 18:38:32 @(#) $";
    private static boolean _isLocalMode = false;
    private Policy _policy = Policy.getPolicy();
    private static AmasSession _sess;
    private static PolicyConfigurationHelper _polHelper;
    private static RoleConfigurationHelper _roleHelper;
    private static RtManager _rtManager;
    private ILogger _trcLogger;
    private ILogger _msgLogger;
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.jacc.TAMPolicy";
    static /* synthetic */ Class class$com$ibm$websphere$security$cred$WSCredential;

    public TAMPolicy() throws JACCException {
        Object object;
        TAMPolicy.init();
        _polHelper = new PolicyConfigurationHelper(_sess);
        _roleHelper = new RoleConfigurationHelper(_sess);
        _rtManager = _sess.getRtManager();
        this._trcLogger = _sess.getLogManager().getTraceLogger("JACCTraceLogger");
        this._msgLogger = _sess.getLogManager().getMessageLogger("JACCMessageLogger");
        try {
            object = null;
            try {
                object = JACCUtil.loadPropertiesFromClasspath("jaccHandlerMappings.properties");
            }
            catch (IOException iOException) {
                String string = AmasMsgHelper.formatSingleParamMessage(864296981, "jaccHandlerMappings.properties");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "TAMPolicy()", string);
                }
                throw new JACCException(string);
            }
            _sess.registerResourceHandlerClasses((Properties)object);
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = amasException.getAmasMessage();
            String string = null;
            if (amasMessage != null) {
                string = amasMessage.toString();
            }
            AmasMessage amasMessage2 = new AmasMessage(864296992, string);
            System.out.println(amasMessage2.getMessageString());
            throw new JACCException(amasMessage2);
        }
        object = AmasMsgHelper.formatMessage(864296999, null);
        if (this._msgLogger != null && this._msgLogger.isLogging()) {
            this._msgLogger.text(1L, (Object)CLASSNAME, "TAMPolicy()", (String)object);
        }
    }

    public static boolean isLocalMode() {
        return _isLocalMode;
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        boolean bl = false;
        if (JACCUtil.isJACCPermission(permission)) {
            block24: {
                Object object;
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.entry(80L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission): permission = " + permission.toString());
                }
                String string = PolicyContext.getContextID();
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "implies(): contextID = " + string, "About to check for existance of Policy and Role Configuration objects in TAM for context: " + string);
                }
                boolean bl2 = false;
                boolean bl3 = false;
                try {
                    bl2 = _polHelper.exists();
                    bl3 = _roleHelper.exists();
                }
                catch (JACCException jACCException) {
                    object = AmasMsgHelper.formatDoubleParamMessage(864297003, string, jACCException.toString());
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", (String)object);
                    }
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                }
                if (bl2 && bl3) {
                    try {
                        Principal[] principalArray = protectionDomain.getPrincipals();
                        if (principalArray == null || principalArray.length == 0) {
                            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                this._trcLogger.text(16L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", "Performing the unauthenticated access check for Permission: " + permission.toString());
                            }
                            bl = _rtManager.isAccessAllowed(permission, null);
                            break block24;
                        }
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", "About to extract PDPrincipal from the ProtectionDomain or Subject in access decision for Permission: " + permission.toString());
                        }
                        object = null;
                        try {
                            object = this.getPDPrincipal(principalArray, permission);
                        }
                        catch (JACCException jACCException) {
                            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                this._trcLogger.text(16L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", "PDPrincipal unsuccessfully extracted from Subject. About to perform access decision for unauthenticated user.");
                            }
                            object = null;
                        }
                        if (object != null) {
                            String string2 = object.getName();
                            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                this._trcLogger.text(16L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", "PDPrincipal successfully extracted from Subject. About to perform access decision for principal: " + string2 + " on Permission: " + permission.toString());
                            }
                            bl = _rtManager.isAccessAllowed(permission, string2);
                            break block24;
                        }
                        String string3 = AmasMsgHelper.formatMessage(864296970, null);
                        if (this._msgLogger != null && this._msgLogger.isLogging()) {
                            this._msgLogger.text(4L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission)", string3);
                        }
                        bl = _rtManager.isAccessAllowed(permission, null);
                    }
                    catch (AmasException amasException) {
                        object = AmasMsgHelper.formatDoubleParamMessage(864296972, permission.toString(), amasException.toString());
                        if (this._msgLogger != null && this._msgLogger.isLogging()) {
                            this._msgLogger.text(4L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission): permission = perm.toString()", (String)object);
                        }
                        bl = false;
                    }
                } else {
                    Object[] objectArray = new Object[]{permission.toString(), new Boolean(bl3), new Boolean(bl2)};
                    object = new AmasMessage(864297004, objectArray);
                    String string4 = ((AmasMessage)object).toString();
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission): permission = perm.toString()", string4);
                    }
                }
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.exit(96L, (Object)CLASSNAME, "implies(ProtectionDomain, Permission): permission = " + permission.toString() + " : returning " + bl);
            }
        } else if (this._policy != null) {
            bl = this._policy.implies(protectionDomain, permission);
        }
        return bl;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getPermissions(CodeSource)");
        }
        PermissionCollection permissionCollection = null;
        if (this._policy != null) {
            permissionCollection = this._policy.getPermissions(codeSource);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getPermissions(CodeSource)");
        }
        return permissionCollection;
    }

    public void refresh() {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "refresh()");
        }
        if (this._policy != null) {
            this._policy.refresh();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "refresh()");
        }
    }

    private PDPrincipal getPDPrincipal(Principal[] principalArray, Permission permission) throws JACCException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getPDPrincipal(Subject, Permission)");
        }
        PDPrincipal pDPrincipal = null;
        Object var4_4 = null;
        if (principalArray != null && principalArray.length > 0) {
            for (int i = 0; i < principalArray.length; ++i) {
                if (!(principalArray[i] instanceof PDPrincipal)) continue;
                pDPrincipal = (PDPrincipal)principalArray[i];
                break;
            }
        }
        if (pDPrincipal == null) {
            String string;
            Object object;
            Subject subject;
            block31: {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "getPDPrincipal(Subject, Permission)", "A PDPrincipal was not found in the Subject");
                }
                subject = null;
                try {
                    subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
                }
                catch (PolicyContextException policyContextException) {
                    object = AmasMsgHelper.formatSingleParamMessage(864296971, permission.toString());
                    string = (String)object + ": " + AmasMsgHelper.formatDoubleParamMessage(864296963, PolicyContext.getContextID(), policyContextException.toString());
                    if (this._msgLogger == null || !this._msgLogger.isLogging()) break block31;
                    this._msgLogger.text(4L, (Object)CLASSNAME, "getPDPrincipal(Subject, Permission)", string);
                }
            }
            if (subject != null) {
                WSCredential wSCredential = null;
                object = subject.getPublicCredentials(class$com$ibm$websphere$security$cred$WSCredential == null ? (class$com$ibm$websphere$security$cred$WSCredential = TAMPolicy.class$("com.ibm.websphere.security.cred.WSCredential")) : class$com$ibm$websphere$security$cred$WSCredential);
                wSCredential = (WSCredential)object.iterator().next();
                string = null;
                if (wSCredential != null) {
                    try {
                        string = wSCredential.getSecurityName();
                    }
                    catch (CredentialDestroyedException credentialDestroyedException) {
                        String string2 = AmasMsgHelper.formatSingleParamMessage(864296973, credentialDestroyedException.toString());
                        if (this._msgLogger != null && this._msgLogger.isLogging()) {
                            this._msgLogger.text(4L, (Object)CLASSNAME, "getPDPrincipal(Subject)", string2);
                        }
                        throw new JACCException(string2);
                    }
                    catch (CredentialExpiredException credentialExpiredException) {
                        String string3 = AmasMsgHelper.formatSingleParamMessage(864296973, credentialExpiredException.toString());
                        if (this._msgLogger != null && this._msgLogger.isLogging()) {
                            this._msgLogger.text(4L, (Object)CLASSNAME, "getPDPrincipal(Subject)", string3);
                        }
                        throw new JACCException(string3);
                    }
                    if (string != null && string.length() > 0) {
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "getPDPrincipal(Subject)", "A WSPrincipal was found in the Subject. About to check the dynamic role cache for a PDPrincipal for user: " + string);
                        }
                        if ((pDPrincipal = (PDPrincipal)_rtManager.getPrinFromDynamicRoleCache(string)) == null) {
                            try {
                                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                    this._trcLogger.text(16L, (Object)CLASSNAME, "getPDPrincipal(Subject)", "A PDPrincipal for user: " + string + " was not found in the dynamic role cache, about to attempt to create a PDPrincipal manually.");
                                }
                                if (string.equalsIgnoreCase("UNAUTHENTICATED")) {
                                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                        this._trcLogger.text(16L, (Object)CLASSNAME, "getPDPrincipal(Subject)", "About to create PDPrincipal for the unauthenticated user");
                                    }
                                    pDPrincipal = new PDPrincipal(_sess.getSessionContext());
                                } else {
                                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                                        this._trcLogger.text(16L, (Object)CLASSNAME, "getPDPrincipal(Subject)", "About to create PDPrincipal for user: " + string);
                                    }
                                    pDPrincipal = new PDPrincipal(_sess.getSessionContext(), string);
                                }
                                _rtManager.addPrinToDynamicRoleCache(string, pDPrincipal);
                            }
                            catch (PDException pDException) {
                                String string4 = AmasMsgHelper.formatDoubleParamMessage(864296968, string, pDException.toString());
                                String string5 = string4 + ": " + AmasMsgHelper.formatSingleParamMessage(864296967, JACCUtil.getPDMessages(pDException.getMessages(), true));
                                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                                    this._msgLogger.text(4L, (Object)CLASSNAME, "getPDPrincipal(Subject)", string5);
                                }
                                throw new JACCException(string5);
                            }
                            catch (AmasException amasException) {
                                AmasMessage amasMessage = amasException.getAmasMessage();
                                String string6 = null;
                                if (amasMessage != null) {
                                    string6 = amasMessage.toString();
                                }
                                AmasMessage amasMessage2 = new AmasMessage(864296993, (Object)string, string6);
                                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                                    this._msgLogger.text(4L, (Object)CLASSNAME, "getPDPrincipal(Subject)", amasMessage2.getMessageString());
                                }
                                throw new JACCException(amasMessage2);
                            }
                        } else if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "getPDPrincipal(Subject)", "A PDPrincipal for user: " + string + " was found in the dynamic role cache and is being returned.");
                        }
                    }
                }
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            String string = null;
            string = pDPrincipal != null ? " returning PDPrincipal for user: " + pDPrincipal.getName() + " on Permission: " + permission.toString() : " returning a null PDPrincipal on Permission: " + permission.toString();
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getPDPrincipal(Subject)" + string);
        }
        return pDPrincipal;
    }

    public static AmasSession getSess() {
        if (_sess == null) {
            try {
                TAMPolicy.init();
            }
            catch (JACCException jACCException) {
                // empty catch block
            }
        }
        return _sess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void init() throws JACCException {
        AmasMessage amasMessage;
        Object object;
        block15: {
            Object object2;
            Object object3;
            if (_sess != null) return;
            Properties properties = null;
            if (TAMPolicy.isLocalMode()) {
                object = TAMConfigUtils.getStringGeneratorForCtx();
                object3 = ((TAMConfigStringGenerator)object).getStringFromTemplate("cells/${CELL_NAME}/amwas.amjacc.template.properties");
                properties = TAMPolicy.readCfgRepositoryProperties((String)object3);
                boolean bl = System.getProperty("os.name").startsWith("Windows");
                object2 = "file:" + (bl ? "/" : "") + ((TAMConfigStringGenerator)object).getPDHome() + File.separator + "PDJLog.properties";
                properties.put("com.tivoli.pd.as.rbpf.AmasSession.LoggingURL", object2);
                properties.put("com.tivoli.pd.as.atcc.ATCCache.enabled", "false");
            }
            object = new Properties(properties);
            object3 = null;
            object3 = !TAMPolicy.isLocalMode() ? new File(TAMConfigUtils.getAMJACCConfigFilename()) : new File(TAMConfigUtils.getAMSvrSSLCfgFilename());
            Object object4 = object3;
            object2 = null;
            SecurityManager securityManager = System.getSecurityManager();
            try {
                try {
                    if (securityManager == null) {
                        object2 = new FileInputStream((File)object3);
                    } else {
                        try {
                            object2 = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction((File)object4){
                                private final /* synthetic */ File val$temp;
                                {
                                    this.val$temp = file;
                                }

                                public Object run() throws FileNotFoundException {
                                    return new FileInputStream(this.val$temp);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            String string = AmasMsgHelper.formatSingleParamMessage(864296964, ((File)object3).getAbsolutePath());
                            System.out.println(string);
                            throw new JACCException(string);
                        }
                    }
                    ((Properties)object).load((InputStream)object2);
                }
                catch (IOException iOException) {
                    String string = AmasMsgHelper.formatDoubleParamMessage(864296966, ((File)object3).getAbsolutePath(), iOException.toString());
                    System.out.println(string);
                    throw new JACCException(string);
                }
                amasMessage = null;
                if (object2 == null) break block15;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                if (object2 == null) throw throwable;
                try {
                    ((FileInputStream)object2).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    String string = AmasMsgHelper.formatDoubleParamMessage(864296966, ((File)object3).getAbsolutePath(), iOException.toString());
                    System.out.println(string);
                    throw new JACCException(string);
                }
            }
            try {}
            catch (IOException iOException) {
                String string = AmasMsgHelper.formatDoubleParamMessage(864296966, ((File)object3).getAbsolutePath(), iOException.toString());
                System.out.println(string);
                throw new JACCException(string);
            }
            ((FileInputStream)object2).close();
        }
        try {
            ((Properties)object).put("com.tivoli.pd.as.rbpf.PropagateChildRole", "false");
            ((Properties)object).put("com.tivoli.pd.as.rbpf.CopyParentRole", "false");
            ((Properties)object).put("com.tivoli.pd.as.rbpf.DeleteBaseRoleRecursive", "false");
            _sess = AmasSession.create((Properties)object);
            return;
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage2 = amasException.getAmasMessage();
            String string = null;
            if (amasMessage2 != null) {
                string = amasMessage2.toString();
            }
            amasMessage = new AmasMessage(864296991, string);
            System.out.println(amasMessage.getMessageString());
            throw new JACCException(amasMessage);
        }
    }

    static Properties readCfgRepositoryProperties(String string) {
        Properties properties = new Properties();
        try {
            DocumentContentSource documentContentSource;
            ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
            if (configRepository != null && (documentContentSource = configRepository.extract(string)) != null) {
                InputStream inputStream = documentContentSource.getSource();
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            System.out.println("readCfgRepositoryProperties, ioE " + iOException.toString());
        }
        catch (RepositoryException repositoryException) {
            System.out.println("readCfgRepositoryProperties, re " + repositoryException.toString());
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService == null) {
            _isLocalMode = true;
        }
    }
}

