/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc;

import com.tivoli.pd.as.jacc.ContextIDHelper;
import com.tivoli.pd.as.jacc.ContextIdTable;
import com.tivoli.pd.as.jacc.PolicyConfigurationHelper;
import com.tivoli.pd.as.jacc.TAMPolicy;
import com.tivoli.pd.as.jacc.util.AddRolePolicyConfigCmd;
import com.tivoli.pd.as.jacc.util.BasePolicyConfigCmd;
import com.tivoli.pd.as.jacc.util.JACCConstants;
import com.tivoli.pd.as.jacc.util.JACCException;
import com.tivoli.pd.as.jacc.util.RemoveRolePolicyConfigCmd;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.CfgManager;
import com.tivoli.pd.as.rbpf.CfgRole;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.AmasPDHelper;
import com.tivoli.pd.as.util.AmasUtil;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import com.tivoli.pd.jutil.PDContext;
import com.tivoli.pd.jutil.PDException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;

public class TAMPolicyConfiguration
implements PolicyConfiguration {
    private final String TAMPolicyConfiguration_java_sourceCodeID = "$Id: @(#)21  1.16.1.1 src/jacc/com/tivoli/pd/as/jacc/TAMPolicyConfiguration.java, amemb.jacc.was, amemb600, 081121a 08/11/20 20:25:00 @(#) $";
    private String _contextID;
    private Vector _commands;
    private String _state;
    private ILogger _trcLogger;
    private ILogger _msgLogger;
    private static String _excludedRoleName;
    private static String _uncheckedRoleName;
    private static PolicyConfigurationHelper _polHelper;
    private static AmasSession _sess;
    private static int NOT_SEARCHED;
    private static int DO_NOT_SEARCH;
    private static int DO_SEARCH;
    private SecurityManager _secMgr;
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.jacc.TAMPolicyConfiguration";

    public TAMPolicyConfiguration(String string) {
        this._contextID = string;
        this._state = "open";
        this._commands = new Vector();
        _excludedRoleName = _sess.getDefaultExcludedName();
        _uncheckedRoleName = _sess.getDefaultUncheckedName();
        this._trcLogger = _sess.getLogManager().getTraceLogger("JACCTraceLogger");
        this._msgLogger = _sess.getLogManager().getMessageLogger("JACCMessageLogger");
        this._secMgr = System.getSecurityManager();
    }

    public synchronized void commit() throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "commit()", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("deleted")) {
            String string = AmasMsgHelper.formatDoubleParamMessage(864296965, this._contextID, "commit");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, string);
            }
            throw new UnsupportedOperationException(string);
        }
        if (this._state.equalsIgnoreCase("open")) {
            Object object;
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "commit(): : contextID = " + this._contextID, "Commiting all command elements in PolicyConfiguration instance with context ID: " + this._contextID);
            }
            List list = this.generateNewCommands();
            this._commands.addAll(list);
            _sess.getCfgManager().enableCache();
            ContextIdTable.setContextID(this._contextID);
            Enumeration enumeration = this._commands.elements();
            while (enumeration.hasMoreElements()) {
                object = (BasePolicyConfigCmd)enumeration.nextElement();
                try {
                    ((BasePolicyConfigCmd)object).commit();
                }
                catch (JACCException jACCException) {
                    String string = AmasMsgHelper.formatDoubleParamMessage(864296985, this._contextID, jACCException.toString());
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, string);
                    }
                    throw new PolicyContextException(string);
                }
            }
            _sess.getCfgManager().disableCache();
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, "About to create PolicyConfigureation object in TAM for contextID: " + this._contextID);
            }
            try {
                _polHelper.create();
            }
            catch (JACCException jACCException) {
                object = AmasMsgHelper.formatDoubleParamMessage(864297002, this._contextID, jACCException.toString());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, (String)object);
                }
                throw new PolicyContextException((String)object);
            }
            ContextIdTable.removeContextID();
            this._commands.clear();
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, "Updating state of PolicyConfiguration instance with context ID: " + this._contextID + " to " + "inService");
            }
            this._state = "inService";
        } else if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, "Called commit on PolicyConfiguration instance with context ID: " + this._contextID + " with state " + "inService" + ". No action was performed.");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID);
        }
    }

    public synchronized void delete() throws PolicyContextException {
        Object object;
        Object object2;
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "delete(): contextID  = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "delete()", amasMessage.getMessageString());
            }
            throw securityException;
        }
        this._commands.clear();
        _sess.getCfgManager().enableCache();
        CfgManager cfgManager = _sess.getCfgManager();
        CfgRole[] cfgRoleArray = new CfgRole[]{};
        try {
            ContextIdTable.setContextID(this._contextID);
            cfgRoleArray = cfgManager.getRoles(JACCConstants._DUMMY_PERM);
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = amasException.getAmasMessage();
            String string = null;
            if (amasMessage != null) {
                string = amasMessage.toString();
                string = amasMessage.getMessageString();
            }
            String string2 = AmasMsgHelper.formatDoubleParamMessage(864296986, this._contextID, string);
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "delete()", string2);
            }
            ContextIdTable.removeContextID();
            throw new PolicyContextException(string2);
        }
        String string = _sess.getProperty("com.tivoli.pd.as.rbpf.NoUncheckedRoles");
        boolean bl = AmasUtil.checkBoolProperty(string, false);
        if (bl) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "delete()", "Deleting all remaining resources.");
            }
            try {
                ContextIDHelper contextIDHelper = new ContextIDHelper(this._contextID);
                object2 = contextIDHelper.getCellName();
                String string3 = contextIDHelper.getAppName();
                object = new RemoveRolePolicyConfigCmd("unchecked_TIV_GC_" + (String)object2 + "_TIV_GC_" + string3, this._contextID);
                ((BasePolicyConfigCmd)object).commit();
            }
            catch (AmasException amasException) {
                String string4 = AmasMsgHelper.formatDoubleParamMessage(864296985, this._contextID, amasException.toString());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "delete(): contextID = " + this._contextID, string4);
                }
                ContextIdTable.removeContextID();
                throw new PolicyContextException(string4);
            }
            catch (JACCException jACCException) {
                String string5 = AmasMsgHelper.formatDoubleParamMessage(864296985, this._contextID, jACCException.toString());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "delete(): contextID = " + this._contextID, string5);
                }
                ContextIdTable.removeContextID();
                throw new PolicyContextException(string5);
            }
        }
        for (int i = 0; i < cfgRoleArray.length; ++i) {
            object2 = new RemoveRolePolicyConfigCmd(cfgRoleArray[i].getRoleName(), this._contextID);
            try {
                ((BasePolicyConfigCmd)object2).commit();
                continue;
            }
            catch (JACCException jACCException) {
                object = AmasMsgHelper.formatDoubleParamMessage(864296985, this._contextID, jACCException.toString());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "delete(): contextID = " + this._contextID, (String)object);
                }
                ContextIdTable.removeContextID();
                throw new PolicyContextException((String)object);
            }
        }
        try {
            if (!bl) {
                this.finalCleanup();
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "delete(): contextID = " + this._contextID, "About to delete PolicyConfiguration object from TAM for contextID: " + this._contextID);
                }
                _polHelper.delete();
            }
        }
        catch (JACCException jACCException) {
            throw new PolicyContextException((Throwable)jACCException);
        }
        finally {
            ContextIdTable.removeContextID();
        }
        _sess.getCfgManager().disableCache();
        this._commands.clear();
        this._state = "deleted";
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "delete(): contextID = " + this._contextID);
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeExcludedPolicy(): contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeExcludedPolicy()", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (!this._state.equalsIgnoreCase("open")) {
            String string = AmasMsgHelper.formatDoubleParamMessage(864296965, this._contextID, "removeExcludedPolicy");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeExcludedPolicy(): contextID = " + this._contextID, string);
            }
            throw new UnsupportedOperationException(string);
        }
        RemoveRolePolicyConfigCmd removeRolePolicyConfigCmd = new RemoveRolePolicyConfigCmd(_excludedRoleName, this._contextID);
        this._commands.add(removeRolePolicyConfigCmd);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeExcludedPolicy(): contextID = " + this._contextID);
        }
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeUncheckedPolicy(): contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeUncheckedPolicy()", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (!this._state.equalsIgnoreCase("open")) {
            String string = AmasMsgHelper.formatDoubleParamMessage(864296965, this._contextID, "removeUncheckedPolicy");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeUncheckedPolicy(): contextID = " + this._contextID, string);
            }
            throw new UnsupportedOperationException(string);
        }
        RemoveRolePolicyConfigCmd removeRolePolicyConfigCmd = new RemoveRolePolicyConfigCmd(_uncheckedRoleName, this._contextID);
        this._commands.add(removeRolePolicyConfigCmd);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeUncheckedPolicy(): contextID = " + this._contextID);
        }
    }

    public boolean inService() throws PolicyContextException {
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "inService()", amasMessage.getMessageString());
            }
            throw securityException;
        }
        return this._state.equalsIgnoreCase("inService");
    }

    public String getContextID() throws PolicyContextException {
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getContextID()", amasMessage.getMessageString());
            }
            throw securityException;
        }
        return this._contextID;
    }

    public void removeRole(String string) throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeRole(String): roleName = " + string + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeRole(String)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (!this._state.equalsIgnoreCase("open")) {
            String string2 = AmasMsgHelper.formatDoubleParamMessage(864296965, this._contextID, "removeRole");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeRole(String): roleName = " + string + " contextID = " + this._contextID, string2);
            }
            throw new UnsupportedOperationException(string2);
        }
        RemoveRolePolicyConfigCmd removeRolePolicyConfigCmd = new RemoveRolePolicyConfigCmd(string, this._contextID);
        this._commands.add(removeRolePolicyConfigCmd);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeRole(String): roleName = " + string + " contextID = " + this._contextID);
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addToExcludedPolicy(Permission): permission = " + permission.toString() + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToExcludedPolicy(Permission)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (!this._state.equalsIgnoreCase("open")) {
            String string = AmasMsgHelper.formatDoubleParamMessage(864296965, this._contextID, "addToExcludedPolicy");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToExcludedPolicy(Permission): permission = " + permission.toString() + " contextID = " + this._contextID, string);
            }
            throw new UnsupportedOperationException(string);
        }
        AddRolePolicyConfigCmd addRolePolicyConfigCmd = new AddRolePolicyConfigCmd(_excludedRoleName, permission, this._contextID);
        this._commands.add(addRolePolicyConfigCmd);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addToExcludedPolicy(Permission): permission = " + permission.toString() + " contextID = " + this._contextID);
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addToUncheckedPolicy(Permission): permission = " + permission.toString() + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToUncheckedPolicy(Permission)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (!this._state.equalsIgnoreCase("open")) {
            String string = AmasMsgHelper.formatDoubleParamMessage(864296965, this._contextID, "addToUncheckedPolicy");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToUncheckedPolicy(Permission): permission = " + permission.toString() + " contextID = " + this._contextID, string);
            }
            throw new UnsupportedOperationException(string);
        }
        AddRolePolicyConfigCmd addRolePolicyConfigCmd = new AddRolePolicyConfigCmd(_uncheckedRoleName, permission, this._contextID);
        this._commands.add(addRolePolicyConfigCmd);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addToUncheckedPolicy(Permission): permission = " + permission.toString() + " contextID = " + this._contextID);
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissionCollection) throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addToExcludedPolicy(PermissionCollection): contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToExcludedPolicy(PermissionCollection)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            if (permissionCollection != null) {
                Enumeration<Permission> enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    AddRolePolicyConfigCmd addRolePolicyConfigCmd = new AddRolePolicyConfigCmd(_excludedRoleName, enumeration.nextElement(), this._contextID);
                    this._commands.add(addRolePolicyConfigCmd);
                }
            }
        } else {
            String string = AmasMsgHelper.formatDoubleParamMessage(864296965, this._contextID, "addToExcludedPolicy");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToExcludedPolicy(PermissionCollection): contextID = " + this._contextID, string);
            }
            throw new UnsupportedOperationException(string);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addToExcludedPolicy(PermissionCollection): contextID = " + this._contextID);
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissionCollection) throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addToUncheckedPolicy(PermissionCollection): contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToUncheckedPolicy(PermissionCollection)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            if (permissionCollection != null) {
                Enumeration<Permission> enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    AddRolePolicyConfigCmd addRolePolicyConfigCmd = new AddRolePolicyConfigCmd(_uncheckedRoleName, enumeration.nextElement(), this._contextID);
                    this._commands.add(addRolePolicyConfigCmd);
                }
            }
        } else {
            String string = AmasMsgHelper.formatDoubleParamMessage(864296965, this._contextID, "addToUncheckedPolicy");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToUncheckedPolicy(PermissionCollection): contextID = " + this._contextID, string);
            }
            throw new UnsupportedOperationException(string);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addToUncheckedPolicy(PermissionCollection): contextID = " + this._contextID);
        }
    }

    public void addToRole(String string, Permission permission) throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addToRole(String, Permission): roleName = " + string + " permission = " + permission.toString() + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToRole(String,Permission)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (!this._state.equalsIgnoreCase("open")) {
            String string2 = AmasMsgHelper.formatDoubleParamMessage(864296965, this._contextID, "addToRole");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToRole(String, Permission): roleName = " + string + " permission = " + permission.toString() + " contextID = " + this._contextID, string2);
            }
            throw new UnsupportedOperationException(string2);
        }
        AddRolePolicyConfigCmd addRolePolicyConfigCmd = new AddRolePolicyConfigCmd(string, permission, this._contextID);
        this._commands.add(addRolePolicyConfigCmd);
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addToRole(String, Permission): roleName = " + string + " permission = " + permission.toString() + " contextID = " + this._contextID);
        }
    }

    public void addToRole(String string, PermissionCollection permissionCollection) throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addToRole(String, PermissionCollection): roleName = " + string + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToRole(String,PermissionCollection)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            if (permissionCollection != null) {
                Enumeration<Permission> enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    AddRolePolicyConfigCmd addRolePolicyConfigCmd = new AddRolePolicyConfigCmd(string, enumeration.nextElement(), this._contextID);
                    this._commands.add(addRolePolicyConfigCmd);
                }
            }
        } else {
            String string2 = AmasMsgHelper.formatDoubleParamMessage(864296965, this._contextID, "addToRole");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "addToRole(String, PermissionCollection): roleName = " + string + " contextID = " + this._contextID, string2);
            }
            throw new UnsupportedOperationException(string2);
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addToRole(String, PermissionCollection): roleName = " + string + " contextID = " + this._contextID);
        }
    }

    public void linkConfiguration(PolicyConfiguration policyConfiguration) throws PolicyContextException {
    }

    void clearPolicyStatements() {
        this._commands.clear();
    }

    synchronized void setStateOpen() {
        this._state = "open";
    }

    private void finalCleanup() throws JACCException {
        try {
            ContextIDHelper contextIDHelper = new ContextIDHelper(this._contextID);
            String string = contextIDHelper.getCellName();
            String string2 = contextIDHelper.getAppName();
            String string3 = contextIDHelper.getModuleName();
            if (string == null || string2 == null || string3 == null) {
                AmasMessage amasMessage = new AmasMessage(864296983, this._contextID);
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "finalCleanup", amasMessage.getMessageString());
                }
                throw new JACCException(amasMessage);
            }
            String string4 = _sess.getResourceContainerName();
            string4 = AmasUtil.appendPosValue(string4, string);
            string4 = AmasUtil.appendPosValue(string4, "WebUserDataPermission");
            string4 = AmasUtil.appendPosValue(string4, string2);
            string4 = AmasUtil.appendPosValue(string4, string3);
            ArrayList arrayList = new ArrayList();
            AmasPDHelper.listResourcesRecursive(arrayList, _sess.getSessionContext(), string4);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                AmasPDHelper.deleteObject((String)iterator.next(), (PDContext)_sess.getSessionContext());
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = amasException.getAmasMessage();
            String string = null;
            if (amasMessage != null) {
                string = amasMessage.toString();
            }
            AmasMessage amasMessage2 = new AmasMessage(864296990, (Object)this._contextID, string);
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "finalCleanup()", amasMessage2.getMessageString());
            }
            throw new JACCException(amasMessage2);
        }
        catch (PDException pDException) {
            AmasMessage amasMessage = new AmasMessage(864296990, (Object)this._contextID, pDException.toString());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "finalCleanup()", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
    }

    private List generateNewCommands() {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "generateNewCommands(): contextID = " + this._contextID);
        }
        int n = this._commands.size();
        int[] nArray = new int[n];
        ArrayList<AddRolePolicyConfigCmd> arrayList = new ArrayList<AddRolePolicyConfigCmd>();
        for (int i = 0; i < n; ++i) {
            BasePolicyConfigCmd basePolicyConfigCmd = (BasePolicyConfigCmd)this._commands.elementAt(i);
            if (nArray[i] == DO_NOT_SEARCH) continue;
            if (basePolicyConfigCmd instanceof AddRolePolicyConfigCmd && ((AddRolePolicyConfigCmd)basePolicyConfigCmd).isEJBMethodPermission()) {
                nArray[i] = DO_SEARCH;
                String string = basePolicyConfigCmd.getRoleName();
                EJBMethodPermission eJBMethodPermission = (EJBMethodPermission)((AddRolePolicyConfigCmd)basePolicyConfigCmd).getPermission();
                for (int j = 0; j < n; ++j) {
                    if (j == i || nArray[j] == DO_NOT_SEARCH) continue;
                    BasePolicyConfigCmd basePolicyConfigCmd2 = (BasePolicyConfigCmd)this._commands.elementAt(j);
                    if (basePolicyConfigCmd2 instanceof AddRolePolicyConfigCmd && ((AddRolePolicyConfigCmd)basePolicyConfigCmd2).isEJBMethodPermission()) {
                        nArray[j] = DO_SEARCH;
                        EJBMethodPermission eJBMethodPermission2 = (EJBMethodPermission)((AddRolePolicyConfigCmd)basePolicyConfigCmd2).getPermission();
                        if (!eJBMethodPermission.implies((Permission)eJBMethodPermission2) || eJBMethodPermission.equals((Object)eJBMethodPermission2)) continue;
                        if (this._trcLogger != null && this._trcLogger.isLogging()) {
                            this._trcLogger.text(16L, (Object)CLASSNAME, "generateNewCommands(): contextID = " + this._contextID, "Generating new AddRolePolicyConfigCmd for EJBMethodPermission: " + eJBMethodPermission2.toString() + ". Adding it to security role: " + string + " in contextID: " + this._contextID);
                        }
                        AddRolePolicyConfigCmd addRolePolicyConfigCmd = new AddRolePolicyConfigCmd(string, (Permission)eJBMethodPermission2, this._contextID);
                        arrayList.add(addRolePolicyConfigCmd);
                        continue;
                    }
                    nArray[j] = DO_NOT_SEARCH;
                }
                continue;
            }
            nArray[i] = DO_NOT_SEARCH;
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "generateNewCommands(): contextID = " + this._contextID);
        }
        return arrayList;
    }

    static {
        String string = System.getProperty("javax.security.jacc.policy.provider");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Method method2 = clazz.getDeclaredMethod("getSess", null);
                _sess = (AmasSession)method2.invoke(null, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                _sess = TAMPolicy.getSess();
            }
            catch (ClassNotFoundException classNotFoundException) {
                _sess = TAMPolicy.getSess();
            }
            catch (IllegalAccessException illegalAccessException) {
                _sess = TAMPolicy.getSess();
            }
            catch (InvocationTargetException invocationTargetException) {
                _sess = TAMPolicy.getSess();
            }
        } else {
            _sess = TAMPolicy.getSess();
        }
        _polHelper = new PolicyConfigurationHelper(_sess);
        NOT_SEARCHED = 0;
        DO_NOT_SEARCH = 1;
        DO_SEARCH = 2;
    }
}

