/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc;

import com.tivoli.pd.as.jacc.TAMPolicy;
import com.tivoli.pd.as.jacc.TAMPolicyConfiguration;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.SecurityPermission;
import java.util.Hashtable;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;

public class TAMPolicyConfigurationFactory
extends PolicyConfigurationFactory {
    private final String TAMPolicyConfigurationFactory_java_sourceCodeID = "$Id: @(#)19  1.6 src/jacc/com/tivoli/pd/as/jacc/TAMPolicyConfigurationFactory.java, amemb.jacc.was, amemb600, 080423a 06/01/03 19:27:32 @(#) $";
    private AmasSession _sess;
    private ILogger _trcLogger;
    private ILogger _msgLogger;
    private Hashtable _policyContexts;
    private SecurityManager _secMgr;
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.jacc.TAMPolicyConfigurationFactory";

    public TAMPolicyConfigurationFactory() {
        String string = System.getProperty("javax.security.jacc.policy.provider");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Method method2 = clazz.getDeclaredMethod("getSess", null);
                this._sess = (AmasSession)method2.invoke(null, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this._sess = TAMPolicy.getSess();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._sess = TAMPolicy.getSess();
            }
            catch (IllegalAccessException illegalAccessException) {
                this._sess = TAMPolicy.getSess();
            }
            catch (InvocationTargetException invocationTargetException) {
                this._sess = TAMPolicy.getSess();
            }
        } else {
            this._sess = TAMPolicy.getSess();
        }
        this._policyContexts = new Hashtable();
        this._trcLogger = this._sess.getLogManager().getTraceLogger("JACCTraceLogger");
        this._msgLogger = this._sess.getLogManager().getMessageLogger("JACCMessageLogger");
        this._secMgr = System.getSecurityManager();
    }

    public PolicyConfiguration getPolicyConfiguration(String string, boolean bl) {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getPolicyConfiguration(String, boolean) contextID = " + string + " remove = " + bl);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getPolicyConfiguration(String,boolean)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        TAMPolicyConfiguration tAMPolicyConfiguration = (TAMPolicyConfiguration)this._policyContexts.get(string);
        if (tAMPolicyConfiguration == null) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getPolicyConfiguration(String, boolean)", "A PolicyConfiguration instance with contextID: " + string + " was not found, thus creating a new instance and returning it.");
            }
            tAMPolicyConfiguration = new TAMPolicyConfiguration(string);
            this._policyContexts.put(string, tAMPolicyConfiguration);
        } else {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getPolicyConfiguration(String, boolean)", "A PolicyConfiguration instance with contextID: " + string + " was found.");
            }
            if (bl) {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "getPolicyConfiguration(String, boolean)", "Removing all policy statements from PolicyConfiguration instance with contextID: " + string);
                }
                tAMPolicyConfiguration.clearPolicyStatements();
            }
            tAMPolicyConfiguration.setStateOpen();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getPolicyConfiguration(String, boolean)");
        }
        return tAMPolicyConfiguration;
    }

    public boolean inService(String string) throws PolicyContextException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "inService(String) contextID = " + string);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "inService()", amasMessage.getMessageString());
            }
            throw securityException;
        }
        boolean bl = false;
        PolicyConfiguration policyConfiguration = (PolicyConfiguration)this._policyContexts.get(string);
        if (policyConfiguration == null) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "inService(String)", "A PolicyConfiguration instance with contextID: " + string + " was not found, returning false.");
            }
        } else {
            try {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "inService(String)", "A PolicyConfiguration instance with contextID: " + string + " was found, thus returning its inService status.");
                }
                bl = policyConfiguration.inService();
            }
            catch (PolicyContextException policyContextException) {
                String string2 = AmasMsgHelper.formatDoubleParamMessage(864296963, string, policyContextException.toString());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "inService(String)", string2);
                }
                throw policyContextException;
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getPolicyConfiguration(String)");
        }
        return bl;
    }
}

