/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc;

import com.ibm.ejs.models.base.bindings.applicationbnd.impl.GroupImpl;
import com.ibm.ejs.models.base.bindings.applicationbnd.impl.UserImpl;
import com.ibm.wsspi.security.authorization.RoleConfiguration;
import com.ibm.wsspi.security.authorization.RoleConfigurationException;
import com.tivoli.pd.as.jacc.ContextIdTable;
import com.tivoli.pd.as.jacc.RoleConfigurationHelper;
import com.tivoli.pd.as.jacc.TAMPolicy;
import com.tivoli.pd.as.jacc.util.AddUsersRoleConfigCmd;
import com.tivoli.pd.as.jacc.util.BasePolicyConfigCmd;
import com.tivoli.pd.as.jacc.util.JACCException;
import com.tivoli.pd.as.jacc.util.RemoveUsersRoleConfigCmd;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.CfgManager;
import com.tivoli.pd.as.rbpf.CfgRole;
import com.tivoli.pd.as.rbpf.RoleMember;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.security.jacc.WebRoleRefPermission;

public class TAMRoleConfiguration
implements RoleConfiguration {
    private final String TAMRoleConfiguration_java_sourceCodeID = "$Id: @(#)23 1.12 src/jacc/com/tivoli/pd/as/jacc/TAMRoleConfiguration.java, amemb.jacc.was, amemb600, 051118a 05/04/11 01:36:38 @(#) $";
    private static WebRoleRefPermission _DUMMY_PERMISSION = new WebRoleRefPermission("dummy", "dummy");
    private Vector _commands;
    private String _contextID;
    private String _state;
    private ILogger _trcLogger;
    private ILogger _msgLogger;
    private static AmasSession _sess = TAMPolicy.getSess();
    private static RoleConfigurationHelper _roleHelper = new RoleConfigurationHelper(_sess);
    private SecurityManager _secMgr;
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.jacc.TAMRoleConfiguration";

    public TAMRoleConfiguration(String string) {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "TAMRoleConfiguration(String): contextID = " + string);
        }
        this._contextID = string;
        this._state = "open";
        _sess = TAMPolicy.getSess();
        this._commands = new Vector();
        this._trcLogger = _sess.getLogManager().getTraceLogger("JACCTraceLogger");
        this._msgLogger = _sess.getLogManager().getMessageLogger("JACCMessageLogger");
        this._secMgr = System.getSecurityManager();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "TAMRoleConfiguration(String): contextID = " + string);
        }
    }

    public void addUsersToRole(String string, List list) throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addUsersToRole(String, List): roleName = " + string + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addUsersToRole(String,List)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            List list2 = this.buildRoleMemberList(list, 1);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addUsersToRole(String, list): roleName = " + string, "Adding command object ro add users to role: " + string + " in context: " + this._contextID);
            }
            this._commands.add(new AddUsersRoleConfigCmd(string, list2, this._contextID));
        } else {
            if (this._state.equalsIgnoreCase("deleted")) {
                AmasMessage amasMessage = new AmasMessage(864296996, (Object)this._contextID, "addUsersToRole");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "addUsersToRole(String, list): roleName = " + string, amasMessage.getMessageString());
                }
                throw new UnsupportedOperationException(amasMessage.getMessageString());
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addUsersToRole(String, List): roleName = " + string, "method called on isService TAMRoleConfiguration instance. No action will be taken.  contextID: " + this._contextID);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addUsersToRole(String, List): roleName = " + string + " contextID = " + this._contextID);
        }
    }

    public void removeUsersFromRole(String string, List list) throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeUsersFromRole(String, List): roleName = " + string + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeUsersFromRole(String,List)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeUsersFromRole(String): roleName = " + string, "TAMRoleConfiguration instance with contextID: " + this._contextID + " is in the open state.");
            }
            List list2 = this.buildRoleMemberList(list, 1);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeUsersFromRole(String, list): roleName = " + string, "Adding command object ro remove users from role: " + string + " in context: " + this._contextID);
            }
            this._commands.add(new RemoveUsersRoleConfigCmd(string, list2, this._contextID));
        } else {
            if (this._state.equalsIgnoreCase("deleted")) {
                AmasMessage amasMessage = new AmasMessage(864296996, (Object)this._contextID, "removeUsersFromRole");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "removeUsersFromRole(String, list): roleName = " + string, amasMessage.getMessageString());
                }
                throw new UnsupportedOperationException(amasMessage.getMessageString());
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeUsersFromRole(String, List): roleName = " + string, "method called on isService TAMRoleConfiguration instance. No action will be taken.  contextID: " + this._contextID);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeUsersFromRole(String, List): roleName = " + string + " contextID = " + this._contextID);
        }
    }

    public void addGroupsToRole(String string, List list) throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addGroupsToRole(String, List): roleName = " + string + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addGroupsToRole(String,List)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addGroupsToRole(String, List): roleName = " + string, "TAMRoleConfiguration instance with contextID: " + this._contextID + " is in the open state.");
            }
            List list2 = this.buildRoleMemberList(list, 2);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addGroupsToRole(String, list): roleName = " + string, "Adding command object to add groups to role: " + string + " in context: " + this._contextID);
            }
            this._commands.add(new AddUsersRoleConfigCmd(string, list2, this._contextID));
        } else {
            if (this._state.equalsIgnoreCase("deleted")) {
                AmasMessage amasMessage = new AmasMessage(864296996, (Object)this._contextID, "addGroupsToRole");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "addGroupsToRole(String, list): roleName = " + string, amasMessage.getMessageString());
                }
                throw new UnsupportedOperationException(amasMessage.getMessageString());
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addGroupsToRole(String, List): roleName = " + string, "method called on isService TAMRoleConfiguration instance. No action will be taken.  contextID: " + this._contextID);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addGroupsToRole(String, List): roleName = " + string + " contextID = " + this._contextID);
        }
    }

    public void removeGroupsFromRole(String string, List list) throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeGroupsFromRole(String, List): roleName = " + string + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeGroupsFromRole(String,List)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            List list2 = this.buildRoleMemberList(list, 2);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeGroupsFromRole(String, list): roleName = " + string, "Adding command object to remove groups from role: " + string + " in context: " + this._contextID);
            }
            this._commands.add(new RemoveUsersRoleConfigCmd(string, list2, this._contextID));
        } else {
            if (this._state.equalsIgnoreCase("deleted")) {
                AmasMessage amasMessage = new AmasMessage(864296996, (Object)this._contextID, "removeGroupsFromRole");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "removeGroupsFromRole(String, list): roleName = " + string, amasMessage.getMessageString());
                }
                throw new UnsupportedOperationException(amasMessage.getMessageString());
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeGroupsFromRole(String, List): roleName = " + string, "method called on isService TAMRoleConfiguration instance. No action will be taken.  contextID: " + this._contextID);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeGroupsFromRole(String, List): roleName = " + string + " contextID = " + this._contextID);
        }
    }

    public void addEveryoneToRole(String string) throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addEveryoneToRole(String): roleName = " + string + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addEveryoneToRole(String)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            ArrayList<RoleMember> arrayList = new ArrayList<RoleMember>();
            RoleMember roleMember = new RoleMember("unauthenticated", 3);
            RoleMember roleMember2 = new RoleMember("any-other", 4);
            arrayList.add(roleMember);
            arrayList.add(roleMember2);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addEveryoneToRole(String): roleName = " + string, "Adding command object to add EVERYONE to role: " + string + " in context: " + this._contextID);
            }
            this._commands.add(new AddUsersRoleConfigCmd(string, arrayList, this._contextID));
        } else {
            if (this._state.equalsIgnoreCase("deleted")) {
                AmasMessage amasMessage = new AmasMessage(864296996, (Object)this._contextID, "addEveryoneToRole");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "addEveryoneToRole(String, list): roleName = " + string, amasMessage.getMessageString());
                }
                throw new UnsupportedOperationException(amasMessage.getMessageString());
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addEveryoneToRole(String, List): roleName = " + string, "method called on isService TAMRoleConfiguration instance. No action will be taken.  contextID: " + this._contextID);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addEveryoneToRole(String, List): roleName = " + string + " contextID = " + this._contextID);
        }
    }

    public void removeEveryoneFromRole(String string) throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeEveryoneFromRole(String, List): roleName = " + string + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeEveryoneFromRole(String)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            ArrayList<RoleMember> arrayList = new ArrayList<RoleMember>();
            RoleMember roleMember = new RoleMember("unauthenticated", 3);
            RoleMember roleMember2 = new RoleMember("any-other", 4);
            arrayList.add(roleMember);
            arrayList.add(roleMember2);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeEveryoneFromRole(String): roleName = " + string, "Adding command object to remove EVERYONE from role: " + string + " in context: " + this._contextID);
            }
            this._commands.add(new RemoveUsersRoleConfigCmd(string, arrayList, this._contextID));
        } else {
            if (this._state.equalsIgnoreCase("deleted")) {
                AmasMessage amasMessage = new AmasMessage(864296996, (Object)this._contextID, "removeEveryoneFromRole");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "removeEveryoneFromRole(String, list): roleName = " + string, amasMessage.getMessageString());
                }
                throw new UnsupportedOperationException(amasMessage.getMessageString());
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeEveryoneFromRole(String, List): roleName = " + string, "method called on isService TAMRoleConfiguration instance. No action will be taken.  contextID: " + this._contextID);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeEveryoneFromRole(String): roleName = " + string + " contextID = " + this._contextID);
        }
    }

    public void addAuthenticatedUsersToRole(String string) throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "addAuthenticatedUsersToRole(String): roleName = " + string + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "addAuthenticatedUserToRole(String)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            ArrayList<RoleMember> arrayList = new ArrayList<RoleMember>();
            RoleMember roleMember = new RoleMember("any-other", 4);
            arrayList.add(roleMember);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addAuthenticatedUsersToRole(String): roleName = " + string, "Adding command object to add AUTHENTICATED users to role: " + string + " in context: " + this._contextID);
            }
            this._commands.add(new AddUsersRoleConfigCmd(string, arrayList, this._contextID));
        } else {
            if (this._state.equalsIgnoreCase("deleted")) {
                AmasMessage amasMessage = new AmasMessage(864296996, (Object)this._contextID, "addAuthenticatedUsersToRole");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "addAuthenticatedUsersToRole(String, list): roleName = " + string, amasMessage.getMessageString());
                }
                throw new UnsupportedOperationException(amasMessage.getMessageString());
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "addAuthenticatedUsersToRole(String, List): roleName = " + string, "method called on isService TAMRoleConfiguration instance. No action will be taken.  contextID: " + this._contextID);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "addAuthenticatedUsersToRole(String): roleName = " + string + " contextID = " + this._contextID);
        }
    }

    public void removeAuthenticatedUsersFromRole(String string) throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "removeAuthenticatedUsersFromRole(String): roleName = " + string + " contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "removeAuthenticatedUsersFromRole(String)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("open")) {
            ArrayList<RoleMember> arrayList = new ArrayList<RoleMember>();
            RoleMember roleMember = new RoleMember("any-other", 4);
            arrayList.add(roleMember);
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeAuthenticatedUsersFromRole(String): roleName = " + string, "Adding command object to remove AUTHENTICATED users from role: " + string + " in context: " + this._contextID);
            }
            this._commands.add(new RemoveUsersRoleConfigCmd(string, arrayList, this._contextID));
        } else {
            if (this._state.equalsIgnoreCase("deleted")) {
                AmasMessage amasMessage = new AmasMessage(864296996, (Object)this._contextID, "removeAuthenticatedUsersFromRole");
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "removeAuthenticatedUsersFromRole(String, list): roleName = " + string, amasMessage.getMessageString());
                }
                throw new UnsupportedOperationException(amasMessage.getMessageString());
            }
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "removeAuthenticatedUsersFromRole(String, List): roleName = " + string, "method called on isService TAMRoleConfiguration instance. No action will be taken.  contextID: " + this._contextID);
            }
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "removeAuthenticatedUsersFromRole(String): roleName = " + string + " contextID = " + this._contextID);
        }
    }

    public void addServerToRole(String string) throws RoleConfigurationException {
        throw new UnsupportedOperationException();
    }

    public void removeServerFromRole(String string) throws RoleConfigurationException {
        throw new UnsupportedOperationException();
    }

    public synchronized void commit() throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "commit()", amasMessage.getMessageString());
            }
            throw securityException;
        }
        if (this._state.equalsIgnoreCase("deleted")) {
            String string = AmasMsgHelper.formatDoubleParamMessage(864296996, this._contextID, "commit");
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, string);
            }
            throw new UnsupportedOperationException();
        }
        if (this._state.equalsIgnoreCase("open")) {
            Object object;
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, "TAMRoleConfiguration instance with contextID: " + this._contextID + " is in the open state and all command objects will be committed");
            }
            _sess.getCfgManager().enableCache();
            ContextIdTable.setContextID(this._contextID);
            int n = this._commands.size();
            for (int i = 0; i < n; ++i) {
                object = (BasePolicyConfigCmd)this._commands.get(i);
                try {
                    ((BasePolicyConfigCmd)object).commit();
                    continue;
                }
                catch (JACCException jACCException) {
                    AmasMessage amasMessage = new AmasMessage(864297005, (Object)this._contextID, jACCException.toString());
                    if (this._msgLogger != null && this._msgLogger.isLogging()) {
                        this._msgLogger.text(4L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, amasMessage.getMessageString());
                    }
                    throw new RoleConfigurationException(amasMessage.getMessageString());
                }
            }
            _sess.getCfgManager().disableCache();
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, "About to create RoleConfigurationObject in TAM for contextID: " + this._contextID);
            }
            try {
                _roleHelper.create();
            }
            catch (JACCException jACCException) {
                object = new AmasMessage(864297005, (Object)this._contextID, jACCException.toString());
                if (this._msgLogger != null && this._msgLogger.isLogging()) {
                    this._msgLogger.text(4L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, ((AmasMessage)object).getMessageString());
                }
                throw new RoleConfigurationException(((AmasMessage)object).getMessageString());
            }
            ContextIdTable.removeContextID();
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, "Updating state of RoleConfiguration instance with context ID: " + this._contextID + " to " + "inService");
            }
            this._state = "inService";
            this._commands.clear();
        } else if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, "Called commit on RoleConfiguration instance with context ID: " + this._contextID + " with state " + "inService" + ". No action was performed.");
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID);
        }
    }

    public synchronized void delete() throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "delete(): contextID = " + this._contextID);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "delete()", amasMessage.getMessageString());
            }
            throw securityException;
        }
        this._commands.clear();
        CfgManager cfgManager = _sess.getCfgManager();
        cfgManager.enableCache();
        try {
            ContextIdTable.setContextID(this._contextID);
            CfgRole[] cfgRoleArray = cfgManager.getRoles(_DUMMY_PERMISSION);
            if (cfgRoleArray != null) {
                for (int i = 0; i < cfgRoleArray.length; ++i) {
                    if (this._trcLogger != null && this._trcLogger.isLogging()) {
                        this._trcLogger.text(16L, (Object)CLASSNAME, "delete(): contextID = " + this._contextID, "deleting role: " + cfgRoleArray[i].getId());
                    }
                    cfgManager.deleteRole(cfgRoleArray[i]);
                }
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864296998, (Object)this._contextID, amasException.toString());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "delete(): contextID = " + this._contextID, amasMessage.getMessageString());
            }
            ContextIdTable.removeContextID();
            throw new RoleConfigurationException(amasMessage.getMessageString());
        }
        cfgManager.disableCache();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.text(16L, (Object)CLASSNAME, "delete(): contextID = " + this._contextID, "About to delete RoleConfiguration object in TAM for contextID: " + this._contextID);
        }
        try {
            _roleHelper.delete();
        }
        catch (JACCException jACCException) {
            AmasMessage amasMessage = new AmasMessage(864297006, (Object)this._contextID, jACCException.toString());
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                this._msgLogger.text(4L, (Object)CLASSNAME, "commit(): contextID = " + this._contextID, amasMessage.getMessageString());
            }
            throw new RoleConfigurationException(amasMessage.getMessageString());
        }
        this._state = "deleted";
        ContextIdTable.removeContextID();
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "delete(): contextID = " + this._contextID);
        }
    }

    public String getContextID() throws RoleConfigurationException {
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getContextID()", amasMessage.getMessageString());
            }
            throw securityException;
        }
        return this._contextID;
    }

    public void clearRoleStatements() {
        this._commands.clear();
    }

    public synchronized void setStateOpen() {
        this._state = "open";
    }

    private List buildRoleMemberList(List list, int n) {
        ArrayList<RoleMember> arrayList = new ArrayList<RoleMember>();
        if (list != null) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                Object e2 = list.get(i);
                String string = null;
                if (n == 1) {
                    string = ((UserImpl)list.get(i)).getName();
                } else if (n == 2) {
                    string = ((GroupImpl)list.get(i)).getName();
                }
                if (string == null) continue;
                arrayList.add(new RoleMember(string, n));
            }
        }
        return arrayList;
    }
}

