/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc;

import com.ibm.wsspi.security.authorization.RoleConfiguration;
import com.ibm.wsspi.security.authorization.RoleConfigurationException;
import com.ibm.wsspi.security.authorization.RoleConfigurationFactory;
import com.tivoli.pd.as.jacc.TAMPolicy;
import com.tivoli.pd.as.jacc.TAMRoleConfiguration;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.security.SecurityPermission;
import java.util.Hashtable;

public class TAMRoleConfigurationFactory
implements RoleConfigurationFactory {
    private final String TAMRoleConfigurationFactory_java_sourceCodeID = "$Id: @(#)22  1.8 src/jacc/com/tivoli/pd/as/jacc/TAMRoleConfigurationFactory.java, amemb.jacc.was, amemb600, 051118a 04/09/27 08:21:08 @(#) $";
    private Hashtable _roleContexts;
    private AmasSession _sess = TAMPolicy.getSess();
    private ILogger _trcLogger;
    private ILogger _msgLogger;
    private SecurityManager _secMgr;
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.tivoli.pd.as.jacc.TAMRoleConfigurationFactory";

    public TAMRoleConfigurationFactory() {
        this._roleContexts = new Hashtable();
        this._trcLogger = this._sess.getLogManager().getTraceLogger("JACCTraceLogger");
        this._msgLogger = this._sess.getLogManager().getMessageLogger("JACCMessageLogger");
        this._secMgr = System.getSecurityManager();
    }

    public RoleConfiguration getRoleConfiguration(String string, boolean bl) throws RoleConfigurationException {
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.entry(80L, (Object)CLASSNAME, "getRoleConfiguration(String, boolean): contextID = " + string + " remove = " + bl);
        }
        try {
            if (this._secMgr != null) {
                this._secMgr.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            if (this._msgLogger != null && this._msgLogger.isLogging()) {
                AmasMessage amasMessage = new AmasMessage(916942882, securityException.toString());
                this._msgLogger.text(4L, (Object)CLASSNAME, "getRoleConfiguration(String,boolean)", amasMessage.getMessageString());
            }
            throw securityException;
        }
        TAMRoleConfiguration tAMRoleConfiguration = (TAMRoleConfiguration)this._roleContexts.get(string);
        if (tAMRoleConfiguration == null) {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getRoleConfiguration(String, boolean): contextID = " + string + " remove = " + bl, "RoleConfiguration object for contextID: " + string + " does not exists, about to create it.");
            }
            tAMRoleConfiguration = new TAMRoleConfiguration(string);
            this._roleContexts.put(string, tAMRoleConfiguration);
        } else {
            if (this._trcLogger != null && this._trcLogger.isLogging()) {
                this._trcLogger.text(16L, (Object)CLASSNAME, "getRoleConfiguration(String, boolean): contextID = " + string + " remove = " + bl, "RoleConfiguration object for contextID: " + string + " was found and will be returned.");
            }
            if (bl) {
                if (this._trcLogger != null && this._trcLogger.isLogging()) {
                    this._trcLogger.text(16L, (Object)CLASSNAME, "getRoleConfiguration(String, boolean): contextID = " + string + " remove = " + bl, "Removing all command objects from the RoleConfiguration object for contextID: " + string);
                }
                tAMRoleConfiguration.clearRoleStatements();
            }
            tAMRoleConfiguration.setStateOpen();
        }
        if (this._trcLogger != null && this._trcLogger.isLogging()) {
            this._trcLogger.exit(96L, (Object)CLASSNAME, "getRoleConfiguration(String, boolean): contextID = " + string + " remove = " + bl + " returning: " + tAMRoleConfiguration);
        }
        return tAMRoleConfiguration;
    }
}

