/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.admin;

import com.tivoli.pd.as.jacc.admin.EJBMethodCtx;
import com.tivoli.pd.as.jacc.admin.EJBRoleRefCtx;
import com.tivoli.pd.as.jacc.admin.MgmtContext;
import com.tivoli.pd.as.jacc.admin.MgmtCtxBase;
import com.tivoli.pd.as.jacc.admin.WebResCtx;
import com.tivoli.pd.as.jacc.admin.WebRoleRefCtx;
import com.tivoli.pd.as.jacc.admin.WebUserDataCtx;
import com.tivoli.pd.as.jacc.util.JACCException;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.rbpf.CfgManager;
import com.tivoli.pd.as.rbpf.CfgResource;
import com.tivoli.pd.as.rbpf.CfgRole;
import com.tivoli.pd.as.util.AmasException;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.jacc.WebUserDataPermission;

public class JACCAdmin {
    private final String JACCAdmin_java_sourceCodeID = "$Id: @(#)21  1.7 src/jacc/com/tivoli/pd/as/jacc/admin/JACCAdmin.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:54:07 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private ILogger _traceLogger = null;
    private ILogger _messageLogger = null;
    private AmasSession _sess = null;
    private CfgManager _cfgMgr = null;
    private static final String CLASSNAME = "com.tivoli.pd.as.jacc.admin.JACCAdmin";
    private SpecialGroupsMapper _groupMapper = new SpecialGroupsMapper();

    JACCAdmin(AmasSession amasSession) throws JACCException {
        this._sess = amasSession;
        this._cfgMgr = amasSession.getCfgManager();
        this._traceLogger = amasSession.getLogManager().getTraceLogger("jaccAdminTraceLogger");
        this._messageLogger = amasSession.getLogManager().getMessageLogger("jaccAdminMessageLogger");
    }

    private static String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    void setGroupMapping(String string, boolean bl, boolean bl2) {
        this._groupMapper.setGroupMapping(string, bl, bl2);
    }

    public void createRole(MgmtContext mgmtContext, String string) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "createRole(MgmtContext, String) ctx = " + mgmtContext + " roleName = " + string);
        }
        if (string == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "createRole(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            this._cfgMgr.createRole(MgmtCtxBase.getMgmtCtx(mgmtContext, null), string);
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321546, new Object[]{string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "createRole(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "createRole(MgmtContext, String)");
        }
    }

    public void deleteRole(MgmtContext mgmtContext, String string) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "deleteRole(MgmtContext, String) ctx = " + mgmtContext + " roleName = " + string);
        }
        if (string == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "deleteRole(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            CfgRole cfgRole = this._cfgMgr.getRole(MgmtCtxBase.getMgmtCtx(mgmtContext, null), string);
            this._cfgMgr.deleteRole(cfgRole);
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321547, new Object[]{string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "deleteRole(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "deleteRole(MgmtContext, String)");
        }
    }

    public String[] getRoles(MgmtContext mgmtContext) throws JACCException {
        String[] stringArray = null;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getRoles(MgmtContext) ctx = " + mgmtContext);
        }
        try {
            CfgRole[] cfgRoleArray = this._cfgMgr.getRoles(MgmtCtxBase.getMgmtCtx(mgmtContext, null));
            if (cfgRoleArray == null) {
                stringArray = new String[]{};
            } else {
                stringArray = new String[cfgRoleArray.length];
                for (int i = 0; i < cfgRoleArray.length; ++i) {
                    stringArray[i] = cfgRoleArray[i].getRoleName();
                    if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                    this._traceLogger.text(16L, (Object)CLASSNAME, "getRoles(MgmtContext)", "retrieved role " + stringArray[i]);
                }
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321548, new Object[]{mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getRoles(MgmtContext)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getRoles(MgmtContext) returning " + stringArray);
        }
        return stringArray;
    }

    public String[] getRolesForPrincipal(MgmtContext mgmtContext, String string) throws JACCException {
        String[] stringArray = null;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getRolesForPrincipal(MgmtContext, String) ctx = " + mgmtContext + " principal = " + string);
        }
        if (string == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getRolesForPrincipal(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            CfgRole[] cfgRoleArray = this._cfgMgr.getRoles(MgmtCtxBase.getMgmtCtx(mgmtContext, null));
            if (cfgRoleArray == null) {
                stringArray = new String[]{};
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < cfgRoleArray.length; ++i) {
                    if (!cfgRoleArray[i].isMember(string)) continue;
                    arrayList.add(cfgRoleArray[i].getRoleName());
                    if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                    this._traceLogger.text(16L, (Object)CLASSNAME, "getRolesForPrincipal(MgmtContext, String)", "retrieved role " + cfgRoleArray[i].getRoleName());
                }
                stringArray = arrayList.toArray(new String[0]);
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321549, new Object[]{string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getRolesForPrincipal(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getRolesForPrincipal(MgmtContext, String) returning " + stringArray);
        }
        return stringArray;
    }

    public String[] getRolesForPermission(MgmtContext mgmtContext, Permission permission) throws JACCException {
        String[] stringArray = null;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getRolesForPermission(MgmtContext, Permission) ctx = " + mgmtContext + " perm = " + permission);
        }
        AmasMessage amasMessage = null;
        if (permission == null || mgmtContext == null) {
            amasMessage = new AmasMessage(864321544);
        }
        if (permission instanceof WebUserDataPermission) {
            amasMessage = new AmasMessage(864321545, permission, permission.getClass().getName());
        }
        if (amasMessage != null) {
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getRolesForPermission(MgmtContext, Permission)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            MgmtCtxBase mgmtCtxBase = MgmtCtxBase.getMgmtCtx(mgmtContext, permission);
            CfgResource[] cfgResourceArray = this._cfgMgr.findResources(mgmtCtxBase);
            if (cfgResourceArray == null) {
                stringArray = new String[]{};
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < cfgResourceArray.length; ++i) {
                    CfgRole[] cfgRoleArray = this._cfgMgr.getLocalGrantedRoles(cfgResourceArray[i]);
                    if (cfgRoleArray == null) continue;
                    for (int j = 0; j < cfgRoleArray.length; ++j) {
                        arrayList.add(cfgRoleArray[j].getRoleName());
                        if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                        this._traceLogger.text(16L, (Object)CLASSNAME, "getRolesForPermission(MgmtContext, Permission)", "retrieved role " + cfgRoleArray[j].getRoleName());
                    }
                }
                stringArray = arrayList.toArray(new String[0]);
            }
        }
        catch (AmasException amasException) {
            amasMessage = new AmasMessage(864321551, new Object[]{permission, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getRolesForPermission(MgmtContext, Permission)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getRolesForPermission(MgmtContext, Permission) returning " + stringArray);
        }
        return stringArray;
    }

    public String[] getRolesForGroup(MgmtContext mgmtContext, String string) throws JACCException {
        String[] stringArray = null;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getRolesForGroup(MgmtContext, String) ctx = " + mgmtContext + " group = " + string);
        }
        if (string == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getRolesForGroup(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            CfgRole[] cfgRoleArray = this._cfgMgr.getRoles(MgmtCtxBase.getMgmtCtx(mgmtContext, null));
            if (cfgRoleArray == null) {
                stringArray = new String[]{};
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl = this._groupMapper.isSpecialGroup(string);
                boolean bl2 = false;
                boolean bl3 = false;
                if (bl) {
                    bl2 = this._groupMapper.isUnauthenticated(string);
                    bl3 = this._groupMapper.isAnyOther(string);
                }
                for (int i = 0; i < cfgRoleArray.length; ++i) {
                    if ((!bl || this._cfgMgr.isAnyOtherRole(cfgRoleArray[i]) != bl3 || this._cfgMgr.isUnauthenticatedRole(cfgRoleArray[i]) != bl2) && !cfgRoleArray[i].isGroupMember(string)) continue;
                    arrayList.add(cfgRoleArray[i].getRoleName());
                    if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                    this._traceLogger.text(16L, (Object)CLASSNAME, "getRolesForGroup(MgmtContext, String)", "retrieved role " + cfgRoleArray[i].getRoleName());
                }
                stringArray = arrayList.toArray(new String[0]);
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321550, new Object[]{string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getRolesForGroup(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getRolesForGroup(MgmtContext, String) returning " + stringArray);
        }
        return stringArray;
    }

    public String[] getPrincipalsForRole(MgmtContext mgmtContext, String string) throws JACCException {
        String[] stringArray = null;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getPrincipalsForRole(MgmtContext, String) ctx = " + mgmtContext + " roleName = " + string);
        }
        if (string == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getPrincipalsForRole(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            CfgRole cfgRole = this._cfgMgr.getRole(MgmtCtxBase.getMgmtCtx(mgmtContext, null), string);
            stringArray = this._cfgMgr.getPrincipalsForRole(cfgRole);
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321552, new Object[]{string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getPrincipalsForRole(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getPrincipalsForRole(MgmtContext, String) returning " + stringArray);
        }
        return stringArray;
    }

    public String[] getGroupsForRole(MgmtContext mgmtContext, String string) throws JACCException {
        String[] stringArray = null;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getGroupsForRole(MgmtContext, String) ctx = " + mgmtContext + " roleName = " + string);
        }
        if (string == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getGroupsForRole(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            CfgRole cfgRole = this._cfgMgr.getRole(MgmtCtxBase.getMgmtCtx(mgmtContext, null), string);
            String[] stringArray2 = this._cfgMgr.getGroupsFromRole(cfgRole);
            boolean bl = this._cfgMgr.isUnauthenticatedRole(cfgRole);
            boolean bl2 = this._cfgMgr.isAnyOtherRole(cfgRole);
            if (bl || bl2) {
                String[] stringArray3 = this._groupMapper.getSpecialGroups(bl, bl2);
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(stringArray2));
                arrayList.addAll(Arrays.asList(stringArray3));
                stringArray = arrayList.toArray(new String[0]);
            } else {
                stringArray = stringArray2;
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321553, new Object[]{string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getGroupsForRole(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getGroupsForRole(MgmtContext, String) returning " + stringArray);
        }
        return stringArray;
    }

    public void addPrincipalsToRole(MgmtContext mgmtContext, String string, String[] stringArray) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "addPrincipalsToRole(MgmtContext, String, String[]) ctx = " + mgmtContext + " roleName = " + string + " principals = " + stringArray);
        }
        if (string == null || stringArray == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "addPrincipalsToRole(MgmtContext, String, String[])", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            CfgRole cfgRole = this._cfgMgr.getRole(MgmtCtxBase.getMgmtCtx(mgmtContext, null), string);
            for (int i = 0; i < stringArray.length; ++i) {
                this._cfgMgr.addPrincipalToRole(cfgRole, stringArray[i]);
                if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                this._traceLogger.text(16L, (Object)CLASSNAME, "addPrincipalsToRole(MgmtContext, String, String[])", "added principal " + stringArray[i] + " to role " + string);
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321554, new Object[]{JACCAdmin.toString(stringArray), string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "addPrincipalsToRole(MgmtContext, String, String[])", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addPrincipalsToRole(MgmtContext, String, String[])");
        }
    }

    public void removePrincipalsFromRole(MgmtContext mgmtContext, String string, String[] stringArray) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "removePrincipalsFromRole(MgmtContext, String, String[]) ctx = " + mgmtContext + " roleName = " + string + " principals = " + stringArray);
        }
        if (string == null || stringArray == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "removePrincipalsFromRole(MgmtContext, String, String[])", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            CfgRole cfgRole = this._cfgMgr.getRole(MgmtCtxBase.getMgmtCtx(mgmtContext, null), string);
            for (int i = 0; i < stringArray.length; ++i) {
                this._cfgMgr.removePrincipalFromRole(cfgRole, stringArray[i]);
                if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                this._traceLogger.text(16L, (Object)CLASSNAME, "removePrincipalsFromRole(MgmtContext, String, String[])", "removed principal " + stringArray[i] + " from role " + string);
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321556, new Object[]{JACCAdmin.toString(stringArray), string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "removePrincipalsFromRole(MgmtContext, String, String[])", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "removePrincipalsFromRole(MgmtContext, String, String[])");
        }
    }

    public void addGroupsToRole(MgmtContext mgmtContext, String string, String[] stringArray) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "addGroupsToRole(MgmtContext, String, String[]) ctx = " + mgmtContext + " roleName = " + string + " groups = " + stringArray);
        }
        if (string == null || stringArray == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "addGroupsToRole(MgmtContext, String, String[])", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            CfgRole cfgRole = this._cfgMgr.getRole(MgmtCtxBase.getMgmtCtx(mgmtContext, null), string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (this._groupMapper.isSpecialGroup(stringArray[i])) {
                    if (this._groupMapper.isUnauthenticated(stringArray[i])) {
                        this._cfgMgr.addUnathenticatedToRole(cfgRole);
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)CLASSNAME, "addGroupsToRole(MgmtContext, String, String[])", "added special group unauthenticated to role " + string);
                        }
                    }
                    if (!this._groupMapper.isAnyOther(stringArray[i])) continue;
                    this._cfgMgr.addAnyOtherToRole(cfgRole);
                    if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                    this._traceLogger.text(16L, (Object)CLASSNAME, "addGroupsToRole(MgmtContext, String, String[])", "added special group any-other to role " + string);
                    continue;
                }
                this._cfgMgr.addGroupToRole(cfgRole, stringArray[i]);
                if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                this._traceLogger.text(16L, (Object)CLASSNAME, "addGroupsToRole(MgmtContext, String, String[])", "added TAM group " + stringArray[i] + " to role " + string);
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321555, new Object[]{JACCAdmin.toString(stringArray), string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "addGroupsToRole(MgmtContext, String, String[])", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addGroupsToRole(MgmtContext, String, String[])");
        }
    }

    public void removeGroupsFromRole(MgmtContext mgmtContext, String string, String[] stringArray) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "removeGroupsFromRole(MgmtContext, String, String[]) ctx = " + mgmtContext + " roleName = " + string + " groups = " + stringArray);
        }
        if (string == null || stringArray == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "removeGroupsFromRole(MgmtContext, String, String[])", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            CfgRole cfgRole = this._cfgMgr.getRole(MgmtCtxBase.getMgmtCtx(mgmtContext, null), string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (this._groupMapper.isSpecialGroup(stringArray[i])) {
                    if (this._groupMapper.isUnauthenticated(stringArray[i])) {
                        this._cfgMgr.removeUnathenticatedFromRole(cfgRole);
                        if (this._traceLogger != null && this._traceLogger.isLogging()) {
                            this._traceLogger.text(16L, (Object)CLASSNAME, "removeGroupsFromRole(MgmtContext, String, String[])", "removed special group unauthenticated from role " + string);
                        }
                    }
                    if (!this._groupMapper.isAnyOther(stringArray[i])) continue;
                    this._cfgMgr.removeAnyOtherFromRole(cfgRole);
                    if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                    this._traceLogger.text(16L, (Object)CLASSNAME, "removeGroupsFromRole(MgmtContext, String, String[])", "removed special group any-other from role " + string);
                    continue;
                }
                this._cfgMgr.removeGroupFromRole(cfgRole, stringArray[i]);
                if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                this._traceLogger.text(16L, (Object)CLASSNAME, "removeGroupsFromRole(MgmtContext, String, String[])", "removed TAM group " + stringArray[i] + " from role " + string);
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321557, new Object[]{JACCAdmin.toString(stringArray), string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "removeGroupsFromRole(MgmtContext, String, String[])", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "removeGroupsFromRole(MgmtContext, String, String[])");
        }
    }

    public PermissionCollection getPermissionsForRole(MgmtContext mgmtContext, String string) throws JACCException {
        Permissions permissions = null;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getPermissionsForRole(MgmtContext, String) ctx = " + mgmtContext + " roleName = " + string);
        }
        if (string == null || mgmtContext == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getPermissionsForRole(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            CfgResource[] cfgResourceArray;
            permissions = new Permissions();
            CfgRole cfgRole = this._cfgMgr.getRole(MgmtCtxBase.getMgmtCtx(mgmtContext, null), string);
            if (this._traceLogger != null && this._traceLogger.isLogging()) {
                this._traceLogger.text(16L, (Object)CLASSNAME, "getPermissionsForRole(MgmtContext, String)", "Finding resources for role - " + cfgRole.getId());
            }
            if ((cfgResourceArray = this._cfgMgr.getResources(cfgRole)) != null) {
                for (int i = 0; i < cfgResourceArray.length; ++i) {
                    MgmtCtxBase[] mgmtCtxBaseArray;
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)CLASSNAME, "getPermissionsForRole(MgmtContext, String)", "Decoding resource - " + cfgResourceArray[i].getId());
                    }
                    if ((mgmtCtxBaseArray = (MgmtCtxBase[])this._cfgMgr.decodeCfgResource(cfgResourceArray[i], string)) == null) continue;
                    for (int j = 0; j < mgmtCtxBaseArray.length; ++j) {
                        ((PermissionCollection)permissions).add(mgmtCtxBaseArray[j].getPermission());
                        if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                        this._traceLogger.text(16L, (Object)CLASSNAME, "getPermissionsForRole(MgmtContext, String)", "Successfully decoded permission - " + mgmtCtxBaseArray[j].getPermission());
                    }
                }
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321558, new Object[]{string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getPermissionsForRole(MgmtContext, String)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getPermissionsForRole(MgmtContext, String) returning " + permissions);
        }
        return permissions;
    }

    public void addToRole(MgmtContext mgmtContext, String string, Permission permission) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "addToRole(MgmtContext, String, Permission) ctx = " + mgmtContext + " roleName = " + string + " perm = " + permission);
        }
        if (permission == null || string == null || mgmtContext == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "addToRole(MgmtContext, String, Permission)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            MgmtCtxBase mgmtCtxBase = MgmtCtxBase.getMgmtCtx(mgmtContext, permission);
            CfgResource[] cfgResourceArray = this._cfgMgr.createResources(mgmtCtxBase);
            if (cfgResourceArray != null) {
                for (int i = 0; i < cfgResourceArray.length; ++i) {
                    this._cfgMgr.addRoleToResource(cfgResourceArray[i], string);
                    if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                    this._traceLogger.text(16L, (Object)CLASSNAME, "addToRole(MgmtContext, String, Permission)", "added config resource " + cfgResourceArray[i] + " to role " + string);
                }
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321559, new Object[]{permission, string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "addToRole(MgmtContext, String, Permission)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addToRole(MgmtContext, String, Permission)");
        }
    }

    public void addToRole(MgmtContext mgmtContext, String string, PermissionCollection permissionCollection) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "addToRole(MgmtContext, String, PermissionCollection) ctx = " + mgmtContext + " roleName = " + string + " perms = " + permissionCollection);
        }
        if (permissionCollection == null || string == null || mgmtContext == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "addToRole(MgmtContext, String, PermissionCollection)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            this.addToRole(mgmtContext, string, permission);
            if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
            this._traceLogger.text(16L, (Object)CLASSNAME, "addToRole(MgmtContext, String, PermissionCollection)", "added permission " + permission + " to role " + string);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addToRole(MgmtContext, String, PermissionCollection)");
        }
    }

    public void removeFromRole(MgmtContext mgmtContext, String string, Permission permission) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "removeFromRole(MgmtContext, String, Permission) ctx = " + mgmtContext + " roleName = " + string + " perm = " + permission);
        }
        if (permission == null || string == null || mgmtContext == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "removeFromRole(MgmtContext, String, Permission)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            MgmtCtxBase mgmtCtxBase = MgmtCtxBase.getMgmtCtx(mgmtContext, permission);
            CfgResource[] cfgResourceArray = this._cfgMgr.createResources(mgmtCtxBase);
            if (cfgResourceArray != null) {
                for (int i = 0; i < cfgResourceArray.length; ++i) {
                    this._cfgMgr.removeRoleFromResource(cfgResourceArray[i], string);
                    if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                    this._traceLogger.text(16L, (Object)CLASSNAME, "removeFromRole(MgmtContext, String, Permission)", "removed config resource " + cfgResourceArray[i] + " from role " + string);
                }
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321560, new Object[]{permission, string, mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "removeFromRole(MgmtContext, String, Permission)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "removeFromRole(MgmtContext, String, Permission)");
        }
    }

    public void removeFromRole(MgmtContext mgmtContext, String string, PermissionCollection permissionCollection) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "removeFromRole(MgmtContext, String, PermissionCollection) ctx = " + mgmtContext + " roleName = " + string + " perms = " + permissionCollection);
        }
        if (permissionCollection == null || string == null || mgmtContext == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "removeFromRole(MgmtContext, String, PermissionCollection)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            this.removeFromRole(mgmtContext, string, permission);
            if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
            this._traceLogger.text(16L, (Object)CLASSNAME, "removeFromRole(MgmtContext, String, PermissionCollection)", "removed permission " + permission + " from role " + string);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "removeFromRole(MgmtContext, String, PermissionCollection)");
        }
    }

    public PermissionCollection getPermissions(MgmtContext mgmtContext) throws JACCException {
        Permissions permissions = null;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getPermissions(MgmtContext) ctx = " + mgmtContext);
        }
        if (mgmtContext == null) {
            AmasMessage amasMessage = new AmasMessage(864321544);
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getPermissions(MgmtContext)", amasMessage.getMessageString());
            }
            throw new IllegalArgumentException(amasMessage.getMessageString());
        }
        try {
            permissions = new Permissions();
            MgmtCtxBase[] mgmtCtxBaseArray = new MgmtCtxBase[]{new WebResCtx(mgmtContext, null), new WebRoleRefCtx(mgmtContext, null), new WebUserDataCtx(mgmtContext, null), new EJBMethodCtx(mgmtContext, null), new EJBRoleRefCtx(mgmtContext, null)};
            for (int i = 0; i < mgmtCtxBaseArray.length; ++i) {
                CfgResource[] cfgResourceArray = this._cfgMgr.listResources(mgmtCtxBaseArray[i]);
                if (cfgResourceArray == null) continue;
                for (int j = 0; j < cfgResourceArray.length; ++j) {
                    MgmtCtxBase[] mgmtCtxBaseArray2;
                    if (this._traceLogger != null && this._traceLogger.isLogging()) {
                        this._traceLogger.text(16L, (Object)CLASSNAME, "getPermissions(MgmtContext)", "retrieved resource" + cfgResourceArray[j]);
                    }
                    if ((mgmtCtxBaseArray2 = (MgmtCtxBase[])this._cfgMgr.decodeCfgResource(cfgResourceArray[j], null)) == null) continue;
                    for (int k = 0; k < mgmtCtxBaseArray2.length; ++k) {
                        permissions.add(mgmtCtxBaseArray2[k].getPermission());
                        if (this._traceLogger == null || !this._traceLogger.isLogging()) continue;
                        this._traceLogger.text(16L, (Object)CLASSNAME, "getPermissions(MgmtContext)", "added permission " + mgmtCtxBaseArray2[k].getPermission() + " defined for management context " + mgmtCtxBaseArray2[k].getMgmtContext());
                    }
                }
            }
        }
        catch (AmasException amasException) {
            AmasMessage amasMessage = new AmasMessage(864321561, new Object[]{mgmtContext, amasException.getAmasMessage().getMessageString()});
            if (this._messageLogger != null && this._messageLogger.isLogging()) {
                this._messageLogger.text(4L, (Object)CLASSNAME, "getPermissions(MgmtContext)", amasMessage.getMessageString());
            }
            throw new JACCException(amasMessage);
        }
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getPermissions(MgmtContext) returning " + permissions);
        }
        return permissions;
    }

    public PermissionCollection getExcludedPermissions(MgmtContext mgmtContext) throws JACCException {
        PermissionCollection permissionCollection = null;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getExcludedPermissions(MgmtContext) ctx = " + mgmtContext);
        }
        permissionCollection = this.getPermissionsForRole(mgmtContext, this._sess.getDefaultExcludedName());
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getExcludedPermissions(MgmtContext) returning " + permissionCollection);
        }
        return permissionCollection;
    }

    public PermissionCollection getUncheckedPermissions(MgmtContext mgmtContext) throws JACCException {
        PermissionCollection permissionCollection = null;
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "getUncheckedPermissions(MgmtContext) ctx = " + mgmtContext);
        }
        permissionCollection = this.getPermissionsForRole(mgmtContext, this._sess.getDefaultUncheckedName());
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "getUncheckedPermissions(MgmtContext) returning " + permissionCollection);
        }
        return permissionCollection;
    }

    public void addToExcluded(MgmtContext mgmtContext, Permission permission) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "addToExcluded(MgmtContext, Permission) ctx = " + mgmtContext + " perm = " + permission);
        }
        this.addToRole(mgmtContext, this._sess.getDefaultExcludedName(), permission);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addToExcluded(MgmtContext, Permission)");
        }
    }

    public void addToUnchecked(MgmtContext mgmtContext, Permission permission) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "addToUnchecked(MgmtContext, Permission) ctx = " + mgmtContext + " perm = " + permission);
        }
        this.addToRole(mgmtContext, this._sess.getDefaultUncheckedName(), permission);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addToUnchecked(MgmtContext, Permission)");
        }
    }

    public void addToExcluded(MgmtContext mgmtContext, PermissionCollection permissionCollection) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "addToExcluded(MgmtContext, PermissionCollection) ctx = " + mgmtContext + " perms = " + permissionCollection);
        }
        this.addToRole(mgmtContext, this._sess.getDefaultExcludedName(), permissionCollection);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addToExcluded(MgmtContext, PermissionCollection)");
        }
    }

    public void addToUnchecked(MgmtContext mgmtContext, PermissionCollection permissionCollection) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "addToUnchecked(MgmtContext, PermissionCollection) ctx = " + mgmtContext + " perms = " + permissionCollection);
        }
        this.addToRole(mgmtContext, this._sess.getDefaultUncheckedName(), permissionCollection);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "addToUnchecked(MgmtContext, PermissionCollection)");
        }
    }

    public void removeFromExcluded(MgmtContext mgmtContext, Permission permission) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "removeFromExcluded(MgmtContext, Permission) ctx = " + mgmtContext + " perm = " + permission);
        }
        this.removeFromRole(mgmtContext, this._sess.getDefaultExcludedName(), permission);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "removeFromExcluded(MgmtContext, Permission)");
        }
    }

    public void removeFromUnchecked(MgmtContext mgmtContext, Permission permission) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "removeFromUnchecked(MgmtContext, Permission) ctx = " + mgmtContext + " perm = " + permission);
        }
        this.removeFromRole(mgmtContext, this._sess.getDefaultUncheckedName(), permission);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "removeFromUnchecked(MgmtContext, Permission)");
        }
    }

    public void removeFromExcluded(MgmtContext mgmtContext, PermissionCollection permissionCollection) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "removeFromExcluded(MgmtContext, PermissionCollection) ctx = " + mgmtContext + " perms = " + permissionCollection);
        }
        this.removeFromRole(mgmtContext, this._sess.getDefaultExcludedName(), permissionCollection);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "removeFromExcluded(MgmtContext, PermissionCollection)");
        }
    }

    public void removeFromUnchecked(MgmtContext mgmtContext, PermissionCollection permissionCollection) throws JACCException {
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.entry(80L, (Object)CLASSNAME, "removeFromUnchecked(MgmtContext, PermissionCollection) ctx = " + mgmtContext + " perms = " + permissionCollection);
        }
        this.removeFromRole(mgmtContext, this._sess.getDefaultUncheckedName(), permissionCollection);
        if (this._traceLogger != null && this._traceLogger.isLogging()) {
            this._traceLogger.exit(96L, (Object)CLASSNAME, "removeFromUnchecked(MgmtContext, PermissionCollection)");
        }
    }

    private class SpecialGroupsMapper {
        private static final int TAM_UNAUTHENTICATED_GROUP = 1;
        private static final int TAM_ANYOTHER_GROUP = 16;
        private Hashtable _groupMappingsToTAM = new Hashtable();

        private SpecialGroupsMapper() {
        }

        public boolean isSpecialGroup(String string) {
            return this._groupMappingsToTAM.containsKey(string);
        }

        public boolean isUnauthenticated(String string) {
            return (this.getTAMSpecialGroups(string) & 1) != 0;
        }

        public boolean isAnyOther(String string) {
            return (this.getTAMSpecialGroups(string) & 0x10) != 0;
        }

        public void setGroupMapping(String string, boolean bl, boolean bl2) {
            this.setGroupMapping(string, (bl ? 1 : 0) | (bl2 ? 16 : 0));
        }

        private void setGroupMapping(String string, int n) {
            this._groupMappingsToTAM.put(string, new Integer(n));
        }

        public String[] getSpecialGroups(boolean bl, boolean bl2) {
            return this.getSpecialGroups((bl ? 1 : 0) | (bl2 ? 16 : 0));
        }

        private String[] getSpecialGroups(int n) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            Enumeration enumeration = this._groupMappingsToTAM.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n2 = (Integer)this._groupMappingsToTAM.get(string);
                if ((n2 & n) != n2) continue;
                boolean bl = true;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    int n3 = (Integer)arrayList2.get(i);
                    int n4 = n3 & n2;
                    if (n4 == n2) {
                        bl = false;
                        break;
                    }
                    if (n4 != n3) continue;
                    arrayList2.remove(i);
                    arrayList.remove(i);
                    --i;
                }
                if (!bl) continue;
                arrayList2.add(new Integer(n2));
                arrayList.add(string);
            }
            return arrayList.toArray(new String[0]);
        }

        private int getTAMSpecialGroups(String string) {
            int n = 0;
            Integer n2 = (Integer)this._groupMappingsToTAM.get(string);
            if (n2 != null) {
                n = n2;
            }
            return n;
        }
    }
}

