/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.tivoli.pd.as.jacc.cfg.ConfigActionFailedException;
import com.tivoli.pd.as.jacc.cfg.ConfigStateProperties;
import com.tivoli.pd.as.jacc.cfg.TAMConfigConstants;
import com.tivoli.pd.as.jacc.cfg.TAMConfigLoggers;
import com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.jcfg.PDJrteCfg;
import com.tivoli.pd.jcfg.SvrSslCfg;
import com.tivoli.pd.jras.pdjlog.jlog.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public abstract class ConfigAction {
    private final String ConfigAction_java_sourceCodeID = "$Id: @(#)63 1.16 src/jacc/com/tivoli/pd/as/jacc/cfg/ConfigAction.java, amemb.jacc.was, amemb600, 060510a 06/05/10 01:55:41 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private boolean _validProps = false;
    protected Properties _props = null;
    protected ConfigStateProperties _stateProps = null;
    protected String _ctxID = null;
    protected boolean _force = false;
    protected String _name = null;
    protected String _desc = null;
    protected ILogger _logger = TAMConfigLoggers.getInstance().getTraceLogger();
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$ConfigAction == null ? (class$com$tivoli$pd$as$jacc$cfg$ConfigAction = ConfigAction.class$("com.tivoli.pd.as.jacc.cfg.ConfigAction")) : class$com$tivoli$pd$as$jacc$cfg$ConfigAction).getName();
    protected static final String _pdJarHome = "/jre/lib/ext/PD.jar";
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$ConfigAction;

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._desc;
    }

    public final void execute() throws ConfigActionFailedException {
        if (!this._validProps || this._stateProps == null || this._ctxID == null) {
            throw new IllegalStateException();
        }
        this.executeInternal();
    }

    public final boolean isReadyToBeExecuted() {
        boolean bl = false;
        if (this._validProps) {
            bl = this.isReadyToBeExecutedInternal();
        }
        return bl;
    }

    public final boolean isPropertiesValid() {
        this._validProps = this.isPropertiesValidInternal();
        return this._validProps;
    }

    public final void setProperties(Properties properties) {
        this._props = properties;
        this._validProps = false;
    }

    protected void exec(Object[][] objectArray, String[] stringArray, File file) throws ConfigActionFailedException {
        this.exec(objectArray, stringArray, file, false);
    }

    protected void exec(Object[][] objectArray, String[] stringArray, File file, boolean bl) throws ConfigActionFailedException {
        Object object;
        Object object2;
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.entry(80L, (Object)CLASSNAME, "exec(Object[][], String[], File) cmdarray = " + objectArray + " envp = " + stringArray + " dir = " + file);
        }
        if (this._logger != null && this._logger.isLogging()) {
            object2 = "cmd = " + (bl ? "SvrSSLCfg" : "PDJrteCfg");
            this._logger.text(16L, (Object)CLASSNAME, "exec(String[], String[], File)", (String)object2);
        }
        object2 = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer("\"");
        for (int i = 0; i < objectArray.length; ++i) {
            String string = objectArray[i][0].toString();
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "exec(String[], String[], File)", "exec: [" + string + "]");
            }
            if (string == null || string.length() <= 0) continue;
            object2.add(string);
            object = (Boolean)objectArray[i][1];
            if (((Boolean)object).booleanValue()) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("*****");
            }
            if (i < objectArray.length - 1) {
                stringBuffer.append("\" \"");
                continue;
            }
            stringBuffer.append("\"");
        }
        String[] stringArray2 = object2.toArray(new String[0]);
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.text(16L, (Object)CLASSNAME, "exec(String[], String[], File)", "About to spawn an external process to execute the following command array:\n" + stringBuffer);
        }
        int n = 1;
        try {
            object = TAMConfigUtils.getStringGeneratorForCtx();
            String string = ((TAMConfigStringGenerator)object).getStringFromTemplate("${COMMON_FILE_LOCATION}");
            System.setProperty("pd.cfg.home", string);
            if (bl) {
                SvrSslCfg svrSslCfg = new SvrSslCfg();
                n = svrSslCfg.invoke(stringArray2);
            } else {
                PDJrteCfg pDJrteCfg = new PDJrteCfg();
                n = pDJrteCfg.invoke(stringArray2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ConfigActionFailedException(exception.toString());
        }
    }

    protected String validateProperty(String string) {
        String string2 = null;
        if (this._props != null && (string2 = this._props.getProperty(string)) != null && !TAMConfigUtils.validateParameter(string, string2)) {
            string2 = null;
        }
        if (string2 == null && this._logger != null && this._logger.isLogging()) {
            this._logger.text(16L, (Object)CLASSNAME, "validateProperty(String)", "Invalid property: name = " + string + " value = " + string2);
        }
        return string2;
    }

    public void setForce(boolean bl) {
        this._force = bl;
    }

    public void setConfigStateProperties(ConfigStateProperties configStateProperties) {
        this._stateProps = configStateProperties;
    }

    public void setUniqueCtxID(String string) {
        this._ctxID = string;
    }

    protected abstract void executeInternal() throws ConfigActionFailedException;

    protected abstract boolean isReadyToBeExecutedInternal();

    protected abstract boolean isPropertiesValidInternal();

    protected String getWASSystemProps() {
        int n;
        String string = new String();
        if (System.getProperty("os.name").equals("OS/400") || System.getProperty("os.name").equals("z/OS")) {
            for (n = 0; n < TAMConfigConstants.WAS_SYSTEM_PROPS.length; ++n) {
                string = string + "-D" + TAMConfigConstants.WAS_SYSTEM_PROPS[n] + "=" + System.getProperty(TAMConfigConstants.WAS_SYSTEM_PROPS[n]) + " ";
            }
        }
        if (System.getProperty("os.name").equals("OS/400")) {
            for (n = 0; n < TAMConfigConstants.WAS_OS400_PROPS.length; ++n) {
                string = string + "-D" + TAMConfigConstants.WAS_OS400_PROPS[n] + "=" + System.getProperty(TAMConfigConstants.WAS_OS400_PROPS[n]) + " ";
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ExecThread
    extends Thread {
        private String[] _cmdarray = null;
        private String[] _envp = null;
        private File _dir = null;
        private String _stdOut = null;
        private String _stdErr = null;
        private int _exitValue = 0;
        private Exception _e = null;

        public ExecThread(String[] stringArray, String[] stringArray2, File file) {
            if (stringArray == null) {
                throw new IllegalArgumentException();
            }
            this._cmdarray = stringArray;
            this._envp = stringArray2;
            this._dir = file;
        }

        public void run() {
            try {
                Runtime runtime2 = Runtime.getRuntime();
                Process process = runtime2.exec(this._cmdarray, this._envp, this._dir);
                ProcessOutputReader processOutputReader = new ProcessOutputReader(process.getErrorStream());
                ProcessOutputReader processOutputReader2 = new ProcessOutputReader(process.getInputStream());
                processOutputReader.start();
                processOutputReader2.start();
                this._exitValue = process.waitFor();
                processOutputReader.join();
                processOutputReader2.join();
                this._stdOut = processOutputReader2.getOutputString();
                this._stdErr = processOutputReader.getOutputString();
            }
            catch (Exception exception) {
                this._e = exception;
            }
        }

        public Exception getException() {
            return this._e;
        }

        public int getExitValue() {
            return this._exitValue;
        }

        public String getStdErr() {
            return this._stdErr;
        }

        public String getStdOut() {
            return this._stdOut;
        }

        private class ProcessOutputReader
        extends Thread {
            private InputStream _in = null;
            private String _out = null;

            public ProcessOutputReader(InputStream inputStream) {
                if (inputStream == null) {
                    throw new IllegalArgumentException();
                }
                this._in = inputStream;
            }

            public void run() {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n != -1) {
                    try {
                        n = this._in.read();
                    }
                    catch (IOException iOException) {
                        n = -1;
                    }
                    if (n == -1) continue;
                    stringBuffer.append((char)n);
                }
                this._out = stringBuffer.length() == 0 ? null : stringBuffer.toString();
            }

            public String getOutputString() {
                return this._out;
            }
        }
    }
}

