/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.tivoli.pd.as.jacc.cfg.ConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigActionFailedException;
import com.tivoli.pd.as.jacc.cfg.RefCounter;
import com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.util.AmasMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ConfigureAmjaccConfigAction
extends ConfigAction {
    private final String ConfigureAmjaccConfigAction_java_sourceCodeID = "$Id: @(#)75  1.13.1.1 src/jacc/com/tivoli/pd/as/jacc/cfg/ConfigureAmjaccConfigAction.java, amemb.jacc.was, amemb600, 071025a 07/10/25 01:29:37 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private String _cfgFilename = null;
    private String _cfgTemplateFilename = null;
    private String _cfgLogTemplateFilename = null;
    private String _cfgLogFilename = null;
    private String _svrsslcfgFilename = null;
    private String _remoteAclUser = null;
    private String _adminUid = null;
    private String _adminPasswd = null;
    private String _serverPolicyFilename = null;
    private String _remoteCfgURLName = null;
    private static final String PROP_NAME_LOG_URL = "com.tivoli.pd.as.rbpf.AmasSession.LoggingURL";
    private static final String PROP_NAME_CFG_URL = "com.tivoli.pd.as.rbpf.AmasSession.CfgURL";
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$ConfigureAmjaccConfigAction == null ? (class$com$tivoli$pd$as$jacc$cfg$ConfigureAmjaccConfigAction = ConfigureAmjaccConfigAction.class$("com.tivoli.pd.as.jacc.cfg.ConfigureAmjaccConfigAction")) : class$com$tivoli$pd$as$jacc$cfg$ConfigureAmjaccConfigAction).getName();
    private static final String _GRANT_CODEBASE_STRING = "grant codeBase \"file:${was.install.root}/installedApps/-\" {";
    private static final String _PDPRINCIPAL_AUTH = "   permission javax.security.auth.AuthPermission \"createPDPrincipal\";";
    private static final String _RTPERMISSION = "   permission com.tivoli.pd.as.rbpf.RtPermission \"*\", \"read\";";
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$ConfigureAmjaccConfigAction;

    public ConfigureAmjaccConfigAction() {
        this._name = "ConfigureAmjacc";
        this._desc = "This class configures the Tivoli Access Manager Java Authorization Contract for Containers Provider";
    }

    protected void executeInternal() throws ConfigActionFailedException {
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.entry(80L, (Object)CLASSNAME, "executeInternal()");
        }
        TAMConfigStringGenerator tAMConfigStringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
        String string = TAMConfigUtils.filenameToURL(this._svrsslcfgFilename);
        String string2 = TAMConfigUtils.filenameToURL(this._cfgLogFilename);
        String string3 = TAMConfigUtils.filenameToURL(this._remoteCfgURLName);
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "Setting new properties (com.tivoli.pd.as.rbpf.AmasSession.LoggingURL=" + string2 + "), (" + PROP_NAME_CFG_URL + "=" + string + ")");
        }
        Properties properties = new Properties();
        properties.setProperty(PROP_NAME_LOG_URL, string2);
        properties.setProperty(PROP_NAME_CFG_URL, string);
        properties.setProperty("com.tivoli.pd.as.jacc.RemoteCfgURL", string3);
        TAMConfigUtils.addServerToGroup(this._logger, this._adminUid, this._adminPasswd, "iv-admin", this._svrsslcfgFilename);
        this.renameCurrentConfig();
        RefCounter refCounter = new RefCounter(this._stateProps.getConfigStateProps(), "secpolicyRefCount.", this._ctxID);
        if (refCounter.getRefCount() == 0) {
            this.updateServerPolicy();
        }
        refCounter.incrementRefCount();
        try {
            this._stateProps.save();
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636966, new Object[]{this._stateProps.getConfigStateFilename(), iOException.toString()});
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        File file = new File(this._cfgFilename);
        File file2 = new File(this._cfgLogFilename);
        String string4 = null;
        String string5 = null;
        try {
            boolean bl;
            string5 = file2.getAbsolutePath();
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "Creating the file " + string5 + " from config repository object " + this._cfgLogTemplateFilename);
            }
            string4 = this._cfgLogTemplateFilename;
            TAMConfigUtils.createFileFromCfgRepository(this._cfgLogTemplateFilename, file2);
            string5 = file.getAbsolutePath();
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "Creating the file " + string5 + " from config repository object " + this._cfgTemplateFilename);
            }
            string4 = this._cfgTemplateFilename;
            TAMConfigUtils.createFileFromCfgRepository(this._cfgTemplateFilename, file);
            string4 = null;
            if (TAMConfigUtils.isDeploymentManager() && (bl = tAMConfigStringGenerator.getLeavePolicyRefreshDmgr())) {
                properties.setProperty("com.tivoli.pd.as.jacc.ForcePolicyRefresh", "true");
            }
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "Appending context specific properties " + properties + " to " + string5);
            }
            TAMConfigUtils.appendProperties(properties, file.getAbsolutePath(), "System-dependant configuration parameters");
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = null;
            amasMessage = string4 == null ? new AmasMessage(864636966, new Object[]{string5, iOException.toString()}) : new AmasMessage(864636986, new Object[]{string4, string5, iOException.toString()});
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.exit(96L, (Object)CLASSNAME, "executeInternal()");
        }
    }

    private void updateServerPolicy() throws ConfigActionFailedException {
        int n;
        Object object;
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.entry(80L, (Object)CLASSNAME, "updateServerPolicy()");
        }
        boolean bl = false;
        String string = System.getProperty("line.separator");
        File file = new File(this._serverPolicyFilename);
        byte[] byArray = null;
        try {
            int n2;
            object = new FileInputStream(file);
            int n3 = ((FileInputStream)object).available();
            byArray = new byte[n3];
            for (n = ((FileInputStream)object).read(byArray); n < n3; n += ((FileInputStream)object).read(byArray, n2, n3 - n2)) {
                n2 = n;
            }
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{file.getAbsolutePath(), iOException.toString()});
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        Object object2 = object = new String(byArray);
        n = ((String)object).indexOf(_GRANT_CODEBASE_STRING);
        if (n < 0) {
            object2 = (String)object + string + _GRANT_CODEBASE_STRING + string + _PDPRINCIPAL_AUTH + string + _RTPERMISSION + string + "};" + string;
            bl = true;
        } else if (((String)object).indexOf(_PDPRINCIPAL_AUTH) == -1) {
            object2 = ((String)object).substring(0, n += _GRANT_CODEBASE_STRING.length()) + string + _PDPRINCIPAL_AUTH + string + _RTPERMISSION + ((String)object).substring(n);
            bl = true;
        }
        if (bl) {
            File file2 = new File(file.getAbsolutePath() + "_preAMWAS");
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "updateServerPolicy()", "Renaming existing server policy file " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
            }
            if (file2.exists()) {
                file2.delete();
            }
            if (!file.renameTo(file2)) {
                AmasMessage amasMessage = new AmasMessage(864636968, new Object[]{file.getAbsolutePath(), file2.getAbsolutePath()});
                throw new ConfigActionFailedException(amasMessage.getMessageString());
            }
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "updateServerPolicy()", "Adding new policy to existing policy and saving to " + file.getAbsolutePath());
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
                fileOutputStream.write(((String)object2).getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                AmasMessage amasMessage = new AmasMessage(864636966, new Object[]{file.getAbsolutePath(), iOException.toString()});
                throw new ConfigActionFailedException(amasMessage.getMessageString());
            }
        }
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.exit(96L, (Object)CLASSNAME, "updateServerPolicy()");
        }
    }

    private void renameCurrentConfig() {
        File file;
        File file2 = new File(this._cfgFilename + ".old");
        if (file2.exists()) {
            file2.delete();
        }
        if ((file = new File(this._cfgFilename)).exists()) {
            file.renameTo(file2);
        }
    }

    protected boolean isReadyToBeExecutedInternal() {
        return true;
    }

    protected boolean isPropertiesValidInternal() {
        boolean bl = false;
        this._adminUid = this.validateProperty("adminUid");
        this._adminPasswd = this.validateProperty("adminPasswd");
        this._cfgFilename = this.validateProperty("amjaccFilename");
        this._cfgTemplateFilename = this.validateProperty("amjaccTemplateFilename");
        this._cfgLogTemplateFilename = this.validateProperty("amjaccLogCfgTemplateFilename");
        this._cfgLogFilename = this.validateProperty("amjaccLogCfgFilename");
        this._svrsslcfgFilename = this.validateProperty("svrsslcfgFilename");
        this._serverPolicyFilename = this.validateProperty("wasServerPolicyFilename");
        this._remoteCfgURLName = this.validateProperty("pdloginSvrsslcfgFilename");
        if (this._adminUid != null && this._adminPasswd != null && this._cfgFilename != null && this._cfgTemplateFilename != null && this._cfgLogTemplateFilename != null && this._svrsslcfgFilename != null && this._serverPolicyFilename != null && this._remoteCfgURLName != null) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

