/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.tivoli.pd.as.jacc.cfg.ConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigActionFailedException;
import com.tivoli.pd.as.jacc.cfg.PortRangeDecoder;
import com.tivoli.pd.as.jacc.cfg.PortsTakenRecorder;
import com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.util.AmasMessage;
import java.io.File;
import java.io.IOException;
import java.util.Random;

public class ConfigureSvrSslCfgConfigAction
extends ConfigAction {
    private final String ConfigureSvrSslCfgConfigAction_java_sourceCodeID = "$Id: @(#)80  1.25 src/jacc/com/tivoli/pd/as/jacc/cfg/ConfigureSvrSslCfgConfigAction.java, amemb.jacc.was, amemb600, 071009a 07/10/09 01:35:45 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private String _cfgFilename = null;
    private String _cfgKSFilename = null;
    private String _policySvrs = null;
    private String _adminUid = null;
    private String _adminPasswd = null;
    private String _mode = null;
    private String _portRange = null;
    private String _authSvrs = null;
    private String _jreDir = null;
    private String _remoteAclUser = null;
    private String _dbDir = null;
    private String _domain = null;
    private boolean _modeLocal = true;
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$ConfigureSvrSslCfgConfigAction == null ? (class$com$tivoli$pd$as$jacc$cfg$ConfigureSvrSslCfgConfigAction = ConfigureSvrSslCfgConfigAction.class$("com.tivoli.pd.as.jacc.cfg.ConfigureSvrSslCfgConfigAction")) : class$com$tivoli$pd$as$jacc$cfg$ConfigureSvrSslCfgConfigAction).getName();
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$ConfigureSvrSslCfgConfigAction;

    public ConfigureSvrSslCfgConfigAction() {
        this._name = "ConfigureSvrSslCfg";
        this._desc = "This class configures a Tivoli Access Manager Java Authorization Application";
    }

    private void executeLocalMode() throws ConfigActionFailedException {
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.entry(80L, (Object)CLASSNAME, "executeLocalMode()");
        }
        PortsTakenRecorder portsTakenRecorder = null;
        String string = null;
        PortRangeDecoder portRangeDecoder = new PortRangeDecoder(this._portRange);
        portsTakenRecorder = new PortsTakenRecorder(this._stateProps.getConfigStateProps(), this._ctxID, portRangeDecoder);
        int n = portsTakenRecorder.findAvailablePort();
        if (n < 0) {
            AmasMessage amasMessage = new AmasMessage(864636977, this._portRange);
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        string = Integer.toString(n);
        this.executeCommon(string);
        portsTakenRecorder.takeAvailablePort(n);
        try {
            this._stateProps.save();
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636966, new Object[]{this._stateProps.getConfigStateFilename(), iOException.toString()});
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.exit(96L, (Object)CLASSNAME, "executeLocalMode()");
        }
    }

    private void executeRemoteMode() throws ConfigActionFailedException {
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.entry(80L, (Object)CLASSNAME, "executeRemoteMode()");
        }
        this.executeCommon("9999");
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.exit(96L, (Object)CLASSNAME, "executeRemoteMode()");
        }
    }

    private void executeCommon(String string) throws ConfigActionFailedException {
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.entry(80L, (Object)CLASSNAME, "executeCommon(String) port = " + string);
        }
        TAMConfigStringGenerator tAMConfigStringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
        String string2 = tAMConfigStringGenerator.getStringFromTemplate("${COMMON_FILE_LOCATION}");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._jreDir);
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("bin");
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("java");
        boolean bl = false;
        int n = 0;
        String string3 = TAMConfigUtils.convertToHash(this._remoteAclUser);
        String string4 = this._remoteAclUser;
        String string5 = tAMConfigStringGenerator.getSvrSslCfgDbRefresh();
        while (!bl) {
            Object[] objectArray;
            Object[] objectArray2;
            Boolean bl2 = new Boolean(true);
            Boolean bl3 = new Boolean(false);
            Object[][] objectArray3 = null;
            String[] stringArray = null;
            if (!this._mode.equalsIgnoreCase("remote")) {
                objectArray2 = new Object[]{"-dbdir", bl2};
                objectArray = new Object[]{this._dbDir, bl2};
            } else {
                objectArray2 = new Object[]{"", bl2};
                objectArray = new Object[]{"", bl2};
            }
            if (System.getProperty("os.name").equals("z/OS")) {
                objectArray3 = new Object[][]{{"-action", bl2}, {"config", bl2}, {"-admin_id", bl2}, {this._adminUid, bl2}, {"-admin_pwd", bl2}, {this._adminPasswd, bl3}, {"-appsvr_id", bl2}, {string3, bl2}, {"-desc", bl2}, {string4, bl2}, {"-port", bl2}, {string, bl2}, {"-mode", bl2}, {this._mode, bl2}, {"-domain", bl2}, {this._domain, bl2}, {"-policysvr", bl2}, {this._policySvrs + ":1", bl2}, {"-authzsvr", bl2}, {this._authSvrs, bl2}, {"-cfg_file", bl2}, {this._cfgFilename, bl2}, {"-key_file", bl2}, {this._cfgKSFilename, bl2}, objectArray2, objectArray, {"-dbrefresh", bl2}, {string5, bl2}};
                stringArray = new String[]{"CLASSPATH=" + this._jreDir + "/jre/lib/ext/PD.jar"};
            } else {
                System.setProperty("pd.cfg.home", string2);
                objectArray3 = new Object[][]{{"-action", bl2}, {"config", bl2}, {"-admin_id", bl2}, {this._adminUid, bl2}, {"-admin_pwd", bl2}, {this._adminPasswd, bl3}, {"-appsvr_id", bl2}, {string3, bl2}, {"-desc", bl2}, {string4, bl2}, {"-port", bl2}, {string, bl2}, {"-mode", bl2}, {this._mode, bl2}, {"-domain", bl2}, {this._domain, bl2}, {"-policysvr", bl2}, {this._policySvrs + ":1", bl2}, {"-authzsvr", bl2}, {this._authSvrs, bl2}, {"-cfg_file", bl2}, {this._cfgFilename, bl2}, {"-key_file", bl2}, {this._cfgKSFilename, bl2}, objectArray2, objectArray, {"-dbrefresh", bl2}, {string5, bl2}};
            }
            try {
                this.exec(objectArray3, stringArray, null, true);
                bl = true;
            }
            catch (ConfigActionFailedException configActionFailedException) {
                String string6 = configActionFailedException.toString();
                if ((TAMConfigUtils.isZOS() || string6 != null && (string6.indexOf("HPDMG0759W") >= 0 || string6.indexOf("HPDMG0453E") >= 0)) && n < 3) {
                    Random random = new Random();
                    int n2 = random.nextInt();
                    string3 = TAMConfigUtils.convertToHash(this._remoteAclUser + "_" + n2);
                    string4 = this._remoteAclUser + "_" + n2;
                    if (this._logger != null && this._logger.isLogging()) {
                        this._logger.text(2L, (Object)CLASSNAME, "executeCommon(String)", "Application server username already exists. Trying again with randomly generated suffix appended to username.");
                    }
                    ++n;
                    continue;
                }
                throw configActionFailedException;
            }
        }
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.exit(96L, (Object)CLASSNAME, "executeCommon(String)");
        }
    }

    protected void executeInternal() throws ConfigActionFailedException {
        if (this._modeLocal) {
            this.executeLocalMode();
        } else {
            this.executeRemoteMode();
        }
    }

    protected boolean isReadyToBeExecutedInternal() {
        return !new File(this._cfgFilename).exists() || !new File(this._cfgKSFilename).exists();
    }

    protected boolean isPropertiesValidInternal() {
        boolean bl = false;
        this._mode = this.validateProperty("mode");
        this._domain = this.validateProperty("secDomain");
        this._adminUid = this.validateProperty("adminUid");
        this._adminPasswd = this.validateProperty("adminPasswd");
        this._jreDir = this.validateProperty("jrejavaDirectory");
        this._cfgFilename = this.validateProperty("svrsslcfgFilename");
        this._cfgKSFilename = this.validateProperty("svrsslcfgKSFilename");
        this._dbDir = this.validateProperty("svrsslcfgDbDir");
        this._policySvrs = this.validateProperty("policySvr");
        this._remoteAclUser = this.validateProperty("remoteAclUser");
        this._authSvrs = this.validateProperty("authSvrs");
        if (this._domain != null && this._cfgFilename != null && this._cfgKSFilename != null && this._policySvrs != null && this._adminUid != null && this._adminPasswd != null && this._mode != null && this._authSvrs != null && this._dbDir != null) {
            if (this._mode.equals("local")) {
                this._portRange = this.validateProperty("portSet");
                if (this._portRange != null) {
                    this._modeLocal = true;
                    bl = true;
                }
            } else {
                this._modeLocal = false;
                bl = true;
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

