/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class LockableFile {
    private final String LockableFile_java_sourceCodeID = "$Id: @(#)65  1.4 src/jacc/com/tivoli/pd/as/jacc/cfg/LockableFile.java, amemb.jacc.was, amemb600, 051118a 04/07/15 17:55:07 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private RandomAccessFile _file = null;
    private boolean _streamInUse = false;

    public LockableFile(String string) throws FileNotFoundException {
        this._file = new RandomAccessFile(string, "rw");
    }

    private synchronized boolean tryTakeStream() {
        boolean bl = false;
        if (!this._streamInUse) {
            this._streamInUse = true;
            bl = true;
        }
        return bl;
    }

    private synchronized void releaseStream() {
        this._streamInUse = false;
    }

    public InputStream getInputStream() {
        InputStream inputStream = null;
        if (this.tryTakeStream()) {
            inputStream = new InputStream(){
                private boolean _closed = false;

                public int read() throws IOException {
                    if (this._closed) {
                        return -1;
                    }
                    return LockableFile.this._file.read();
                }

                public int read(byte[] byArray, int n, int n2) throws IOException {
                    if (this._closed) {
                        return -1;
                    }
                    return LockableFile.this._file.read(byArray, n, n2);
                }

                public int read(byte[] byArray) throws IOException {
                    if (this._closed) {
                        return -1;
                    }
                    return LockableFile.this._file.read(byArray);
                }

                public void close() throws IOException {
                    if (this._closed) {
                        return;
                    }
                    LockableFile.this._file.seek(0L);
                    this._closed = true;
                    LockableFile.this.releaseStream();
                }
            };
        }
        return inputStream;
    }

    public OutputStream getOutputStream() {
        OutputStream outputStream = null;
        if (this.tryTakeStream()) {
            outputStream = new OutputStream(){
                private boolean _closed = false;

                public void write(int n) throws IOException {
                    if (this._closed) {
                        return;
                    }
                    LockableFile.this._file.write(n);
                }

                public void write(byte[] byArray, int n, int n2) throws IOException {
                    if (this._closed) {
                        return;
                    }
                    LockableFile.this._file.write(byArray, n, n2);
                }

                public void write(byte[] byArray) throws IOException {
                    if (this._closed) {
                        return;
                    }
                    LockableFile.this._file.write(byArray);
                }

                public void close() throws IOException {
                    LockableFile.this._file.setLength(LockableFile.this._file.getFilePointer());
                    LockableFile.this._file.seek(0L);
                    this._closed = true;
                    LockableFile.this.releaseStream();
                }
            };
        }
        return outputStream;
    }

    public void close() throws IOException {
        this._file.close();
    }

    public FileLock lock() throws IOException {
        return this._file.getChannel().lock();
    }

    public FileLock tryLock() throws IOException {
        return this._file.getChannel().tryLock();
    }
}

