/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.tivoli.pd.as.jacc.cfg.ConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigActionFailedException;
import com.tivoli.pd.as.jacc.cfg.RefCounter;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pdwas.migrate.Migrate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class MigrateToTAMConfigAction
extends ConfigAction {
    private final String MigrateToTAMConfigAction_java_sourceCodeID = "$Id: @(#)91  1.21 src/jacc/com/tivoli/pd/as/jacc/cfg/MigrateToTAMConfigAction.java, amemb.jacc.was, amemb600, 051118a 05/10/04 00:38:38 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$MigrateToTAMConfigAction == null ? (class$com$tivoli$pd$as$jacc$cfg$MigrateToTAMConfigAction = MigrateToTAMConfigAction.class$("com.tivoli.pd.as.jacc.cfg.MigrateToTAMConfigAction")) : class$com$tivoli$pd$as$jacc$cfg$MigrateToTAMConfigAction).getName();
    private static final String PROP_NAME_RBPF_POS_ROOT = "com.tivoli.pd.as.rbpf.PosRoot";
    private static final String PROP_NAME_RBPF_AM_ACTION_GROUP = "com.tivoli.pd.as.rbpf.AMActionGroup";
    private static final String PROP_NAME_RBPF_ROLE_CONT_NAME = "com.tivoli.pd.as.rbpf.RoleContainerName";
    private String _adminUid = null;
    private String _adminPasswd = null;
    private String _amwasAdminUid = null;
    private String _secDomain = null;
    private String _dnsSuffix = null;
    private String _cfgFilename = null;
    private String _jaccCfgFilename = null;
    private String _wasProfilesHome = null;
    private String _mtsTimeout = null;
    private String[] _migrateFiles = new String[0];
    private String[] _migrateAppNames = new String[]{null, null};
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$MigrateToTAMConfigAction;

    public MigrateToTAMConfigAction() {
        this._name = "MigrateToTAM";
        this._desc = "This class migrates binding information contained in several WebSphere applications to the Tivoli Access Manager domain.";
    }

    protected void executeInternal() throws ConfigActionFailedException {
        Object object;
        RefCounter refCounter;
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.entry(80L, (Object)CLASSNAME, "executeInternal()");
        }
        if ((refCounter = new RefCounter(this._stateProps.getConfigStateProps(), "migrateRefCount.", this._ctxID)).getRefCount() == 0) {
            Object object2;
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "This is the first attempted migration on this node - migrate the admin binding information");
            }
            String string = null;
            object = null;
            String string2 = null;
            try {
                object2 = TAMConfigUtils.readCfgRepositoryProperties(this._jaccCfgFilename);
                string = ((Properties)object2).getProperty(PROP_NAME_RBPF_POS_ROOT);
                object = ((Properties)object2).getProperty(PROP_NAME_RBPF_AM_ACTION_GROUP);
                string2 = ((Properties)object2).getProperty(PROP_NAME_RBPF_ROLE_CONT_NAME);
                if (string2 != null && string2.length() == 0) {
                    string2 = null;
                }
                if (string != null && string.length() == 0) {
                    string = null;
                }
                if (object != null && ((String)object).length() == 0) {
                    object = null;
                }
            }
            catch (IOException iOException) {
                AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{this._jaccCfgFilename, iOException.toString()});
                throw new ConfigActionFailedException(amasMessage.getMessageString());
            }
            object2 = this._wasProfilesHome + File.separatorChar + "logs";
            for (int i = 0; i < this._migrateFiles.length; ++i) {
                Object object3;
                String[] stringArray = new String[]{"-q", this._migrateFiles[i], "-a", this._adminUid, "-p", this._adminPasswd, "-w", this._amwasAdminUid, "-d", this._dnsSuffix, "-t", this._mtsTimeout, "-b", this._secDomain, "-c", "file:" + (System.getProperty("os.name").startsWith("Windows") ? "/" : "") + this._cfgFilename, "-z", string2, "-r", string, "-g", object};
                try {
                    AmasMessage amasMessage;
                    boolean bl = Migrate.JaccCfgMigrate(stringArray, (String)object2);
                    if (bl && this._logger != null && this._logger.isLogging()) {
                        object3 = new Boolean(true);
                        amasMessage = new AmasMessage(864636998, new Object[]{this._migrateFiles[i], object3});
                        this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", amasMessage.getMessageString());
                        continue;
                    }
                    if (bl) continue;
                    object3 = new Boolean(false);
                    amasMessage = new AmasMessage(864636998, new Object[]{this._migrateFiles[i], object3});
                    if (this._logger != null && this._logger.isLogging()) {
                        this._logger.text(4L, (Object)CLASSNAME, "executeInternal()", amasMessage.getMessageString());
                    }
                    throw new ConfigActionFailedException(amasMessage.getMessageString());
                }
                catch (IOException iOException) {
                    object3 = new AmasMessage(864636997, new Object[]{this._migrateFiles[i], iOException.toString()});
                    if (this._logger != null && this._logger.isLogging()) {
                        this._logger.text(4L, (Object)CLASSNAME, "executeInternal()", ((AmasMessage)object3).getMessageString());
                    }
                    throw new ConfigActionFailedException(((AmasMessage)object3).getMessageString());
                }
            }
        } else if (this._logger != null && this._logger.isLogging()) {
            this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "This is not the first migration to be attempted on this node, so we can assume the migration has already occurred");
        }
        refCounter.incrementRefCount();
        try {
            this._stateProps.save();
        }
        catch (IOException iOException) {
            object = new AmasMessage(864636966, new Object[]{this._stateProps.getConfigStateFilename(), iOException.toString()});
            throw new ConfigActionFailedException(((AmasMessage)object).getMessageString());
        }
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.exit(96L, (Object)CLASSNAME, "executeInternal()");
        }
    }

    protected boolean isReadyToBeExecutedInternal() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService == null) {
            return false;
        }
        String string = adminService.getProcessType();
        if (string == null) {
            return false;
        }
        return string.equals("UnManagedProcess") || string.equals("DeploymentManager");
    }

    protected boolean isPropertiesValidInternal() {
        boolean bl = false;
        this._adminUid = this.validateProperty("adminUid");
        this._adminPasswd = this.validateProperty("adminPasswd");
        this._amwasAdminUid = this.validateProperty("wasAdminDN");
        this._secDomain = this.validateProperty("secDomain");
        this._dnsSuffix = this.validateProperty("dnSuffix");
        this._wasProfilesHome = this.validateProperty("wasProfilesHomeDirectory");
        this._mtsTimeout = this.validateProperty("mtsTimeout");
        this._migrateAppNames[0] = this.validateProperty("migrateAppname2");
        this._migrateAppNames[1] = this.validateProperty("migrateAppname3");
        this._jaccCfgFilename = this.validateProperty("amjaccTemplateFilename");
        this._cfgFilename = this.validateProperty("pdloginSvrsslcfgFilename");
        String string = this.validateProperty("migrateFilename4");
        File file = new File(string);
        if (file.exists()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.validateProperty("migrateFilename2"));
            arrayList.add(this.validateProperty("migrateFilename3"));
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                String string2 = fileArray[i].getName();
                String string3 = this.validateProperty("migrateFilenameRel") + File.separator + string2 + File.separator + "admin-authz.xml";
                String string4 = fileArray[i].getAbsolutePath() + File.separator + "admin-authz.xml";
                File file2 = new File(string4);
                if (!file2.exists()) continue;
                arrayList.add(string3);
            }
            this._migrateFiles = arrayList.toArray(new String[0]);
        } else {
            this._migrateFiles = new String[]{this.validateProperty("migrateFilename2"), this.validateProperty("migrateFilename3")};
        }
        if (this._adminUid != null && this._adminPasswd != null && this._amwasAdminUid != null && this._secDomain != null && this._dnsSuffix != null && this._wasProfilesHome != null && this._mtsTimeout != null && this._migrateFiles[0] != null && this._migrateFiles[1] != null && this._cfgFilename != null && this._jaccCfgFilename != null) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

