/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.tivoli.pd.as.jacc.cfg.ConfigAction;
import com.tivoli.pd.as.jacc.cfg.ConfigActionFailedException;
import com.tivoli.pd.as.jacc.cfg.PDServer;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.util.AmasMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class ModifySvrSslCfgConfigAction
extends ConfigAction {
    private final String ModifySvrSslCfgConfigAction_java_sourceCodeID = "$Id: @(#)81  1.11 src/jacc/com/tivoli/pd/as/jacc/cfg/ModifySvrSslCfgConfigAction.java, amemb.jacc.was, amemb600, 060405a 06/04/05 00:19:25 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private String _cfgFilename = null;
    private String _authSvrs = null;
    private String _jreDir = null;
    private static final String CLASSNAME = (class$com$tivoli$pd$as$jacc$cfg$ModifySvrSslCfgConfigAction == null ? (class$com$tivoli$pd$as$jacc$cfg$ModifySvrSslCfgConfigAction = ModifySvrSslCfgConfigAction.class$("com.tivoli.pd.as.jacc.cfg.ModifySvrSslCfgConfigAction")) : class$com$tivoli$pd$as$jacc$cfg$ModifySvrSslCfgConfigAction).getName();
    private static final String SVRSSLCFG_APPSVR_AUTHZSVRS = "appsvr-authzsvrs";
    static /* synthetic */ Class class$com$tivoli$pd$as$jacc$cfg$ModifySvrSslCfgConfigAction;

    public ModifySvrSslCfgConfigAction() {
        this._name = "ModifySvrSslCfg";
        this._desc = "This class modifies the authorization server settings for a Tivoli Access Manager Java Authorization Application";
    }

    protected void executeInternal() throws ConfigActionFailedException {
        PDServer pDServer;
        int n;
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.entry(80L, (Object)CLASSNAME, "executeInternal()");
        }
        Properties properties = null;
        try {
            properties = TAMConfigUtils.readProperties(this._cfgFilename);
        }
        catch (IOException iOException) {
            AmasMessage amasMessage = new AmasMessage(864636965, new Object[]{this._cfgFilename, iOException.toString()});
            throw new ConfigActionFailedException(amasMessage.getMessageString());
        }
        String string = properties.getProperty(SVRSSLCFG_APPSVR_AUTHZSVRS);
        ArrayList arrayList = TAMConfigUtils.parseServers(string, ";");
        ArrayList arrayList2 = TAMConfigUtils.parseServers(this._authSvrs);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._jreDir);
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("bin");
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("java");
        Boolean bl = new Boolean(true);
        for (n = 0; n < arrayList2.size(); ++n) {
            Object[][] objectArray;
            Object[][] objectArray2;
            pDServer = (PDServer)arrayList2.get(n);
            int n2 = arrayList.indexOf(pDServer);
            if (n2 >= 0) {
                objectArray2 = (Object[][])arrayList.get(n2);
                if (objectArray2.getRank() == pDServer.getRank()) {
                    if (this._logger != null && this._logger.isLogging()) {
                        this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "Authorization server config already exists for " + pDServer.getServer() + " - doing nothing");
                    }
                } else {
                    if (this._logger != null && this._logger.isLogging()) {
                        this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "Changing authorization server config from " + objectArray2.getServer() + " to " + pDServer.getServer());
                    }
                    objectArray = null;
                    String[] stringArray = null;
                    if (System.getProperty("os.name").equals("z/OS")) {
                        objectArray = new Object[][]{{"-action", bl}, {"chgsvr", bl}, {"-authzsvr", bl}, {pDServer.getServer(), bl}, {"-cfg_file", bl}, {this._cfgFilename, bl}};
                        stringArray = new String[]{"CLASSPATH=" + this._jreDir + "/jre/lib/ext/PD.jar"};
                    } else {
                        objectArray = new Object[][]{{"-action", bl}, {"chgsvr", bl}, {"-authzsvr", bl}, {pDServer.getServer(), bl}, {"-cfg_file", bl}, {this._cfgFilename, bl}};
                    }
                    this.exec(objectArray, stringArray, null, true);
                }
                arrayList.remove(objectArray2);
                continue;
            }
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "Adding authorization server config for " + pDServer.getServer());
            }
            objectArray2 = null;
            objectArray = null;
            if (System.getProperty("os.name").equals("z/OS")) {
                objectArray2 = new Object[][]{{"-action", bl}, {"addsvr", bl}, {"-authzsvr", bl}, {pDServer.getServer(), bl}, {"-cfg_file", bl}, {this._cfgFilename, bl}};
                objectArray = new String[]{"CLASSPATH=" + this._jreDir + "/jre/lib/ext/PD.jar"};
            } else {
                objectArray2 = new Object[][]{{"-action", bl}, {"addsvr", bl}, {"-authzsvr", bl}, {pDServer.getServer(), bl}, {"-cfg_file", bl}, {this._cfgFilename, bl}};
            }
            this.exec(objectArray2, (String[])objectArray, null, true);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            pDServer = (PDServer)arrayList.get(n);
            if (this._logger != null && this._logger.isLogging()) {
                this._logger.text(16L, (Object)CLASSNAME, "executeInternal()", "Removing authorization server config for " + pDServer.getServer());
            }
            Object[][] objectArray = new Object[][]{{"-action", bl}, {"rmsvr", bl}, {"-authzsvr", bl}, {pDServer.getServer(), bl}, {"-cfg_file", bl}, {this._cfgFilename, bl}};
            this.exec(objectArray, null, null);
        }
        if (this._logger != null && this._logger.isLogging()) {
            this._logger.exit(96L, (Object)CLASSNAME, "executeInternal()");
        }
    }

    protected boolean isReadyToBeExecutedInternal() {
        return new File(this._cfgFilename).exists();
    }

    protected boolean isPropertiesValidInternal() {
        boolean bl = false;
        this._jreDir = this.validateProperty("jrejavaDirectory");
        this._cfgFilename = this.validateProperty("svrsslcfgFilename");
        this._authSvrs = this.validateProperty("authSvrs");
        if (this._cfgFilename != null && this._authSvrs != null) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

