/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.security.web.AmasWSAttributes;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import com.tivoli.pd.as.jacc.cfg.JACCCallbackHandler;
import com.tivoli.pd.as.jacc.cfg.TAMConfigInitialize;
import com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.jazn.PDAuthorizationContext;
import com.tivoli.pd.jazn.PDLoginModule;
import com.tivoli.pd.jazn.PDPrincipal;
import java.net.URL;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class PDLoginModuleWrapper
extends PDLoginModule {
    private final String PDLoginModuleWrapper_java_sourceCodeID = "$Id: @(#)91  1.16.1.1 src/jacc/com/tivoli/pd/as/jacc/cfg/PDLoginModuleWrapper.java, amemb.jacc.was, amemb600, 070522a 07/05/09 23:10:49 @(#) $";
    private static String INT_SID;
    private static final boolean _isServant;
    private Subject _subject;
    private JACCCallbackHandler _callbackHandler;
    private Map _sharedState;
    private Map _options;
    private boolean _delegate = false;
    private static final String CLASSNAME = "com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapper";
    private final String ORGANISATION = "IBM";
    private final String PRODUCT = "Tivoli Access Manager";
    private final String COMPONENT = "PDLoginModuleWrapper";
    private Logger _logger = null;
    private static boolean _jaccInitialized;
    private static URL _cfgURL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWASAttributes() {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "addWASAttributes()");
        }
        try {
            block12: {
                try {
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperaddWASAttributes() Looking for custom properties in public cred list.");
                    }
                    Object[] objectArray = this._subject.getPublicCredentials().toArray();
                    boolean bl = false;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!(objectArray[i] instanceof Hashtable) || ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null) continue;
                        bl = true;
                        this._sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", objectArray[i]);
                        if (!this._logger.isLoggable(Level.FINE)) continue;
                        this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperaddWASAttributes() WAS attributes found in the Subject. The existing attributes added to the shared state");
                    }
                    if (bl) break block12;
                    AmasWSAttributes amasWSAttributes = new AmasWSAttributes();
                    PDAuthorizationContext pDAuthorizationContext = super.getAuthorizationContext();
                    amasWSAttributes.initialize(pDAuthorizationContext);
                    Hashtable hashtable = amasWSAttributes.getAttributes((Principal)this.pdPrincipal);
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperaddWASAttributes() Successfully created WAS attributes from PDPrincipal: " + hashtable.toString());
                    }
                    this._sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", hashtable);
                    if (!this._logger.isLoggable(Level.FINE)) break block12;
                    this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperaddWASAttributes() Added WAS attributes to the shared state.");
                }
                catch (Exception exception) {
                    if (this._logger.isLoggable(Level.INFO)) {
                        this._logger.info("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperaddWASAttributes()" + AmasMsgHelper.formatSingleParamMessage(864636988, exception.toString()));
                    }
                    Object var7_9 = null;
                    if (this._logger.isLoggable(Level.FINER)) {
                        this._logger.exiting(CLASSNAME, "addWASAttributes()");
                    }
                }
            }
            Object var7_8 = null;
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "addWASAttributes()");
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "addWASAttributes()");
            }
            throw throwable;
        }
    }

    private void cleanupSharedState() {
        Object v;
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "cleanupSharedState()");
        }
        if ((v = this._sharedState.remove("com.ibm.wsspi.security.cred.propertiesObject")) != null && this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrappercleanupSharedState() WAS attributes removed from the shared state.");
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "cleanupSharedState()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this._logger = Logger.getLogger(CLASSNAME);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "initialize()");
        }
        this._subject = subject;
        this._callbackHandler = new JACCCallbackHandler(callbackHandler);
        this._sharedState = map;
        this._options = map2;
        super.initialize(subject, (CallbackHandler)this._callbackHandler, map, map2);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "initialize()");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws AccountExpiredException, CredentialExpiredException, FailedLoginException, LoginException {
        Object object;
        Object object2;
        block44: {
            Callback[] callbackArray;
            Set<Object> set;
            boolean bl;
            block46: {
                Object[] objectArray;
                block47: {
                    block45: {
                        boolean bl2;
                        block43: {
                            if (this._logger.isLoggable(Level.FINER)) {
                                this._logger.entering(CLASSNAME, "login()");
                            }
                            if (!_jaccInitialized) {
                                AmasMessage amasMessage = new AmasMessage(864636987);
                                if (!this._logger.isLoggable(Level.INFO)) throw new LoginException(amasMessage.getMessageString());
                                this._logger.info("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin()" + amasMessage.getMessageString());
                                throw new LoginException(amasMessage.getMessageString());
                            }
                            this._delegate = true;
                            bl = false;
                            if (this._logger.isLoggable(Level.FINE)) {
                                this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() Checking PDPrincipal in the Subject.");
                            }
                            set = null;
                            try {
                                set = this._subject.getPrincipals(Class.forName("com.tivoli.pd.jazn.PDPrincipal"));
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                if (!this._logger.isLoggable(Level.FINE)) break block43;
                                this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() com.tivoli.pd.jazn.PDPrincipal not found. Exception: " + classNotFoundException);
                            }
                        }
                        if (set != null && !set.isEmpty()) {
                            if (this._logger.isLoggable(Level.FINE)) {
                                this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() PDPrincipal found in the Subject.");
                            }
                            bl = true;
                        } else if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() PDPrincipal not found in the Subject.");
                        }
                        if (bl) break block44;
                        callbackArray = new Callback[]{new WSCredTokenCallbackImpl("Credential Token: "), new WSTokenHolderCallback("Authz Token List: "), new PasswordCallback(this.getStringWD(this.RB(), "Password") + ": ", false)};
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() Calling callbacks to retrieve token information.");
                        }
                        try {
                            this._callbackHandler.handle(callbackArray);
                        }
                        catch (Exception exception) {
                            AmasMessage amasMessage = new AmasMessage(864636989, exception);
                            if (!this._logger.isLoggable(Level.INFO)) throw new WSLoginFailedException(amasMessage.getMessageString(), exception);
                            this._logger.info("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin()" + amasMessage.getMessageString());
                            throw new WSLoginFailedException(amasMessage.getMessageString(), exception);
                        }
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() Checking for propagation login.");
                        }
                        if (!(bl2 = ((WSTokenHolderCallback)callbackArray[1]).getRequiresLogin())) break block45;
                        object2 = (Hashtable)this._sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
                        if (object2 != null) break block46;
                        object = this._subject;
                        objectArray = ((Subject)object).getPublicCredentials().toArray();
                        break block47;
                    }
                    this._delegate = false;
                    bl = true;
                    break block44;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof Hashtable) || ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                    object2 = (Hashtable)objectArray[i];
                    break;
                }
                if (object2 == null) {
                    Object[] objectArray2 = ((Subject)object).getPrivateCredentials().toArray();
                    for (int i = 0; i < objectArray2.length; ++i) {
                        if (!(objectArray2[i] instanceof Hashtable) || ((Hashtable)objectArray2[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)objectArray2[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                        object2 = (Hashtable)objectArray2[i];
                        break;
                    }
                }
            }
            if (object2 != null && ((Hashtable)object2).get("com.ibm.wsspi.security.cred.uniqueId") != null && ((Hashtable)object2).get("com.ibm.wsspi.security.cred.userId") == null) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperCustom login module passing in credential properties.  Handling login outside this login module.");
                }
                if (!this._logger.isLoggable(Level.FINER)) return true;
                this._logger.exiting(CLASSNAME, "login()");
                return true;
            }
            object = ((WSTokenHolderCallback)callbackArray[1]).getTokenHolderList();
            if (object != null) {
                void var7_16;
                boolean bl3 = false;
                while (var7_16 < object.size()) {
                    TokenHolder tokenHolder = (TokenHolder)object.get((int)var7_16);
                    if (tokenHolder.getName().startsWith("com.tivoli.pd.jazn.PDPrincipal")) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() PDPrincipal found in the authorization token. No further processing required.");
                        }
                        this._delegate = false;
                        bl = true;
                    }
                    ++var7_16;
                }
            }
            if (!bl) {
                byte[] byArray;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() Checking for LTPA login.");
                }
                if ((byArray = ((WSCredTokenCallbackImpl)callbackArray[0]).getCredToken()) != null) {
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() LTPA token found.");
                    }
                    try {
                        String string = WSSecurityPropagationHelper.validateLTPAToken(byArray);
                        if (string != null) {
                            String string2 = WSSecurityPropagationHelper.getUserFromUniqueID(string);
                            if (string2 != null) {
                                if (string2.startsWith(INT_SID)) {
                                    if (this._logger.isLoggable(Level.FINE)) {
                                        this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() LTPA token contains internal server id, skipping login. User ID: " + string2);
                                    }
                                    if (!this._logger.isLoggable(Level.FINER)) return true;
                                    this._logger.exiting(CLASSNAME, "login()", Boolean.toString(true));
                                    return true;
                                }
                                if (this._logger.isLoggable(Level.FINE)) {
                                    this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() LTPA token validated successfully and user ID retrieved. User ID: " + string2);
                                }
                                PDAuthorizationContext pDAuthorizationContext = super.getAuthorizationContext();
                                this.pdPrincipal = new PDPrincipal(pDAuthorizationContext, string2);
                                if (this._logger.isLoggable(Level.FINE)) {
                                    this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() PDPrincipal created successfully.");
                                }
                                set = this._subject.getPrincipals();
                                set.add(this.pdPrincipal);
                                if (this._logger.isLoggable(Level.FINE)) {
                                    this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() PDPrincipal added to the Subject.");
                                }
                                break block44;
                            }
                            if (this._logger.isLoggable(Level.FINE)) {
                                this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() Failed to retrieve user ID from the LTPA token.");
                            }
                            break block44;
                        }
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() Failed to validate the LTPA token.");
                        }
                    }
                    catch (Exception exception) {
                        AmasMessage amasMessage = new AmasMessage(864636990, exception.toString());
                        if (!this._logger.isLoggable(Level.INFO)) throw new WSLoginFailedException(amasMessage.getMessageString(), exception);
                        this._logger.info("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin()" + amasMessage.getMessageString());
                        throw new WSLoginFailedException(amasMessage.getMessageString(), exception);
                    }
                }
            }
        }
        boolean bl = true;
        if (this._delegate && this._callbackHandler.hasPassword()) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() Delegating login to PDLoginModule.");
            }
            try {
                bl = super.login();
            }
            catch (LoginException loginException) {
                if (!this._logger.isLoggable(Level.INFO)) throw loginException;
                object2 = this._callbackHandler.getUserName();
                object = new AmasMessage(864297008, object2, loginException.toString());
                this._logger.info("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin()" + ((AmasMessage)object).getMessageString());
                throw loginException;
            }
            this.addWASAttributes();
        } else if (this._delegate && this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogin() PDLoginModule password not found in callback.");
        }
        if (!this._logger.isLoggable(Level.FINER)) return bl;
        this._logger.exiting(CLASSNAME, "login()", Boolean.toString(bl));
        return bl;
    }

    public boolean commit() throws LoginException {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "commit()");
        }
        if (!_jaccInitialized) {
            AmasMessage amasMessage = new AmasMessage(864636987);
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrappercommit()" + amasMessage.getMessageString());
            }
            throw new LoginException(amasMessage.getMessageString());
        }
        this.cleanupSharedState();
        boolean bl = true;
        if (this._delegate) {
            bl = super.commit();
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "abort()");
        }
        if (!_jaccInitialized) {
            AmasMessage amasMessage = new AmasMessage(864636987);
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperabort()" + amasMessage.getMessageString());
            }
            throw new LoginException(amasMessage.getMessageString());
        }
        this.cleanupSharedState();
        boolean bl = true;
        if (this._delegate) {
            bl = super.abort();
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "abort()");
        }
        return bl;
    }

    public boolean logout() throws LoginException {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "logout()");
        }
        if (!_jaccInitialized) {
            AmasMessage amasMessage = new AmasMessage(864636987);
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapperlogout()" + amasMessage.getMessageString());
            }
            throw new LoginException(amasMessage.getMessageString());
        }
        this.cleanupSharedState();
        boolean bl = true;
        if (this._delegate) {
            bl = super.logout();
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "logout()");
        }
        return bl;
    }

    private String getStringWD(ResourceBundle resourceBundle, String string) {
        String string2;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapper getStringWD() Couldn't locate msg text for: " + string);
            }
            string2 = string;
        }
        catch (NullPointerException nullPointerException) {
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapper getStringWD() Couldn't locate msg text for: " + string);
            }
            string2 = string;
        }
        return string2;
    }

    private final ResourceBundle RB() {
        ResourceBundle resourceBundle;
        block2: {
            resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle("com.ibm.ejs.resources.labels", Locale.getDefault());
            }
            catch (Exception exception) {
                if (!this._logger.isLoggable(Level.FINER)) break block2;
                this._logger.fine("com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapper RB() Couldn't locate msg bundle: " + exception.getMessage());
            }
        }
        return resourceBundle;
    }

    static {
        Object object;
        Object object2;
        INT_SID = "server:";
        _isServant = TAMConfigUtils.isServant();
        if (!_isServant) {
            try {
                object2 = new TAMConfigInitialize(null);
                ((TAMConfigInitialize)object2).initialize(null);
                _jaccInitialized = true;
            }
            catch (Exception exception) {
                _jaccInitialized = false;
                object = new AmasMessage(864636984, exception.toString());
                System.out.println(((AmasMessage)object).getMessageString());
            }
        } else {
            _jaccInitialized = true;
        }
        try {
            object2 = TAMConfigUtils.getStringGeneratorForCtx();
            object = _isServant ? ((TAMConfigStringGenerator)object2).getStringFromTemplate("${WAS_PROFILES_ROOT}/etc/tam/amwas.${NODE_NAME}_${SERVER_NAME}_${STOKEN}.amjacc.properties") : ((TAMConfigStringGenerator)object2).getStringFromTemplate("${WAS_PROFILES_ROOT}/etc/tam/amwas.${NODE_NAME}_${SERVER_NAME}.amjacc.properties");
            Properties properties = TAMConfigUtils.readProperties((String)object);
            String string = properties.getProperty("com.tivoli.pd.as.jacc.RemoteCfgURL");
            _cfgURL = new URL(string);
            PDAuthorizationContext pDAuthorizationContext = new PDAuthorizationContext(new URL(string));
            PDLoginModule.setDefaultAuthorizationContext((PDAuthorizationContext)pDAuthorizationContext);
        }
        catch (Exception exception) {
            System.out.println("PDLoginModuleWrapper. Cannot read configuration URL from properties file. Using login module option instead.");
            _cfgURL = null;
        }
    }
}

