/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.as.jacc.cfg;

import com.tivoli.pd.as.jacc.cfg.PortRangeDecoder;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PortsTakenRecorder {
    private final String PortsTakenRecorder_java_sourceCodeID = "$Id: @(#)87  1.6 src/jacc/com/tivoli/pd/as/jacc/cfg/PortsTakenRecorder.java, amemb.jacc.was, amemb600, 051118a 05/03/08 12:48:56 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private String _uniqueID = null;
    private PortRangeDecoder _decoder = null;
    private Properties _portsTakenProps = null;

    public PortsTakenRecorder(Properties properties, String string, PortRangeDecoder portRangeDecoder) {
        if (properties == null || string == null) {
            throw new IllegalArgumentException();
        }
        this._decoder = portRangeDecoder;
        this._portsTakenProps = properties;
        this._uniqueID = string;
    }

    public void releasePorts() {
        Iterator<Map.Entry<Object, Object>> iterator = this._portsTakenProps.entrySet().iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (!((String)entry.getValue()).equals(this._uniqueID)) continue;
            arrayList.add(entry.getKey());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this._portsTakenProps.remove(arrayList.get(i));
        }
    }

    public void releaseAllPorts() {
        Enumeration<Object> enumeration = this._portsTakenProps.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("portTaken.")) continue;
            arrayList.add(string);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this._portsTakenProps.remove(arrayList.get(i));
        }
    }

    public int findAvailablePort() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Enumeration<Object> enumeration = this._portsTakenProps.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("portTaken.")) continue;
            try {
                int n = Integer.parseInt(string.substring("portTaken.".length()));
                arrayList.add(new Integer(n));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int n = -1;
        n = TAMConfigUtils.isDeploymentManager() ? this._decoder.findAvailablePortAfterFirst(0, this._decoder.getDmgrMax(), arrayList.toArray(new Integer[0])) : this._decoder.findAvailablePortAfterFirst(this._decoder.getDmgrMax(), -1, arrayList.toArray(new Integer[0]));
        return n;
    }

    public void takeAvailablePort(int n) {
        this._portsTakenProps.setProperty("portTaken." + n, this._uniqueID);
    }
}

